/* Author   : Imran
   Date     : 19/8/98
   Synopsis : Contains the Parameter IDs used by all modules
*/

/* IP Parameters */
#define 	IP_NUMBER_OF_PORTS												1001
#define 	IP_DEFAULT_GATEWAY  												1002
#define 	IP_DNS_ENABLED 													1003
#define 	IP_DNS_PRIMARY_ADDRESS											1004
#define 	IP_DNS_SECONDARY_ADDRESS										1005

/* IP port parameters */
#define 	IP_PORT_ISP_ASSIGNS_ADDRESS									1101
#define 	IP_PORT_BOOTP														1102
#define 	IP_PORT_IP_ADDRESS												1103
#define 	IP_PORT_SUBNET_MASK												1104
#define 	IP_PORT_REMOTE_ADDRESS											1105

/* PPP Parameters */
#define 	PPP_ENABLE															1201
#define 	PPP_NUMBER_OF_PORTS												1202
#define 	PPP_NEED_TO_DIAL_OUT_INITIALLY								1203
#define 	PPP_PRINTF															1204
#define 	PPP_PRINTF_LCP														1205
#define 	PPP_PRINTF_NCP														1206
#define 	PPP_PRINTF_ALARM													1207

/* PPP Port Parameters  */
#define 	PPP_PORT_ENABLE													1301
#define 	PPP_PORT_USER_NAME												1302
#define 	PPP_PORT_USER_PASSWORD											1303
#define 	PPP_PORT_CONNECTION_DIAL_ON_DEMAND							1304
#define 	PPP_PORT_HANGUP_TIME												1305
#define 	PPP_PORT_IP															1306
#define 	PPP_PORT_AUTHENTICATION_TYPE									1307
#define	PPP_PORT_REMOTE_PORT_CLIENT_ONLY						      1308

#define 	PPP_PORT_OPTION_LCP_ACCM										1309
#define 	PPP_PORT_REMOTE_OPTION_LCP_ACCM								1310
#define 	PPP_PORT_OPTION_LCP_MRU											1311
#define 	PPP_PORT_REMOTE_OPTION_LCP_MRU								1312
#define 	PPP_PORT_REMOTE_OPTION_LCP_AUTHENTICATION 				1313
#define 	PPP_PORT_OPTION_LCP_MAGIC_NUMBER								1314
#define 	PPP_PORT_REMOTE_OPTION_LCP_MAGIC_NUMBER					1315
#define 	PPP_PORT_OPTION_IPCP_IP_ADDRESS								1316
#define 	PPP_PORT_REMOTE_OPTION_IPCP_IP_ADDRESS						1317
#define 	PPP_PORT_OPTION_LCP_EPD											1318
#define 	PPP_PORT_REMOTE_OPTION_LCP_EPD								1319	
#define 	PPP_PORT_OPTION_LCP_MRRU										1320
#define 	PPP_PORT_REMOTE_OPTION_LCP_MRRU								1321
#define 	PPP_PORT_REMOTE_OPTION_LCP_CALLBACK							1322
#define 	PPP_PORT_IPCP_DNS_ADDRESS1										1323
#define 	PPP_PORT_IPCP_DNS_ADDRESS2										1324

#define	PPP_OPTION_TYPE      											1325
#define	PPP_OPTION_AUTO													1326
#define	PPP_OPTION_NEG_NOT_REQD											1327
#define	PPP_OPTION_NEGOTIABLE											1328
#define	PPP_OPTION_VALID 													1329
#define	PPP_OPTION_VALUE_TYPE											1330
#define	PPP_OPTION_VALUE											      1331

		  	
/* WAN Parameters */
#define 	WAN_ENABLE										 					1401
#define 	WAN_NUMBER_OF_PORTS							 					1402
																 
/* WAN Port Parameters */
#define 	WAN_PORT_ENABLE											 		1501
#define 	WAN_PORT_SPEED									 					1502
#define 	WAN_PORT_SCRIPT_ENABLE						 					1503
#define 	WAN_PORT_RESTART_SCRIPT_ON_COMM_FAILURE 					1504
#define 	WAN_PORT_DIRECT_CONNECT						 					1505
#define 	WAN_PORT_AUTO_ANSWER							 					1506
#define 	WAN_PORT_MODEM_TYPE							 					1507
#define 	WAN_PORT_MODEM_INITIALIZATION_STRING1	 					1508
#define 	WAN_PORT_MODEM_INITIALIZATION_STRING2	 					1509
#define 	WAN_PORT_MODEM_INITIALIZATION_STRING3	 					1510
#define 	WAN_PORT_MODEM_INITIALIZATION_STRING4	 					1511
#define 	WAN_PORT_MODEM_INITIALIZATION_STRING5	 					1512
#define 	WAN_PORT_DIAL_PREFIX							 					1513
#define 	WAN_PORT_DIAL_NUMBER							 					1514
#define 	WAN_PORT_DIAL_SUFFIX							 					1515
#define 	WAN_PORT_RING_MESSAGE						 					1516
#define 	WAN_PORT_HANGUP_STRING						 					1517
#define 	WAN_PORT_OK_MESSAGE							 					1518
#define 	WAN_PORT_NO_CARRIER_MESSAGE				 					1519
#define 	WAN_PORT_ERROR_MESSAGE						 					1520
#define 	WAN_PORT_NO_DIAL_TONE_MESSAGE				 					1521
#define 	WAN_PORT_BUSY_MESSAGE						 					1522
#define 	WAN_PORT_NO_ANSWER_MESSAGE					 					1523
#define 	WAN_PORT_RESPONSE_STRING					 					1524

/* PROXY parameters */
#define  PROXY_NUMBER_OF_PORTS											1601
#define  PROXY_ENABLE														1602
#define	PROXY_ANY_APP														1603
#define  PROXY_NUMBER_OF_APPLICATION_ENTRIES		 				 	1604
#define  PROXY_NUMBER_OF_USER_DEFINED_APPLICATION_ENTRIES		1605
#define  PROXY_APPLICATIONS_PORT										   1606
#define  PROXY_APPLICATIONS_PROTOCOL									1607
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */
#define  PROXY_FTP_CONTROL_CONNECTION									1608
#define  PROXY_FTP_DATA_CONNECTION										1609
/* Jo 04/10/99 Added to support configurable FTP Data and Control Ports */

#define  PROXY_VS_NO_OF_GLBL_ADDRESS_ENTRIES							1701
#define  PROXY_VS_NO_OF_STATIC_MAPPING_ENTRIES						1702
#define  PROXY_VS_NO_OF_DYNAMIC_MAPPING_ENTRIES						1703
#define  PROXY_VS_GLOBAL_ADDRESS_ENTRIES							   1704
#define  PROXY_VS_STATIC_MAPPING_ENTRIES_GLOBAL_ADDRESS			1705
#define  PROXY_VS_STATIC_MAPPING_ENTRIES_LOCAL_ADDRESS			1706
#define  PROXY_VS_DYNAMIC_MAPPING_ENTRIES_GLOBAL_ADDRESS		  	1707
#define  PROXY_VS_DYNAMIC_MAPPING_ENTRIES_LOCAL_ADDRESS			1708
#define  PROXY_VS_DYNAMIC_MAPPING_ENTRIES_PORT						1709
#define  PROXY_VS_DYNAMIC_MAPPING_ENTRIES_PROTOCOL					1710

#define  PROXY_FILTER_NO_OF_FORBIDDEN_SITES_ENTRIES            1801
#define  PROXY_FILTER_NO_OF_RESTRICTED_CLIENTS_ENTRIES         1802
#define  PROXY_FILTER_NO_OF_RESTRICTED_APPLICATION_ENTRIES     1803
#define  PROXY_FILTER_NO_OF_MAC_ADDRESS_ENTRIES                1804
#define  PROXY_FILTER_NO_OF_DOMAIN_NAME_ENTRIES                1805
#define  PROXY_FILTER_FORBIDDEN_SITES_ENTRIES                  1806
#define  PROXY_FILTER_RESTRICTED_CLIENTS_ENTRIES               1807
#define  PROXY_FILTER_RESTRICTED_APPLICATION_ENTRIES_PORT      1808
#define  PROXY_FILTER_RESTRICTED_APPLICATION_ENTRIES_PROTOCOL	1809
#define  PROXY_FILTER_MAC_ADDRESS_ENTRIES                      1810
#define  PROXY_FILTER_DOMAIN_NAME_ENTRIES                  		1811

/* PROXY port parameters */
#define  PROXY_PORT_ENABLE													1901
#define  PROXY_PORT_NUMBER_OF_ADDRESS_ENTRIES						1902
#define  PROXY_PORT_NUMBER_OF_CONNECTIONS_TO_TRIGGER				1903
#define  PROXY_PORT_NUMBER_OF_HOSTS_TO_TRIGGER						1904
#define  PROXY_PORT_ADDRESS												1905

/* DHCP parameters */
#define  DHCP_NUMBER_OF_ADDRESS_RANGE_ENTRIES						2001
#define  DHCP_SERVER_ENABLE												2002

#define  DHCP_LOWER_IP_ADDRESS											2003
#define  DHCP_HIGHER_IP_ADDRESS											2004
#define  DHCP_ADDRESS_MASK													2005
#define  DHCP_NUMBER_OF_BINDINGS_ENTRIES								2006
#define  DHCP_EXCLUDE_LOWER_IP_ADDRESS									2007
#define  DHCP_EXCLUDE_HIGHER_IP_ADDRESS								2008
#define  DHCP_CLIENT_ENABLE												2009
#define  DHCP_SERVER_IP_ADDRESS											2010

#define  DHCP_OPTIONS_INFO_ROUTER_ADDRESS								2101
#define  DHCP_OPTIONS_INFO_DOMAIN_NAME									2102
#define  DHCP_OPTIONS_INFO_REASSEMBLY_SIZE		 					2103
#define  DHCP_OPTIONS_INFO_DEFAULT_IP_TTL								2104
#define  DHCP_OPTIONS_INFO_MTU											2105
#define  DHCP_OPTIONS_INFO_DEFAULT_TCP_TTL							2106
#define  DHCP_OPTIONS_INFO_LEASE_TIME									2107

#define  DHCP_BINDING_INFO_IP_ADDRESS									2201
#define  DHCP_BINDING_INFO_MAC_ADDRESS_LENGTH						2202
#define  DHCP_BINDING_INFO_MAC_ADDRESS									2203


#define 	ADD_IP_PORT															3001
#define 	DELETE_IP_PORT														3002

#define  ADD_PROXY_ADDRESS_FILTER										3003
#define  ADD_RESTRICTED_APPLICATION_ENTRIES							3005
#define  ADD_PROXY_APPLICATION											3008
#define 	ADD_PROXY_USER_APP												3009
#define  ADD_PROXY_ADDRESS_ENTRIES										3010
#define  ADD_GLOBAL_ADDRESS_ENTRIES										3011
#define  ADD_PROXY_STATIC_MAPPING										3012
#define  ADD_PROXY_DYNAMIC_MAPPING										3013

#define  DELETE_PROXY_ADDRESS_FILTER									3114
#define  DELETE_RESTRICTED_APPLICATION_ENTRIES						3115
#define  DELETE_PROXY_ADDRESS_ENTRIES									3116
#define  DELETE_PROXY_APPLICATION										3117
#define 	DELETE_PROXY_USER_APP											3118
#define  DELETE_GLOBAL_ADDRESS_ENTRIES									3119
#define  DELETE_PROXY_STATIC_MAPPING									3120
#define  DELETE_PROXY_DYNAMIC_MAPPING									3121
/* Jo 20/08/99 Added for Static Routes */
#define 	ADD_STATIC_ROUTE													5101
#define 	DELETE_STATIC_ROUTE												5102

#ifdef _BIG_PROXY_
/* all these are for ip port filtering	*/
#define 	ADD_IP_FILTER_DEST_PORT_ENTRY									5111
#define 	ADD_IP_FILTER_SOURCE_PORT_ENTRY								5112
#define 	ADD_IP_FORWARD_DEST_PORT_ENTRY								5113
#define 	ADD_IP_FORWARD_SOURCE_PORT_ENTRY								5114
#define 	DELETE_IP_FILTER_PORT_ENTRY									5115

/* all these are for ip address filtering */
#define 	ADD_IP_FILTER_DEST_ADDRESS_ENTRY								5121
#define 	ADD_IP_FILTER_SOURCE_ADDRESS_ENTRY							5122
#define 	ADD_IP_FORWARD_DEST_ADDRESS_ENTRY							5123
#define 	ADD_IP_FORWARD_SOURCE_ADDRESS_ENTRY							5124
#define 	DELETE_IP_FILTER_ADDRESS_ENTRY								5125
#endif



/* all these are for ipx address filtering  */
#define 	ADD_IPX_FILTER_DEST_ADDRESS_ENTRY							5131
#define 	ADD_IPX_FILTER_SOURCE_ADDRESS_ENTRY							5132
#define 	ADD_IPX_FORWARD_DEST_ADDRESS_ENTRY							5133
#define 	ADD_IPX_FORWARD_SOURCE_ADDRESS_ENTRY						5134
#define 	DELETE_IPX_FILTER_ADDRESS_ENTRY								5135

/* all these are for STP address filtering	 */
#define 	ADD_STP_FILTER_DEST_ADDRESS_ENTRY							5141
#define 	ADD_STP_FILTER_SOURCE_ADDRESS_ENTRY							5142
#define 	ADD_STP_FORWARD_DEST_ADDRESS_ENTRY							5143
#define 	ADD_STP_FORWARD_SOURCE_ADDRESS_ENTRY						5144
#define 	DELETE_STP_FILTER_ADDRESS_ENTRY								5145
