/*	$Modname: lslproto.h$  $version: 1.5$      $date: 02/02/94$   */
/*
* 	$lgb$
1.0 10/11/93 ross adding version control.
1.1 10/11/93 ross added some prototypes.
1.2 10/18/93 ross added lsl frame type and ip header.
1.3 12/03/93 ross fixes for lsl version 3.0
1.4 01/08/94 ross More LSL version 3 changes
1.5 02/02/94 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _LSLPROTO_H_
#define _LSLPROTO_H_

#define ILLEGAL_DEVICE_ID 0xffffffffL

#ifndef RX_PACKET_STATE_DEFINED

	#define RX_PACKET_STATE_DEFINED

	enum	RX_PACKET_STATE
	{
		PACKET_NOT_RECOGNIZED,
		PACKET_RECOGNIZED_BUT_NOT_FORWARDED,
		PACKET_RECOGNIZED_AND_FORWARDED
	};

#endif

#ifndef LINK_TYPEDEF_DEFINED

	#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;
} LINK;

typedef	struct	SINGLE_LINK
{
	struct	SINGLE_LINK	*sptr_forward_link;
} SINGLE_LINK;

#endif

enum LINKED_LIST_COMPARISON_RESULT
{
	LESS_THAN_CURRENT_ELEMENT,
	GREATER_THAN_CURRENT_ELEMENT,
	SAME_AS_CURRENT_ELEMENT,
	ERROR_IN_COMPARISON
};

typedef	struct	LINKED_LIST_INDEX
{
	USHORT 					offset;
	USHORT 					size;
	BYTE_ENUM (BOOLEAN)	swap;
} LINKED_LIST_INDEX;

typedef	struct	LINKED_LIST_SORT_PARAMETERS
{
	LINK					*sptr_list;
	LINK					*sptr_entry_to_add;

	LINKED_LIST_INDEX	index[5];

} LINKED_LIST_SORT_PARAMETERS;

enum SERIAL_DRIVER_TYPE
{
	ASYNCHRONOUS_SERIAL_DRIVER,
	SYNCHRONOUS_SERIAL_DRIVER
};

enum SERIAL_DRIVER_CONTROL
{
	OPEN_SERIAL_PORT,
	CLOSE_SERIAL_PORT
};

enum APPLICATION_CONTROL_OPERATION
{
	START_APPLICATION,
	TERMINATE_APPLICATION,
	IS_APPLICATION_ENABLED,
	GET_SOCKET_ERROR_VALUE,
	RUN_APPLICATION,
	CONNECTION_COMPLETED,
	CONNECTION_REQUEST_RECEIVED,
	CONNECTION_CLOSED,
	CONNECTION_CLOSED_BY_REMOTE,
	READ_DATA_FROM_SOCKET,
	WRITE_DATA_TO_SOCKET,

	INITIALIZE_FUNCTION_POINTERS,
	_ACO_ULONG_FILLER = 0x10000000L
};

enum TRANSPORT_CONTROL_OPERATION
{
	OPEN_TRANSPORT,
	CLOSE_TRANSPORT,
	IS_TRANSPORT_ENABLED,
	INITIALIZE_SOCKET_TRANSPORT_INTERFACE,
	INITIALIZE_TRANSPORT_FUNCTION_POINTERS
};

enum PROTOCOL_CONTROL_OPERATION
{
	OPEN_PROTOCOL_STACK,
	CLOSE_PROTOCOL_STACK,
	OPEN_VIRTUAL_PORT,
	CLOSE_VIRTUAL_PORT,
	GET_IP_ADDRESS_FOR_PORT,

	IS_PROTOCOL_STACK_ENABLED = 0x0100,
	GET_NUMBER_OF_PROTOCOL_STACKS_VIRTUAL_PORTS,
	GET_PROTOCOL_STACK_TYPE,
	GET_PROTOCOL_STACK_PROTOCOL_ID,
	GET_PROTOCOL_STACK_SSAP,
	GET_PROTOCOL_STACK_DSAP,
	GET_PROTOCOL_STACK_VIRTUAL_PORT_PACKET_TYPE,
	GET_PROTOCOL_STACK_REAL_PORT_NUMBER_USING_VIRTUAL_PORT_NUMBER,

	INITIALIZE_SOCKET_PROTOCOL_STACK_INTERFACE,

	IS_TOKEN_RING_FRAME_SOURCE_ROUTED,
	IS_TOKEN_RING_FRAME_A_MAC,
	GET_LENGTH_OF_TOKEN_RING_RIF,
	CLEAR_SOURCE_ROUTED_BIT,
	MOVE_RIF_INTO_PACKET,
	IS_MAC_ADDRESS_SOURCE_ROUTED,
	REGISTER_TO_IP_FROM_UPPER_LAYER,

	INITIALIZE_STACK_FUNCTION_POINTERS,
	INITIALIZE_PROTOCOL_FUNCTION_POINTERS,
	GET_PROTOCOL_ADDRESS
};

enum LSL_CONTROL_OPERATION
{
	REGISTER_APPLICATION,
	REGISTER_TRANSPORT,
	REGISTER_PROTOCOL_STACK,
	REGISTER_HIGH_LEVEL_DEVICE_DRIVER,
	REGISTER_LOW_LEVEL_DEVICE_DRIVER,
	LSL_REGISTER_SERIAL_DEVICE_DRIVER,

	DEREGISTER_APPLICATION,
	DEREGISTER_TRANSPORT,
	DEREGISTER_PROTOCOL_STACK,
	DEREGISTER_HIGH_LEVEL_DEVICE_DRIVER,
	DEREGISTER_LOW_LEVEL_DEVICE_DRIVER,
	DEREGISTER_SERIAL_DEVICE_DRIVER,

	GET_MAC_ADDRESS,
	GET_RANDOM_NUMBER,
	DEVICE_DRIVER_GET_MAC_ADDRESS,
	GET_REMOTE_CONSOLE_BUFFER_STRING,
	INITIALIZE_BUFFER_CLASS,
	GET_CURRENT_RX_BUFFER_LIST_SIZE,
	SET_CURRENT_RX_BUFFER_LIST_SIZE,
	LSL_GET_BUFFER_SIZE,
	LSL_PORT,
	LOW_LEVEL_DEVICE_DRIVER_PORT,
	HIGH_LEVEL_DEVICE_DRIVER_PORT,
	PROTOCOL_STACK_PORT,
	SERIAL_DRIVER_GET_DEVICE_DRIVER_ID,
	GET_DRIVER_HEADER_SIZE,
	LSL_GET_DEVICE_DRIVER_TYPE_FROM_RECEIVE_PORT,
	GET_NUMBER_OF_WAN_PORTS,
	GET_NUMBER_OF_LAN_PORTS,
	PROTOCOL_STACK_VIRTUAL_PORT,
	RESOLVE_SOCKET_API,

	ADD_LSL_MESSAGE,
	COPY_PROTECTED_MODE_LSL,
	CHECK_LSL,
	CONVERT_STACK_VIRTUAL_TO_REAL_PORT_NUMBER,
	PROTOCOL_STACK_CONTROL,
	REGISTER_LSL_TRAP_FUNCTION,

	GET_SIZE_OF_LSL_CLASS,

	INITIALIZE_LSL_FUNCTION_POINTERS,
	INITIALIZE_SOCKET_FUNCTION_POINTERS,
	INITIALIZE_IP_FUNCTION_POINTERS,
	RESOLVE_FUNCTION_POINTERS,

	INTERNAL_DEVICE_DRIVER_TRANSMIT_COMPLETE,
	GET_LSL_CLASS,

	LSL_RX_LIST_ADD,
	LSL_TX_LIST_PACKET_SENT,
	UPPER_DEVICE_DRIVER_PORT,

	NUMBER_OF_LSL_CONTROL_OPERATIONS
};

enum DEVICE_CONTROL_OPERATION
{
	OPEN_DEVICE_DRIVER,
	STACK_HAS_REGISTERED,
	CLOSE_DEVICE_DRIVER,
	OPEN_DEVICE_DRIVER_PORT,
	CLOSE_DEVICE_DRIVER_PORT,
	DEVICE_QUERY,
	GET_DEVICE_MAC_ADDRESS,
	LOWER_DEVICE_DRIVER_UP,
	LOWER_DEVICE_DRIVER_DOWN,
	IS_CLASS_ENABLED,
	REGISTER_SERIAL_DEVICE_DRIVER,
	PASSWORD_VERIFICATION
};

enum DEVICE_DRIVER_TYPE
{
	ETHERNET_DEVICE_DRIVER,
	TOKEN_RING_DEVICE_DRIVER,
	SYNC_DEVICE_DRIVER,
	FRAME_RELAY_DEVICE_DRIVER,
	ASYNC_DEVICE_DRIVER,
	PPP_DEVICE_DRIVER,
	FDDI_DEVICE_DRIVER,
	VIRTUAL_DEVICE_DRIVER
};

enum LSL_PACKET_TYPE
{
	RAW_8023,
	ETHERNET_TYPE_II,
	LLC_PACKET,
	SNAP_PACKET,
	WAN_PACKET,
	SAME_TYPE_AS_RX_PACKET_, /* for future use, DO NOT ALLOW AS A CONFIGURATION OPTION */

	__ENUM_USHORT_FILLER_ = 0x1000
};

enum PROTOCOL_STACK_TYPE
{
	IP_PROTOCOL_STACK,
	IPX_PROTOCOL_STACK,
	SPANNING_TREE_STACK,
	SOURCE_ROUTING_STACK,
	NLSP_PROTOCOL_STACK,
	DLSW_PROTOCOL_STACK,
	OSPF_PROTOCOL_STACK,
	APPLETALK_PROTOCOL_STACK,
	NETBIOS_PROTOCOL_STACK,
	VINES_PROTOCOL_STACK,
	CONSOLE_PROTOCOL_STACK
};

enum TRANSPORT_TYPE
{
	SPX_TRANSPORT,
	TCP_TRANSPORT
};

enum APPLICATION_TYPE
{
	SOCKETS_INTERFACE,
	BOOTP_APPLICATION,
	CONSOLE_APPLICATION,
	DLSW_APPLICATION,

	TEST_SOCKET_TCP_APPLICATION,
	TEST_SOCKET_UDP_APPLICATION,
	TEST_SOCKET_IPX_APPLICATION,

	SNMP_MANAGEMENT
};

enum ISO_LAYER_TYPE
{
	PHYSICAL_LAYER_TYPE,
	DATA_LINK_LAYER_TYPE,
	NETWORK_LAYER_TYPE,
	TRANSPORT_LAYER_TYPE,
	SESSION_LAYER_TYPE,
	PRESENTATION_LAYER_TYPE,
	APPLICATION_LAYER_TYPE,
	LINK_SERVICES_LAYER_TYPE,
	OPERATING_SYSTEM_TYPE
};

enum _LSL_CONTROL_OPERATION
{
	IS_LSL_ENABLED,
	ADD_MESSAGE_TO_QUEUE
};


typedef	struct	LSL_MESSAGE_LINK
{
	struct LSL_MESSAGE_LINK	*sptr_forward_link;
	struct LSL_MESSAGE_LINK	*sptr_backward_link;
} LSL_MESSAGE_LINK;


typedef	struct	LSL_MESSAGE
{
	LSL_MESSAGE_LINK 										links;
	USHORT 													port_number;
	ULONG_ENUM (APPLICATION_CONTROL_OPERATION)	command;
	ULONG 													socket_descriptor;
	void 														*vptr_buffer;
	USHORT 													buffer_size;
	void 														*vptr_context;
	ULONG 													destination_id;
	enum ISO_LAYER_TYPE 									destination_iso_layer_type;
	ULONG 													source_id;
	enum ISO_LAYER_TYPE 									source_iso_layer_type;
	ULONG 													priority;
} LSL_MESSAGE;

typedef	struct	LSL_IP_HEADER
{
	USHORT_ENUM (SNAP_PROTOCOL_ID)	protocol_type;

	MAC_ADDRESS								destination_address;
	MAC_ADDRESS								source_address;
	USHORT_ENUM (LSL_PACKET_TYPE)		lsl_packet_type;
} LSL_IP_HEADER;

typedef	struct	LOW_LEVEL_DEVICE_DRIVER_API
{
	USHORT 									port_number;
	char 										*cptr_device_name;
	BYTE_ENUM (SERIAL_DRIVER_TYPE) 	device_driver_type;
	enum TEST 								(*fptr_tx_routine) (USHORT port_number,USHORT virtual_port_number,void *sptr_tx_buffer,
													USHORT number_of_bytes,enum BOOLEAN bridged_packet,enum BOOLEAN protocol_packet,
													void (*fptr_tx_completion)	(USHORT port_number,void *vptr_tx_buffer));
	void 										(*fptr_tx_complete) (USHORT port_number);
	enum BOOLEAN 							(*fptr_rx_routine) (USHORT port_number,void **vptr_buffer,USHORT *usptr_number_of_bytes_rxed);
	void 										(*fptr_timer_routine) (void);
	enum TEST 								(*fptr_control_routine) (enum SERIAL_DRIVER_CONTROL command,ULONG parameter_0,
													ULONG parameter_1);
	void 										(*fptr_rx_buffer_return) (USHORT port_number,void *vptr_buffer);
} LOW_LEVEL_DEVICE_DRIVER_API;

enum SNMP_BOOLEAN
{
	SNMP_BOOLEAN_ENABLED = 0x01,
	SNMP_BOOLEAN_DISABLED = 0x02
};

/* snmp */

#if !defined (__MIB_OPERATION_DEFINED__)
	#define __MIB_OPERATION_DEFINED__

	enum MIB_OPERATION
	{
		GET_OPERATION,
		VERIFY_OPERATION,
		SET_OPERATION
	};
#endif


/************************************************************************/
#include <rwutils.h>
/************************************************************************/

extern enum TEST initialize_bridge (ULONG clock_ticks_per_second); 
extern enum TEST initialize_source_routing (ULONG clock_ticks_per_second);
extern enum TEST initialize_lsl (ULONG clock_ticks_per_second);
extern enum TEST initialize_IPX_router (ULONG clock_ticks_per_second);
extern enum TEST initialize_IP (ULONG ticks_per_second);
extern enum TEST initialize_NLSP_router (ULONG clock_ticks_per_second);
extern enum TEST initialize_DLSW_router (ULONG clock_ticks_per_second);
extern enum TEST initialize_ppp (ULONG clock_ticks_per_second);
extern enum TEST initialize_frame_relay (ULONG clock_ticks_per_second);
extern enum TEST initialize_spx (ULONG clock_ticks_per_second);
extern enum TEST initialize_snmp (ULONG clock_ticks_per_second);
extern enum TEST initialize_tcp (ULONG clock_ticks_per_second);
extern enum TEST initialize_nvram (char *cptr_file_name,ULONG location_of_ini_file);
extern enum TEST initialize_vjc (ULONG clock_ticks_per_second);
extern enum TEST initialize_cipx (ULONG clock_ticks_per_second);
extern enum TEST initialize_appletalk_router (ULONG clock_ticks_per_second);
extern enum TEST initialize_socket (ULONG clock_ticks_per_second);
extern enum TEST initialize_bootp (ULONG clock_ticks_per_second);
extern enum TEST close_lsl (void);
extern enum TEST initialize_odi (ULONG clock_ticks_per_second);
extern enum TEST initialize_ndis (ULONG clock_ticks_per_second);
extern void polling_timer_interrupt (void);
extern enum TEST initialize_serial_controller (ULONG clock_ticks_per_second);
extern enum TEST initialize_wan_controller (ULONG clock_ticks_per_second);
extern enum TEST initialize_wan_odi_driver (ULONG clock_ticks_per_second);
extern enum TEST initialize_wan_ndis (ULONG clock_ticks_per_second);
extern enum TEST initialize_console_stack (ULONG clock_ticks_per_second);
extern enum TEST initialize_dlsw_application (ULONG clock_ticks_per_second);
extern enum TEST initialize_server_console (ULONG clock_ticks_per_second);
extern enum TEST initialize_remote_console (ULONG clock_ticks_per_second);
extern enum TEST initialize_netbios_gateway (ULONG clock_ticks_per_second);

/* lsltx.c */

enum TEST send_packet (ULONG protocol_stack_id,USHORT port_number,void *sptr_tx_packet,USHORT number_of_bytes,
	enum BOOLEAN do_not_calculate_new_crc,enum BOOLEAN device_driver_buffer,
	void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer));

#ifdef __LSL__

	/* lslbuff.c */

	void *device_driver_malloc (USHORT real_port_number,ULONG device_driver_id,USHORT number_of_bytes);
	enum TEST device_driver_free (USHORT real_port_number,ULONG device_driver_id,void *vptr_buffer);
	enum TEST packet_forward_device_driver_free (USHORT real_tx_port_number,ULONG tx_device_driver_id,void *vptr_buffer_data);

	/* lslctrl.c */

	ULONG lsl_control (enum LSL_CONTROL_OPERATION command,...);

	void poll_for_packet_received (enum BOOLEAN return_from_poll);

#endif /* #ifdef __LSL__ */

#endif /* _LSLPROTO_H_ */
