/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#ifndef _BROUTILS_H_
#define _BROUTILS_H_

/* convutls.c */

_EXTERN USHORT host_to_net_short (USHORT host_order_short_value);
_EXTERN USHORT net_to_host_short (USHORT net_order_short_value);
_EXTERN ULONG host_to_net_long (ULONG host_order_long_value);
_EXTERN ULONG net_to_host_long (ULONG net_order_long_value);

#ifndef BIG_ENDIAN
_EXTERN 	USHORT swap (USHORT ushort_to_swap_bytes_with);
_EXTERN 	ULONG swap_long (ULONG ulong_to_swap_bytes_with);
#endif


/* miscutls.c */

extern	MAC_ADDRESS	bridge_group_address;
extern	MAC_ADDRESS	bridge_management_group_address;
extern	MAC_ADDRESS	token_ring_bridge_group_address;
_EXTERN enum SORT_RETURN compare_mac_addresses (void *sptr_address_1,void *sptr_address_2);

_EXTERN char *convert_ip_address_to_dot_format (char *cptr_array_to_store_dot_format_address, ULONG ip_address);
#if 0	/* Jo 05/05/99 */
#if !defined (_MSC_VER)
	char *strlwr (char *cptr_string_to_lower_case);
#endif
#endif
_EXTERN void *x86_normalize (void *vptr_address_to_normalize);

/* listutls.c */

_EXTERN void add_entry_to_list (LINK *sptr_link, LINK *sptr_link_to_add);
_EXTERN void *get_entry_from_list (LINK *sptr_link);
_EXTERN void delete_entry_from_list (LINK *sptr_list_link, LINK *sptr_link_to_delete);
_EXTERN void add_entry_to_front_of_list (LINK *sptr_link, LINK *sptr_link_to_add);
_EXTERN void insert_entry_in_list (LINK *sptr_link, LINK *sptr_link_to_add, LINK *sptr_link_after_which_to_add);
_EXTERN void *get_pointer_to_first_entry_in_list (LINK *sptr_link);
_EXTERN void *get_pointer_to_next_entry_in_list (LINK *sptr_current_entry);
_EXTERN void *get_pointer_to_last_entry_in_list (LINK *sptr_link);
_EXTERN void *get_pointer_to_previous_entry_in_list (LINK *sptr_current_entry);
_EXTERN void free_list (LINK *sptr_list, void (*fptr_free) (void *vptr_data_to_free));
_EXTERN void *get_entry_from_list_using_index (LINK *sptr_list,USHORT element_index_to_find);
/*
 * The following functions have not been implemented yet
 *
 *	void *get_last_entry_from_list (LINK *sptr_link);
 *
 *	void add_entry_to_single_list (LINK *sptr_link,SINGLE_LINK *sptr_link_to_add);
 *	void add_entry_to_front_of_single_list (LINK *sptr_link,SINGLE_LINK *sptr_link_to_add);
 *	void *get_entry_from_single_list (LINK *sptr_link);
 *	void delete_entry_from_single_list (LINK *sptr_list_link,SINGLE_LINK *sptr_link_to_delete);
 *	void *get_last_entry_from_single_list (LINK *sptr_link);
 */


/* sortlist.c */

_EXTERN void add_entry_to_sorted_linked_list (LINKED_LIST_SORT_PARAMETERS *sptr_linked_list_sort_parameters);

/* snmpglbl.c */
/* Srikar, Mar 20, 1997. Changed the function prototype as a result of change in object id type from */
/* BYTE to OBJECT_ID */
#if defined (__SNMP__)
_EXTERN 	enum TEST process_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
		BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
		OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name,
		SNMP_TABLE_ENTRY *sptr_first_table_entry);
#else
_EXTERN 	enum TEST process_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
		BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
		OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name,
		void *sptr_first_table_entry);
#endif

/* accesnmp.c */

/* Srikar, Mar 18, 1997. Added the following function prototype for supporting setting of ip addresses. */
_EXTERN enum TEST snmp_get_or_set_ip_address (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
_EXTERN enum TEST snmp_get_or_set_ulong (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
_EXTERN enum TEST snmp_get_or_set_ushort (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
/* Srikar, Mar 17, 1997. Prototype for funciton to access ushort value already in big endian form */
_EXTERN enum TEST snmp_get_or_set_big_endian_ushort (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
_EXTERN enum TEST snmp_get_or_set_boolean_plus_one (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size, void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
_EXTERN enum TEST snmp_get_or_set_byte (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
_EXTERN enum TEST snmp_get_or_set_string (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
/* Srikar, Mar 17, 1997. Prototype for function to access fixed length string of size 2 */
enum TEST snmp_get_or_set_2_byte_string (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
_EXTERN enum TEST snmp_get_or_set_mac_address (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size, void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);
_EXTERN enum TEST snmp_get_or_set_8_byte_object (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained);
/* Srikar, Mar 15, 1997. Prototype for function to access 4 byte values added */
_EXTERN enum TEST snmp_get_or_set_4_byte_object (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained);
_EXTERN enum TEST snmp_get_or_set_2_byte_object (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained);
_EXTERN enum TEST snmp_get_port_number (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained);

/* snmpncfg.c */

void *get_mib_access_function (enum TEST (*fptr_mib_access_function) (USHORT port_number, enum MIB_OPERATION mib_operation,
	 ULONG offset_into_class, ULONG class_address, ULONG size_of_port_class, void *vptr_mib_value,
	 USHORT *usptr_length_of_mib_obtained));

#endif /* _BROUTILS_H_ */
