#ifndef _UDB_H_

#define _UDB_H_

#include "defs.h"
#include <kstart.h>
#include <v8022str.h>
#include <lslproto.h>

/* Symbol Definitions */
#define UDB_MAX_USERS              128
#define UDB_USER_NAME_LENGTH       40
#define UDB_PASSWORD_LENGTH        8
#define UDB_CALLBACK_NUMBER_LENGTH 40
#define UDB_HEADER_ADDRESS         FL_UDB_HDR

/*
	User database manipulation :
	Before a round of user database manipulation, initially call
	udb_initialize to initialize the handler. Then on, start making
	calls to udb_insert(), udb_delete() and udb_edit() as required.
	Make sure you finally call udb_deinitialize() at the end.
*/

enum UDB_MODIFY
{
	INIT_SUCCESSFUL,
	INIT_NO_MEMORY,
	INIT_MODIFY_SEQUENCE_ALREADY_ON,

	INSERT_SUCCESSFUL,
	INSERT_USER_ALREADY_EXISTS,
	INSERT_MAX_COUNT_EXCEEDED,
	INSERT_NO_MEMORY,

	DELETE_SUCCESSFUL,
	DELETE_USER_NOT_FOUND,

	EDIT_SUCCESSFUL,
	EDIT_RECORD_NOT_FOUND,
	EDIT_NO_MEMORY,

	DEINIT_SUCCESSFUL,

	UPDATE_SUCCESSFUL,
	UPDATE_NO_MEMORY,

	UDB_HANDLER_NOT_INITED
} ;

/* Structure definitions */
typedef struct
{
	BYTE user_name[UDB_USER_NAME_LENGTH] ;
	BYTE password[UDB_PASSWORD_LENGTH] ;	
	ULONG dial_in_port_mask ;
	ULONG dial_out_port_mask ;
/* Jo BYTE protocol_mask ; */
	BYTE call_back_security ;
	BYTE call_back_number[UDB_CALLBACK_NUMBER_LENGTH] ;
	USHORT call_back_delay ;
	BYTE call_back_enabled ;
/* Jo	BYTE reserved[9] ; */
} RAS_USER_DATABASE_RECORD ;

/* Extern declarations */
/* For the PPP module */
extern enum TEST initialize_user_database () ;
extern enum TEST check_if_udb_updated () ;
extern int get_ras_number_of_users () ;
extern RAS_USER_DATABASE_RECORD *get_ptr_to_udb_record (char *user_name) ;
extern enum BOOLEAN do_passwords_match (RAS_USER_DATABASE_RECORD *udb_record, char *password) ;
extern enum BOOLEAN is_dial_in_permitted_for_port (RAS_USER_DATABASE_RECORD *udb_record, char port_number) ;
extern enum BOOLEAN is_dial_out_permitted_for_port (RAS_USER_DATABASE_RECORD *udb_record, char port_number) ;
extern enum BOOLEAN is_ipx_permitted (RAS_USER_DATABASE_RECORD *udb_record) ;
extern enum BOOLEAN is_ip_permitted (RAS_USER_DATABASE_RECORD *udb_record) ;
extern enum BOOLEAN is_stp_permitted (RAS_USER_DATABASE_RECORD *udb_record) ;

/* For AG and Telnet Dialout */
extern int get_ras_number_of_users () ;
extern BYTE *is_valid_ras_user (char *username);
extern enum BOOLEAN has_ras_user_password (BYTE *user_entry);
extern enum BOOLEAN is_valid_ras_user_password (BYTE *user_entry, char *password_str);
extern enum BOOLEAN has_dialout_access (BYTE *user_entry, USHORT port_number);
extern enum BOOLEAN has_dialout_inbound_access (BYTE *user_entry, USHORT port_number);
extern char *get_ras_user_name (BYTE *user_entry, char *user_name);	
extern enum BOOLEAN is_ras_callback_enabled (BYTE *user_entry, USHORT port_number);
extern enum BOOLEAN is_ras_callback_callback_security (BYTE *user_entry, USHORT port_number);
extern char *ras_get_callback_number (BYTE *user_entry, USHORT port_number, char *callback_number);
extern USHORT ras_get_callback_delay (BYTE *user_entry, USHORT port_number);
extern RAS_USER_DATABASE_RECORD *get_ras_user_entry_from_index (int index) ;


/* For modules that modify configuration - for now (23rd Dec.) only Telnet */
extern enum UDB_MODIFY udb_initialize () ;
extern enum UDB_MODIFY udb_insert (RAS_USER_DATABASE_RECORD *) ;
extern enum UDB_MODIFY udb_delete (char *) ;
extern enum UDB_MODIFY udb_edit (RAS_USER_DATABASE_RECORD *) ;
extern enum UDB_MODIFY udb_update_after_changes () ;
extern enum UDB_MODIFY udb_deinitialize () ;
extern int udb_get_number_of_users();
extern RAS_USER_DATABASE_RECORD *udb_get_user_entry_from_index (int);

#endif /* _UDB_H_ */
