/* WANMGR.H -- Has some globally available prototypes related to WANDRV and
**			   other constants and enumerations.
*/

#ifndef _WANMGR_H_
#define _WANMGR_H_

enum WAN_PORT_OWNER
{
	OWNED_BY_NONE,
	OWNED_BY_PPP,
	OWNED_BY_SLIP,    /* Kamalnath  SLIP 	05\02\1997 */
	OWNED_BY_TELNET,	/* Only Telnet Dialout */
	OWNED_BY_AG,
	OWNED_BY_CHAT,		/* Both SMC and TELNET based chat */
	OWNED_BY_TERMINAL_SERVER
};

/* Sachin 18/12/1886 */
/*
	This is done for the purpose of WAN device configuration only.
	Any other module wanting to use it should have another look at the
	function is_port_available_for_configuration() in
	\rtrware\devdrvrs\wandrv\wanconf.c.
		It just finds out if it is safe to do wan device configuration.
	If it is not, it returns the reason why it is currently not available.
	!!!!!!!!!!!!!!!!!!
	If the enumeration order is changed,
	make sure you change the strings in wanconf.c in the wan driver.
	!!!!!!!!!!!!!!!!!!
*/

enum WAN_PORT_AVAILABILITY
{
	PORT_AVAILABLE_FOR_CONFIGURATION = 0,
	PORT_DISABLED,
	PORT_IN_USE,
	PORT_DIAL_ON_DEMAND
} ;

extern char *wan_conf_return_strings[] ;
extern enum WAN_PORT_AVAILABILITY is_port_available_for_configuration (USHORT port_number) ;

/* Sachin 18/12/1886 */

extern void init_wan_port_owner_table(void);
extern void set_wan_port_owner(USHORT port_number, enum WAN_PORT_OWNER wan_owner);
extern enum WAN_PORT_OWNER get_wan_port_owner(USHORT port_number);

/* 29/06/99 Added from Jessi */
/* sudha 18 May 1999 */
extern void set_dialing_initiated_from_proxy_successful_to_true (USHORT port_number);
extern BYTE is_dialing_initiated_from_proxy_successful_to_bring_link_up (USHORT port_number);

extern enum BOOLEAN is_wan_enabled(USHORT port_number);
extern enum BOOLEAN is_wan_direct_connect(USHORT port_number);
extern enum BOOLEAN is_wan_async(USHORT port_number);
extern ULONG get_wan_configured_baud_rate(USHORT port_number);

/* For following provide a pointer to an array of 5 pointers as parameter */
extern char **get_wan_modem_init_strings(USHORT port_number, char **modem_init_strings);
extern char *get_wan_modem_hangup_string(USHORT port_number);
extern char *get_wan_modem_dial_prefix(USHORT port_number);
extern char *get_wan_modem_dial_suffix(USHORT port_number);

#endif /* _WANMGR_H_ */
