  #include	"defs.h"
/*	$Modname: lslport.c$  $version: 1.20$      $date: 06/29/95$   */
/*
* 	$lgb$
1.0 11/29/93 ross initial check-in.
1.1 11/29/93 ross
1.2 12/03/93 ross token ring fixes
1.3 12/03/93 ross delete unnecessary stack packet types for bridging stacks.
1.4 12/27/93 ross changed device_driver_port and protocol_stack_port functions.
1.5 01/08/94 ross More LSL version 3 changes
1.6 02/02/94 ross fixed lslsnap bugs, and added ipx protocol detection, support for dlsx and nlsp
1.7 02/04/94 ross changed header files.
1.8 03/06/94 ross adding more rfc 1213 statistics.
1.9 03/09/94 ross removed some duplicate variables
1.10 03/14/94 ross cleaned up braces and white spaces for release.
1.11 03/26/94 ross used meta include header file.
1.12 04/21/94 ross added code to handle rfc1042.
1.13 06/24/94 ross added lsl_port and protocol_stack_virtual_functions.
1.14 09/26/94 ross put in check for control routine not being present.
1.15 09/29/94 ross added BYTE_ENUM and USHORT_ENUM
1.16 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.17 01/12/95 ross building rwutils directory.
1.18 02/21/95 ross add close changes.
1.19 03/31/95 ross New close function, general cleanup.
1.20 06/29/95 ross new snmp access routine
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<string.h>
#include	"lsl.h"

/* Srikar, Mar 23, 1997. Added the following definitions to take avoid multiple instances of the same string constants. */
/* Jo 27/04/99 */
static const char	PPP_Driver[] = "PPP Driver";
static const char	SLIP_Driver[] = "SLIP Driver";

/* Srikar, Mar 30, 1997. Added the extern declaration */
extern ULONG router_up_time;

#ifdef FRAME_RELAY
extern USHORT get_frame_relay_real_port_number (enum PROTOCOL_STACK_TYPE, USHORT) ;
#endif

/****************************************************************************/
void initialize_port_class (void)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	for (sptr_device_driver_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.device_drivers_list);
		sptr_device_driver_entry != NULL;
		sptr_device_driver_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_device_driver_entry->links))
	{
		if (sptr_device_driver_entry->fptr_control_routine != NULL)
		{
			(*sptr_device_driver_entry->fptr_control_routine) (GET_DEVICE_MAC_ADDRESS,
				(ULONG) sptr_device_driver_entry->real_port_number,
				(ULONG) &sptr_device_driver_entry->rfc1213_ifEntry.ifPhysAddress);
		}
	}
}
/****************************************************************************/
ULONG serial_driver_get_device_driver_id (USHORT real_port_number)
{
	USHORT instance_counter;
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	instance_counter = 0x0000;

	for (sptr_device_driver_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.device_drivers_list);
		sptr_device_driver_entry != NULL;
		sptr_device_driver_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_device_driver_entry->links))
	{
		if (strcmp (sptr_device_driver_entry->rfc1213_ifEntry.ifDescr,"PPP Driver") == STRINGS_MATCH)
		{
			if (instance_counter == real_port_number)
				return (sptr_device_driver_entry->id);
			else
				++instance_counter;
		}

		if (strcmp (sptr_device_driver_entry->rfc1213_ifEntry.ifDescr,"Frame Relay Driver") ==	STRINGS_MATCH)
		{
			if (instance_counter == real_port_number)
				return (sptr_device_driver_entry->id);
			else
				++instance_counter;
		}
	}

	return ((ULONG) NULL);
}
/****************************************************************************/
enum TEST get_port_parameters (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_stack_entry)
{
	USHORT virtual_port_number;
	enum BOOLEAN volatile stack_enabled;
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	stack_enabled = FALSE;

	if (sptr_stack_entry->fptr_control_routine == NULL)
		return (PASS);

 	(*sptr_stack_entry->fptr_control_routine) (IS_PROTOCOL_STACK_ENABLED,(ULONG) NULL,(ULONG) &stack_enabled,(ULONG) NULL);

	if (stack_enabled == FALSE)
		return (PASS);

	(*sptr_stack_entry->fptr_control_routine)
		(GET_NUMBER_OF_PROTOCOL_STACKS_VIRTUAL_PORTS,(ULONG) NULL,(ULONG) &sptr_stack_entry->number_of_virtual_ports,(ULONG) NULL);

	if (sptr_stack_entry->number_of_virtual_ports > MAXIMUM_NUMBER_OF_VIRTUAL_PORTS)
		return (FAIL);

	(*sptr_stack_entry->fptr_control_routine) (GET_PROTOCOL_STACK_TYPE,(ULONG) NULL,(ULONG) &sptr_stack_entry->type,(ULONG) NULL);
	(*sptr_stack_entry->fptr_control_routine) (GET_PROTOCOL_STACK_PROTOCOL_ID,(ULONG) NULL,
		(ULONG) &sptr_stack_entry->snap_protocol_id,(ULONG) NULL);
	(*sptr_stack_entry->fptr_control_routine) (GET_PROTOCOL_STACK_SSAP,(ULONG) NULL,
		(ULONG) &sptr_stack_entry->source_address_SSAP,(ULONG) NULL);
	(*sptr_stack_entry->fptr_control_routine) (GET_PROTOCOL_STACK_DSAP,(ULONG) NULL,
		(ULONG) &sptr_stack_entry->source_address_DSAP,(ULONG) NULL);

	for (virtual_port_number = 0x0000; virtual_port_number < sptr_stack_entry->number_of_virtual_ports; ++virtual_port_number)
	{
		(*sptr_stack_entry->fptr_control_routine)	(GET_PROTOCOL_STACK_VIRTUAL_PORT_PACKET_TYPE,virtual_port_number,
				(ULONG) &sptr_stack_entry->port_number[virtual_port_number].packet_type,(ULONG) NULL);

		(*sptr_stack_entry->fptr_control_routine)	(GET_PROTOCOL_STACK_REAL_PORT_NUMBER_USING_VIRTUAL_PORT_NUMBER,
			virtual_port_number,(ULONG) &sptr_stack_entry->port_number[virtual_port_number].real_port_number,(ULONG) NULL);

		sptr_stack_entry->port_number[virtual_port_number].virtual_port_number = virtual_port_number;

		sptr_device_driver_entry = get_device_driver_entry_from_protocol_stack_id (sptr_stack_entry,virtual_port_number);

		if (sptr_device_driver_entry == NULL)
			sptr_stack_entry->port_number[virtual_port_number].driver_type = VIRTUAL_DEVICE_DRIVER;
		else
			sptr_stack_entry->port_number[virtual_port_number].driver_type = sptr_device_driver_entry->type;
	}

	return (PASS);
}
/****************************************************************************/
enum TEST protocol_stack_control (char *cptr_protocol_stack_name,enum PROTOCOL_CONTROL_OPERATION protocol_control_operation,
	ULONG parameter_0,ULONG parameter_1,ULONG parameter_2)
{
	PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry;

	for (sptr_protocol_stack_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.protocol_stacks_list);
		sptr_protocol_stack_entry != NULL;
		sptr_protocol_stack_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_protocol_stack_entry->links))
	{
		if (strcmp (sptr_protocol_stack_entry->name,cptr_protocol_stack_name) == STRINGS_MATCH)
		{
			(*sptr_protocol_stack_entry->fptr_control_routine) (protocol_control_operation,parameter_0,parameter_1,parameter_2);

			return (PASS);
		}
	}

	return (FAIL);
}
/****************************************************************************/
void protocol_stack_port (USHORT real_port_number,ULONG protocol_stack_id,
	enum PROTOCOL_CONTROL_OPERATION protocol_control_operation,ULONG parameter_1,ULONG parameter_2)
{
	USHORT virtual_port_number;
	PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_stack_entry;

	sptr_stack_entry = (PROTOCOL_STACK_REGISTRATION_ENTRY *) protocol_stack_id;

	if (sptr_stack_entry->fptr_control_routine != NULL)
	{
		for (virtual_port_number = 0x0000; virtual_port_number < sptr_stack_entry->number_of_virtual_ports; ++virtual_port_number)
		{
			if (real_port_number ==	sptr_stack_entry->port_number[virtual_port_number].real_port_number)
				(*sptr_stack_entry->fptr_control_routine)	(protocol_control_operation,virtual_port_number,parameter_1,parameter_2);
		}
	}
}
/****************************************************************************/
ULONG low_level_device_driver_port (USHORT virtual_port_number,ULONG protocol_stack_id,
	enum DEVICE_CONTROL_OPERATION device_control_operation,ULONG parameter_1)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = get_device_driver_entry_from_protocol_stack_id (
		(PROTOCOL_STACK_REGISTRATION_ENTRY *) protocol_stack_id,virtual_port_number);

	if (sptr_device_driver_entry->real_port_number >= lsl.number_of_real_ports)
	{
/*		lsl_printf (LSL_ALARM_PRINTF,"Illegal port number %04u in device driver port\r\n",
			sptr_device_driver_entry->real_port_number); */

		return ((ULONG) NULL);
	}

	if (sptr_device_driver_entry->fptr_control_routine != NULL)
	{
 		(*sptr_device_driver_entry->fptr_control_routine) (device_control_operation,
			sptr_device_driver_entry->real_port_number,parameter_1);
	}

	return ((ULONG) NULL);
}
/****************************************************************************/
void high_level_device_driver_port (ULONG device_driver_id,enum DEVICE_CONTROL_OPERATION device_control_operation,
	ULONG parameter_1)
{
	/* Srikar, Mar 24, 1997. Added the following code to reflect the port operational status change. */
	lsl_set_port_operational_status(((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->real_port_number, device_control_operation);

 	(*((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->fptr_control_routine)
		(device_control_operation,((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->real_port_number,parameter_1);
}
/****************************************************************************/
void lsl_port (USHORT real_port_number,enum BOOLEAN port_is_up)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = find_matching_device_driver_for_port_number (real_port_number);

	if (sptr_device_driver_entry->rfc1213_ifEntry.ifOperStatus == REAL_PORT_UP)
	{
		if (port_is_up == FALSE)
		{
			if (lsl.fptr_snmp_trap_function != NULL)
				(*lsl.fptr_snmp_trap_function) (real_port_number,CLOSE_DEVICE_DRIVER);
		}
	}
	else if (sptr_device_driver_entry->rfc1213_ifEntry.ifOperStatus == REAL_PORT_DOWN)
	{
		if (port_is_up == TRUE)
		{
			if (lsl.fptr_snmp_trap_function != NULL)
				(*lsl.fptr_snmp_trap_function) (real_port_number,OPEN_DEVICE_DRIVER);
		}
	}
}
/**********************************************************************************/
void *get_lsl_class (void)
{
	return (&lsl);
}
/**********************************************************************************/
ULONG get_size_of_lsl_class (void)
{
	return (sizeof (LSL_CLASS));
}
/**********************************************************************************/
USHORT convert_stack_virtual_to_real_port_number (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,
	USHORT virtual_port_number)
{
	return (sptr_protocol_stack_entry->port_number[virtual_port_number].real_port_number);
}
/**********************************************************************************/
DEVICE_DRIVER_REGISTRATION_ENTRY *get_device_driver_entry_from_protocol_stack_id
	(PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,USHORT virtual_port_number)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

#if PROXY_SERVER
	sptr_device_driver_entry =
		find_matching_device_driver_for_port_number (sptr_protocol_stack_entry->port_number[virtual_port_number].real_port_number);
#else
#ifndef FRAME_RELAY
	sptr_device_driver_entry =
		find_matching_device_driver_for_port_number (sptr_protocol_stack_entry->port_number[virtual_port_number].real_port_number);
#else

	USHORT real_port_number ;

	real_port_number = sptr_protocol_stack_entry->port_number[virtual_port_number].real_port_number ;
	if (real_port_number > 0)
	{
		real_port_number = get_frame_relay_real_port_number (sptr_protocol_stack_entry->type, virtual_port_number) ;
		if (real_port_number == ILLEGAL_VIRTUAL_PORT_NUMBER)
			real_port_number = sptr_protocol_stack_entry->port_number[virtual_port_number].real_port_number ;
	}
	sptr_device_driver_entry = 
		find_matching_device_driver_for_port_number (real_port_number) ;

#endif
#endif /* PROXY_SERVER */
	return (sptr_device_driver_entry);
}
/****************************************************************************/
USHORT lsl_get_length_of_token_ring_rif (void *vptr_token_ring_frame)
{
	USHORT length_of_token_ring_rif;

	(*lsl.sptr_source_routing->fptr_control_routine) (GET_LENGTH_OF_TOKEN_RING_RIF,(ULONG) &length_of_token_ring_rif,
		(ULONG) vptr_token_ring_frame,(ULONG) NULL);

	return (length_of_token_ring_rif);
}
/****************************************************************************/
enum BOOLEAN lsl_is_token_ring_frame_a_mac (void *vptr_token_ring_frame)
{
	enum BOOLEAN mac_frame;

	if (lsl.sptr_source_routing != NULL)
	{
		(*lsl.sptr_source_routing->fptr_control_routine) (IS_TOKEN_RING_FRAME_A_MAC,(ULONG) &mac_frame,
			(ULONG) vptr_token_ring_frame,(ULONG) NULL);

		return (mac_frame);
	}
	else
		return (FALSE);
}

enum BOOLEAN lsl_is_token_ring_frame_source_routed (void *vptr_token_ring_frame)
{
	enum BOOLEAN source_routed_boolean;

	if (lsl.sptr_source_routing != NULL)
	{
		(*lsl.sptr_source_routing->fptr_control_routine) (IS_TOKEN_RING_FRAME_SOURCE_ROUTED,(ULONG) &source_routed_boolean,
			(ULONG) vptr_token_ring_frame,(ULONG) NULL);

		return (source_routed_boolean);
	}
	else
		return (FALSE);
}
/* Jo 21/04/99 */
#if 0
void lsl_clear_source_routed_bit (void *vptr_token_ring_frame)
{
	if (lsl.sptr_source_routing != NULL)
		{
		(*lsl.sptr_source_routing->fptr_control_routine) (CLEAR_SOURCE_ROUTED_BIT,(ULONG) vptr_token_ring_frame,(ULONG) NULL,
			(ULONG) NULL);
		}
}
#endif
/* Jo 21/04/99 */

void *lsl_move_rif_into_packet (void *vptr_token_ring_packet,USHORT *usptr_size_of_tx_packet) 
{
	void *vptr_new_pointer_to_token_ring_packet;

	if (lsl.sptr_source_routing != NULL)
	{
		vptr_new_pointer_to_token_ring_packet = (void *) (*lsl.sptr_source_routing->fptr_control_routine)
			(MOVE_RIF_INTO_PACKET,(ULONG) vptr_token_ring_packet,(ULONG) usptr_size_of_tx_packet,(ULONG) NULL);
	}
	return (vptr_new_pointer_to_token_ring_packet);
}
/****************************************************************************/
enum BOOLEAN lsl_is_mac_address_source_routed (void *vptr_token_ring_source_address)
{
	enum BOOLEAN source_routed;

	if (lsl.sptr_source_routing != NULL)
	{
		source_routed = (enum BOOLEAN) (*lsl.sptr_source_routing->fptr_control_routine) (IS_MAC_ADDRESS_SOURCE_ROUTED,
			(ULONG) vptr_token_ring_source_address,(ULONG) NULL,(ULONG) NULL);
	}

	return (source_routed);
}

ULONG lsl_port_speed(USHORT real_port_number)
{
	return lsl.port[real_port_number].rfc1213_ifEntry.ifSpeed;
}

/* Srikar, Mar 24, 1997. Following function added to reflect to LSL changes in port speed by wan driver. */

ULONG	lsl_set_port_speed(ULONG real_port_number, ULONG port_speed)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	lsl.port[real_port_number].rfc1213_ifEntry.ifSpeed = port_speed;
	sptr_device_driver_entry = find_matching_device_driver_for_port_number (real_port_number);
	if (sptr_device_driver_entry != NULL)
		sptr_device_driver_entry->rfc1213_ifEntry.ifSpeed = port_speed;
	return(port_speed);
}

/* Srikar, Mar 24, 1997. Following function added to reflect to LSL changes in port status by wan driver. */

ULONG	lsl_set_port_operational_status(ULONG real_port_number, ULONG status_change)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;
	BYTE_ENUM (RFC1213_STATUS)		new_status;
	BYTE_ENUM (RFC1213_IF_TYPE)		interface_type;
	char	*driver_name;

	switch (status_change)
	{
		case LOWER_DEVICE_DRIVER_UP :
		case LOWER_DEVICE_DRIVER_SLIP_UP :
			new_status = REAL_PORT_UP;
			break;
		case LOWER_DEVICE_DRIVER_DOWN :
			new_status = REAL_PORT_DOWN;
			break;
		default :
			return(status_change);
	}

	/* If the connection is made and it is a SLIP connection, set it SLIP mode, else set it PPP. */
	if (status_change == LOWER_DEVICE_DRIVER_SLIP_UP)
	{
		interface_type = SLIP;
		driver_name = SLIP_Driver;
	}
	else
	{
		interface_type = PPP_;
		driver_name = PPP_Driver;
	}

	/* Update the operational status in both the port and device driver entry. Also */
	/* initialize the time the port entered the current operational state and the */
	/* pending outbound packet queue length. */

	lsl.port[real_port_number].rfc1213_ifEntry.ifOperStatus = new_status;
	/* Srikar, Mar 30, 1997. ifLastChange should reflect the sysUpTime when the interface
	enters a new operational state */
	lsl.port[real_port_number].rfc1213_ifEntry.ifLastChange = router_up_time;
	lsl.port[real_port_number].rfc1213_ifEntry.ifOutQLen = 0;
	lsl.port[real_port_number].rfc1213_ifEntry.ifType = interface_type;
	strcpy(lsl.port[real_port_number].rfc1213_ifEntry.ifDescr,driver_name);

	sptr_device_driver_entry = find_matching_device_driver_for_port_number (real_port_number);
	if (sptr_device_driver_entry != NULL)
	{
		sptr_device_driver_entry->rfc1213_ifEntry.ifOperStatus = new_status;
		/* Srikar, Mar 30, 1997. ifLastChange should reflect the sysUpTime when the interface
		enters a new operational state */
		sptr_device_driver_entry->rfc1213_ifEntry.ifLastChange = router_up_time;
		sptr_device_driver_entry->rfc1213_ifEntry.ifOutQLen = 0;
		sptr_device_driver_entry->rfc1213_ifEntry.ifType = interface_type;
		strcpy(sptr_device_driver_entry->rfc1213_ifEntry.ifDescr,driver_name);
	}
	return(status_change);
}

/* Srikar, Mar 24, 1997. Following function added to adjust the length of the transmit pending queue. This is */
/* called by the lower level device driver every time a packet is successfully queued for transmission with the */
/* parameter LSL_PACKET_SUBMITTED_FOR_TRANSMIT. Again this is called when the packet transmission is over with */
/* the parameter LSL_PACKET_TRANSMIT_OVER. */

ULONG	lsl_adjust_out_queue_length(ULONG real_port_number, ULONG event_type)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = find_matching_device_driver_for_port_number (real_port_number);
	if (sptr_device_driver_entry != NULL)
	{
		switch (event_type)
		{
			case LSL_PACKET_SUBMITTED_FOR_TRANSMIT :		/* Packet submitted for transmission and queued.	*/
				lsl.port[real_port_number].rfc1213_ifEntry.ifOutQLen++;
				sptr_device_driver_entry->rfc1213_ifEntry.ifOutQLen++;
				break;
			case LSL_PACKET_TRANSMIT_OVER :					/* Packet transmission complete.	*/
				if (lsl.port[real_port_number].rfc1213_ifEntry.ifOutQLen)
					lsl.port[real_port_number].rfc1213_ifEntry.ifOutQLen--;
				if (sptr_device_driver_entry->rfc1213_ifEntry.ifOutQLen)
					sptr_device_driver_entry->rfc1213_ifEntry.ifOutQLen--;
				break;
			default :
				return(event_type);
		}
	}
	return(event_type);
}

/* Srikar, Mar 24, 1997. Following function added to reflect to LSL changes in port admin status by wan driver. */

ULONG	lsl_set_port_admin_status(ULONG real_port_number, ULONG status_change)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = find_matching_device_driver_for_port_number (real_port_number);
	if (sptr_device_driver_entry != NULL)
	{
		switch (status_change)
		{
			case LSL_PUT_PORT_BACK_TO_SERVICE :
				lsl.port[real_port_number].rfc1213_ifEntry.ifAdminStatus =
					sptr_device_driver_entry->rfc1213_ifEntry.ifAdminStatus = REAL_PORT_UP;
				break;
			case LSL_PUT_PORT_OUT_OF_SERVICE :
				lsl.port[real_port_number].rfc1213_ifEntry.ifAdminStatus =
					sptr_device_driver_entry->rfc1213_ifEntry.ifAdminStatus = REAL_PORT_DOWN;
				break;
		}
	}
	return(status_change);
}
