#include	"defs.h"
/*	$Modname: lslrx.c$  $version: 1.27$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 10/30/92 ross returned to normal lsl, took out temp counter.
1.1 01/31/93 ross
1.2 06/29/93 ross
1.3 07/01/93 ross Fixed timer_ulong bug with 82596 driver
1.4 07/19/93 ross added token ring broadcast case.
1.5 07/27/93 ross
1.6 10/05/93 ross changed BYTE real_port_number to USHORT.
1.7 10/11/93 ross changes for frame relay and spanning tree
1.8 10/28/93 ross changed the broadcast check for group bit only.
1.9 11/01/93 ross ipx certification version
1.10 11/19/93 ross
1.11 12/03/93 ross token ring fixes
1.12 01/08/94 ross More LSL version 3 changes
1.13 02/02/94 ross fixed lslsnap bugs, and added ipx protocol detection, support for dlsx and nlsp
1.14 03/06/94 ross adding more rfc 1213 statistics.
1.15 03/09/94 ross removed some duplicate variables
1.16 03/11/94 ross introduced a bug adding the 1213, sptr_device_driver->type has been changed in router_receive.
1.17 03/14/94 ross removed a 1213 related multiple stack problem.
1.18 03/26/94 ross token ring mac frame filter added.
1.19 04/21/94 ross added code to handle rfc1042.
1.20 06/15/94 ross changed dlsx to dlsw.  Added ifdef for ipx.
1.21 09/26/94 ross protected mode additions.
1.22 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.23 11/18/94 ross added endian conditionals for broadcast bit fields.  Courtesy of Walter.
1.24 01/12/95 ross building rwutils directory.
1.25 02/04/95 ross dynamic drivers and stacks.
1.26 02/21/95 ross add close changes.
1.27 03/31/95 ross New close function, general cleanup.
* 	$lge$
Changes for Frame Relay : Sachin, 18/02/1997
--------------------------------------------
. reset_frame_relay_rxed_dlci (), a new function is called after taking
  out a packet from the device driver.

*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<string.h>
#ifdef DEBUG
	#include	<stdio.h>
#endif
#include	"lsl.h"
ULONG router_up_time;


#if LSL_DEBUG
#if STATUS_DEBUG
extern int lsl_debug_on;
#endif
#endif

/****************************************************************************/
static enum LSL_DESTINATION_ADDRESS_TYPE is_packet_routable (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,
	UNION_MAC_HEADER *sptr_rx_buffer);
enum RX_PACKET_STATE router_receive (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,void *vptr_rx_buffer,
	USHORT number_of_bytes);
static enum RX_PACKET_STATE bridge_receive (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,void *vptr_rx_buffer,
	USHORT number_of_bytes);
void give_receive_packet_to_protocol_stacks (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,
	void *vptr_rx_buffer,USHORT number_of_bytes_rxed);

#ifdef FRAME_RELAY
extern void reset_frame_relay_rxed_dlci () ;
extern USHORT get_frame_relay_virtual_port_number (enum PROTOCOL_STACK_TYPE proto_type) ;
#endif

/****************************************************************************/
/* Sachin 01/02/1997 */
#define ETH_DRIVER_POLL_COUNT 100
void poll_for_packet_received (enum BOOLEAN return_from_poll)
{
	void *vptr_rx_buffer;
	USHORT number_of_bytes_rxed;
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;
	int number_of_times_to_poll, number_of_times_polled ;

	do
	{
		lsl.system_mib.sysUpTime = router_up_time;
		for (sptr_device_driver_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.device_drivers_list) ;
			sptr_device_driver_entry != NULL;
			sptr_device_driver_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_device_driver_entry->links))
		{
/* Sachin 04/04/1997 */
#if 0
			if (sptr_device_driver_entry->rfc1213_ifEntry.ifOperStatus == REAL_PORT_UP)
#endif
/* Sachin 04/04/1997 */
			{
				/* keep track of the number of times, DDs are polled */
				number_of_times_polled = 0 ;

				/* Decide how many times you want THIS DD to be polled */
				if (sptr_device_driver_entry->type == ETHERNET_DEVICE_DRIVER)
					number_of_times_to_poll = ETH_DRIVER_POLL_COUNT ;
				else
					number_of_times_to_poll = 1 ;

				while (number_of_times_polled++ < number_of_times_to_poll)
				{
					if (sptr_device_driver_entry->fptr_rx_routine != NULL)
					{
						if ((*sptr_device_driver_entry->fptr_rx_routine) (sptr_device_driver_entry->real_port_number,
						    &vptr_rx_buffer,&number_of_bytes_rxed) == TRUE)
						{
							give_receive_packet_to_protocol_stacks (sptr_device_driver_entry,vptr_rx_buffer,number_of_bytes_rxed);
							/* process_lsl_message ();*/
						}
						else
							/* Anyway there is no packet received. Stop polling it */
							number_of_times_polled = number_of_times_to_poll ;
#if PROXY_SERVER
#else
/* Sachin 18/03/1997 */
#ifdef FRAME_RELAY
						reset_frame_relay_rxed_dlci() ;
#endif
/* Sachin 18/03/1997 */
#endif
					}
					if (sptr_device_driver_entry->fptr_tx_complete != NULL)
					{
						(*sptr_device_driver_entry->fptr_tx_complete) (sptr_device_driver_entry->real_port_number);
					}
				} /* end of the while loop */
			} /* end of if block for ports that are up */
		} /* end of for loop for each device driver */
	}
	while (return_from_poll == FALSE);

	/* to process messages generated as a result of local events */

	process_lsl_message ();
}
/****************************************************************************/
void give_receive_packet_to_protocol_stacks (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,
	void *vptr_rx_buffer,USHORT number_of_bytes_rxed)
{
	enum RX_PACKET_STATE return_code;

#ifdef DEBUG
	if ((ULONG) vptr_rx_buffer < lsl.buffer.start_address_device_driver_buffers)
	{
		while (TRUE)
		{
			printf ("Illegal Buffer %08lx\r\n",vptr_rx_buffer);
		}
	}
#endif
	return_code = router_receive (sptr_device_driver_entry,vptr_rx_buffer,number_of_bytes_rxed);

	if ((lsl.sptr_dlsw != NULL) && (return_code == PACKET_NOT_RECOGNIZED))
	{
		return_code = (*lsl.sptr_dlsw->fptr_rx_routine)	(sptr_device_driver_entry->real_port_number,vptr_rx_buffer,
			number_of_bytes_rxed);
	}

	if (return_code == PACKET_NOT_RECOGNIZED)
	{
		++sptr_device_driver_entry->rfc1213_ifEntry.ifInUnknownProtos;

		return_code = bridge_receive (sptr_device_driver_entry,vptr_rx_buffer,number_of_bytes_rxed);
	}

	if (return_code != PACKET_RECOGNIZED_AND_FORWARDED)
	{
		if (sptr_device_driver_entry->fptr_rx_buffer_return != NULL)
		{
			(*sptr_device_driver_entry->fptr_rx_buffer_return)	(sptr_device_driver_entry->real_port_number,vptr_rx_buffer);
		}
	}
}
/****************************************************************************/
void internal_device_driver_transmit_complete (ULONG device_driver_id)
{
	if (((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->fptr_tx_complete != NULL)
	{
		(*((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->fptr_tx_complete) (
			((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->real_port_number);
	}
}
/****************************************************************************/
enum RX_PACKET_STATE router_receive (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,void *vptr_rx_buffer,
	USHORT number_of_bytes_rxed)
{
	enum RX_PACKET_STATE return_code;
	BYTE header[MAXIMUM_HEADER_SIZE];
	void *vptr_original_rx_buffer;
	USHORT original_number_of_bytes_rxed;
	USHORT virtual_port_number;
	enum LSL_DESTINATION_ADDRESS_TYPE lsl_destination_address_type;
	PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry;

	return_code = PACKET_NOT_RECOGNIZED;

	memcpy (&header[0],vptr_rx_buffer,MAXIMUM_HEADER_SIZE);

	lsl_destination_address_type = is_packet_routable (sptr_device_driver_entry,(UNION_MAC_HEADER *) vptr_rx_buffer);

#if LSL_DEBUG
#if STATUS_DEBUG
   if (lsl_debug_on)
   {
      switch(lsl_destination_address_type)
      {
         case NOT_ROUTABLE: printf("Packet NOT ROUTABLE\n");break;
         case UNICAST: printf("Packet is UNICAST\n");break;
         case BROADCAST: printf("Packet is BROADCAST \n");break;
         case DIRECTED_TO_ME: printf("Packet is DIRECTED TO ME\n");break;
         default: printf("UNKNOWN PACKET\n");break;
      }
   }
#endif
#endif
	if (lsl_destination_address_type != NOT_ROUTABLE)
	{
		for (sptr_protocol_stack_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.protocol_stacks_list);
			sptr_protocol_stack_entry != NULL;
			sptr_protocol_stack_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_protocol_stack_entry->links))
		{
			if ((sptr_protocol_stack_entry == lsl.sptr_spanning_tree) || (sptr_protocol_stack_entry == lsl.sptr_dlsw))
				continue;

			if (sptr_protocol_stack_entry->fptr_rx_routine != NULL)
			{
				vptr_original_rx_buffer = vptr_rx_buffer;
				original_number_of_bytes_rxed = number_of_bytes_rxed;

#ifdef LSL_HEADER_TRANSLATION

				vptr_rx_buffer = convert_stack_header_in_rx_packet (sptr_device_driver_entry,(PACKET *) vptr_rx_buffer,
					&number_of_bytes_rxed,sptr_protocol_stack_entry);

				if (vptr_rx_buffer == NULL)
				{
/* Commented out by Sanjay -- code moved to drivers */
/*					++sptr_device_driver_entry->rfc1213_ifEntry.ifInErrors; */

					++lsl.statistics.number_of_protocol_packets_dumped;

					break;
				}

#if PROXY_SERVER
				virtual_port_number = convert_real_to_stack_virtual_port_number (sptr_protocol_stack_entry,vptr_rx_buffer,
					sptr_device_driver_entry);
#else
#ifdef FRAME_RELAY
				virtual_port_number = get_frame_relay_virtual_port_number (sptr_protocol_stack_entry->type) ;
				if (virtual_port_number == 0x00FF)
				{
					virtual_port_number = convert_real_to_stack_virtual_port_number (sptr_protocol_stack_entry,vptr_rx_buffer,
						sptr_device_driver_entry);
				}
#else
				virtual_port_number = convert_real_to_stack_virtual_port_number (sptr_protocol_stack_entry,vptr_rx_buffer,
					sptr_device_driver_entry);
#endif
#endif /* PROXY_SERVER */

#else
				virtual_port_number = sptr_device_driver_entry->real_port_number;

#endif
				if (virtual_port_number != ILLEGAL_VIRTUAL_PORT_NUMBER)
				{
/* Commented out by Sanjay -- code moved to drivers */
/*					sptr_device_driver_entry->rfc1213_ifEntry.ifInOctets += number_of_bytes_rxed; */

					switch (lsl_destination_address_type)
					{
						case UNICAST:
						case DIRECTED_TO_ME:
							++sptr_device_driver_entry->rfc1213_ifEntry.ifInUcastPkts;
							break;
						case BROADCAST:
							++sptr_device_driver_entry->rfc1213_ifEntry.ifInNUcastPkts;
							break;
					}

					return_code = (*sptr_protocol_stack_entry->fptr_rx_routine)	(virtual_port_number,vptr_rx_buffer,
						number_of_bytes_rxed);
				}
				else
					++lsl.statistics.number_of_protocol_packets_dumped;

				if (return_code != PACKET_NOT_RECOGNIZED)
					break;

				vptr_rx_buffer = vptr_original_rx_buffer;
				number_of_bytes_rxed = original_number_of_bytes_rxed;

				memcpy (vptr_rx_buffer,&header[0],MAXIMUM_HEADER_SIZE);
			}
		}
	}
	
	return (return_code);
}
/****************************************************************************/
static enum LSL_DESTINATION_ADDRESS_TYPE is_packet_routable (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,
	UNION_MAC_HEADER *sptr_rx_buffer)
{
	USHORT destination_mac_address_ushort;
	ULONG destination_mac_address_ulong;

#ifdef DEBUG
	if (sptr_rx_buffer == NULL)
	{
		while (TRUE)
			printf ("NULL buffer received on port %04x\r\n",sptr_device_driver_entry->real_port_number);
	}
#endif

	if (sptr_device_driver_entry->type == TOKEN_RING_DEVICE_DRIVER)
	{
		destination_mac_address_ushort = sptr_rx_buffer->token_ring.destination_address._ushort;
		destination_mac_address_ulong = sptr_rx_buffer->token_ring.destination_address._ulong;

		if (destination_mac_address_ulong & GROUP_BIT_TOKEN_RING)
			return (BROADCAST);

		if (lsl_is_token_ring_frame_source_routed (sptr_rx_buffer) == TRUE)
			return (UNICAST);
	}
	else
	{
		destination_mac_address_ushort = sptr_rx_buffer->ethernet.destination_address._ushort;
		destination_mac_address_ulong = sptr_rx_buffer->ethernet.destination_address._ulong;

		if (destination_mac_address_ulong & GROUP_BIT_ETHERNET)
			return (BROADCAST);
	}

	if ((destination_mac_address_ushort ==
		sptr_device_driver_entry->rfc1213_ifEntry.ifPhysAddress._ushort) &&
		(destination_mac_address_ulong ==
		sptr_device_driver_entry->rfc1213_ifEntry.ifPhysAddress._ulong))
	{
		return (DIRECTED_TO_ME);
	}
	else
	{
		++lsl.statistics.number_of_non_routable_packets;

		return (NOT_ROUTABLE);
	}
}
/****************************************************************************/
static enum RX_PACKET_STATE bridge_receive (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,
	void *vptr_rx_buffer,USHORT number_of_bytes_rxed)
{
	enum RX_PACKET_STATE return_code;
#ifdef FRAME_RELAY
	int virtual_port_number ;
#endif

	if (sptr_device_driver_entry->type == TOKEN_RING_DEVICE_DRIVER)
	{
		if (lsl_is_token_ring_frame_a_mac (vptr_rx_buffer) == TRUE)
			return (PACKET_NOT_RECOGNIZED);
	}

	if (lsl.sptr_spanning_tree != NULL)
	{
#if PROXY_SERVER
		return_code = (*lsl.sptr_spanning_tree->fptr_rx_routine)	(sptr_device_driver_entry->real_port_number,vptr_rx_buffer,
			number_of_bytes_rxed);
#else
#ifdef FRAME_RELAY
		virtual_port_number = get_frame_relay_virtual_port_number (SPANNING_TREE_STACK) ;
		if (virtual_port_number == 0x00FF)
		{
			virtual_port_number = sptr_device_driver_entry->real_port_number ;
		}
		return_code = (*lsl.sptr_spanning_tree->fptr_rx_routine) (virtual_port_number, vptr_rx_buffer,
			number_of_bytes_rxed) ;
#else
		return_code = (*lsl.sptr_spanning_tree->fptr_rx_routine)	(sptr_device_driver_entry->real_port_number,vptr_rx_buffer,
			number_of_bytes_rxed);
#endif
#endif /* PROXY_SERVER */
	}
	else
		return_code = PACKET_NOT_RECOGNIZED;

	return (return_code);
}
/****************************************************************************/
void process_lsl_message (void)
{
	LSL_MESSAGE *sptr_lsl_message;

	sptr_lsl_message = (LSL_MESSAGE *) get_pointer_to_first_entry_in_list ((LINK *) &lsl.message_list);

	while (sptr_lsl_message != NULL)
	{
		lsl_process_message_list_entry (sptr_lsl_message);

		delete_entry_from_list ((LINK *) &lsl.message_list, (LINK *) sptr_lsl_message);

		table_free ((void *) sptr_lsl_message);

		sptr_lsl_message = (LSL_MESSAGE *) get_pointer_to_first_entry_in_list ((LINK *) &lsl.message_list);
	}
}

