/*	$Modname: vlslsnmp.h$  $version: 1.6$      $date: 07/05/95$   */
/*
* 	$lgb$
1.0 06/15/94 ross initial check-in.
1.1 06/15/94 ross added copyright.
1.2 01/12/95 ross building rwutils directory.
1.3 01/20/95 ross new snmp.
1.4 03/31/95 ross New close function, general cleanup.
1.5 06/29/95 ross new snmp access routine
1.6 07/05/95 ross changes to lsl class.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/

#ifdef _BIG_PROXY_
/* lslsnmp.c */

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
enum TEST get_lsl_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);
enum BOOLEAN lsl_index_value_equals_entry_value (SNMP_TABLE_ENTRY *sptr_snmp_table_entry,void *sptr_mib_table_entry);

/* Srikar, Mar 24, 1997. Added the following function prototypes. */
extern	enum TEST snmp_get_or_set_sysContact (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

extern	enum TEST snmp_get_or_set_sysName (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

extern	enum TEST snmp_get_or_set_sysLocation (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

extern	enum TEST snmp_get_or_set_ifAdminStatus (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

#ifdef __MSDOS__
	SNMP_TABLE_ENTRY_PARAMETERS far	lsl_snmp_table_parameters[] =
#else
	SNMP_TABLE_ENTRY_PARAMETERS lsl_snmp_table_parameters[] =
#endif
{
	{(ULONG) &lsl,
		FALSE
		},

	{(ULONG) NULL,
		TRUE,
		0x01,
		{{
			SNMP_SCALAR_TYPE,
			/* Srikar, Mar 18, 1996. Changed the size of table entry index from that of ulong to byte. */
			/* Srikar, Mar 30, 1996. Changed it back to size of ulong */
			sizeof (ULONG),
			offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifIndex),
			FALSE
		}},
		MIB_TABLE_AS_A_LINKED_LIST,
		&lsl.device_drivers_list
		},

	{(ULONG) &lsl,
		FALSE
		}
};


#ifdef __MSDOS__
	SNMP_TABLE_ENTRY far	lsl_interfaces_snmp_table[] =
#else
	SNMP_TABLE_ENTRY lsl_interfaces_snmp_table[] =
#endif
{
	{"ifNumber",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (LSL_CLASS,number_of_real_ports),
		&lsl_snmp_table_parameters[0]
		},

	{"ifIndex",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifIndex),
		&lsl_snmp_table_parameters[1]
		},

	{"ifDescr",RFC1213_DESCRIPTION_SIZE,snmp_get_or_set_string,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifDescr),
		&lsl_snmp_table_parameters[1]
		},

	{"ifType",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifType),
		&lsl_snmp_table_parameters[1]
		},

	{"ifMtu",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifMtu),
		&lsl_snmp_table_parameters[1]
		},

	{"ifSpeed",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifSpeed),
		&lsl_snmp_table_parameters[1]
		},

	{"ifPhysAddress",0x0006,snmp_get_or_set_mac_address,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifPhysAddress),
		&lsl_snmp_table_parameters[1]
		},

	/* Srikar, Mar 24, 1997. Changed the access function from snmp_get_or_set_ulong to snmp_get_or_set_ifAdminStatus */
	/* to take action of the status change. */
	{"ifAdminStatus",sizeof (ULONG),snmp_get_or_set_ifAdminStatus,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifAdminStatus),
		&lsl_snmp_table_parameters[1]
		},

	{"ifOperStatus",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifOperStatus),
		&lsl_snmp_table_parameters[1]
		},

	/* Srikar, Mar 24, 1997. Changed the access function from snmp_get_or_set_ulong to snmp_get_or_set_ifLastChange. */
	/* Srikar, Mar 30, 1997. Changed the access function back to snmp_get_or_set_ulong */
	{"ifLastChange",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifLastChange),
		&lsl_snmp_table_parameters[1]
		},

	{"ifInOctets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifInOctets),
		&lsl_snmp_table_parameters[1]
		},

	{"ifInUcastPkts",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifInUcastPkts),
		&lsl_snmp_table_parameters[1]
		},

	{"ifInNUcastPkts",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifInNUcastPkts),
		&lsl_snmp_table_parameters[1]
		},

	{"ifInDiscards",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifInDiscards),
		&lsl_snmp_table_parameters[1]
		},

	{"ifInErrors",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifInErrors),
		&lsl_snmp_table_parameters[1]
		},

	{"ifInUnknownProtos",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifInUnknownProtos),
		&lsl_snmp_table_parameters[1]
		},

	{"ifOutOctets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifOutOctets),
		&lsl_snmp_table_parameters[1]
		},

	{"ifOutUcastPkts",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifOutUcastPkts),
		&lsl_snmp_table_parameters[1]
		},

	{"ifOutNUcastPkts",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifOutNUcastPkts),
		&lsl_snmp_table_parameters[1]
		},

	{"ifOutDiscards",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifOutDiscards),
		&lsl_snmp_table_parameters[1]
		},

	{"ifOutErrors",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifOutErrors),
		&lsl_snmp_table_parameters[1]
		},

	{"ifOutQLen",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifOutQLen),
		&lsl_snmp_table_parameters[1]
		},

	{"ifSpecific",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (DEVICE_DRIVER_REGISTRATION_ENTRY,rfc1213_ifEntry.ifSpecific),
		&lsl_snmp_table_parameters[1]
		},

	{"",0x0000,NULL,
		FALSE,
		FALSE,
		(ULONG) NULL,
		NULL
		}
};


#ifdef __MSDOS__
	SNMP_TABLE_ENTRY far	lsl_system_snmp_table[] =
#else
	SNMP_TABLE_ENTRY lsl_system_snmp_table[] =
#endif
{
	{"sysDescr",sizeof (lsl.system_mib.sysDescr),snmp_get_or_set_string,
		FALSE,
		FALSE,
		(ULONG) offsetof (LSL_CLASS,system_mib.sysDescr),
		&lsl_snmp_table_parameters[2]
		},

	/* Srikar, Mar 20, 1997. Changed the mib_access_function from snmp_get_or_set_string. */
	/* This is because after copying the null string, it sets the length to 4 which */
	/* confuses the manager. */
	{"sysObjectID",sizeof (lsl.system_mib.sysObjectID),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (LSL_CLASS,system_mib.sysObjectID),
		&lsl_snmp_table_parameters[2]
		},

	{"sysUpTime",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (LSL_CLASS,system_mib.sysUpTime),
		&lsl_snmp_table_parameters[2]
		},

	/* Srikar, Mar 24, 1997. Changed the access function from snmp_get_or_set_string to snmp_get_or_set_sysContact. */
	/* This is to check the length of the string on set operation and truncate if necessary. */
	{"sysContact",sizeof (lsl.system_mib.sysContact),snmp_get_or_set_sysContact,
		FALSE,
		FALSE,
		(ULONG) offsetof (LSL_CLASS,system_mib.sysContact),
		&lsl_snmp_table_parameters[2]
		},

	/* Srikar, Mar 24, 1997. Changed the access function from snmp_get_or_set_string to snmp_get_or_set_sysName. */
	/* This is to check the length of the string on set operation and truncate if necessary. */
	{"sysName",sizeof (lsl.system_mib.sysName),snmp_get_or_set_sysName,
		FALSE,
		FALSE,
		(ULONG) offsetof (LSL_CLASS,system_mib.sysName),
		&lsl_snmp_table_parameters[2]
		},

	/* Srikar, Mar 24, 1997. Changed the access function from snmp_get_or_set_string to snmp_get_or_set_sysLocation. */
	/* This is to check the length of the string on set operation and truncate if necessary. */
	{"sysLocation",sizeof (lsl.system_mib.sysLocation),snmp_get_or_set_sysLocation,
		FALSE,
		FALSE,
		(ULONG) offsetof (LSL_CLASS,system_mib.sysLocation),
		&lsl_snmp_table_parameters[2]
		},

	{"sysServices",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (LSL_CLASS,system_mib.sysServices),
		&lsl_snmp_table_parameters[2]
		},

	{"",0x0000,NULL,
		FALSE,
		FALSE,
		(ULONG) NULL,
		NULL
		}
};
#endif
