/*	$Modname: vlslstr.h$  $version: 1.25$      $date: 07/05/95$   */
/*
* 	$lgb$
1.0 01/31/93 ross
1.1 07/01/93 ross Fixed timer_ulong bug with 82596 driver
1.2 07/27/93 ross
1.3 10/11/93 ross changes for frame relay and spanning tree
1.4 10/12/93 ross added ifdef wrapper arount the pack 1.
1.5 11/01/93 ross ipx certification version
1.6 11/19/93 ross
1.7 11/29/93 ross version 3.0 beta release
1.8 12/03/93 ross token ring fixes
1.9 01/08/94 ross More LSL version 3 changes
1.10 02/02/94 ross fixed lslsnap bugs, and added ipx protocol detection, support for dlsx and nlsp
1.11 03/06/94 ross adding more rfc 1213 statistics.
1.12 03/09/94 ross removed some duplicate variables
1.13 03/09/94 ross removing the wan_port dependency on rip and sap aging.
1.14 03/11/94 ross removed packed pragma, look in kstart.h
1.15 03/26/94 ross changed saps from bytes to enums.
1.16 04/21/94 ross got rid of old ip boolean.
1.17 06/15/94 ross added trap function.
1.18 09/26/94 ross protected mode changes.
1.19 09/29/94 ross added BYTE_ENUM and USHORT_ENUM
1.20 01/12/95 ross building rwutils directory.
1.21 02/21/95 ross add close changes.
1.22 03/03/95 ross added lsl control.
1.23 03/31/95 ross New close function, general cleanup.
1.24 06/29/95 ross new snmp access routine
1.25 07/05/95 ross changes to lsl class.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef LINK_TYPEDEF_DEFINED

	#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;
} LINK;

#endif

typedef	struct	LSL_STATISTICS
{
	ULONG	number_of_packets_txed;
	ULONG	number_of_discarded_tx_packets;
	ULONG	number_of_packets_rxed;
	ULONG	number_of_non_routable_packets;
	ULONG number_of_protocol_packets_dumped;

} LSL_STATISTICS;

typedef	struct	GENERIC_LINKS
{
	struct GENERIC_LINKS *sptr_forward_link;
	struct GENERIC_LINKS *sptr_backward_link;
} GENERIC_LINKS;

typedef	struct	GENERIC_REGISTRATION_ENTRY
{
	GENERIC_LINKS	links;
	ULONG				id;
	enum TEST 		(*fptr_control_routine) (ULONG command,ULONG parameter_0,ULONG parameter_1);
	char				name[30];
} GENERIC_REGISTRATION_ENTRY;

typedef	struct	APPLICATION_LINKS
{
	struct APPLICATION_REGISTRATION_ENTRY *sptr_forward_link;
	struct APPLICATION_REGISTRATION_ENTRY *sptr_backward_link;
} APPLICATION_LINKS;

typedef	struct	APPLICATION_REGISTRATION_ENTRY
{
	APPLICATION_LINKS						links;

	ULONG										id;
	enum TEST 								(*fptr_control_routine)
													(enum APPLICATION_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1);

	char										name[30];

	BYTE_ENUM (APPLICATION_TYPE)		type;

	BYTE_ENUM (BOOLEAN)					enabled;

	void 										(*fptr_timer_routine) (void);
} APPLICATION_REGISTRATION_ENTRY;

typedef	struct	TRANSPORT_LINKS
{
	struct TRANSPORT_REGISTRATION_ENTRY *sptr_forward_link;
	struct TRANSPORT_REGISTRATION_ENTRY *sptr_backward_link;
} TRANSPORT_LINKS;

typedef	struct	TRANSPORT_REGISTRATION_ENTRY
{
	TRANSPORT_LINKS						links;
	ULONG										id;
	enum TEST 								(*fptr_control_routine)
													(enum TRANSPORT_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1);

	char										name[30];

	BYTE_ENUM (TRANSPORT_TYPE)			type; 

	BYTE_ENUM (BOOLEAN)					enabled;
	BYTE										filler;

	void 										(*fptr_timer_routine) (void);
} TRANSPORT_REGISTRATION_ENTRY;

typedef	struct	TRANSPORTS
{
	TRANSPORT_REGISTRATION_ENTRY registration_entry[MAXIMUM_NUMBER_OF_TRANSPORTS];
} TRANSPORTS;

typedef	struct	PROTOCOL_PORT_NUMBER
{
	USHORT									real_port_number;
	USHORT									virtual_port_number;
	BYTE_ENUM (DEVICE_DRIVER_TYPE)	driver_type;
	USHORT_ENUM (LSL_PACKET_TYPE)		packet_type;
} PROTOCOL_PORT_NUMBER;

typedef	struct	PROTOCOL_STACK_LINKS
{
	struct PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_forward_link;
	struct PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_backward_link;
} PROTOCOL_STACK_LINKS;

typedef	struct	PROTOCOL_STACK_REGISTRATION_ENTRY
{
	PROTOCOL_STACK_LINKS					links;
	ULONG										id;
	enum TEST 								(*fptr_control_routine)	(enum PROTOCOL_CONTROL_OPERATION command, ULONG parameter_0,
													ULONG parameter_1, ULONG parameter_2);

	char										name[30];

	BYTE_ENUM (PROTOCOL_STACK_TYPE)	type; 

	BYTE_ENUM (BOOLEAN)					enabled;

	enum RX_PACKET_STATE 				(*fptr_rx_routine) (USHORT port_number,void *vptr_buffer,USHORT number_of_bytes);
	void 										(*fptr_timer_routine) (void);

	PROTOCOL_PORT_NUMBER					port_number[MAXIMUM_NUMBER_OF_VIRTUAL_PORTS];
	USHORT									number_of_virtual_ports;

	USHORT_ENUM (SNAP_PROTOCOL_ID)	snap_protocol_id;
	BYTE_ENUM (SAP_TYPES)	 			source_address_SSAP;
	BYTE_ENUM (SAP_TYPES)	 			source_address_DSAP;

	USHORT									buffer_size;
	LINK										tx_buffer_list;
	USHORT									number_of_tx_buffers_in_use;
	USHORT									tx_buffer_limit;
} PROTOCOL_STACK_REGISTRATION_ENTRY;

typedef	struct	PROTOCOL_STACKS
{
	PROTOCOL_STACK_REGISTRATION_ENTRY registration_entry[MAXIMUM_NUMBER_OF_PROTOCOL_STACKS];
} PROTOCOL_STACKS;

typedef	struct	RFC1213_DEVICE_DRIVER_TYPE
{
	ULONG_ENUM (RFC1213_IF_TYPE)		ifType;

	ULONG_ENUM (DEVICE_DRIVER_TYPE)	type;

} RFC1213_DEVICE_DRIVER_TYPE;

typedef	struct	LSL_PRINT_CLASS
{
	BYTE_ENUM (BOOLEAN)						enabled;
	BYTE_ENUM (BOOLEAN)						snap_enabled;
	BYTE_ENUM (BOOLEAN)						snmp_enabled;
	BYTE_ENUM (BOOLEAN)						buffer_enabled;
	BYTE_ENUM (BOOLEAN)						alarm_enabled;
} LSL_PRINT_CLASS;


typedef	struct	LSL_CONSOLE_CLASS
{
	BYTE_ENUM (BOOLEAN)						remote_printing;
	BYTE_ENUM (BOOLEAN)						local_printing;
	USHORT										size_of_remote_buffer;
	char											*cptr_remote_buffer;
	char											*cptr_current_buffer_string;
} LSL_CONSOLE_CLASS;


typedef	struct	LSL_SYSTEM_MIB
{
	char 			sysDescr[SIZE_OF_SYSTEM_DESCRIPTION];
	char 			sysObjectID[SIZE_OF_SYSTEM_OBJECT_ID];
	ULONG 		sysUpTime;
	char 			sysContact[SIZE_OF_SYSTEM_CONTACT];
	char 			sysName[SIZE_OF_SYSTEM_NAME];
	char 			sysLocation[SIZE_OF_SYSTEM_LOCATION];
	ULONG 		sysServices;
} LSL_SYSTEM_MIB;

typedef struct LSL_PORT_CLASS
{
	RFC1213_IFENTRY rfc1213_ifEntry ;
	USHORT buffer_size ;
	LINK rx_buffer_list ;
	USHORT number_of_buffers_allocated ;
	USHORT number_of_system_buffers_free ;
	USHORT current_rx_buffers_in_list ;
	USHORT rx_buffer_lower_limit ;
	USHORT current_tx_buffers_in_list ;
	USHORT tx_buffer_upper_limit ;
	USHORT header_size ;
/* Sachin 25/04/1997 */
   USHORT buffer_share_factor ;
/* Sachin 25/04/1997 */
} LSL_PORT_CLASS ; 

typedef struct LSL_CLASS
{
	LSL_PORT_CLASS port[MAXIMUM_NUMBER_OF_DEVICE_DRIVERS] ;
	LSL_BUFFER_CLASS buffer ;
	USHORT number_of_virtual_ports ;
	USHORT number_of_lan_ports ;
	USHORT number_of_wan_ports ;
	ULONG number_of_real_ports ;
	USHORT number_of_device_drivers ;
	void (*fptr_snmp_trap_function)
	 (USHORT real_port_number,enum DEVICE_CONTROL_OPERATION control_command);
	BYTE_ENUM (BOOLEAN) real_mode;
	APPLICATION_LINKS applications_list;	
	TRANSPORT_LINKS transports_list;
	PROTOCOL_STACK_LINKS protocol_stacks_list;
	DEVICE_DRIVER_LINKS device_drivers_list;
	LSL_MESSAGE_LINK message_list;
	PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_source_routing;
	PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_dlsw;
	PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_spanning_tree;
	LSL_CONSOLE_CLASS console;

#if PRINT_IP_TABLE_INFO /* Jo 21/05/99 */
	LSL_PRINT_CLASS print;
#endif /* Jo 21/05/99 */
	ULONG	clock_ticks_per_second;
	LSL_STATISTICS	statistics;
	LSL_SYSTEM_MIB	system_mib;
	BYTE_ENUM (BOOLEAN) started_system_shutdown;
} LSL_CLASS;

typedef struct	LSL_CONTROL_FUNCTION_TABLE
{
	ULONG	(*fptr_control_function) (ULONG parameter_0,ULONG parameter_1,ULONG parameter_2,
					ULONG parameter_3,ULONG parameter_4,ULONG parameter_5,ULONG parameter_6,ULONG parameter_7,ULONG parameter_8) ;
	USHORT number_of_parameters_to_pass ;
} LSL_CONTROL_FUNCTION_TABLE ;


/* lslbuff.c */

enum TEST packet_forward_device_driver_free (USHORT real_tx_port_number,ULONG tx_device_driver_id,void *vptr_buffer_data);
enum TEST initialize_buffer_class (ULONG size_of_memory_for_device_drivers);
void set_current_rx_buffer_list_size (ULONG rx_device_driver_id,USHORT size_of_rx_list);
ULONG get_current_rx_buffer_list_size (ULONG rx_device_driver_id);
ULONG lsl_get_buffer_size (USHORT real_port_number);
ULONG lsl_get_port_mtu (USHORT real_port_number);
ULONG lsl_rx_list_add (ULONG rx_device_driver_id);
enum DEVICE_DRIVER_TYPE lsl_get_device_driver_type_from_receive_port (void *vptr_buffer);
enum BOOLEAN lsl_tx_list_packet_sent (ULONG tx_device_driver_id);

/* lslinit.c */

void close_buffer_class (void);
enum TEST initialize_lsl (ULONG ticks_per_second);
enum TEST close_lsl (void);
enum TEST deregister_module (enum ISO_LAYER_TYPE iso_layer_type, ULONG module_id);
ULONG register_application
	(
	char *cptr_application_name,
	enum APPLICATION_TYPE type,
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum APPLICATION_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	ULONG *ulptr_return_application_id
	);

ULONG register_transport
	(
	char *cptr_transport_name,
	enum TRANSPORT_TYPE type,
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum TRANSPORT_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	ULONG *ulptr_return_transport_id
	);

ULONG register_protocol_stack
	(
	char *cptr_stack_name,
	enum RX_PACKET_STATE (*fptr_rx_routine) (USHORT port_number,void *vptr_buffer,USHORT number_of_bytes),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum PROTOCOL_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1,
		ULONG parameter_2),
	ULONG *ulptr_return_protocol_id
	);

ULONG register_device_driver
	(
	char *cptr_device_name,
	enum DEVICE_DRIVER_TYPE device_driver_type,
	enum TEST (*fptr_tx_routine) (ULONG protocol_stack_id,USHORT port_number,USHORT virtual_port_number,void *sptr_tx_buffer,
		USHORT number_of_bytes,enum BOOLEAN bridged_packet,enum BOOLEAN protocol_packet,
		void (*fptr_tx_completion)	(USHORT port_number,void *sptr_ethernet_buffer)),
	void 	(*fptr_tx_complete) (USHORT port_number),
	enum BOOLEAN (*fptr_rx_routine) (USHORT port_number,void **vptr_buffer,USHORT *usptr_number_of_bytes_rxed),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum DEVICE_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	void 	(*fptr_rx_buffer_return) (USHORT port_number,void *vptr_buffer),
	ULONG *ulptr_return_device_driver_id
	);

ULONG register_serial_device_driver
	(
	USHORT port_number,
	char *cptr_device_name,
	enum SERIAL_DRIVER_TYPE device_driver_type,
	enum TEST (*fptr_tx_routine) (USHORT port_number,USHORT virtual_port_number,void *sptr_tx_buffer,
		USHORT number_of_bytes,enum BOOLEAN do_not_calculate_new_crc,enum BOOLEAN device_driver_buffer,
		void (*fptr_tx_completion)	(USHORT port_number,void *vptr_tx_buffer)),
	void 	(*fptr_tx_complete) (USHORT port_number),
	enum BOOLEAN (*fptr_rx_routine) (USHORT port_number,void **vptr_buffer,USHORT *usptr_number_of_bytes_rxed),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum SERIAL_DRIVER_CONTROL command,ULONG parameter_0,ULONG parameter_1),
	void 	(*fptr_rx_buffer_return) (USHORT port_number,void *vptr_buffer)
	);

void issue_command_to_entry_control_routine (ULONG command,GENERIC_LINKS *sptr_generic_links);

void register_lsl_trap_function (void (*fptr_lsl_trap_function) (USHORT real_port_number,
	enum DEVICE_CONTROL_OPERATION control_command));

/* lslrx.c */

void internal_device_driver_transmit_complete (ULONG device_driver_id);
void process_lsl_message (void);

/* lslutil.c */

void pass_stack_id_to_device_driver (char *cptr_stack_name,ULONG stack_id);
void lsl_printf (enum LSL_PRINTF_GROUPS printf_group,const char *cptr_format, ...);

/* lslsnap.c */

void *convert_stack_header_in_rx_packet (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,PACKET *sptr_rx_packet,
	USHORT *usptr_size_of_rx_packet,PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry);
void *convert_stack_header_for_tx (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,USHORT virtual_port_number,
	PACKET *sptr_tx_packet,USHORT *usptr_size_of_tx_packet);
USHORT convert_real_to_stack_virtual_port_number (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,
	void *vptr_rx_buffer,DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry);
USHORT raw_convert_real_to_stack_virtual_port_number (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,
	void *vptr_rx_buffer,DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry);
DEVICE_DRIVER_REGISTRATION_ENTRY *get_device_driver_entry_from_protocol_stack_id
	(PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,USHORT virtual_port_number);
DEVICE_DRIVER_REGISTRATION_ENTRY *find_matching_device_driver_for_port_number (USHORT real_port_number);

/* lslport.c */
void initialize_port_class (void);
enum TEST get_port_parameters (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_stack_entry);
ULONG serial_driver_get_device_driver_id (USHORT real_port_number);
void lsl_port (USHORT real_port_number,enum BOOLEAN port_is_up);
ULONG low_level_device_driver_port (USHORT virtual_port_number,ULONG protocol_stack_id,
	enum DEVICE_CONTROL_OPERATION device_control_operation,ULONG parameter_1);
void high_level_device_driver_port (ULONG device_driver_id,enum DEVICE_CONTROL_OPERATION device_control_operation,
	ULONG parameter_1);
enum TEST protocol_stack_control (char *cptr_protocol_stack_name,enum PROTOCOL_CONTROL_OPERATION protocol_control_operation,
	ULONG parameter_0,ULONG parameter_1,ULONG parameter_2);
ULONG get_number_of_wan_ports (void);
ULONG get_number_of_lan_ports (void);
ULONG get_hardware_model (void);
enum BOOLEAN lsl_is_token_ring_frame_source_routed (void *vptr_token_ring_frame);
enum BOOLEAN lsl_is_token_ring_frame_a_mac (void *sptr_token_ring_frame);
USHORT lsl_get_length_of_token_ring_rif (void *vptr_token_ring_frame);
void lsl_clear_source_routed_bit (void *sptr_token_ring_frame);
void *lsl_move_rif_into_packet (void *sptr_token_ring_packet,USHORT *usptr_size_of_tx_packet);
enum BOOLEAN lsl_is_mac_address_source_routed (void *sptr_token_ring_source_address);
USHORT convert_stack_virtual_to_real_port_number (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,
	USHORT virtual_port_number);
ULONG get_size_of_lsl_class (void);
void protocol_stack_port (USHORT real_port_number,ULONG protocol_stack_id,
	enum PROTOCOL_CONTROL_OPERATION protocol_control_operation,ULONG parameter_1,ULONG parameter_2);
void *get_lsl_class (void);
ULONG lsl_port_speed(USHORT real_port_number);

/* Srikar, Mar 24, 1997. Following function prototypes added to reflect to LSL changes in port speed and status by wan driver. */

extern	ULONG	lsl_set_port_speed(ULONG real_port_number, ULONG port_speed);
extern	ULONG	lsl_set_port_operational_status(ULONG real_port_number, ULONG status_change);
extern	ULONG	lsl_adjust_out_queue_length(ULONG real_port_number, ULONG event_type);

/* Srikar, Mar 24, 1997. Following function prototypes added to reflect to LSL changes in port admin status by wan driver. */

extern	ULONG	lsl_set_port_admin_status(ULONG real_port_number, ULONG status_change);

#ifndef BIG_ENDIAN
	extern USHORT swap (USHORT ushort_to_swap);
#endif

/* lslmsg.c */
enum TEST lsl_process_message_list_entry (LSL_MESSAGE *sptr_lsl_message);

/* lslctrl.c */

void copy_protected_mode_lsl (LSL_CLASS *sptr_destination_lsl,USHORT selector,LSL_CLASS *sptr_source_lsl,ULONG lsl_size);
void check_lsl (LSL_CLASS *sptr_lsl);
void get_mac_address (USHORT virtual_port_number,ULONG protocol_stack_id,MAC_ADDRESS *sptr_return_mac_address);
void device_driver_get_mac_address (USHORT real_port_number,MAC_ADDRESS *sptr_return_mac_address);
ULONG get_random_number (void);
char *get_remote_console_buffer_string (char **ptr_cptr_end_of_string);
enum TEST lsl_configuration (enum ISO_LAYER_TYPE iso_layer_type, ULONG command,ULONG parameter_0,ULONG parameter_1);
enum TEST lsl_pass_parameters_to_transport (enum TRANSPORT_TYPE transport_type,	ULONG command,	ULONG parameter_0,
	ULONG parameter_1);
enum TEST lsl_pass_parameters_to_protocol_stack (enum PROTOCOL_STACK_TYPE protocol_stack_type,	ULONG command,
	ULONG parameter_0, ULONG parameter_1);
ULONG get_driver_header_size (ULONG device_driver_id);
void protocol_stack_virtual_port (USHORT virtual_port_number,ULONG protocol_stack_id,
	enum PROTOCOL_CONTROL_OPERATION protocol_control_operation,ULONG parameter_1,ULONG parameter_2);
void initialize_lsl_function_pointers (enum APPLICATION_TYPE application_type, ULONG *ptr_to_fptr_poll_for_packet_received,
	ULONG *ptr_to_fptr_polling_timer_interrupt);
enum TEST lsl_pass_parameters_to_application (enum APPLICATION_TYPE application_type,	ULONG command,	ULONG parameter_0,
	ULONG parameter_1);
enum TEST get_channel_occupancy (ULONG port_number, ULONG *ulptr_channel_occupancy, ULONG unloaded_bandwidth,
	ULONG number_of_neighbors);
enum TEST get_interface_error_rate (ULONG port_number, ULONG *ulptr_error_rate);


