#include	"defs.h"
/*	$Modname: convutls.c$  $version: 1.1$      $date: 01/12/95$   */
/*
* 	$lgb$
1.0 01/12/95 ross
1.1 01/12/95 ross added copyright.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <kstart.h>
#include	<v8022str.h>
#include <lslproto.h>
/*************************************************************/
#define NUMBER_OF_BITS_IN_BYTE 		8
/*************************************************************/
USHORT host_to_net_short (USHORT host_order_short_value)
{
#ifdef BIG_ENDIAN

	return (host_order_short_value);

#else

	BYTE *bptr_return_value;
	USHORT net_order_value;

	bptr_return_value = (BYTE *) &net_order_value;

	*bptr_return_value = (BYTE) (host_order_short_value >> NUMBER_OF_BITS_IN_BYTE);

	++bptr_return_value;

	*bptr_return_value = host_order_short_value;

	return (net_order_value);

#endif
}
/*****************************************************************************/
USHORT net_to_host_short (USHORT net_order_short_value)
{
#ifdef BIG_ENDIAN

	return (net_order_short_value);

#else

	USHORT host_order_value;
	BYTE *bptr_net_order_value;

	bptr_net_order_value = (BYTE *) &net_order_short_value;

	host_order_value = *bptr_net_order_value;

	++bptr_net_order_value;

	host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

	host_order_value = (USHORT) (host_order_value | *bptr_net_order_value);

	return (host_order_value);

#endif
}											
/*****************************************************************************/
ULONG host_to_net_long (ULONG host_order_long_value)
{
#ifdef BIG_ENDIAN

	return (host_order_long_value);

#else

	BYTE *bptr_net_order_value;
	BYTE *bptr_host_order_long_value;
	ULONG net_order_value;

	bptr_net_order_value = (BYTE *) &net_order_value + (sizeof (ULONG) - 0x0001);

	bptr_host_order_long_value = (BYTE *) &host_order_long_value;

	*bptr_net_order_value = *bptr_host_order_long_value;

	--bptr_net_order_value;

	++bptr_host_order_long_value;

	*bptr_net_order_value = *bptr_host_order_long_value;

	--bptr_net_order_value;

	++bptr_host_order_long_value;

 		*bptr_net_order_value = *bptr_host_order_long_value;

	--bptr_net_order_value;

	++bptr_host_order_long_value;

	*bptr_net_order_value = *bptr_host_order_long_value;

	return (net_order_value);

#endif
}
/*****************************************************************************/
ULONG net_to_host_long (ULONG net_order_long_value)
{
#ifdef BIG_ENDIAN

	return (net_order_long_value);

#else

	ULONG host_order_value;
	BYTE *bptr_net_order_long_value;

	bptr_net_order_long_value = (BYTE *) &net_order_long_value;

	host_order_value = *bptr_net_order_long_value;

	++bptr_net_order_long_value;

	host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

	host_order_value = host_order_value | *bptr_net_order_long_value;

	++bptr_net_order_long_value;

	host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

	host_order_value = host_order_value | *bptr_net_order_long_value;

	++bptr_net_order_long_value;

	host_order_value <<= NUMBER_OF_BITS_IN_BYTE;

	host_order_value = host_order_value | *bptr_net_order_long_value;

	return (host_order_value);

#endif
}
#ifndef BIG_ENDIAN
/****************************************************************************/
USHORT swap (USHORT ushort_to_swap_bytes_with)
{
	USHORT low_byte;
	USHORT high_byte;
	USHORT return_value;

	low_byte = (USHORT) low_byte_of_ushort (ushort_to_swap_bytes_with);

	high_byte = (USHORT) high_byte_of_ushort (ushort_to_swap_bytes_with);

	return_value = (USHORT) two_bytes_to_ushort (low_byte, high_byte);

	return (return_value);
}
/****************************************************************************/
ULONG swap_long (ULONG ulong_to_swap_bytes_with)
{
	ULONG return_value;
	BYTE *bptr_return_value;
	BYTE *bptr_ulong;

	bptr_return_value = (BYTE *) &return_value + 3;

	bptr_ulong = (BYTE *) &ulong_to_swap_bytes_with;

	*bptr_return_value = *bptr_ulong;

	--bptr_return_value;

	++bptr_ulong;

	*bptr_return_value = *bptr_ulong;

	--bptr_return_value;

	++bptr_ulong;

	*bptr_return_value = *bptr_ulong;

	--bptr_return_value;

	++bptr_ulong;

	*bptr_return_value = *bptr_ulong;

	return (return_value);
}
#endif

