/**  **/
/*	Author 	: Neelu																		*/
/*	Module	: Event Broadcast           											*/
/*	Synopsis	: Sends a UDP Broadcast as soon as any event occurs         */
/**  **/
/* Subbi ported from  Neelu on 22 Sep 1999 and included changes in it */

#include	<stdlib.h>
#include "event.h"
#include "evnt.h"	/* Added by Subbi on 30 Sep 1999 for changes */
#include "evntstr.h"

const char *users_log_msgs[] = 
   {  
		"WAN Link Up on Port %s",
		"Port %s Idle",
		"RAS Client connected on Port %s ",
		"RAS Client disconnected from Port %s",
 	  	"User Accessing Destination IP Filtered Sites",
		"User Accessing Source IP Filtered Sites",
		"User Accessing MAC Address Filtered Sites",
		"User Accessing Domain Name Filtered Sites",
		"User Accessing Application Filtered Sites",
		"Modem reports ERROR on WAN",
	   "Modem reports BUSY on WAN",
	   "Modem reports NO CARRIER on WAN",		
		"Proxy Server Rebooted",
		"Waiting Connect Message",
		"DCD detected on WAN",
		"DCD lost on WAN",
		"Changing to PPP on WAN",
		"Changing to UART on WAN",
		"Callback arranged on WAN",
		"Callback cancelled on WAN",
		"CHAP authentication OK on WAN",
		"CHAP authentication fails on WAN",
		"Remote PAP authentication OK on WAN",
		"Remote PAP authentication failed on WAN",
		"PAP authentication OK on WAN",
		"PAP authentication failed on WAN",
		"Going down by no demand on DOD port",
      "Coming up by demand on DOD port"
  	};/* Subbi changed the structure on 28 Sep 1999 */

extern UNION_IP_PACKET *get_an_ip_send_packet (USHORT port_number, ULONG size_of_packet);
extern void send_completion_ip_packet (USHORT port_number, void *vptr_txed_packet);
extern ULONG get_ip_address(USHORT port_number);
static void send_event_packet (IP_SOCKET *sptr_remote_socket, EVENT_HEADER *event_packet);
void event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet);

void event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet)
{
	USHORT port_number;
	IP_SOCKET remote_socket;

   remote_socket.ip_address = INTERNET_ADDRESS_BROADCAST;

	remote_socket.port = EVENT_PORT; /* 1025 */
	remote_socket.virtual_port_number = 0 ;
	send_event_packet (&remote_socket, event_packet);
}


static void send_event_packet (IP_SOCKET *sptr_remote_socket,EVENT_HEADER *event_packet)
{
	EVENT_REQUEST_PACKET *sptr_event_request_packet;
	IP_SOCKET local_socket;
	UNION_SERVICE_TYPE_BIT_STRUCTURE type_of_service;
	USHORT size;
	EVENT_HEADER event_broadcast_pkt;

	sptr_event_request_packet = (EVENT_REQUEST_PACKET *) get_an_ip_send_packet (sptr_remote_socket->virtual_port_number,
											sizeof (EVENT_REQUEST_PACKET));
	if (sptr_event_request_packet == NULL)
	{
			return;
	}
	
	local_socket.ip_address = get_ip_address(sptr_remote_socket->virtual_port_number);
	local_socket.port = EVENT_PORT;

	event_packet->server_ip_address = get_ip_address(0);
	sptr_event_request_packet->header = *event_packet;
	
	type_of_service._byte = 0x00;
	
	send_udp (sptr_remote_socket->virtual_port_number, &local_socket, sptr_remote_socket, type_of_service._bit,
		255, (void *)sptr_event_request_packet, 0, FALSE, sizeof (EVENT_REQUEST_PACKET),
		send_completion_ip_packet, NULL);
}
