#include	"defs.h"
/*	$Modname: listutls.c$  $version: 1.2$      $date: 03/11/95$   */
/*
* 	$lgb$
1.0 01/12/95 ross
1.1 01/12/95 ross added copyright.
1.2 03/11/95 ross added new list routine.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdio.h>
#include <kstart.h>
#include	<v8022str.h>
#include <lslproto.h>
/*************************************************************************/
void add_entry_to_list (LINK *sptr_link, LINK *sptr_link_to_add)
{

	if (sptr_link == NULL)
		return;

	if (sptr_link_to_add == NULL)
		return;

	sptr_link_to_add->sptr_backward_link = sptr_link->sptr_backward_link;

	if (sptr_link->sptr_backward_link != NULL)
		sptr_link->sptr_backward_link->sptr_forward_link = sptr_link_to_add;
	else
		sptr_link->sptr_forward_link = sptr_link_to_add;
	
	sptr_link->sptr_backward_link = sptr_link_to_add;

	sptr_link_to_add->sptr_forward_link = NULL;
}
/*************************************************************************/

void *get_entry_from_list (LINK *sptr_link)
{
	LINK	*sptr_return_link;

	if (sptr_link == NULL)
		return (NULL);

	sptr_return_link = sptr_link->sptr_forward_link;

	if (sptr_return_link != NULL)
		{
		sptr_link->sptr_forward_link = sptr_link->sptr_forward_link->sptr_forward_link;

		if (sptr_link->sptr_forward_link != NULL)
			sptr_link->sptr_forward_link->sptr_backward_link = NULL;
		else 
			sptr_link->sptr_backward_link = NULL;

		if (sptr_return_link != NULL)
			{
			sptr_return_link->sptr_forward_link = NULL;
			sptr_return_link->sptr_backward_link = NULL;
			}
		}

	return (sptr_return_link);
}
/*************************************************************************/
void delete_entry_from_list (LINK *sptr_list_link, LINK *sptr_link_to_delete)
{
	if (sptr_list_link == NULL)
		return;

	if (sptr_link_to_delete == NULL)
		return;

	if (sptr_link_to_delete->sptr_forward_link == NULL && sptr_link_to_delete->sptr_backward_link == NULL) /* 1 entry in list */
		{
		sptr_list_link->sptr_forward_link = NULL;
		sptr_list_link->sptr_backward_link = NULL;
		return;
		}

	if (sptr_link_to_delete->sptr_backward_link == NULL) /* First entry in N (N >= 2) entry list  */
		sptr_list_link->sptr_forward_link = sptr_link_to_delete->sptr_forward_link; /* new first entry in list have list point to it */
	else 
		sptr_link_to_delete->sptr_backward_link->sptr_forward_link = sptr_link_to_delete->sptr_forward_link;

	if (sptr_link_to_delete->sptr_forward_link == NULL) /* Last entry in N (N >= 2) entry list */
		sptr_list_link->sptr_backward_link = sptr_link_to_delete->sptr_backward_link; /* new last entry in list because we're deleting the end*/
	else 
		sptr_link_to_delete->sptr_forward_link->sptr_backward_link = sptr_link_to_delete->sptr_backward_link;

	sptr_link_to_delete->sptr_forward_link = NULL;
	sptr_link_to_delete->sptr_backward_link = NULL;
}
/*************************************************************************/
void add_entry_to_front_of_list (LINK *sptr_link, LINK *sptr_link_to_add)
{
	if (sptr_link == NULL)
		return;

	if (sptr_link_to_add == NULL)
		return;

	if (sptr_link->sptr_forward_link != NULL)
		{
		sptr_link_to_add->sptr_forward_link = sptr_link->sptr_forward_link;

		sptr_link->sptr_forward_link->sptr_backward_link = sptr_link_to_add;
		}
	else
		{
		sptr_link->sptr_backward_link = sptr_link_to_add;
		}

	sptr_link->sptr_forward_link = sptr_link_to_add;
	
	sptr_link_to_add->sptr_backward_link = NULL;
}
/*************************************************************************/
void insert_entry_in_list (LINK *sptr_link, LINK *sptr_link_to_add, LINK *sptr_link_after_which_to_add)
{
	if (sptr_link == NULL)
		return;

	if (sptr_link_after_which_to_add == NULL)
		return;

	if (sptr_link_to_add == NULL)
		return;

	if (sptr_link_after_which_to_add->sptr_forward_link != NULL)
		{
		sptr_link_to_add->sptr_forward_link = sptr_link_after_which_to_add->sptr_forward_link;

		sptr_link_after_which_to_add->sptr_forward_link->sptr_backward_link = sptr_link_to_add;
		}
	else
		{
		sptr_link->sptr_backward_link = sptr_link_to_add;
		}

	sptr_link_after_which_to_add->sptr_forward_link = sptr_link_to_add;
	
	sptr_link_to_add->sptr_backward_link = sptr_link_after_which_to_add;
}
/*************************************************************************/
void *get_pointer_to_first_entry_in_list (LINK *sptr_link)
{
	LINK	*sptr_return_link;

	if (sptr_link == NULL)
		return (NULL);

	sptr_return_link = sptr_link->sptr_forward_link;

	return (sptr_return_link);
}
/*************************************************************************/
void *get_pointer_to_next_entry_in_list (LINK *sptr_current_entry)
{
	LINK	*sptr_return_link;

	if (sptr_current_entry == NULL)
		return (NULL);

	sptr_return_link = sptr_current_entry->sptr_forward_link;

	return (sptr_return_link);
}
/*************************************************************************/
void *get_pointer_to_last_entry_in_list (LINK *sptr_link)
{
	LINK	*sptr_return_link;

	if (sptr_link == NULL)
		return (NULL);

	sptr_return_link = sptr_link->sptr_backward_link;

	return (sptr_return_link);
}
/*************************************************************************/
void *get_pointer_to_previous_entry_in_list (LINK *sptr_current_entry)
{
	LINK	*sptr_return_link;

	if (sptr_current_entry == NULL)
		return (NULL);

	sptr_return_link = sptr_current_entry->sptr_backward_link;

	return ((void *) sptr_return_link);
}



