/*---------------------------------------------------------------------------
	file	:	log.h
	Auth	:	vidy
	Date	:	30th Jan 98
	Synop	:	Contains the routines for the log abstract data type
	Assumptions :
	1. This is for logging events which are not-too-fast. SO it
	assumes that the log read is a much faster operation than log write.
	2. log functions are not to be used from ISRs
---------------------------------------------------------------------------*/
/*
#ifndef TRUE
#define	FALSE	0
#define	TRUE 1
#define	NULL 0
#endif
*/

#define	LOG_MIN_FILE_SIZE		(20 * 1024)
#define	LOG_MAX_FILE_SIZE		(100 * 1024)
#define	LOG_DEF_FILE_SIZE		LOG_MIN_FILE_SIZE
#define	LOG_MIN_FREE_SIZE		100

#if 0
#define	LOG_MIN_FILE_SIZE		(41)
#define	LOG_MAX_FILE_SIZE		(100 * 1024)
#define	LOG_DEF_FILE_SIZE		LOG_MIN_FILE_SIZE
#define	LOG_MIN_FREE_SIZE		2
#endif

#define	CHAR_NEW_LINE			'\n'
#define  LOG_MAX_OPENS			10
#define  LOG_MAX_RECORDS 		50
#define  LOG_FREE_UP_QUANTUM  3

typedef struct log_descriptor {
   struct event_record *read_ptr;
	char valid;
}log_descriptor_type;

/* Imran ...*/
static int get_log_time_stamp(ULONG time,char *buffer);
static void free_up_event_records(void);

/* ...Imran */
  

