#include	"defs.h"
/*	$Modname: sortlist.c$  $version: 1.1$      $date: 01/12/95$   */
/*
* 	$lgb$
1.0 01/12/95 ross
1.1 01/12/95 ross added copyright.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdio.h>
#include <kstart.h>
#include	<v8022str.h>
#include <lslproto.h>
/****************************************************************************/
static LINK *find_location_in_list_for_index (LINK *sptr_linked_list, LINK *sptr_current_entry,
	LINKED_LIST_INDEX *sptr_current_linked_list_index, LINK *sptr_entry_to_add, enum BOOLEAN *eptr_finished,
	enum TEST *eptr_passed);
static enum LINKED_LIST_COMPARISON_RESULT compare_entry_values (LINKED_LIST_INDEX *sptr_current_linked_list_index,
	LINK *sptr_current_entry,LINK *sptr_entry_to_add);
static enum LINKED_LIST_COMPARISON_RESULT compare_short_values (USHORT current_value, USHORT add_in_value,
	enum BOOLEAN swap_values);
static enum LINKED_LIST_COMPARISON_RESULT compare_long_values (ULONG current_value, ULONG add_in_value,
	enum BOOLEAN swap_values);
/****************************************************************************/
void add_entry_to_sorted_linked_list (LINKED_LIST_SORT_PARAMETERS *sptr_linked_list_sort_parameters)
{
	LINKED_LIST_INDEX *sptr_current_linked_list_index;
	LINK *sptr_current_entry;
	enum BOOLEAN comparsion_finished;
	enum TEST comparsion_passed;

	if (sptr_linked_list_sort_parameters->sptr_list->sptr_forward_link == NULL)
		{
		add_entry_to_list (sptr_linked_list_sort_parameters->sptr_list,sptr_linked_list_sort_parameters->sptr_entry_to_add);

		return;
		}

	sptr_current_entry = sptr_linked_list_sort_parameters->sptr_list->sptr_forward_link;

	for (sptr_current_linked_list_index = &sptr_linked_list_sort_parameters->index[0];
		sptr_current_linked_list_index->size != 0x0000; ++sptr_current_linked_list_index)
		{
		sptr_current_entry = find_location_in_list_for_index (sptr_linked_list_sort_parameters->sptr_list,
			sptr_current_entry,sptr_current_linked_list_index,sptr_linked_list_sort_parameters->sptr_entry_to_add,
			&comparsion_finished,&comparsion_passed);

		if (comparsion_finished == TRUE)
			{
			return;
			}

		if (sptr_current_entry == NULL)
			{
			break;
			}
		}
}
/****************************************************************************/
static LINK *find_location_in_list_for_index (LINK *sptr_linked_list, LINK *sptr_current_entry,
	LINKED_LIST_INDEX *sptr_current_linked_list_index, LINK *sptr_entry_to_add, enum BOOLEAN *eptr_finished,
	enum TEST *eptr_passed)
{
	enum LINKED_LIST_COMPARISON_RESULT comparison_result;

	*eptr_finished = FALSE;
	*eptr_passed = FAIL;

	while (TRUE)
		{
		comparison_result = compare_entry_values (sptr_current_linked_list_index,sptr_current_entry,sptr_entry_to_add);

		switch (comparison_result)
			{
			case LESS_THAN_CURRENT_ELEMENT:
				sptr_current_entry = sptr_current_entry->sptr_backward_link;

				if (sptr_current_entry != NULL)
					{
					insert_entry_in_list (sptr_linked_list,sptr_entry_to_add,sptr_current_entry);
					}
				else
					{
					add_entry_to_front_of_list (sptr_linked_list, sptr_entry_to_add);
					}

				*eptr_finished = TRUE;
				*eptr_passed = PASS;

				return (sptr_entry_to_add);

			case GREATER_THAN_CURRENT_ELEMENT:
				sptr_current_entry = get_pointer_to_next_entry_in_list (sptr_current_entry);

				if (sptr_current_entry == NULL)
					{
					*eptr_finished = TRUE;
					}

				break;

			case SAME_AS_CURRENT_ELEMENT:
				*eptr_passed = PASS;

				return (sptr_current_entry);

			case ERROR_IN_COMPARISON:
			default:
				return (NULL);
			}

		if (*eptr_finished == TRUE)
			{
			break;
			}
		}

	add_entry_to_list (sptr_linked_list,sptr_entry_to_add);

	*eptr_finished = TRUE;
	*eptr_passed = PASS;

	return (sptr_entry_to_add);
}
/****************************************************************************/
static enum LINKED_LIST_COMPARISON_RESULT compare_entry_values (LINKED_LIST_INDEX *sptr_current_linked_list_index,
	LINK *sptr_current_entry, LINK *sptr_entry_to_add)
{
	USHORT ushort_add_value;
	USHORT ushort_current_value;
	ULONG ulong_add_value;
	ULONG ulong_current_value;
	BYTE *bptr_add_in_value;
	BYTE *bptr_current_value;
	USHORT size_counter;
	enum LINKED_LIST_COMPARISON_RESULT return_comparison_result;

	if (sptr_current_linked_list_index->size == 0x0002)
		{
		ushort_current_value = *((USHORT *) ((ULONG) sptr_current_entry + sptr_current_linked_list_index->offset));
		ushort_add_value = *((USHORT *) ((ULONG) sptr_entry_to_add + sptr_current_linked_list_index->offset));

		return_comparison_result = compare_short_values (ushort_current_value,ushort_add_value,
			sptr_current_linked_list_index->_swap);
		}
	else if (sptr_current_linked_list_index->size == 0x0004)
		{
		ulong_current_value = *((ULONG *) ((ULONG) sptr_current_entry + sptr_current_linked_list_index->offset));
		ulong_add_value = *((ULONG *) ((ULONG) sptr_entry_to_add + sptr_current_linked_list_index->offset));

		return_comparison_result = compare_long_values (ulong_current_value,ulong_add_value,
			sptr_current_linked_list_index->_swap);
		}
	else
		{
		bptr_current_value =
			(BYTE *) ((ULONG) sptr_current_entry + sptr_current_linked_list_index->offset);
		bptr_add_in_value =
			(BYTE *) ((ULONG) sptr_entry_to_add + sptr_current_linked_list_index->offset);

		for (size_counter = 0x0000; size_counter < sptr_current_linked_list_index->size; --size_counter)
			{
			if (*bptr_add_in_value > *bptr_current_value)
				{
				return (GREATER_THAN_CURRENT_ELEMENT);
				}
			else if (*bptr_add_in_value < *bptr_current_value)
				{
				return (LESS_THAN_CURRENT_ELEMENT);
				}
			else
				{
				++bptr_current_value;

				++bptr_add_in_value;
				}
			}

		return (SAME_AS_CURRENT_ELEMENT);
		}

	return (return_comparison_result);
}
/****************************************************************************/
static enum LINKED_LIST_COMPARISON_RESULT compare_short_values (USHORT current_value, USHORT add_in_value,
	enum BOOLEAN swap_values)
{
	if (swap_values == TRUE)
		{
		current_value = swap (current_value);
		add_in_value = swap (add_in_value);
		}

	if (current_value > add_in_value)
		{
		return (LESS_THAN_CURRENT_ELEMENT);
		}
	else if (current_value < add_in_value)
		{
		return (GREATER_THAN_CURRENT_ELEMENT);
		}
	else
		{
		return (SAME_AS_CURRENT_ELEMENT);
		}
}
/****************************************************************************/
static enum LINKED_LIST_COMPARISON_RESULT compare_long_values (ULONG current_value, ULONG add_in_value, enum BOOLEAN swap_values)
{
	if (swap_values == TRUE)
		{
		current_value = swap_long (current_value);
		add_in_value = swap_long (add_in_value);
		}

	if (current_value > add_in_value)
		{
		return (LESS_THAN_CURRENT_ELEMENT);
		}
	else if (current_value < add_in_value)
		{
		return (GREATER_THAN_CURRENT_ELEMENT);
		}
	else
		{
		return (SAME_AS_CURRENT_ELEMENT);
		}
}
