/* 
History of Changes :
		{Jo, 26 Oct 1999, Changed function get_port_status() to send proper status to roucon}
		{Jo, 16 Nov 1999, Changed function get_port_status() to send proper status to roucon,
								Added new state in enum variable WAN_LINK_STATUS,
								Added new message string global variable wan_link_status[]}
		{Jo, 24 Nov 1999, Changed function proxy_get_local_ip_address() to prevent displaying 
								wrong IP address in statistics,
								Changed function proxy_get_remote_ip_address() to check if port is direct connect}
*/

#include	"defs.h"
#include	<stdlib.h>
#include <incall.h>
#include	<string.h>


typedef enum
{
   PS_IDLE,
   PS_OFFLINE,
   PS_WAN_LINK_UP, /* Physical Link up */
   PS_LCP_UP,
   PS_PPP_CLIENT_UP,
   PS_MLPPP_CLIENT_UP,
   PS_SEND_INIT_COMMAND,
   PS_WAIT_FOR_OK,
   PS_DIAL_NUMBER,
   PS_WAIT_FOR_CONNECT,
   PS_SLIP_CLIENT_UP,
   PS_DISABLED,
/* new states to display 9/4/98 */
	PS_CALL_BACK,
	PS_RAS_CLIENT_CONNECTED,
	PS_IDLE_WAIT_CALL,
/* ...Jo 16 Nov 1999. Added new state for DialIn Port Type */
	PS_RAS_WAIT_CALL,
/* Jo 16 Nov 1999. Added new state for DialIn Port Type... */
	PS_HANGING_UP,


   PS_WAN_PORT_STATUS_NUMBER_OF_STATES
} WAN_LINK_STATUS ;



extern USHORT is_the_link_member_of_some_bundle (port_number) ;

/* Jo 26/04/99 */
#if 0
const char *modem_states[] =
{
   "IDLE",
   "OFFLINE",
   "ONLINE",
   "SEND INIT COMMAND",  /* "SEND COMMAND A", */
   "SEND INIT COMMAND",  /* "SEND COMMAND T", */
   "SEND INIT COMMAND",  /* "SEND COMMAND REST", */
   "WAIT FOR OK",
   "DIAL NUMBER", /* "DIAL A", */
   "DIAL NUMBER", /* "DIAL T", */
   "DIAL NUMBER", /* "DIAL REST", */
   "WAIT FOR CONNECT MESSAGE",
   "WAIT FOR RING",
   "HANGUP DTR DOWN",
   "HANGUP CHECK CD",
   "SEND HANGUP STRING",
   "SEND BREAK",
   "DELAY ONLINE",
   "DTR DIAL LINK DOWN",
   "DTR DIAL DTR UP",
   "DTR DIAL CHECK ONLINE",
   "CALLBACK",
   "ABSENT",
} ;
#endif 
/* Jo 26/04/99 */

ULONG proxy_get_local_ip_address (USHORT port_number)
{
   USHORT virtual_port_number ;

#if 0
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;
#endif

   virtual_port_number = is_the_link_member_of_some_bundle (port_number) ;
   if (virtual_port_number < NUMBER_OF_SERIAL_PORTS)
      port_number = virtual_port_number ;

   if (ip.port[ppp.number_of_lan_ports + port_number].config.ip_address)
      return (ip.port[ppp.number_of_lan_ports + port_number].config.ip_address) ;

/* ...Jo commented on 24 Nov 1999 to prevent displaying wrong IP address in statistics */
   else
      return (ip.port[port_number].config.ip_address) ;
/* Jo commented on 24 Nov 1999 to prevent displaying wrong IP address in statistics... */
      
}

ULONG proxy_get_remote_ip_address (USHORT port_number)
{
   USHORT virtual_port_number ;

/* Jo 24 Nov 1999. Check if port is direct connect */
	if ((wan.port[port_number].direct_connect_enabled == FALSE ) &&
   (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE))
      return (0L) ;

   virtual_port_number = is_the_link_member_of_some_bundle (port_number) ;
   if (virtual_port_number < NUMBER_OF_SERIAL_PORTS)
      port_number = virtual_port_number ;

   return (ip.port[ppp.number_of_lan_ports + port_number].config.point_to_point_remote_ip_address) ;
}

ULONG proxy_get_subnet_mask (USHORT port_number)
{
   USHORT virtual_port_number ;

   virtual_port_number = is_the_link_member_of_some_bundle (port_number) ;
   if (virtual_port_number < NUMBER_OF_SERIAL_PORTS)
      port_number = virtual_port_number ;

   return (ip.port[ppp.number_of_lan_ports + port_number].config.subnetmask) ;
}



BYTE get_port_status (USHORT port_number)
{
   int modem_state = wan.port[port_number].modem_info.status.state ;
   USHORT virtual_port_number ;

   if (wan.port[port_number].enabled == FALSE)
      return PS_DISABLED ;

   if (wan.port[port_number].direct_connect_enabled == TRUE)
/* ...Jo 16 Nov 1999. Put in the following lines to display proper status in case of Direct Connect */
	{
      if (ppp.port[port_number].state != PPP_OPENED_STATE)
         return PS_WAN_LINK_UP ;   /* Physical Link up */
#ifdef __MLPPP__
		virtual_port_number = is_the_link_member_of_some_bundle (port_number) ;
		if (virtual_port_number >= NUMBER_OF_SERIAL_PORTS)
			virtual_port_number = ppp.port[port_number].virtual_port_number;
		if (mlppp.port[virtual_port_number].ncp[PPP_IP_NCP_STACK_INDEX].state != PPP_OPENED_STATE)
#else
		if (ppp.port[port_number].ncp[PPP_IP_NCP_STACK_INDEX].state != PPP_OPENED_STATE)
#endif
			return PS_LCP_UP ;	/* LCP UP */

		/* PPP/MLPPP client up */
#ifdef __MLPPP__
		if (is_the_link_member_of_some_bundle (port_number) < NUMBER_OF_SERIAL_PORTS)
		{
			if (is_remote_access_client_active(port_number))
				return PS_RAS_CLIENT_CONNECTED;
			else
				return PS_MLPPP_CLIENT_UP ;
		}
		else
		{
			if (is_remote_access_client_active(port_number))
				return PS_RAS_CLIENT_CONNECTED;
			else
				return PS_PPP_CLIENT_UP ;
		}
#else
		if (is_remote_access_client_active(port_number))
			return PS_RAS_CLIENT_CONNECTED;
		else
			return PS_PPP_CLIENT_UP ;
#endif		
   }
/*  return PS_WAN_LINK_UP ;*/
/* Jo 16 Nov 1999. Put in the following lines to display proper status in case of Direct Connect... */

   if (modem_state > MDM_STATE_LAST_STATE)
      modem_state = MDM_STATE_LAST_STATE ;

   switch (modem_state)
   {
      case (MDM_STATE_IDLE) :
		/* if modem is idle, and if ras is enabled */
			if (is_remote_access_enabled_on_port(port_number))
	         return PS_IDLE_WAIT_CALL ;
			else
	         return PS_IDLE ;

      case (MDM_STATE_OFFLINE) :
         return PS_OFFLINE ;

      case (MDM_STATE_ONLINE) :

#ifdef _BIG_PROXY_ /* Jo 18/5/99 */
         if (ppp.port[port_number].slip_on)
            return (PS_SLIP_CLIENT_UP) ;
#endif /* Jo 18/5/99 */

/* ...Added by Jo on 26 Oct 1999 */
         if (ppp.port[port_number].state != PPP_OPENED_STATE)
            return PS_WAN_LINK_UP ;   /* Physical Link up */

#ifdef __MLPPP__
			virtual_port_number = is_the_link_member_of_some_bundle (port_number) ;
			if (virtual_port_number >= NUMBER_OF_SERIAL_PORTS)
				virtual_port_number = ppp.port[port_number].virtual_port_number;
			if (mlppp.port[virtual_port_number].ncp[PPP_IP_NCP_STACK_INDEX].state != PPP_OPENED_STATE)
#else
			if (ppp.port[port_number].ncp[PPP_IP_NCP_STACK_INDEX].state != PPP_OPENED_STATE)
#endif
				return PS_LCP_UP ;	/* LCP UP */

			/* PPP/MLPPP client up */
#ifdef __MLPPP__
			if (is_the_link_member_of_some_bundle (port_number) < NUMBER_OF_SERIAL_PORTS)
			{
				if (is_remote_access_client_active(port_number))
					return PS_RAS_CLIENT_CONNECTED;
				else
					return PS_MLPPP_CLIENT_UP ;
			}
			else
			{
				if (is_remote_access_client_active(port_number))
					return PS_RAS_CLIENT_CONNECTED;
				else
					return PS_PPP_CLIENT_UP ;
			}
#else
			if (is_remote_access_client_active(port_number))
				return PS_RAS_CLIENT_CONNECTED;
			else
				return PS_PPP_CLIENT_UP ;
#endif
/* Added by Jo on 26 Oct 1999... */
         break ;

      case (MDM_STATE_CMD_A) :
      case (MDM_STATE_CMD_T) :
      case (MDM_STATE_CMD_REST) :
         return PS_SEND_INIT_COMMAND ;

      case (MDM_STATE_WAIT_OK) :
         return PS_WAIT_FOR_OK ;

      case (MDM_STATE_DIAL_A) :
         return PS_DIAL_NUMBER ;

/* ...Jo 16 Nov 1999. For DialIn Port Type or DialIn/Out modem state will be WAIT_RING. 
Send messages accordingly */

      case (MDM_STATE_WAIT_RING) :
			if (!is_wan_port_answering (port_number) &&
				 (is_remote_access_enabled_on_port(port_number)))	/* DialIn/Out type */
	         return PS_IDLE_WAIT_CALL ;
			else 
				if (is_wan_port_answering (port_number) &&
					 (is_remote_access_enabled_on_port(port_number)))	/* Dial In type */
		         return PS_RAS_WAIT_CALL ; /* Jo New State that is introduced */
			else
	         return PS_WAIT_FOR_CONNECT ;
/* ...Jo 16 Nov 1999. For DialIn Port Type or DialIn/Out modem state will be WAIT_RING. 
Send messages accordingly */

      case (MDM_STATE_WAIT_CONN) :
      case (MDM_STATE_DTR_DIAL_CHK_ONLINE) :
      case (MDM_STATE_DTR_DIAL_DTR_UP) :
      case (MDM_STATE_DELAY_ONLINE) :
         return PS_WAIT_FOR_CONNECT ;

      case (MDM_STATE_HUP_DTR_DN) :
      case (MDM_STATE_HUP_CHK_CD) :
      case (MDM_STATE_HUP_STR) :
      case (MDM_STATE_BREAK) :
      case (MDM_STATE_DTR_DIAL_LINK_DN) :
      case (MDM_STATE_DTR_DIAL_DTR_DN) :
         return PS_HANGING_UP;

      case (MDM_STATE_CALLBACK) :
			return PS_CALL_BACK;
   }
	return PS_WAN_PORT_STATUS_NUMBER_OF_STATES ;
}


/* The following array has a 1-1 mapping with the enum WAN_LINK_STATUS
defined in cfgmgr.h
*/
/* Jo 19/5/99 */

static const char *wan_link_status[] =
{
	"Idle",
	"Off-line",
	"WAN link up",
	"LCP up",
	"Internet connect(PPP)",
	"Internet connect(MLPPP)",
	"Initializing modem",
	"Waiting for OK",
	"Dialing number",
	"Waiting connect message",
	"SLIP client up",
	"Disabled",

	"Callback in progress",
	"RAS client connected",
	"Waiting call/demand",			/* if dod_down and ras enabled */
/* Jo 16 Nov 1999. Added new message string for DialIn Port Type and RAS is enabled */
	"Waiting call",
	"Hangup in progress",

	"Unknown"
};
/* Jo 19/5/99 */

BYTE *get_port_status_from_id (USHORT index)
{
	if (index > PS_WAN_PORT_STATUS_NUMBER_OF_STATES)
		index = PS_WAN_PORT_STATUS_NUMBER_OF_STATES;

	return (wan_link_status[index]);
}

ULONG get_baud_rate (USHORT port_number)
{
   return (wan.port[port_number].port_speed) ;
}


char *get_modem_name (USHORT port_number, char *modem_name_string, int modem_name_string_length)
{
   strncpy (modem_name_string, wan.port[port_number].modem_info.strings.modem_type, modem_name_string_length-1) ;
   modem_name_string[modem_name_string_length-1] = 0 ;

   return (modem_name_string) ;
}


char *get_modem_connect_message (USHORT port_number, char *connect_message_string, int connect_message_string_length)
{
   char* temp_ptr;

   strncpy (connect_message_string, &wan.port[port_number].statistics.modem_connect_message[0], connect_message_string_length-1) ;
   connect_message_string[connect_message_string_length-1] = 0 ;

   temp_ptr = strchr(connect_message_string, '\r');
   if (temp_ptr != NULL)
      *temp_ptr = 0;

   return (connect_message_string) ;
}


char *get_ppp_user_name (USHORT port_number, char *user_name, int user_name_length)
{
   strncpy (user_name, ppp.port[port_number].authentication.user_name, user_name_length-1) ;
   user_name[user_name_length-1] = 0 ;

   return (user_name) ;
}

ULONG get_connection_up_time (USHORT port_number)
{
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   return (wan.port[port_number].statistics.connection_up_time) ;
}

ULONG get_connection_tx_count (USHORT port_number)
{
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   return (wan.port[port_number].statistics.connection_bytes_transmitted) ;
}


ULONG get_connection_rx_count (USHORT port_number)
{
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   return (wan.port[port_number].statistics.connection_bytes_received) ;
}


ULONG get_aggregate_rx_count (USHORT port_number)
{
   return (wan.port[port_number].statistics.number_of_bytes_rxed) ;
}


ULONG get_aggregate_tx_count (USHORT port_number)
{
   return (wan.port[port_number].statistics.number_of_bytes_txed) ;
}


ULONG get_number_of_calls (USHORT port_number)
{
   return (wan.port[port_number].statistics.number_of_calls) ;
}


ULONG get_aggregate_connection_time (USHORT port_number)
{
   return (wan.port[port_number].statistics.aggregate_connection_time) ;
}

/* Vidy added the following 4 functions 31/10/97 */

ULONG get_connection_tx_packet_count (USHORT port_number)
{
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   return (wan.port[port_number].statistics.connection_packets_transmitted) ;
}


ULONG get_connection_rx_packet_count (USHORT port_number)
{
   if (wan.port[port_number].modem_info.status.state != MDM_STATE_ONLINE)
      return (0L) ;

   return (wan.port[port_number].statistics.connection_packets_received) ;
}

ULONG get_aggregate_rx_packet_count (USHORT port_number)
{
   return (wan.port[port_number].statistics.number_of_packets_rxed) ;
}


ULONG get_aggregate_tx_packet_count (USHORT port_number)
{
   return (wan.port[port_number].statistics.number_of_packets_txed) ;
}

char	*get_time_in_hms(ULONG SEC, char *Time)
{
	USHORT	days, hrs, mins, secs;
	ULONG		rest;

	days = (USHORT)( SEC / ((int)3600 * 24));
	rest = SEC % ((int)3600 * 24);
	hrs = (USHORT) (rest / 3600);
	rest %= 3600;
	mins = (USHORT) (rest / 60);
	secs = (USHORT) (rest % 60);

	sprintf(Time,"%03u:%02u:%02u:%02u", days, hrs, mins, secs);
	return (Time);
}

BYTE *net_to_str (BYTE *Addr, ULONG Address)
{
   sprintf(Addr,"%03u.%03u.%03u.%03u",(((int)(Address >> 24)) & 0xff),
		(((int)(Address >> 16)) & 0xff), (((int)(Address >> 8)) & 0xff),
		(((int)(Address)) & 0xff));

   return Addr;
}


ULONG str_to_net(BYTE *Str)
{
	int f1, f2, f3, f4;

	if (sscanf(Str,"%03u.%03u.%03u.%03u", &f1, &f2, &f3, &f4) != 4)
		return(-1l);

	if ((f1 < 0) || (f1 > 255) || (f2 < 0) || (f2 > 255) ||
			(f3 < 0) || (f3 > 255) || (f4 < 0) || (f4 > 255))
		return(-1l);

	return ((f1 << 24) | (f2 << 16) | (f3 << 8) | f4);
}

/* Jo  Commented 'coz it is also present in nvram.c */
#if 0
char *process_back_slash (char *string)
{
	char new_string[256] ;
	char *src_ptr = string, *dest_ptr = &new_string[0] ;
	int flag = 0 ;

	while (*dest_ptr = *src_ptr)
	{
		if ((*src_ptr == '\\') && (*(src_ptr+1) == 'b'))
		{
			*dest_ptr++ = ' ' ;
			src_ptr += 2 ;
			flag++ ;
		}
		else
			*dest_ptr++ = *src_ptr++ ;
	}
	strcpy (string, &new_string[0]) ;
	return (string) ;
}
#endif

/* Jo 6/5/99 */
#if 0
static void check_port_number (char *cptr_port_number_string)
{
	if ((*cptr_port_number_string != '0') && (*cptr_port_number_string != '1'))
		{
		while (TRUE)
			{
			printf ("Illegal Port Enabled Value %s\n",cptr_port_number_string);
			}
		}
}

USHORT get_port_number_and_string (char *cptr_port_number_and_value,char *return_string)
{
	ULONG port_number;

	check_port_number (cptr_port_number_and_value);

	*return_string = (char) NULL;

	sscanf (cptr_port_number_and_value,"%02u,%s",(int *) &port_number,return_string);

	return ((USHORT) port_number);
}

void *allocate_memory_block(size_t size, char *file_name, int line_number)
{
	void *tmp ; 

	tmp = malloc(size) ; 

	if (tmp != NULL)
		return tmp ; 
}

void free_memory_block(void *ptr, char *file_name, int line_number)
{
	free(ptr);
}

#endif
/* Jo 6/5/99 */

ULONG convert_4_bytes_to_ulong (BYTE byte_1,BYTE byte_2,BYTE byte_3,BYTE byte_4)
{
	ULONG return_value;
	ULONG byte_array[4];

#ifdef BIG_ENDIAN
	byte_array[3] = byte_1;
	byte_array[2] = byte_2;
	byte_array[1] = byte_3;
	byte_array[0] = byte_4;
#else
	byte_array[0] = byte_1;
	byte_array[1] = byte_2;
	byte_array[2] = byte_3;
	byte_array[3] = byte_4;
#endif

	return_value = (ULONG) byte_array[0];
	return_value |= (ULONG) (byte_array[1] << 8);
	return_value |= (ULONG) (byte_array[2] << 16);
	return_value |= (ULONG) (byte_array[3] << 24);

/*	return_value = swap_long (return_value); */

	return (return_value);
}
