/*	$Modname: ksocket.h$  $version: 1.6$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 10/10/94 titus
1.1 10/10/94 titus Initial Version
1.2 10/10/94 titus Added version control header.
1.3 11/04/94 titus Cosmetic changes for c++ compilation.
1.4 11/15/94 titus Changed the name of the file from ksock.h to ksocket.h .
1.5 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.6 04/06/95 titus Added the TEST_SOCKET and CONSOLE port numbers to this file
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#ifndef	_KSOCKET_H_
#define	_KSOCKET_H_

#define ARG_NOT_USED													0x00000000L

#define VARIABLE_NUMBER_OF_ELEMENTS								0x0001

#define INTERNET_ADDRESS_ANY										(ULONG)0x00000000L
#define INTERNET_ADDRESS_LOOPBACK								(ULONG)0x7F000001L
#define INTERNET_ADDRESS_BROADCAST								(ULONG)0xffffffffL

#define INVALID_SOCKET_DESCRIPTOR								0xffffffffL

#define MAXIMUM_NUMBER_OF_SOCKET_USER_APPLICATIONS			0x04

#define NUMBER_OF_BITS_IN_BYTE									0x08

#define ONE_FIFTY_THREE												153

#define START_OF_USER_PORT_NUMBERS								0x0400		/* 1024 */

#define POLL_PERIOD_FOR_POLLING_TIMER_INTERRUPT_CALL 		0x1e		/* 30 */

#define INADDR_ANY													0x0L			/* Local IP wildcard address */

#define SOCKADDR_SIZE												(sizeof (SOCKADDR))

#define MAXIMUM_SOCKET_NAME_SIZE									SOCKSIZE 		/* All sockets are of the same size for now */

#define SOCKADDR_DATA_SIZE											0x0e

#define SIN_ZERO_SIZE												0x08

#define IPX_ZERO_SIZE												0x02

#ifdef __SOCKET_TEST_APPS__

#define TEST_SOCKET_UDP_PORT		 								1025
#define TEST_SOCKET_IPX_PORT		 								1026
#define TEST_SOCKET_TCP_PORT		 								1027

#endif /* __SOCKET_TEST_APPS__ */

#define REMOTE_CONSOLE_TCP_PORT 									1028
#define SERVER_CONSOLE_TCP_PORT 	 								1029
#define REMOTE_CONSOLE_VM_PORT 									0xfffe
#define SERVER_CONSOLE_VXD_PORT 									0xffff


/* IP protocol numbers */
/* now in internet.h */

enum TCP_PORT_NUMBERS
{
	IPPORT_ECHO			= 7,		/* Echo data port */
	IPPORT_DISCARD		= 9,		/* Discard data port */
	IPPORT_FTPD			= 20,		/* FTP Data port */
	IPPORT_FTP			= 21,		/* FTP Control port */
	IPPORT_TELNET		= 23,		/* Telnet port */
	IPPORT_SMTP			= 25,		/* Mail port */
	IPPORT_MTP			= 57,		/* Secondary telnet protocol */
	IPPORT_FINGER		= 79,		/* Finger port */
	IPPORT_TTYLINK		= 87,		/* Chat port */
	IPPORT_POP			= 109,	/* pop2 port */
	IPPORT_NNTP			= 119,	/* Netnews port */
	IPPORT_LOGIN		= 513 	/* BSD rlogin port */
};

enum UDP_PORT_NUMBERS
{
	IPPORT_DOMAIN	= 53,
	IPPORT_BOOTPS	= 67,
	IPPORT_BOOTPC	= 68,
	IPPORT_RIP		= 520,
	IPPORT_REMOTE	= 1234	/* Pulled out of the air */
};

enum ADDRESS_FAMILY_TYPES
{
	AF_INET						= 0,
	AF_NETWARE					= 1,
	AF_RTRWARE					= 100,
	INVALID_ADDRESS_FAMILY 	= 0xffff
};

enum SOCKET_TYPES
{
	SOCK_STREAM			= 0,
	SOCK_DGRAM			= 1,
	SOCK_RAW				= 2,
	INVALID_SOCKET_TYPE = 0xff
};

enum USER_SOCKET_TYPES
{
	NOT_USED			= 0,
	TYPE_TCP			= 1,
	TYPE_UDP			= 2,
	TYPE_RAW			= 3,
	TYPE_SPX			= 4,
	TYPE_IPX			= 5,
	TYPE_CONSOLE	= 6,
	INVALID_USER_SOCKET_TYPE = 0xff
};

enum SOCKET_INTERFACE_ERRORS 
{
	WOULD_BLOCK_ERROR								= 36,
	NOT_CONNECTED_ERROR							= 37,
	SOCKET_NOT_SUPPORTED_ERROR					= 38,
	ADDRESS_FAMILY_NOT_SUPPORTED_ERROR		= 39,
	IS_CONNECTED_ERROR							= 40,
	OPERATION_NOT_SUPPORTED_ERROR				= 41,
	ALARM_ERROR										= 42,
	ABORT_ERROR										= 43,
	INTR												= 44,
	CONNECTION_REFUSED_ERROR					= 45,
	MESSAGE_SIZE_ERROR							= 46,
	ADDRESS_IN_USE_ERROR							= 47,
	MAXIMUM_ERROR									= 48,
	SHUTDOWN_RECEIVE_CHANNEL_ERROR,
	SOCKET_INTERFACE_NOT_ENABLED
};


enum IO_ERRORS
{
	TOO_MANY_SOCKETS_OPEN 	= 4,
	BAD_SOCKET_HANDLE 		= 6,
	BAD_DATA 					= 13,
	NULL_LOCAL_ADDRESS 		= 14,
	NULL_PEER_ADDRESS,
	NULL_SOCKET_ADDRESS,
	ALREADY_BOUND_TO_ADDRESS,
	NOT_BOUND_TO_ADDRESS,
	INVALID_SOCKET_VECTOR,
	BAD_LENGTH,
	BAD_NEW_SOCKET_HANDLE,
	END_OF_FILE_ERROR
};

enum QUEUE_TYPES
{
	RECEIVE_QUEUE,
	SEND_QUEUE
};

enum CHANNEL_TYPES
{
	RECEIVE_CHANNEL,
	SEND_CHANNEL,
	SEND_AND_RECEIVE_CHANNELS
};

enum EXECUTION_RESULT
{
  FAILED 	= 0xffffffffL,
  DONE 		= 0x00000000L
};

enum SOCKET_EVENT
{
	NULL_EVENT,
	CONNECTION_REQUEST_EVENT,
	CONNECTION_ESTABLISHED_EVENT,
	RECEIVE_EVENT,
	SEND_EVENT,
	CONNECTION_CLOSED_EVENT,
	ABORT_CONNECTION_EVENT
};

enum SOCKET_PRINTF_GROUPS
{
	SOCKET_PRINTF,
	SOCKET_INIT_PRINTF,
	SOCKET_TX_PRINTF,
	SOCKET_RX_PRINTF,
	SOCKET_BLOCK_PRINTF,
	SOCKET_EVENT_PRINTF,
	SOCKET_STRING_PRINTF,
	SOCKET_ALARM_PRINTF,
	SOCKET_MEMORY_PRINTF,
	SOCKET_DATA_PRINTF,
	SOCKET_DIAGNOSTIC_PRINTF
};

/* Sanjay -- added following enum from a later version (1.8) socket library 
** code by RouterWare so as to allow SPX code (which uses this) to work
** properly. (9, July, 1996)
*/

enum SOCKET_LISTEN_MODE
{
        SOCKET_OPEN_MODE_WAIT_FOR_ONE_CONNECTION = 0,
        SOCKET_OPEN_MODE_INITIATE_CONNECTION = 1,
        SOCKET_OPEN_MODE_WAIT_FOR_MULTIPLE_CONNECTION = 2
};
#endif 	/* _KSOCKET_H_ */
