#include	"defs.h"
/*	$Modname: sockbutl.c$  $version: 1.6$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 11/04/94 titus Initial Release. Broke up sockutil.c into sockbutl.c and socknutl.c .
1.1 11/04/94 titus Cosmetic changes for c++ compilation.
1.2 11/15/94 titus Utilization of links for list manipulation and ULONG socket_descriptors.
1.3 11/16/94 titus Just added the version control header.
1.4 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.5 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
1.6 04/06/95 titus Changes for dynamic loading
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "socket.h"
/*********************************************************************************************/
static void check_if_tcp_send_window_open_for_a_send_event_in_waited_on_event_queue (void);
static EVENT_QUEUE_ELEMENT *check_if_event_waited_on_occured (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event);
static void	add_to_waited_on_event_queue (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event);
static EVENT_QUEUE_ELEMENT *remove_from_waited_on_event_queue (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event);
static void call_operating_system (USHORT *usptr_number_of_polling_timer_interrupt_calls);
/*********************************************************************************************/
enum TEST wait_on_socket_event (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event)
{
	USHORT number_of_polling_timer_interrupt_calls;
	EVENT_QUEUE_ELEMENT *sptr_event_queue_element_occured;

	if (sptr_user_socket == NULL)
		{
		return (FAIL);
		}

	number_of_polling_timer_interrupt_calls = 0x0000;

	add_to_waited_on_event_queue (sptr_user_socket, socket_event);

	while (TRUE)
		{
		check_if_tcp_send_window_open_for_a_send_event_in_waited_on_event_queue ();

		sptr_event_queue_element_occured = check_if_event_waited_on_occured (sptr_user_socket, socket_event);

		if (sptr_event_queue_element_occured != NULL)
			{
			table_free ((void *) sptr_event_queue_element_occured);

			break;
			}
		else if ((sptr_user_socket->socket_type_of_service == TYPE_TCP) && (socket_event == CONNECTION_ESTABLISHED_EVENT))
			{
			sptr_event_queue_element_occured = check_if_event_waited_on_occured (sptr_user_socket, SEND_EVENT);

			if (sptr_event_queue_element_occured != NULL)
				{
				table_free ((void *) sptr_event_queue_element_occured);

				break;
				}
			}

		call_operating_system (&number_of_polling_timer_interrupt_calls);
		}

	return (PASS);
}
/*********************************************************************************************/
static void check_if_tcp_send_window_open_for_a_send_event_in_waited_on_event_queue (void)
{
	EVENT_QUEUE_ELEMENT *sptr_event_queue_element;
	TRANSPORT_INTERFACE *sptr_transport_interface;
	USER_SOCKET *sptr_user_socket;

	sptr_event_queue_element = (EVENT_QUEUE_ELEMENT *) get_pointer_to_first_entry_in_list (
		(LINK *) &socket_class.event_queue_element_waited_on_list);

	if (sptr_event_queue_element == NULL)
		{
		socket_printf (SOCKET_EVENT_PRINTF,
			"SOCKET: check_if_tcp_send_window_open_for_a_send_event_in_waited_on_event_queue (): no entries in occured queue\n");

		return;
		}
	else
		{
		while (sptr_event_queue_element != NULL)
			{
			sptr_user_socket = sptr_event_queue_element->sptr_user_socket;

			if ((sptr_user_socket->socket_type_of_service == TYPE_TCP) && (sptr_event_queue_element->event_waited_on == SEND_EVENT))
				{
				sptr_transport_interface = sptr_event_queue_element->sptr_user_socket->sptr_transport_interface;

				if ((*sptr_transport_interface->check_if_window_open) (sptr_user_socket) == TRUE)
					{
					delete_entry_from_list ((LINK *) &socket_class.event_queue_element_waited_on_list,
						(LINK *) sptr_event_queue_element);

					sptr_event_queue_element->event_occured = SEND_EVENT;

					add_entry_to_list ((LINK *) &socket_class.event_queue_element_occured_list, (LINK *) sptr_event_queue_element);
					}
				}

			sptr_event_queue_element = (EVENT_QUEUE_ELEMENT *) get_pointer_to_next_entry_in_list (
				(LINK *) sptr_event_queue_element);
			}
		}
}
/*********************************************************************************************/
enum TEST wakeup_those_waiting_on_socket_event (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event)
{
	EVENT_QUEUE_ELEMENT *sptr_event_queue_element_waited_on;

	sptr_event_queue_element_waited_on =
		remove_from_waited_on_event_queue (sptr_user_socket, socket_event);

	if ((sptr_event_queue_element_waited_on == NULL) && (sptr_user_socket->socket_type_of_service == TYPE_TCP)
		&& (socket_event == SEND_EVENT))
		{
		sptr_event_queue_element_waited_on =
			remove_from_waited_on_event_queue (sptr_user_socket, CONNECTION_ESTABLISHED_EVENT);

		if (sptr_event_queue_element_waited_on != NULL)
			{
			sptr_event_queue_element_waited_on->event_occured = CONNECTION_ESTABLISHED_EVENT;

			add_entry_to_list ((LINK *) &socket_class.event_queue_element_occured_list,
				(LINK *) sptr_event_queue_element_waited_on);
			}
		}
	else if (sptr_event_queue_element_waited_on != NULL)
		{
		sptr_event_queue_element_waited_on->event_occured = socket_event;

		add_entry_to_list ((LINK *) &socket_class.event_queue_element_occured_list, (LINK *) sptr_event_queue_element_waited_on);
		}

	return (PASS);
}
/*********************************************************************************************/
static EVENT_QUEUE_ELEMENT *check_if_event_waited_on_occured (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event)
{
	EVENT_QUEUE_ELEMENT *sptr_event_queue_element;

	sptr_event_queue_element = (EVENT_QUEUE_ELEMENT *) get_pointer_to_first_entry_in_list (
		(LINK *) &socket_class.event_queue_element_occured_list);

	if (sptr_event_queue_element == NULL)
		{
		socket_printf (SOCKET_EVENT_PRINTF, "SOCKET: check_if_event_waited_on_occured (): no entries in occured queue\n");

		return (NULL);
		}
	else
		{
		while (sptr_event_queue_element != NULL)
			{
			if ((sptr_event_queue_element->sptr_user_socket == sptr_user_socket) &&
				(sptr_event_queue_element->event_occured == socket_event))
				{
				delete_entry_from_list ((LINK *) &socket_class.event_queue_element_occured_list,
					(LINK *) sptr_event_queue_element);
				}

			sptr_event_queue_element = (EVENT_QUEUE_ELEMENT *) get_pointer_to_next_entry_in_list (
				(LINK *) sptr_event_queue_element);
			}

		socket_printf (SOCKET_EVENT_PRINTF, "SOCKET: check_if_event_waited_on_occured (): could not find matching occured event\n");

		return (NULL);
		}
}
/*********************************************************************************************/
static void	add_to_waited_on_event_queue (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event)
{
	EVENT_QUEUE_ELEMENT *sptr_event_queue_element;

	sptr_event_queue_element = (EVENT_QUEUE_ELEMENT *) table_malloc (1, sizeof (EVENT_QUEUE_ELEMENT));

	if (sptr_event_queue_element == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "SOCKET: add_to_waited_on_event_queue (): table_malloc failed\n");

		return;
		}

	sptr_event_queue_element->sptr_user_socket = sptr_user_socket;

	sptr_event_queue_element->event_waited_on = socket_event;

	add_entry_to_list ((LINK *) &socket_class.event_queue_element_waited_on_list, (LINK *) sptr_event_queue_element);
}
/*********************************************************************************************/
static EVENT_QUEUE_ELEMENT *remove_from_waited_on_event_queue (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event)
{
	EVENT_QUEUE_ELEMENT *sptr_event_queue_element;

	sptr_event_queue_element = (EVENT_QUEUE_ELEMENT *) get_pointer_to_first_entry_in_list (
		(LINK *) &socket_class.event_queue_element_waited_on_list);

	if (sptr_event_queue_element == NULL)
		{
		socket_printf (SOCKET_EVENT_PRINTF, "SOCKET: remove_from_waited_on_event_queue (): no entries in waited on queue\n");

		return (NULL);
		}
	else
		{
		while (sptr_event_queue_element != NULL)
			{
			if ((sptr_event_queue_element->sptr_user_socket == sptr_user_socket) &&
				(sptr_event_queue_element->event_waited_on == socket_event))
				{
				delete_entry_from_list ((LINK *) &socket_class.event_queue_element_waited_on_list,
					(LINK *) sptr_event_queue_element);

				return (sptr_event_queue_element);
				}

			sptr_event_queue_element = (EVENT_QUEUE_ELEMENT *) get_pointer_to_next_entry_in_list (
				(LINK *) sptr_event_queue_element);
			}

		socket_printf (SOCKET_EVENT_PRINTF,
			"SOCKET: remove_from_waited_on_event_queue (): could not find matching waited on event\n");

		return (NULL);
		}
}
/*********************************************************************************************/
static void call_operating_system (USHORT *usptr_number_of_polling_timer_interrupt_calls)
{
	(*socket_class.fptr_poll_for_packet_received) (TRUE);

	*usptr_number_of_polling_timer_interrupt_calls = (USHORT) (*usptr_number_of_polling_timer_interrupt_calls + 0x0001);

	if (*usptr_number_of_polling_timer_interrupt_calls > POLL_PERIOD_FOR_POLLING_TIMER_INTERRUPT_CALL)
		{
		(*socket_class.fptr_polling_timer_interrupt) ();

		*usptr_number_of_polling_timer_interrupt_calls = 0x0000;
		}
}
