#include	"defs.h"
/*	$Modname: sockcnfg.c$  $version: 1.8$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 10/10/94 titus
1.1 10/10/94 titus Initial Version
1.2 10/10/94 titus Added version control header.
1.3 11/04/94 titus Cosmetic changes for c++ compilation.
1.4 11/15/94 titus Changed files sock.h to socket.h, ktsi.h to ktstsipx.h, ktsu.h to ktstsudp.h etc
1.5 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.6 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
1.7 04/06/95 titus Changes for dynamic loading
1.8 04/06/95 titus Changes for lint
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#include <stddef.h>
#include <stdlib.h>
#include "socket.h"
#include <vnvrmstr.h>
#include "vnvsock.h"
/****************************************************************************/
static enum TEST free_entries_in_user_socket_list (void);
static enum TEST free_entries_in_waited_on_event_list (void);
static enum TEST free_entries_in_occured_event_list (void);

#ifdef __LSL__
static enum TEST free_entries_in_transport_interface_list (void);
#endif /* __LSL__ */

#ifdef __SOCKET_TEST_APPS__
	extern void test_socket_tcp_application_entry_point (enum APPLICATION_CONTROL_OPERATION command, ULONG socket_descriptor);
	extern void test_socket_udp_application_entry_point (void);
	extern void test_socket_ipx_application_entry_point (void);
#endif /* __SOCKET_TEST_APPS__ */
/****************************************************************************/
enum TEST socket_configuration (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
	SOCKET_FUNCTION_POINTERS *sptr_socket_function_pointers;
#ifndef __LSL__
	ULONG temporary_variable;
#endif /* __LSL__ */

	PARAMETER_NOT_USED (parameter_0);

	switch (command)
		{
		case START_APPLICATION:

			break;

		case TERMINATE_APPLICATION:

			if (socket_class.enabled == TRUE)
				{
				free_entries_in_user_socket_list ();

				#ifdef __LSL__

					free_entries_in_transport_interface_list ();

				#endif /* __LSL__ */

				free_entries_in_waited_on_event_list ();

				free_entries_in_occured_event_list ();
				}

			socket_class.enabled = FALSE;

			break;

		case IS_APPLICATION_ENABLED:

			*((enum BOOLEAN *) parameter_1) = socket_class.enabled;

			break;

		case GET_SOCKET_ERROR_VALUE:

		  *((ULONG *) parameter_1) = socket_class.error_number;

			break;

		case CONNECTION_COMPLETED:
		case CONNECTION_REQUEST_RECEIVED:
		case CONNECTION_CLOSED:
		case READ_DATA_FROM_SOCKET:
		case WRITE_DATA_TO_SOCKET:

#ifdef __SOCKET_TEST_APPS__

			if (test_socket_tcp.enabled == TRUE)
				{
				test_socket_tcp_application_entry_point (command, parameter_0);
				}
			else if (test_socket_udp.enabled == TRUE)
				{
				test_socket_udp_application_entry_point ();
				}
			else if (test_socket_ipx.enabled == TRUE)
				{
				test_socket_ipx_application_entry_point ();
				}

#endif /* __SOCKET_TEST_APPS__ */

			break;

#ifndef __LSL__

		case GET_NUMBER_OF_VIRTUAL_PORTS:

			ip_configuration (GET_NUMBER_OF_PROTOCOL_STACKS_VIRTUAL_PORTS, (ULONG) NULL, (ULONG) &temporary_variable);

			*((USHORT *) parameter_1) = (USHORT) temporary_variable;

			break;

#endif /* __LSL__ */

		case INITIALIZE_FUNCTION_POINTERS:

			sptr_socket_function_pointers = (SOCKET_FUNCTION_POINTERS *) parameter_1;

			if ((enum ISO_LAYER_TYPE) parameter_0 == TRANSPORT_LAYER_TYPE)
				{
				sptr_socket_function_pointers->fptr_get_socket_class_error_number = get_socket_class_error_number;
				sptr_socket_function_pointers->fptr_set_socket_class_error_number = set_socket_class_error_number;
				sptr_socket_function_pointers->fptr_get_number_of_already_allocated_ports_in_socket_class =
					get_number_of_already_allocated_ports_in_socket_class;

				sptr_socket_function_pointers->fptr_set_number_of_already_allocated_ports_in_socket_class =
					set_number_of_already_allocated_ports_in_socket_class;

				sptr_socket_function_pointers->fptr_bind = bind;
				sptr_socket_function_pointers->fptr_socket = socket;
				sptr_socket_function_pointers->fptr_wait_on_socket_event = wait_on_socket_event;
				sptr_socket_function_pointers->fptr_wakeup_those_waiting_on_socket_event = wakeup_those_waiting_on_socket_event;
				sptr_socket_function_pointers->fptr_socket_add_packet_to_user_socket_send_queue =
					socket_add_packet_to_user_socket_send_queue;
				}
			else if ((enum ISO_LAYER_TYPE) parameter_0 == NETWORK_LAYER_TYPE)
				{
				sptr_socket_function_pointers->fptr_get_socket_class_error_number = get_socket_class_error_number;
				sptr_socket_function_pointers->fptr_set_socket_class_error_number = set_socket_class_error_number;
				sptr_socket_function_pointers->fptr_get_number_of_already_allocated_ports_in_socket_class =
					get_number_of_already_allocated_ports_in_socket_class;

				sptr_socket_function_pointers->fptr_set_number_of_already_allocated_ports_in_socket_class =
					set_number_of_already_allocated_ports_in_socket_class;

				sptr_socket_function_pointers->fptr_bind = bind;
				sptr_socket_function_pointers->fptr_closesocket = closesocket;
				sptr_socket_function_pointers->fptr_wait_on_socket_event = wait_on_socket_event;
				sptr_socket_function_pointers->fptr_wakeup_those_waiting_on_socket_event = wakeup_those_waiting_on_socket_event;
				}

			break;

		default:

			return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST free_entries_in_user_socket_list (void)
{
	SOCKET_BUFFER *sptr_socket_buffer;
	SOCKET_BUFFER *sptr_socket_buffer_next;
	USER_SOCKET *sptr_user_socket;
	USER_SOCKET *sptr_user_socket_next;

	sptr_user_socket = (USER_SOCKET *) get_pointer_to_first_entry_in_list ((LINK *) &socket_class.user_socket_list);

	while (sptr_user_socket != NULL)
		{
		sptr_user_socket_next = (USER_SOCKET *) get_pointer_to_next_entry_in_list ((LINK *) sptr_user_socket);

		sptr_socket_buffer = (SOCKET_BUFFER *) get_pointer_to_first_entry_in_list (
			(LINK *) &sptr_user_socket->socket_buffer_send_queue);

		while (sptr_socket_buffer != NULL)
			{
			sptr_socket_buffer_next = (SOCKET_BUFFER *) get_pointer_to_next_entry_in_list ((LINK *) sptr_socket_buffer);

			table_free ((void *) sptr_socket_buffer);

			sptr_socket_buffer = sptr_socket_buffer_next;
			}

		if (sptr_user_socket->vptr_address != NULL)
			{
			table_free (sptr_user_socket->vptr_address);
			}

		if (sptr_user_socket->vptr_peer_address != NULL)
			{
			table_free (sptr_user_socket->vptr_peer_address);
			}

		table_free ((void *) sptr_user_socket);

		sptr_user_socket = sptr_user_socket_next;
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST free_entries_in_waited_on_event_list (void)
{
	EVENT_QUEUE_ELEMENT *sptr_event_queue_element;
	EVENT_QUEUE_ELEMENT *sptr_event_queue_element_next;

	sptr_event_queue_element = (EVENT_QUEUE_ELEMENT *) get_pointer_to_first_entry_in_list (
		(LINK *) &socket_class.event_queue_element_waited_on_list);

	while (sptr_event_queue_element != NULL)
		{
		sptr_event_queue_element_next = (EVENT_QUEUE_ELEMENT *) get_pointer_to_next_entry_in_list (
			(LINK *) sptr_event_queue_element);

		table_free ((void *) sptr_event_queue_element);

		sptr_event_queue_element = sptr_event_queue_element_next;
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST free_entries_in_occured_event_list (void)
{
	EVENT_QUEUE_ELEMENT *sptr_event_queue_element;
	EVENT_QUEUE_ELEMENT *sptr_event_queue_element_next;

	sptr_event_queue_element = (EVENT_QUEUE_ELEMENT *) get_pointer_to_first_entry_in_list (
		(LINK *) &socket_class.event_queue_element_occured_list);

	while (sptr_event_queue_element != NULL)
		{
		sptr_event_queue_element_next = (EVENT_QUEUE_ELEMENT *) get_pointer_to_next_entry_in_list (
			(LINK *) sptr_event_queue_element);

		table_free ((void *) sptr_event_queue_element);

		sptr_event_queue_element = sptr_event_queue_element_next;
		}

	return (PASS);
}

#ifdef __LSL__
/****************************************************************************/
static enum TEST free_entries_in_transport_interface_list (void)
{
	TRANSPORT_INTERFACE *sptr_transport_interface;
	TRANSPORT_INTERFACE *sptr_transport_interface_next;

	sptr_transport_interface = (TRANSPORT_INTERFACE *) get_pointer_to_first_entry_in_list (
		(LINK *) &socket_class.transport_interface_list);

	while (sptr_transport_interface != NULL)
		{
		sptr_transport_interface_next = (TRANSPORT_INTERFACE *) get_pointer_to_next_entry_in_list (
			(LINK *) sptr_transport_interface);

		table_free ((void *) sptr_transport_interface);

		sptr_transport_interface = sptr_transport_interface_next;
		}

	return (PASS);
}
#endif /* __LSL__ */

