#include	"defs.h"
/*	$Modname: socknutl.c$  $version: 1.6$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 11/04/94 titus Initial Release. Broke up sockutil.c into sockbutl.c and socknutl.c .
1.1 11/04/94 titus Cosmetic changes
1.2 11/04/94 titus Cosmetic changes for c++ compilation.
1.3 11/15/94 titus Utilization of links for list manipulation and ULONG socket_descriptors.
1.4 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.5 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
1.6 04/06/95 titus Changes for dynamic loading
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "socket.h"
/*********************************************************************************************/
/*
 * Return ASCII string giving reason for connection closing
 */

#ifdef _BIG_PROXY_
char *socket_get_reason_for_connection_closing (ULONG socket_descriptor)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (bad_socket);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	if (sptr_transport_interface->error != NULL)
		{
		return (sptr_transport_interface->error[sptr_user_socket->error_codes[0]]);
		}
	else
		{
		socket_class.error_number = OPERATION_NOT_SUPPORTED_ERROR;	/* not yet, anyway */

		return (NULL);
		}
}
/*********************************************************************************************/
/*
 * Get state of protocol. Valid only for connection-oriented sockets.
 */
char *socket_get_state_of_protocol (ULONG socket_descriptor)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;
	char *cptr_state;

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (bad_socket);
		}

	if (sptr_user_socket->vptr_protocol_control_block == NULL)
		{
		socket_class.error_number = NOT_CONNECTED_ERROR;

		return (NULL);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	if (sptr_transport_interface->state != NULL)
		{
		cptr_state = (*sptr_transport_interface->state) (sptr_user_socket);

		return (cptr_state);
		}

 	/* Datagram sockets don't have state */

	socket_class.error_number = OPERATION_NOT_SUPPORTED_ERROR;

	return (NULL);
}
#endif
/*****************************************************************************************/
enum TEST socket_add_packet_to_user_socket_send_queue (USER_SOCKET *sptr_user_socket, void *vptr_user_data,
	USHORT number_of_data_bytes)
{
	SOCKET_BUFFER *sptr_socket_buffer;

	if (sptr_user_socket != NULL)
		{
		if ((vptr_user_data == NULL) || (number_of_data_bytes == 0x0000))
			{
			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: Failed to put data on send queue\n");

			return (FAIL);
			}
		else
			{
			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: %d bytes in send queue %x\n", sptr_user_socket->send_queue_count,
				sptr_user_socket->socket_descriptor);

			sptr_socket_buffer = (SOCKET_BUFFER *) table_malloc (1, sizeof (SOCKET_BUFFER));

			if (sptr_socket_buffer == NULL)
				{
				socket_printf (SOCKET_ALARM_PRINTF, "SOCKET: socket_add_packet_to_user_socket_send_queue (): table_malloc failed\n");
				}

			add_entry_to_list ((LINK *) &sptr_user_socket->socket_buffer_send_queue, (LINK *) sptr_socket_buffer);

			sptr_socket_buffer->vptr_buffer = (void *) table_malloc (1, number_of_data_bytes);

			if (sptr_socket_buffer->vptr_buffer == NULL)
				{
				socket_printf (SOCKET_ALARM_PRINTF, "SOCKET: socket_add_packet_to_user_socket_send_queue (): table_malloc failed\n");
				}

			sptr_socket_buffer->vptr_start_of_data = sptr_socket_buffer->vptr_buffer;
			sptr_socket_buffer->count = number_of_data_bytes;
			sptr_socket_buffer->size = number_of_data_bytes;

			memcpy (sptr_socket_buffer->vptr_start_of_data, vptr_user_data, number_of_data_bytes);

			sptr_user_socket->send_queue_count += number_of_data_bytes;

			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: Added %d bytes to send queue\n", number_of_data_bytes);

			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: %d bytes in send queue %x\n", sptr_user_socket->send_queue_count,
				sptr_user_socket->socket_descriptor);

			return (PASS);
			}
		}

	return (FAIL);
}
/*****************************************************************************************/
enum TEST socket_remove_packet_from_user_socket_send_queue (USER_SOCKET *sptr_user_socket, void **ptr_to_vptr_user_data,
	USHORT *usptr_number_of_data_bytes)
{
	SOCKET_BUFFER *sptr_socket_buffer;

	if ((ptr_to_vptr_user_data == NULL) || (usptr_number_of_data_bytes == NULL))
		{
		return (FAIL);
		}

	*ptr_to_vptr_user_data = NULL;

	*usptr_number_of_data_bytes = 0x0000;

	if (sptr_user_socket != NULL)
		{
		sptr_socket_buffer = (SOCKET_BUFFER *) get_pointer_to_first_entry_in_list (
			(LINK *) &sptr_user_socket->socket_buffer_send_queue); 

		if (sptr_socket_buffer != NULL)
			{
			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: %d bytes in send queue %x\n", sptr_user_socket->send_queue_count,
				sptr_user_socket->socket_descriptor);

			*ptr_to_vptr_user_data = sptr_socket_buffer->vptr_start_of_data;

			*usptr_number_of_data_bytes = sptr_socket_buffer->count;

			sptr_user_socket->send_queue_count = sptr_user_socket->send_queue_count - sptr_socket_buffer->count;

			delete_entry_from_list ((LINK *) &sptr_user_socket->socket_buffer_send_queue, (LINK *) sptr_socket_buffer);

			table_free ((void *) sptr_socket_buffer);

			if (sptr_user_socket->send_queue_count == 0x00000000L)
				{
				sptr_socket_buffer = (SOCKET_BUFFER *) get_pointer_to_first_entry_in_list (
					(LINK *) &sptr_user_socket->socket_buffer_send_queue); 

				if (sptr_socket_buffer != NULL)
					{
					socket_printf (SOCKET_DATA_PRINTF, "SOCKET: ERROR in managing send queue\n");
					}
				}

			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: Removed %d bytes from send queue\n", *usptr_number_of_data_bytes);

			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: %d bytes in send queue %x\n", sptr_user_socket->send_queue_count,
				sptr_user_socket->socket_descriptor);

			return (PASS);
			}
		}

	return (FAIL);
}
/*****************************************************************************************/
enum TEST socket_prepend_packet_to_user_socket_send_queue (USER_SOCKET *sptr_user_socket, void *vptr_user_data,
	USHORT number_of_data_bytes)
{
	SOCKET_BUFFER *sptr_socket_buffer;

	if (sptr_user_socket != NULL)
		{
		if ((vptr_user_data == NULL) || (number_of_data_bytes == 0x00000000L))
			{
			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: Failed to put data on send queue\n");

			return (FAIL);
			}
		else
			{
			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: %d bytes in send queue %x\n", sptr_user_socket->send_queue_count,
				sptr_user_socket->socket_descriptor);

			sptr_socket_buffer = (SOCKET_BUFFER *) table_malloc (1, sizeof (SOCKET_BUFFER));

			if (sptr_socket_buffer == NULL)
				{
				socket_printf (SOCKET_ALARM_PRINTF,
					"SOCKET: socket_prepend_packet_to_user_socket_send_queue (): table_malloc failed\n");
				}

			sptr_socket_buffer->count = number_of_data_bytes;
			sptr_socket_buffer->size = number_of_data_bytes;
			sptr_socket_buffer->vptr_buffer = vptr_user_data;
			sptr_socket_buffer->vptr_start_of_data = sptr_socket_buffer->vptr_buffer;

			add_entry_to_front_of_list ((LINK *) &sptr_user_socket->socket_buffer_send_queue, (LINK *) sptr_socket_buffer);

			sptr_user_socket->send_queue_count += number_of_data_bytes;

			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: Prepended %d bytes to send queue\n", number_of_data_bytes);

			socket_printf (SOCKET_DATA_PRINTF, "SOCKET: %d bytes in send queue %x\n", sptr_user_socket->send_queue_count,
				sptr_user_socket->socket_descriptor);

			return (PASS);
			}
		}

	return (FAIL);
}
/******************************************************************************/
void socket_send_the_packets_on_user_socket_send_queue (void)
{
	USER_SOCKET *sptr_user_socket;
	void *vptr_user_data;
	USHORT number_of_data_bytes;
	enum TEST error;
	USHORT count;
	SOCKADDR sockaddr;
	USHORT sockaddr_length;

	sptr_user_socket = (USER_SOCKET *) get_pointer_to_first_entry_in_list ((LINK *) &socket_class.user_socket_list);

	while (sptr_user_socket != NULL)
		{
		if ((sptr_user_socket->socket_type_of_service == TYPE_TCP) && (sptr_user_socket->send_queue_count > 0x00000000L))
			{
			sockaddr_length = sizeof (SOCKADDR);

			error = PASS;

			if (get_peer_address ((ULONG) sptr_user_socket, &sockaddr, &sockaddr_length) == FAIL)
				{
				socket_printf (SOCKET_TX_PRINTF, "SOCKET: TX ERROR: Invalid peer address for socket %p\n", sptr_user_socket);
				}
			else
				{
				socket_remove_packet_from_user_socket_send_queue (sptr_user_socket, &vptr_user_data, &number_of_data_bytes);

				/*	The proto send routine is expected to free the buffer we pass it even if the send fails */

				count = socket_send_data ((ULONG) sptr_user_socket, vptr_user_data, number_of_data_bytes, ARG_NOT_USED,
					&sockaddr, sockaddr_length, &error);

				if (error == FAIL)
					{
					socket_printf (SOCKET_TX_PRINTF, "SOCKET: Failed to send packet from send queue\n");

					socket_prepend_packet_to_user_socket_send_queue (sptr_user_socket, vptr_user_data, number_of_data_bytes);
					}
				else if (count != number_of_data_bytes)
					{
					socket_printf (SOCKET_TX_PRINTF, "SOCKET: Tried to send %u, but send only %u bytes\n", number_of_data_bytes,
						count);
					}
				}
			}

		sptr_user_socket = (USER_SOCKET *) get_pointer_to_next_entry_in_list ((LINK *) sptr_user_socket);
		}
}
/******************************************************************************/
USHORT get_socket_class_error_number (void)
{
	return (socket_class.error_number);
}
/******************************************************************************/
void set_socket_class_error_number (USHORT error_number)
{
	socket_class.error_number = error_number;
}
/******************************************************************************/
USHORT get_number_of_already_allocated_ports_in_socket_class (void)
{
	return (socket_class.number_of_already_allocated_ports);
}
/******************************************************************************/
void set_number_of_already_allocated_ports_in_socket_class (USHORT number_of_software_ports)
{
	socket_class.number_of_already_allocated_ports = number_of_software_ports;
}

