#include	"defs.h"
/*	$Modname: sockprnt.c$  $version: 1.7$      $date: 01/26/95$   */
/*
* 	$lgb$
1.0 10/10/94 titus
1.1 10/10/94 titus Initial Version
1.2 10/10/94 titus Added version control header.
1.3 11/04/94 titus Cosmetic changes to adhere to codestyle.
1.4 11/10/94 titus Cosmetic changes for c++ compilation.
1.5 11/15/94 titus Changed class name sock to socket_class, sock to	socket, SOCK to SOCKET etc.
1.6 11/17/94 titus Deleted the function print_socket_status.
1.7 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#include	<string.h>
#include	<stdarg.h>
#include	"socket.h"
/**************************************************************************/
void socket_printf (enum SOCKET_PRINTF_GROUPS printf_group, const char *cptr_format, ...)
{
	enum BOOLEAN print_string;
	va_list argptr;

	va_start (argptr, cptr_format);

	print_string = FALSE;

#if PRINT_IP_TABLE_INFO /* Jo 21/05/99 */
	if (socket_class.print_class.socket_print_switch_on == FALSE)
		{
		va_end (argptr);

		return;
		}

	switch (printf_group)
		{
		case SOCKET_PRINTF:

			print_string = socket_class.print_class.socket_printing_enabled;

			break;

		case SOCKET_INIT_PRINTF:

			print_string = socket_class.print_class.init_printing_enabled;

			break;

		case SOCKET_TX_PRINTF:

			print_string = socket_class.print_class.tx_printing_enabled;

			break;

		case SOCKET_RX_PRINTF:

			print_string = socket_class.print_class.rx_printing_enabled;

			break;

		case SOCKET_STRING_PRINTF:

			print_string = socket_class.print_class.string_printing_enabled;

			break;

		case SOCKET_ALARM_PRINTF:

			print_string = socket_class.print_class.alarm_printing_enabled;

			break;

		case SOCKET_MEMORY_PRINTF:

			print_string = socket_class.print_class.memory_printing_enabled;

			break;

		case SOCKET_DATA_PRINTF:

			print_string = socket_class.print_class.data_printing_enabled;

			break;

		case SOCKET_DIAGNOSTIC_PRINTF:

			print_string = socket_class.print_class.diagnostic_printing_enabled;

			break;

		default:

			print_string = FALSE;

			break;
		}
#endif /* Jo 21/05/99 */

	if (print_string == TRUE)
		{
		#ifdef __BORLANDC__
		vprintf (cptr_format, argptr);

		#endif
		}

	va_end (argptr);
}

