#include	"defs.h"
/*	$Modname: tsocktcp.c$  $version: 1.2$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 01/26/95 titus Initial version.
1.1 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc.
1.2 04/06/95 titus Changes for dynamic loading and for new LSL messages
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#ifdef __SOCKET_TEST_APPS__
#define GLOBAL_FILE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <kstart.h>
#include <v8022str.h>
#include <lslproto.h>
#include "socklib.h"
#include <iplib.h>
#include <tcplib.h>
#include "ktststcp.h"
#include "vtststr.h"
#include <rwarebuf.h>
/****************************************************************************/
/* Jo 27/04/99 */
const char *cptr_test_socket_tcp_static_messages[] =
{
	"HELLO THERE! STATION 6\0",
	"HELLO STATION 6\0",
	"HELLO THERE! STATION 2\0",
	"HELLO STATION 2\0"
};

TEST_SOCKET_TCP_CLASS test_socket_tcp;
/****************************************************************************/
enum TEST initialize_test_socket_tcp (ULONG clock_ticks_per_second);
void test_socket_tcp_application_entry_point (enum APPLICATION_CONTROL_OPERATION command, ULONG socket_descriptor);
/****************************************************************************/
static void test_socket_tcp_set_or_reset_boolean_variables_and_increment_count (void);
static enum TEST test_socket_tcp_initialize_socket_for_connection (void);
static enum TEST test_socket_tcp_send_message (void);
static enum TEST test_socket_tcp_receive_message (void);
static void test_socket_tcp_timer (void);
static void	test_socket_tcp_timer_reset_counters (void);
enum TEST set_test_socket_tcp_local_ip_address (char *cptr_ip_address_string);
enum TEST set_test_socket_tcp_remote_ip_address (char *cptr_ip_address_string);
static void test_socket_tcp_listen_for_connection (void);
static void test_socket_tcp_attempt_to_connect (void);
static enum BOOLEAN test_socket_tcp_check_for_established_connection (void);
static enum BOOLEAN test_socket_tcp_close_connection (void);
/****************************************************************************/
enum TEST initialize_test_socket_tcp (ULONG clock_ticks_per_second)
{
	if (test_socket_tcp.enabled == TRUE)
		{
		test_socket_tcp.clock_ticks_per_second = clock_ticks_per_second;

		if ((enum TEST) lsl_control (REGISTER_APPLICATION, "Test Socket TCP Application", TEST_SOCKET_TCP_APPLICATION,
			test_socket_tcp_timer,
			(enum TEST (*) (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)) socket_configuration,
			&test_socket_tcp.application_id) ==  FAIL)
			{
			socket_printf (SOCKET_INIT_PRINTF,
				"TEST_SOCKET_TCP: register_application () failed to register Test Socket TCP with lsl\n");

			return (FAIL);
			}

		if (test_socket_tcp_initialize_socket_for_connection () == FAIL)
			{
			socket_printf (SOCKET_INIT_PRINTF, "TEST_SOCKET_TCP: failed to initialize socket for connection\n");
			}
		}

	return (PASS);
 }
/****************************************************************************/
void test_socket_tcp_application_entry_point (enum APPLICATION_CONTROL_OPERATION command, ULONG socket_descriptor)
{
	PARAMETER_NOT_USED (socket_descriptor);

	switch (command)
		{
		case CONNECTION_REQUEST_RECEIVED:

			socket_printf (SOCKET_PRINTF, "TEST_SOCKET_TCP: CONNECTION REQUEST RECEIVED\n");

			if (test_socket_tcp.socket_interface_initialized == TRUE)
				{
				test_socket_tcp_check_for_established_connection ();
				}

			break;

		case CONNECTION_COMPLETED:

			socket_printf (SOCKET_PRINTF, "TEST_SOCKET_TCP: CONNECTION COMPLETED\n");

			test_socket_tcp_set_or_reset_boolean_variables_and_increment_count ();

			break;

		case CONNECTION_CLOSED:

			socket_printf (SOCKET_PRINTF, "TEST_SOCKET_TCP: CONNECTION CLOSED\n");

			test_socket_tcp_close_connection ();

			test_socket_tcp_timer_reset_counters ();

			break;

		case WRITE_DATA_TO_SOCKET:

			socket_printf (SOCKET_PRINTF, "TEST_SOCKET_TCP: WRITE DATA TO SOCKET\n");

			test_socket_tcp_set_or_reset_boolean_variables_and_increment_count ();

			break;

		case READ_DATA_FROM_SOCKET:

			socket_printf (SOCKET_PRINTF, "TEST_SOCKET_TCP: READ DATA FROM SOCKET\n");

			if (test_socket_tcp.socket_interface_initialized == TRUE)
				{
				test_socket_tcp_set_or_reset_boolean_variables_and_increment_count ();

				if (test_socket_tcp_receive_message () == FAIL)
					{
					socket_printf (SOCKET_BLOCK_PRINTF, "TEST_SOCKET_TCP: receive_test_socket_tcp_reply failed\n");
					}
				}

			break;

		default:

			socket_printf (SOCKET_PRINTF, "TEST_SOCKET_TCP: RECEIVED UNKNOWN MESSAGE\n");

			break;
		}
}
/****************************************************************************/
static void test_socket_tcp_set_or_reset_boolean_variables_and_increment_count (void)
{
	if (test_socket_tcp.socket_interface_initialized == TRUE)
		{
		if (test_socket_tcp.connection_up == FALSE)
			{
			++test_socket_tcp.number_of_times_connection_was_set_up;

			test_socket_tcp.connection_up = TRUE;
			test_socket_tcp.connection_initiated = FALSE;
			}
		}
}
/****************************************************************************/
static enum TEST test_socket_tcp_initialize_socket_for_connection (void)
{
	int bind_return_value;
	SOCKADDR_IN local_read_sockaddr_in;

	local_read_sockaddr_in.sin_family = AF_INET;
	local_read_sockaddr_in.sin_port = TEST_SOCKET_TCP_PORT;
	local_read_sockaddr_in.sin_addr.s_addr = test_socket_tcp.local_ip_address;

	test_socket_tcp.socket_descriptor = socket (AF_INET, SOCK_STREAM, 0x00000000L);

	if (test_socket_tcp.socket_descriptor == FAILED)
		{
		return (FAIL);
		}

	associate_application_with_socket (test_socket_tcp.socket_descriptor, test_socket_tcp.application_id);

	bind_return_value = bind (test_socket_tcp.socket_descriptor, (SOCKADDR *) &local_read_sockaddr_in,
		sizeof (SOCKADDR_IN));

	if (bind_return_value == FAILED)
		{
		return (FAIL);
		}

	test_socket_tcp.socket_interface_initialized = TRUE;

	return (PASS);
}
/****************************************************************************/
static enum TEST test_socket_tcp_send_message (void)
{
	char *cptr_test_socket_tcp_message_to_be_send;
	SOCKADDR_IN remote_sockaddr_in;

	cptr_test_socket_tcp_message_to_be_send = (char *) table_malloc (1, SIZEOF_TEST_SOCKET_TCP_MESSAGE);

	if (cptr_test_socket_tcp_message_to_be_send == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "TEST_SOCKET_TCP: test_socket_tcp_send_message (): table_malloc failed\n");

		return (FAIL);
		}

	remote_sockaddr_in.sin_family = AF_INET;
	remote_sockaddr_in.sin_port = TEST_SOCKET_TCP_PORT;
	remote_sockaddr_in.sin_addr.s_addr = test_socket_tcp.remote_ip_address;

	memcpy ((void *) cptr_test_socket_tcp_message_to_be_send,
		(void *) cptr_test_socket_tcp_static_messages[2*test_socket_tcp.station_number], SIZEOF_TEST_SOCKET_TCP_MESSAGE);

	if (sendto (test_socket_tcp.socket_descriptor, cptr_test_socket_tcp_message_to_be_send, SIZEOF_TEST_SOCKET_TCP_MESSAGE,
		(int) NULL, (SOCKADDR *) &remote_sockaddr_in, sizeof (SOCKADDR_IN)) != FAILED)
		{
		socket_printf (SOCKET_TX_PRINTF, "TEST_SOCKET_TCP: sent message : %s\n", cptr_test_socket_tcp_message_to_be_send);

		table_free ((void *) cptr_test_socket_tcp_message_to_be_send);
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST test_socket_tcp_receive_message (void)
{
	char *cptr_test_socket_tcp_message_received;
	char *cptr_test_socket_tcp_message_to_be_send;
	int number_of_bytes_received;
	SOCKADDR_IN remote_sockaddr_in;

	cptr_test_socket_tcp_message_received = (char *) table_malloc (1, SIZEOF_TEST_SOCKET_TCP_MESSAGE);

	if (cptr_test_socket_tcp_message_received == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "TEST_SOCKET_TCP: test_socket_tcp_receive_message (): table_malloc failed\n");

		return (FAIL);
		}

	number_of_bytes_received = recv (test_socket_tcp.socket_descriptor, cptr_test_socket_tcp_message_received,
		SIZEOF_TEST_SOCKET_TCP_MESSAGE, (int) NULL);

	if (number_of_bytes_received <= 0x0000)
		{
		table_free ((void *) cptr_test_socket_tcp_message_received);

		return (FAIL);
		}

	socket_printf (SOCKET_RX_PRINTF, "TEST_SOCKET_TCP: received message : %s\n", cptr_test_socket_tcp_message_received);

	if (((test_socket_tcp.station_number == 0x00) &&
		(strcmp (cptr_test_socket_tcp_message_received,
		cptr_test_socket_tcp_static_messages[2*(test_socket_tcp.station_number + 1)]) == 0)) ||
		((test_socket_tcp.station_number == 0x01) &&
		(strcmp (cptr_test_socket_tcp_message_received,
		cptr_test_socket_tcp_static_messages[2*(test_socket_tcp.station_number - 1)]) == 0)))
		{
		cptr_test_socket_tcp_message_to_be_send = (char *) table_malloc (1, SIZEOF_TEST_SOCKET_TCP_MESSAGE);

		if (cptr_test_socket_tcp_message_to_be_send == NULL)
			{
			socket_printf (SOCKET_ALARM_PRINTF, "TEST_SOCKET_TCP: test_socket_tcp_receive_message (): table_malloc failed\n");

			table_free ((void *) cptr_test_socket_tcp_message_received);

			return (FAIL);
			}

		remote_sockaddr_in.sin_family = AF_INET;
		remote_sockaddr_in.sin_port = TEST_SOCKET_TCP_PORT;
		remote_sockaddr_in.sin_addr.s_addr = test_socket_tcp.remote_ip_address;

		memcpy ((void *) cptr_test_socket_tcp_message_to_be_send,
			(void *) cptr_test_socket_tcp_static_messages[2*test_socket_tcp.station_number + 1], SIZEOF_TEST_SOCKET_TCP_MESSAGE);

		if (sendto (test_socket_tcp.socket_descriptor, cptr_test_socket_tcp_message_to_be_send, SIZEOF_TEST_SOCKET_TCP_MESSAGE,
			(int) NULL, (SOCKADDR *) &remote_sockaddr_in, sizeof (SOCKADDR_IN)) != FAILED)
			{
			socket_printf (SOCKET_TX_PRINTF, "TEST_SOCKET_TCP: sent message : %s\n", cptr_test_socket_tcp_message_to_be_send);

			table_free ((void *) cptr_test_socket_tcp_message_to_be_send);
			}
		}

	table_free ((void *) cptr_test_socket_tcp_message_received);

	return (PASS);
}
/****************************************************************************/
static void test_socket_tcp_timer (void)
{
	if (test_socket_tcp.timer_enabled == FALSE)
		{
		return;
		}

	++test_socket_tcp.tick_counter;

	if (test_socket_tcp.tick_counter >= test_socket_tcp.clock_ticks_per_second)
		{
		test_socket_tcp.tick_counter = 0x00000000L;

		++test_socket_tcp.current_seconds;

		if (test_socket_tcp.connection_up == TRUE)
			{
			if (test_socket_tcp.current_seconds > test_socket_tcp.seconds_between_retransmissions)
				{
				if (test_socket_tcp.retransmission_counter < test_socket_tcp.maximum_retransmission_count)
					{
					++test_socket_tcp.retransmission_counter;

					test_socket_tcp_send_message ();

					test_socket_tcp.current_seconds = 0x00000000L;

					return;
					}

				test_socket_tcp.retransmission_counter = 0x00000000L;

				test_socket_tcp.current_seconds = 0x00000000L;

				test_socket_tcp_close_connection ();
				}

			return;
			}
		else if (test_socket_tcp.socket_interface_initialized == TRUE)
			{
			if ((test_socket_tcp.connection_initiated == FALSE) &&
				(test_socket_tcp.current_seconds > test_socket_tcp.seconds_between_repeated_connection_attempts))
				{
				test_socket_tcp.current_seconds = 0x00000000L;

				test_socket_tcp_attempt_to_connect ();
				}
			}
		else
			{
			if (test_socket_tcp.number_of_times_connection_was_set_up < test_socket_tcp.number_of_times_test_to_be_run)
				{
				test_socket_tcp.current_seconds = 0x00000000L;

				test_socket_tcp_initialize_socket_for_connection ();

				test_socket_tcp_listen_for_connection ();
				}
			else
				{
				test_socket_tcp_timer_reset_counters ();

				test_socket_tcp.timer_enabled = FALSE;
				test_socket_tcp.enabled = FALSE;
				}
			}
		}

	return;
}
/****************************************************************************/
static void	test_socket_tcp_timer_reset_counters (void)
{
	test_socket_tcp.tick_counter = 0x00000000L;
	test_socket_tcp.current_seconds = 0x00000000L;
	test_socket_tcp.retransmission_counter = 0x00000000L;
}
/****************************************************************************/
enum TEST set_test_socket_tcp_local_ip_address (char *cptr_ip_address_string)
{
	BYTE ip_address_array[10];

	sscanf (cptr_ip_address_string,"%03u.%03u.%03u.%03u",
		(int *) &ip_address_array[0],(int *) &ip_address_array[1],(int *) &ip_address_array[2],(int *) &ip_address_array[3]);

	test_socket_tcp.local_ip_address = net_to_host_long ( *((ULONG *) &ip_address_array[0]));

	return (PASS);
}
/****************************************************************************/
enum TEST set_test_socket_tcp_remote_ip_address (char *cptr_ip_address_string)
{
	BYTE ip_address_array[10];

	sscanf (cptr_ip_address_string,"%03u.%03u.%03u.%03u",
		(int *) &ip_address_array[0],(int *) &ip_address_array[1],(int *) &ip_address_array[2],(int *) &ip_address_array[3]);

	test_socket_tcp.remote_ip_address = net_to_host_long ( *((ULONG *) &ip_address_array[0]));

	return (PASS);
}
/****************************************************************************/
static void test_socket_tcp_listen_for_connection (void)
{
	enum TCP_OPEN_MODE mode;

	if ((test_socket_tcp.connection_up == FALSE) && (test_socket_tcp.socket_interface_initialized == TRUE))
		{
		mode = OPEN_MODE_WAIT_FOR_ONE_CONNECTION;

		if (listen (test_socket_tcp.socket_descriptor, (int) mode) == FAILED)
			{
			socket_printf (SOCKET_ALARM_PRINTF, "TEST_SOCKET_TCP: listen call failed for socket %x\n",
				test_socket_tcp.socket_descriptor);

			return;
			}
		}
}
/****************************************************************************/
static void test_socket_tcp_attempt_to_connect (void)
{
	SOCKADDR_IN remote_read_sockaddr_in;
	ULONG socket_error;

	if (test_socket_tcp.connection_up == FALSE)
		{
		remote_read_sockaddr_in.sin_family = AF_INET;
		remote_read_sockaddr_in.sin_port = TEST_SOCKET_TCP_PORT;
		remote_read_sockaddr_in.sin_addr.s_addr = test_socket_tcp.remote_ip_address;

		test_socket_tcp.connection_initiated = TRUE;

		if (connect (test_socket_tcp.socket_descriptor, &remote_read_sockaddr_in, sizeof (SOCKADDR_IN)) == FAILED)
			{
#ifdef __LSL__
			lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG) GET_SOCKET_ERROR_VALUE, (ULONG) SOCKETS_INTERFACE,
				(ULONG) &socket_error);
#else
			socket_configuration (GET_SOCKET_ERROR_VALUE, NULL, (ULONG) &socket_error);
#endif 

			if (socket_error != WOULD_BLOCK_ERROR)
				{
				socket_printf (SOCKET_PRINTF, "TEST_SOCKET_TCP: connect call failed for socket %x with socket_error value %d\n",
					test_socket_tcp.socket_descriptor, socket_error);
				}

			return;
			}

		test_socket_tcp_set_or_reset_boolean_variables_and_increment_count ();
		}
}
/****************************************************************************/
static enum BOOLEAN test_socket_tcp_check_for_established_connection (void)
{
	SOCKADDR_IN remote_write_sockaddr_in;
	int remote_write_sockaddr_in_length;
	ULONG socket_error;
	ULONG socket_descriptor;

	if ((test_socket_tcp.connection_up == FALSE) && (test_socket_tcp.socket_interface_initialized == TRUE))
		{
		socket_descriptor =  accept (test_socket_tcp.socket_descriptor, (SOCKADDR *) &remote_write_sockaddr_in,
			(int *) &remote_write_sockaddr_in_length);

		if (socket_descriptor == FAILED)
			{
		#ifdef __LSL__
			lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG) GET_SOCKET_ERROR_VALUE, (ULONG) SOCKETS_INTERFACE,
				(ULONG) &socket_error);
		#else
			socket_configuration (GET_SOCKET_ERROR_VALUE, NULL, (ULONG) &socket_error);
		#endif /* __LSL__ */

			if (socket_error != WOULD_BLOCK_ERROR)
				{
				socket_printf (SOCKET_PRINTF, "TEST_SOCKET_TCP: accept call failed for socket %x with socket_error value %d\n",
					test_socket_tcp.socket_descriptor, socket_error);
				}

			return (FALSE);
			}
		else
			{
			test_socket_tcp_set_or_reset_boolean_variables_and_increment_count ();

			socket_printf (SOCKET_PRINTF, "TEST_SOCKET_TCP: Socket Connection Established\n");

			return (TRUE);
			}
		}
	else
		{
		return (TRUE);
		}
}
/****************************************************************************/
static enum BOOLEAN test_socket_tcp_close_connection (void)
{
	ULONG socket_error;

	if (test_socket_tcp.socket_interface_initialized == TRUE)
		{
		if (closesocket (test_socket_tcp.socket_descriptor) == FAILED)
			{
#ifdef __LSL__
			lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG) GET_SOCKET_ERROR_VALUE, (ULONG) SOCKETS_INTERFACE,
				(ULONG) &socket_error);
#else
			socket_configuration (GET_SOCKET_ERROR_VALUE, NULL, (ULONG) &socket_error);
#endif 

			socket_printf (SOCKET_PRINTF, "TEST_SOCKET_TCP: closesocket call failed for socket %x with socket_error value %d\n",
				test_socket_tcp.socket_descriptor, socket_error);

			return (FALSE);
			}
		}

	test_socket_tcp.connection_up = FALSE;
	test_socket_tcp.connection_initiated = FALSE;
	test_socket_tcp.socket_interface_initialized = FALSE;

	return (TRUE);
}
#endif /* __SOCKET_TEST_APPS__ */

