/*	$Modname: vsockstr.h$  $version: 1.12$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 10/10/94 titus
1.1 10/10/94 titus Initial Version
1.2 10/10/94 titus Added version control header.
1.3 11/04/94 titus Broke up sockapi.c into socklapi.c and sockoapi.c
1.4 11/04/94 titus Broke up sockutil.c into sockbutl.c and socknutl.c
1.5 11/04/94 titus Cosmetic changes for c++ compilation.
1.6 11/15/94 titus Utilization of links, ULONG socket_descriptors, TRANSPORT_INTERFACE etc.
1.7 11/17/94 titus Deleted the function prototype for print_socket_status .
1.8 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.9 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
1.10 02/06/95 titus Changed application_id to a ULONG
1.11 04/06/95 titus Added struct SOCKET_FUNCTION_POINTERS and some others for dynamic loading
1.12 04/06/95 titus Changes for lint
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#ifndef	_VSOCKSTR_H_
#define	_VSOCKSTR_H_


typedef	struct	TRANSPORT_INTERFACE_LINK
{
	struct TRANSPORT_INTERFACE *sptr_forward_link;
	struct TRANSPORT_INTERFACE *sptr_backward_link;
} TRANSPORT_INTERFACE_LINK;


typedef struct TRANSPORT_INTERFACE
{
	TRANSPORT_INTERFACE_LINK 	links;
	BYTE								socket_type_of_service;		/* Socket type */
	BYTE_ENUM (BOOLEAN)			accept;
	BYTE_ENUM (TEST) 				(*socket) (struct USER_SOCKET *sptr_user_socket, USHORT protocol);
	BYTE_ENUM (TEST) 				(*bind) (struct USER_SOCKET *sptr_user_socket);
	BYTE_ENUM (TEST) 				(*listen) (struct USER_SOCKET *sptr_user_socket, USHORT mode);
	BYTE_ENUM (TEST) 				(*connect) (struct USER_SOCKET *sptr_user_socket);
	USHORT							(*receive) (struct USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length,
											SOCKADDR	*sptr_sockaddr, USHORT *usptr_address_length, enum TEST *eptr_error);
	USHORT							(*send) (struct USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length,
											SOCKADDR	*sptr_sockaddr, enum TEST *eptr_error);
	USHORT							(*queue_length) (struct USER_SOCKET *sptr_user_socket, USHORT queue_type, enum TEST *eptr_error);
	BYTE_ENUM (TEST) 				(*kick) (struct USER_SOCKET *sptr_user_socket);
	BYTE_ENUM (TEST) 				(*shut) (struct USER_SOCKET *sptr_user_socket, USHORT channel);
	BYTE_ENUM (TEST) 				(*close) (struct USER_SOCKET *sptr_user_socket);
	BYTE_ENUM (BOOLEAN) 			(*check_if_window_open) (struct USER_SOCKET *sptr_user_socket);
	BYTE_ENUM (TEST)	  			(*check) (SOCKADDR *sptr_sockaddr, USHORT sockaddr_length);
	char 								**error;
	char 								*(*state) (struct USER_SOCKET *sptr_user_socket);
	BYTE_ENUM (TEST)	  			(*status) (struct USER_SOCKET *sptr_user_socket);
	char 								*end_of_line;
} TRANSPORT_INTERFACE;


typedef	struct	USER_SOCKET_LINK
{
	struct USER_SOCKET *sptr_forward_link;
	struct USER_SOCKET *sptr_backward_link;
} USER_SOCKET_LINK;


/* User sockets */
typedef struct USER_SOCKET
{
	USER_SOCKET_LINK			links;
	ULONG 						socket_descriptor;
	ULONG 						application_id;
	USHORT						reference_count;
	BYTE_ENUM (BOOLEAN) 		do_not_block;
	BYTE 							socket_type_of_service;
	TRANSPORT_INTERFACE 		*sptr_transport_interface;
	BYTE_ENUM (BOOLEAN) 		valid_ready_socket;
	ULONG							ready_socket;
	void 							*vptr_protocol_control_block;
	void 							*vptr_address;
	USHORT						address_length;
	void 							*vptr_peer_address;
	USHORT						peer_address_length;
	BYTE 							error_codes[4];				/* Protocol-specific error codes */
	BYTE							internet_type_of_service;	/* Internet type-of-service */
	ULONG							flag;								/* Mode flags, defined in socket.h */
	BYTE_ENUM (BOOLEAN) 		connection_initiated;
	SOCKET_BUFFER_LINK		socket_buffer_send_queue;
	ULONG 						send_queue_count;
} USER_SOCKET;


typedef struct SOCKET_PRINT_CLASS
{
	BYTE_ENUM (BOOLEAN) 		socket_print_switch_on;
	BYTE_ENUM (BOOLEAN) 		socket_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		init_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		tx_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		rx_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		block_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		tcb_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		string_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		alarm_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		memory_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		data_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		diagnostic_printing_enabled;
} SOCKET_PRINT_CLASS;


typedef	struct	EVENT_QUEUE_LINK
{
	struct EVENT_QUEUE_LINK 		*sptr_forward_link;
	struct EVENT_QUEUE_LINK 		*sptr_backward_link;
} EVENT_QUEUE_LINK;


typedef struct EVENT_QUEUE_ELEMENT
{
	EVENT_QUEUE_LINK 					links;
	USER_SOCKET 						*sptr_user_socket;
	BYTE_ENUM (SOCKET_EVENT) 		event_waited_on;
	BYTE_ENUM (SOCKET_EVENT) 		event_occured;
} EVENT_QUEUE_ELEMENT;


#ifndef __LSL__

	typedef struct SOCKET_USER_APPLICATIONS
	{
		ULONG	 							application_id;
		BYTE_ENUM (SOCKET_EVENT)  	socket_event_waited_on;
		BYTE_ENUM (SOCKET_EVENT)  	socket_event_occured;

		void		 						(*fptr_application_entry_point) (enum SOCKET_EVENT socket_event_occured);
	} SOCKET_USER_APPLICATIONS;

#endif /* __LSL__ */


typedef	struct	SOCKET_FUNCTION_POINTERS
{
	USHORT 	 (*fptr_get_socket_class_error_number) (void);
	void 	 	 (*fptr_set_socket_class_error_number) (USHORT error_number);
	USHORT 	 (*fptr_get_number_of_already_allocated_ports_in_socket_class) (void);
	void 		 (*fptr_set_number_of_already_allocated_ports_in_socket_class) (USHORT number_of_software_ports);
	int 		 (*fptr_bind) (int socket_descriptor, SOCKADDR *sptr_sockaddr, int address_length);
	int 		 (*fptr_socket) (int address_family, int type, int protocol);
	int 		 (*fptr_closesocket) (int socket_descriptor);
	enum TEST (*fptr_wait_on_socket_event) (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event);
	enum TEST (*fptr_wakeup_those_waiting_on_socket_event) (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event);
	enum TEST (*fptr_socket_add_packet_to_user_socket_send_queue) (USER_SOCKET *sptr_user_socket, void *vptr_user_data,
		USHORT number_of_data_bytes);
} SOCKET_FUNCTION_POINTERS;


typedef struct SOCKET_CLASS
{
	BYTE_ENUM (BOOLEAN) 				enabled;
	BYTE_ENUM (BOOLEAN) 				timer_enabled;
	BYTE_ENUM (BOOLEAN) 				blocking_enabled;
	ULONG 								application_id;
	USHORT								error_number;
	USHORT								number_of_already_allocated_ports;
#if PRINT_IP_TABLE_INFO /* Jo 21/05/99 */
	SOCKET_PRINT_CLASS 				print_class;
#endif /* Jo 21/05/99 */
	TRANSPORT_INTERFACE_LINK		transport_interface_list;
	USER_SOCKET_LINK					user_socket_list;
	USHORT								maximum_number_of_sockets;
	USHORT								current_number_of_sockets;
	EVENT_QUEUE_LINK 					event_queue_element_waited_on_list;
	EVENT_QUEUE_LINK 					event_queue_element_occured_list;

	void (*fptr_poll_for_packet_received) (enum BOOLEAN return_from_poll);
	void (*fptr_polling_timer_interrupt) (void);

	#ifndef __LSL__

		USHORT 							number_of_user_applications;
		SOCKET_USER_APPLICATIONS 	socket_user_applications[MAXIMUM_NUMBER_OF_SOCKET_USER_APPLICATIONS];

	#endif /* __LSL__ */

} SOCKET_CLASS;

#endif 	/* _VSOCKSTR_H_ */


/* function prototypes */

/* In socklapi.c: */

int socket (int address_family, int type, int protocol);
int bind (int socket_descriptor, SOCKADDR *sptr_sockaddr, int address_length);
int connect (int socket_descriptor, SOCKADDR_IN *sptr_sockaddr_in, int address_length);
int accept (int socket_descriptor, SOCKADDR *sptr_peer_address, int *peer_address_length);
int recvfrom (int socket_index, char *cptr_data, int length, int flags, SOCKADDR *sptr_sockaddr, int *iptr_address_length);
int sendto (int socket_descriptor, char *cptr_data, int length, int flags, SOCKADDR *sptr_sockaddr, int address_length);


/* In sockoapi.c: */

int listen (int socket_descriptor, int mode);
int recv (int socket_descriptor, char *cptr_data, int length, int flags);
int send (int socket_descriptor, char *cptr_data, int length, int flags);
int shutdown (int socket_descriptor, int how);
int closesocket (int socket_descriptor);
int getpeername (int socket_descriptor, SOCKADDR *sptr_sockaddr, int *iptr_address_length);
int associate_application_with_socket (int socket_descriptor, ULONG application_id);

#ifndef __LSL__
	int register_application_to_socket_interface (ULONG application_id,
		void (*fptr_application_entry_point) (enum SOCKET_EVENT socket_event_occured));
#endif /* __LSL__ */


/* In sockinit.c */

enum TEST initialize_socket (ULONG clock_ticks_per_second);
void set_socket_class_to_zero (void);


/* In socktimr.c */

void socket_timer (void);


/* In sockcnfg.c */

enum TEST socket_configuration (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);


/* In socksubr.c */

USHORT socket_receive_data (ULONG socket_descriptor, void *vptr_data, USHORT length, ULONG flags, SOCKADDR *sptr_sockaddr,
	USHORT *usptr_sockaddr_length, enum TEST *eptr_error);
USHORT socket_send_data (ULONG socket_descriptor, void *vptr_data, USHORT length, ULONG flags, SOCKADDR *sptr_sockaddr,
	USHORT sockaddr_length, enum TEST *eptr_error);
enum TEST get_socket_address (ULONG socket_descriptor, SOCKADDR *sptr_sockaddr, USHORT *usptr_sockaddr_length);
enum TEST get_peer_address (ULONG socket_descriptor, SOCKADDR *sptr_sockaddr, USHORT *usptr_sockaddr_length);
USHORT get_queue_length_for_socket (ULONG socket_descriptor, USHORT queue_type, enum TEST *eptr_error);
enum TEST socket_kick (ULONG socket_descriptor);
enum TEST increment_reference_count_of_socket (ULONG socket_descriptor);
enum TEST set_type_of_service (ULONG socket_descriptor, ULONG type_of_service);


/* In file sockbutl.c: */

enum TEST wait_on_socket_event (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event);
enum TEST wakeup_those_waiting_on_socket_event (USER_SOCKET *sptr_user_socket, enum SOCKET_EVENT socket_event);


/* In file socknutl.c: */

char *socket_get_reason_for_connection_closing (ULONG socket_descriptor);
char *socket_get_state_of_protocol (ULONG socket_descriptor);
enum TEST socket_add_packet_to_user_socket_send_queue (USER_SOCKET *sptr_user_socket, void *vptr_user_data,
	USHORT number_of_data_bytes);
enum TEST socket_remove_packet_from_user_socket_send_queue (USER_SOCKET *sptr_user_socket, void **ptr_to_vptr_user_data,
	USHORT *usptr_number_of_data_bytes);
void socket_send_the_packets_on_user_socket_send_queue (void);
enum TEST socket_prepend_packet_to_user_socket_send_queue (USER_SOCKET *sptr_user_socket, void *vptr_user_data,
	USHORT number_of_data_bytes);
USHORT get_socket_class_error_number (void);
void set_socket_class_error_number (USHORT error_number);
USHORT get_number_of_already_allocated_ports_in_socket_class (void);
void set_number_of_already_allocated_ports_in_socket_class (USHORT number_of_software_ports);


/* In file sockprnt.c: */

void socket_printf (enum SOCKET_PRINTF_GROUPS printf_group, const char *cptr_format, ...);


/* external prototypes */

/*
extern enum TEST socket_ipx (USER_SOCKET *sptr_user_socket, USHORT protocol);
extern enum TEST socket_ipx_bind (USER_SOCKET *sptr_user_socket);
extern enum TEST socket_ipx_connect (USER_SOCKET *sptr_user_socket);
extern USHORT socket_ipx_receive (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	USHORT *usptr_sockaddr_length, enum TEST *eptr_error);
extern USHORT socket_ipx_send (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	enum TEST *eptr_error);
extern USHORT socket_ipx_queue_length (USER_SOCKET *sptr_user_socket, USHORT queue_type, enum TEST *eptr_error);
extern enum TEST socket_ipx_close (USER_SOCKET *sptr_user_socket);
extern enum TEST socket_ipx_status (USER_SOCKET *sptr_user_socket);
extern enum TEST check_ipx_address (SOCKADDR *sptr_sockaddr, USHORT sockaddr_length);
*/

extern enum TEST ip_configuration (enum PROTOCOL_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
