#include	"defs.h"
/*
 * $Log: /IP/ARPRX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: arprx.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include "ip.h"
/*************************************************************************/
static enum TEST check_for_valid_arp_packet (USHORT port_number, ARP_PACKET *sptr_arp_packet, USHORT number_of_bytes_rxed);
static enum BOOLEAN check_if_arp_packet_is_destined_to_this_router (ULONG *ulptr_target_protocol_address,
	ARP_PACKET *sptr_arp_packet, enum BOOLEAN *eptr_target_to_me);
static void	get_arp_table_entry_that_corresponds_to_the_sender (ULONG *ulptr_sender_protocol_address,
	ARP_PACKET *sptr_arp_packet, ARP_TABLE_ENTRY **ptr_to_sptr_arp_table_entry);
static void	update_arp_table_entry (ARP_TABLE_ENTRY *sptr_arp_table_entry, ARP_PACKET *sptr_arp_packet, USHORT port_number);
static void	send_waiting_packet (ARP_TABLE_ENTRY *sptr_arp_table_entry, ARP_PACKET *sptr_arp_packet, USHORT port_number,
	UNION_IP_PACKET_LIST_ELEMENT *sptr_ip_packet_element);
static void add_new_arp_table_entry_for_sender_if_arp_packet_is_destined_to_this_router (enum BOOLEAN target_to_me,
	USHORT port_number, ULONG target_protocol_address, ULONG sender_protocol_address, ARP_PACKET *sptr_arp_packet,
	ARP_TABLE_ENTRY **ptr_to_sptr_arp_table_entry);
static enum TEST processing_for_proxy_arp (ARP_PACKET *sptr_arp_packet, USHORT port_number, ULONG target_protocol_address,
	USHORT number_of_bytes_rxed, enum BOOLEAN i_am_target, enum IP_PACKET_STATE *return_value);

/* Sachin 17/07/1996 for RAS */
enum TEST arp_processing_for_remote_clients (ARP_PACKET *sptr_arp_packet, USHORT port_number, ULONG target_protocol_address,
	USHORT number_of_bytes_rxed) ;
/* Sachin 17/07/1996 for RAS */

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
static void print_rxed_arp_header (ARP_HEADER *sptr_arp_header, USHORT port_number);
#endif
/*************************************************************************/
enum IP_PACKET_STATE arp_packet_received (USHORT port_number, ARP_PACKET *sptr_arp_packet, USHORT number_of_bytes_rxed)
{
	enum BOOLEAN target_to_me;
	ULONG target_protocol_address;
	ULONG sender_protocol_address;
	ARP_TABLE_ENTRY *sptr_arp_table_entry;
	UNION_IP_PACKET_LIST_ELEMENT *sptr_ip_packet_element;
   enum IP_PACKET_STATE return_value ;

	++ip.arp.statistics.total_number_of_packets_received;

	if (check_for_valid_arp_packet (port_number, sptr_arp_packet, number_of_bytes_rxed) == FAIL)
	{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
	}

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
	print_rxed_arp_header (&sptr_arp_packet->header, port_number);
#endif 
/* Jo 23/04/99 */

	check_if_arp_packet_is_destined_to_this_router (&target_protocol_address, sptr_arp_packet, &target_to_me);

	get_arp_table_entry_that_corresponds_to_the_sender (&sender_protocol_address, sptr_arp_packet, &sptr_arp_table_entry);

	if (sptr_arp_table_entry != NULL)
	{
		update_arp_table_entry (sptr_arp_table_entry, sptr_arp_packet, port_number);

		--ip.arp.port[port_number].number_of_arp_table_entries_awaiting_reply;

		sptr_ip_packet_element = (UNION_IP_PACKET_LIST_ELEMENT *) get_entry_from_list ((LINK *)
			&sptr_arp_table_entry->list_of_packets_waiting_to_be_sent);

		while (sptr_ip_packet_element != NULL)
		{
			if (sptr_ip_packet_element->sptr_packet_waiting_to_send != NULL)
			{
				send_waiting_packet (sptr_arp_table_entry, sptr_arp_packet, port_number, sptr_ip_packet_element);

				table_free ((void *) sptr_ip_packet_element);
			}

			sptr_ip_packet_element = (UNION_IP_PACKET_LIST_ELEMENT *) get_entry_from_list ((LINK *)
				&sptr_arp_table_entry->list_of_packets_waiting_to_be_sent);
		}
	}
	else
	{
		add_new_arp_table_entry_for_sender_if_arp_packet_is_destined_to_this_router (target_to_me, port_number,
			target_protocol_address, sender_protocol_address, sptr_arp_packet, &sptr_arp_table_entry);
	}

/* Sachin 02/05/1997 added the new parameter and handling it */
	if (processing_for_proxy_arp (sptr_arp_packet, port_number, target_protocol_address, number_of_bytes_rxed, target_to_me, &return_value)
		== PASS)
	{
      return (return_value) ;
		/* return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED); */
	}


/* Jo Added for RAS 03/06/99 */
/* Sachin 17/07/96 for RAS */

	if (arp_processing_for_remote_clients (sptr_arp_packet, port_number, target_protocol_address, number_of_bytes_rxed)
	     == PASS)
	{
/* Sachin 05/05/1997 */
		/* return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED); */
      return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED) ;
/* Sachin 05/05/1997 */
	}

/* Sachin 17/07/96 for RAS */
/* Jo Added for RAS 03/06/99 */
/*
   Send proxy_arp_if_enabled...this_router() does not use up the buffer
   even if it returns PASS. So, the return value is correct. We can then
   have LSL free up the buffer.
*/
	if (send_proxy_arp_if_enabled_when_the_target_is_not_this_router (sender_protocol_address, target_protocol_address,
		port_number, target_to_me, &sptr_arp_table_entry, sptr_arp_packet) == PASS)
	{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
	}

/* Sachin, 05/06/1996 */

/* Sachin 02/05/1997 */
/* Check if sptr_arp_table_entry is NULL */
   if (sptr_arp_table_entry != NULL)
   {
	   if ((sptr_arp_table_entry->port_number == 0) &&
		    (target_protocol_address != ip.port[0].config.ip_address))
		{
			return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED) ;
		}
   }
   else
	{
      return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED) ;
	}

	/* This portion of code solves two problems.
		(a). Some hosts, when they come up make an ARP with target address being
		     their own IP address. This is to detect in case there's an address
			  conflict. We should not be replying unless it clashes with our address.
			  Never mind if it is there in our cache with a different HW address

		(b). The ROUTER, was responding even to ARP requests seeking hardware
		     address of some host on the network. We have no business to reply
			  to any ARP request unless the target IP address is our own.

		P.S : The code assumes that port 0 corresponds to the LAN port.
	*/

/* Sachin, 05/06/1996 */

	++ip.arp.statistics.total_number_of_incoming_requests;

	send_arp_reply (port_number, sptr_arp_packet, number_of_bytes_rxed, target_protocol_address, sptr_arp_table_entry, FALSE,
		target_to_me);

	return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
}
/*************************************************************************/
static enum TEST check_for_valid_arp_packet (USHORT port_number, ARP_PACKET *sptr_arp_packet, USHORT number_of_bytes_rxed)
{
	ULONG sender_protocol_address;
	IP_PORT_CLASS *sptr_port;

	if (number_of_bytes_rxed < MINIMUM_ARP_PACKET_LENGTH)
		{
		++ip.arp.statistics.total_number_of_short_packets_received;

		return (FAIL);
		} 

	if (sptr_arp_packet->header.protocol != SNAP_IP_PACKET)
		{
		++ip.arp.statistics.unsupported_protocol;

		return (FAIL);
		}

	if ((sptr_arp_packet->header.hardware_type != ARP_HARDWARE_ETHERNET) &&
		(sptr_arp_packet->header.hardware_type != ARP_HARDWARE_IEEE_802_NETWORKS))
		{
		++ip.arp.statistics.unsupported_hardware;

		return (FAIL);
		}

	sptr_port = &ip.port[port_number];

	if ((sptr_arp_packet->header.hardware_address_length != sptr_port->hardware_address_length) ||
		(sptr_arp_packet->header.protocol_address_length != IP_ADDRESS_LENGTH))
		{
		++ip.arp.statistics.bad_length_field;

		return (FAIL);
		}

	if (memcmp (&sptr_arp_packet->header.sender_hardware_address, &sptr_port->mac_address,
		sptr_arp_packet->header.hardware_address_length) == (int) NULL)
		{
#ifdef _BIG_PROXY_ /* Jo 26/05/99 */
		++ip.arp.statistics.total_number_of_packets_from_me_received;
#endif /* Jo 26/05/99 */

		return (FAIL);
		}

	if (memcmp (&sptr_arp_packet->header.sender_hardware_address, &ethernet_broadcast_address,
		sptr_arp_packet->header.hardware_address_length) == (int) NULL)
		{
#ifdef _BIG_PROXY_ /* Jo 26/05/99 */
		++ip.arp.statistics.total_number_of_source_broadcasts_received;
#endif /* Jo 26/05/99 */

		return (FAIL);
		}

	sender_protocol_address = net_to_host_long (sptr_arp_packet->header.sender_protocol_address);

/* Sachin 02/05/1997 */
/* Somebody may be misconfigured with the router's IP address.
So, we need to respond even to such requests. This check otherwise
filters off such packets */
#if 0
	if ((sptr_arp_packet->header.operation_code == ARP_REQUEST) &&
		(ip_match_full_address_to_port (sender_protocol_address) != NO_SUCH_PORT))
		{
		/* received from me */

		++ip.arp.statistics.total_number_of_packets_from_me_received;

		return (FAIL);
		}
#endif
/* Sachin 02/05/1997 */

	return (PASS);
}
/*************************************************************************/
static enum BOOLEAN check_if_arp_packet_is_destined_to_this_router (ULONG *ulptr_target_protocol_address,
	ARP_PACKET *sptr_arp_packet, enum BOOLEAN *eptr_target_to_me)
{
	*eptr_target_to_me = FALSE;

	*ulptr_target_protocol_address = net_to_host_long (sptr_arp_packet->header.target_protocol_address);

	if (ip_match_full_address_to_port (*ulptr_target_protocol_address) != NO_SUCH_PORT)
		{
		*eptr_target_to_me = TRUE;

		return (TRUE);
		}
	return (FALSE);
}
/*************************************************************************/
static void	get_arp_table_entry_that_corresponds_to_the_sender (ULONG *ulptr_sender_protocol_address,
	ARP_PACKET *sptr_arp_packet, ARP_TABLE_ENTRY **ptr_to_sptr_arp_table_entry)
{
	*ulptr_sender_protocol_address = net_to_host_long (sptr_arp_packet->header.sender_protocol_address);

	*ptr_to_sptr_arp_table_entry = find_arp_table_entry (NO_SUCH_PORT, *ulptr_sender_protocol_address, FALSE);
}
/*************************************************************************/
static void	update_arp_table_entry (ARP_TABLE_ENTRY *sptr_arp_table_entry, ARP_PACKET *sptr_arp_packet, USHORT port_number)
{
	if (sptr_arp_table_entry->type == INVALID_ARP_ENTRY)
		{
		sptr_arp_table_entry->type = DYNAMIC_ARP_ENTRY;
		}

	sptr_arp_table_entry->hardware_address = sptr_arp_packet->header.sender_hardware_address;

#ifdef _BIG_PROXY_
	if (ip.port[port_number].config.token_ring == TRUE && ip.port[port_number].config.rfc1042_enabled == TRUE)
		{
		add_token_ring_rif_to_arp_table_entry (sptr_arp_packet, sptr_arp_table_entry);
		}
#endif
}
/*************************************************************************/
static void	send_waiting_packet (ARP_TABLE_ENTRY *sptr_arp_table_entry, ARP_PACKET *sptr_arp_packet, USHORT port_number,
	UNION_IP_PACKET_LIST_ELEMENT *sptr_ip_packet_element)
{
#ifdef _BIG_PROXY_
	if (ip.port[port_number].config.token_ring == TRUE && ip.port[port_number].config.rfc1042_enabled == TRUE)
		{
		add_rif_to_token_ring_packet (sptr_ip_packet_element->sptr_packet_waiting_to_send, sptr_arp_table_entry);
		}
#endif

	if (ip.port[port_number].config.proxy_arp_enabled == FALSE)
		{
#ifdef DEBUG
		print_txed_ip_header (&sptr_ip_packet_element->sptr_packet_waiting_to_send->ip.header, port_number);
#endif

		send_packet_to_lsl (port_number, sptr_ip_packet_element->sptr_packet_waiting_to_send,
			sptr_ip_packet_element->number_of_bytes_to_send, FALSE, (void (*) (USHORT port_number, void *sptr_tx_packet))
			send_completion_ip_packet, SNAP_IP_PACKET, &sptr_arp_packet->header.sender_hardware_address);
		}
	else
		{
#ifdef DEBUG
		print_txed_ip_header (&sptr_ip_packet_element->sptr_packet_waiting_to_send->ip.header,
			sptr_arp_table_entry->port_number);
#endif

		send_packet_to_lsl (sptr_arp_table_entry->port_number, sptr_ip_packet_element->sptr_packet_waiting_to_send,
			sptr_ip_packet_element->number_of_bytes_to_send, FALSE, (void (*) (USHORT port_number, void *sptr_tx_packet))
			send_completion_ip_packet, SNAP_IP_PACKET, &sptr_arp_packet->header.sender_hardware_address);
		}

	sptr_ip_packet_element->sptr_packet_waiting_to_send = NULL;
}
/*************************************************************************/
static void add_new_arp_table_entry_for_sender_if_arp_packet_is_destined_to_this_router (enum BOOLEAN target_to_me,
	USHORT port_number, ULONG target_protocol_address, ULONG sender_protocol_address, ARP_PACKET *sptr_arp_packet,
	ARP_TABLE_ENTRY **ptr_to_sptr_arp_table_entry)
{
	/* sender's ip address is not in arp table. Only if it wants to talk to us, will it be added to the arp table. */

	if ((target_to_me == TRUE) || (ip.port[port_number].config.proxy_arp_enabled == TRUE) ||
		(find_remote_access_target (target_protocol_address) != NULL)) /* Jo Added for RAS 03/06/99 */
	{
		*ptr_to_sptr_arp_table_entry = (ARP_TABLE_ENTRY *) add_entry_to_arp_table (port_number, sender_protocol_address,
			&sptr_arp_packet->header.sender_hardware_address, DYNAMIC_ARP_ENTRY, sptr_arp_packet);

/* Jo 23/04/99 */
	#if PRINT_IP_TABLE_INFO
		arp_print_table ();
	#endif /* __IP__DEBUG__ */
	}
}
/*************************************************************************/
static enum TEST processing_for_proxy_arp (ARP_PACKET *sptr_arp_packet, USHORT port_number, ULONG target_protocol_address,
	USHORT number_of_bytes_rxed, enum BOOLEAN i_am_target, enum IP_PACKET_STATE *eptr_return_value)
{
	ARP_TABLE_ENTRY *sptr_arp_table_entry;
/* Sachin 07/06/1996 */
	USHORT port_number_to_proxy_for ;
	enum BOOLEAN is_target_in_subnet ;
/* Sachin 07/06/1996 */

/* Sachin 02/05/1997 */
   *eptr_return_value = IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED ;
/* Sachin 02/05/1997 */

	if (sptr_arp_packet->header.operation_code != ARP_REQUEST)
	{
		if (ip.port[port_number].config.proxy_arp_enabled == TRUE)
		{
			sptr_arp_table_entry = find_arp_table_entry (port_number, target_protocol_address, TRUE);

			if (sptr_arp_table_entry != NULL)
			{
				send_arp_reply (sptr_arp_table_entry->port_number, sptr_arp_packet, number_of_bytes_rxed,
					target_protocol_address, sptr_arp_table_entry, TRUE, i_am_target);
/* Sachin 02/05/1997 */
            *eptr_return_value = IP_DATA_PACKET_RXED_AND_WAS_FORWARDED ;
/* Sachin 02/05/1997 */
			}
		}

		return (PASS);
	}

/* Sachin 07/06/1996 */

	if (ip.port[port_number].config.proxy_arp_enabled == FALSE)
		return (FAIL) ;

	is_target_in_subnet = FALSE ;
	for (port_number_to_proxy_for = 0x0000 ;
	     port_number_to_proxy_for < ip.number_of_ports ;
		  port_number_to_proxy_for++)
	{
/* Sachin 02/05/1997 */
      /* if (is_target_in_subnet)
			break ; */
/* Sachin 02/05/1997 */

		/* In case of remote access clients, there is another function that
		   takes care */

		if ((port_number_to_proxy_for == port_number) ||
		    (ip.port[port_number_to_proxy_for].config.remote_access_enabled))
			continue ;

      /* Dont proxy if the port_number happens to be a subnet of the port_number_to_proxy_for */
/* Sachin 02/05/1997 */
      if (ip.port[port_number_to_proxy_for].config.subnetmask < ip.port[port_number].config.subnetmask)
         continue ;
/* Sachin 02/05/1997 */

		if (ip.port[port_number_to_proxy_for].config.port_enabled)
		{
			if ((target_protocol_address & ip.port[port_number_to_proxy_for].config.subnetmask) ==
		    	(ip.port[port_number_to_proxy_for].config.ip_address & ip.port[port_number_to_proxy_for].config.subnetmask))
			{
				is_target_in_subnet = TRUE ;
/* Sachin 02/05/1997 */
            break ;
/* Sachin 02/05/1997 */
			}
		}
	}

	if (is_target_in_subnet)
	{
		sptr_arp_packet->header.operation_code = ARP_REPLY ;
		sptr_arp_packet->header.target_hardware_address = sptr_arp_packet->header.sender_hardware_address;
		sptr_arp_packet->header.target_protocol_address = sptr_arp_packet->header.sender_protocol_address;

		sptr_arp_packet->header.sender_protocol_address = swap_long (target_protocol_address);
		sptr_arp_packet->header.sender_hardware_address = ip.port[0].mac_address;
		/* It is assumed here that port 0 is the LAN port */

		send_packet_to_lsl (port_number, (UNION_IP_PACKET *)sptr_arp_packet, number_of_bytes_rxed, TRUE, NULL, SNAP_IP_ARP_PACKET,
                          &sptr_arp_packet->header.target_hardware_address) ;

/* Sachin 02/05/1997 */
      *eptr_return_value = IP_DATA_PACKET_RXED_AND_WAS_FORWARDED ;
/* Sachin 02/05/1997 */
		++ip.arp.statistics.total_number_of_replies_sent ;

		return (PASS) ;
	}

/* Sachin 07/06/1996 */

	return (FAIL);
}
/*************************************************************************/

#ifdef _BIG_PROXY_
void add_token_ring_rif_to_arp_table_entry (ARP_PACKET *sptr_arp_packet, ARP_TABLE_ENTRY *sptr_arp_table_entry)
{
	BYTE length_of_rif;
	ROUTING_INFORMATION_FIELD *sptr_rif;

	if ((sptr_arp_packet->mac_header.ethernet.source_address._ulong & SET_SOURCE_ROUTING_BIT) != 0x00000000L)
		{
		length_of_rif = *(BYTE *) ((ULONG) sptr_arp_packet - sizeof (SNAP_HEADER) - sizeof (BYTE));

		sptr_rif = (ROUTING_INFORMATION_FIELD *) ((ULONG) sptr_arp_packet - sizeof (SNAP_HEADER) - sizeof (length_of_rif) -
			length_of_rif);

		memcpy (&sptr_arp_table_entry->rif[0], sptr_rif, length_of_rif);

		sptr_arp_table_entry->use_rif = TRUE;
		sptr_arp_table_entry->length_of_rif = length_of_rif;
		}
}
/*************************************************************************/
void add_rif_to_token_ring_packet (UNION_IP_PACKET *uptr_ip_packet, ARP_TABLE_ENTRY *sptr_arp_table_entry)
{
	UNION_ROUTING_CONTROL_FIELD *sptr_routing_control_field;
	BYTE *bptr_length;
	SNAP_HEADER *sptr_snap_header;

	/* put the routing control field in */

	bptr_length = (BYTE *) ((ULONG) uptr_ip_packet - sizeof (SNAP_HEADER) - sizeof (BYTE));

	*bptr_length = sptr_arp_table_entry->length_of_rif;

	sptr_routing_control_field = (UNION_ROUTING_CONTROL_FIELD *) ((ULONG) bptr_length - sptr_arp_table_entry->length_of_rif);

	memcpy (sptr_routing_control_field, &sptr_arp_table_entry->rif[0], sptr_arp_table_entry->length_of_rif);

	sptr_routing_control_field->_bit.length_of_routing_field = sptr_arp_table_entry->length_of_rif;
	sptr_routing_control_field->_bit.broadcast_indicators = NON_BROADCAST;

	if (sptr_routing_control_field->_bit.direction == TRUE)
		{
		sptr_routing_control_field->_bit.direction = FALSE;
		}
	else
		{
		sptr_routing_control_field->_bit.direction = TRUE;
		}

	sptr_snap_header = (SNAP_HEADER *) ((ULONG) uptr_ip_packet - sizeof (SNAP_HEADER));

	sptr_snap_header->destination_address_DSAP = LSAP_SNAP_LLC;
	sptr_snap_header->source_address_SSAP = LSAP_SNAP_LLC;
	sptr_snap_header->llc_frame_type = UNNUMBERED_INFORMATION;

	sptr_snap_header->protocol_id_filler[0] = 0x00;
	sptr_snap_header->protocol_id_filler[1] = 0x00;
	sptr_snap_header->protocol_id_filler[2] = 0x00;
	sptr_snap_header->protocol_id = SNAP_IP_PACKET;

	uptr_ip_packet->ip.mac_header.ethernet.source_address._ulong =
		uptr_ip_packet->ip.mac_header.ethernet.source_address._ulong | SET_SOURCE_ROUTING_BIT;
}
#endif

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
static void print_rxed_arp_header (ARP_HEADER *sptr_arp_header, USHORT port_number)
{
	char *ptr_to_string;

	if (ip.print_class.arp_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], net_to_host_long (sptr_arp_header->sender_protocol_address));

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], net_to_host_long (sptr_arp_header->target_protocol_address));

		ptr_to_string += sprintf (ptr_to_string, "IP/ARP: rxed packet %x%x:%s --> %x%x:%s on port %u\n",
			net_to_host_long (sptr_arp_header->sender_hardware_address._ulong),
			net_to_host_short (sptr_arp_header->sender_hardware_address._ushort), &ip.print_buffer[0],
			net_to_host_long (sptr_arp_header->target_hardware_address._ulong),
			net_to_host_short (sptr_arp_header->target_hardware_address._ushort), ip.print_buffer_2,
			port_number);

		ptr_to_string += sprintf (ptr_to_string, "   header: type:%u,proto:%u,halen:%u,palen:%u,opcode:%u\n",
			sptr_arp_header->hardware_type,
			net_to_host_short (sptr_arp_header->protocol), (USHORT) sptr_arp_header->hardware_address_length,
			(USHORT) sptr_arp_header->protocol_address_length, net_to_host_short (sptr_arp_header->operation_code));

		ip_printf (ARP_PRINTF, &ip.string_to_print[0]);
		}
}
#endif 
/* Jo 23/04/99 */
