#include	"defs.h"
/*
 * $Log: /IP/ARPTX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: arptx.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ip.h"
/*************************************************************************/
#define __IP_DEBUG__

static void send_proxy_arp_request (USHORT port_number, ARP_PACKET *sptr_arp_packet, ULONG target_protocol_address);
static void	put_the_routing_control_field_into_packet (USHORT tx_port_number, UNION_IP_PACKET *uptr_ip_packet,
	enum SNAP_PROTOCOL_ID protocol_type, UNION_ROUTING_CONTROL_FIELD **ptr_to_sptr_routing_control_field);
static void	put_the_length_of_the_rif_field_into_packet (UNION_ROUTING_CONTROL_FIELD *sptr_routing_control_field);
static void	build_snap_header (UNION_IP_PACKET *uptr_ip_packet, enum SNAP_PROTOCOL_ID protocol_type);
static void	build_arp_packet (IP_PORT_CLASS *sptr_port, ARP_PACKET *sptr_arp_packet, enum BOOLEAN proxy_arp,
	ULONG sender_ip_address, ULONG tx_ip_address);
static enum BOOLEAN check_if_matching_arp_table_entry_is_found (ARP_TABLE_ENTRY *sptr_arp_table_entry, USHORT tx_port_number,
	UNION_IP_PACKET *sptr_tx_packet);
static enum TEST processing_when_arp_table_entry_is_not_found (ARP_TABLE_ENTRY *sptr_arp_table_entry, USHORT tx_port_number,
	ULONG tx_ip_address, UNION_IP_PACKET *sptr_tx_packet, USHORT number_of_bytes);
static void	put_current_packet_on_waiting_to_send_queue_of_arp_table_entry (USHORT tx_port_number, USHORT number_of_bytes,
	ARP_TABLE_ENTRY *sptr_arp_table_entry, UNION_IP_PACKET *sptr_tx_packet);

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
static void print_txed_arp_header (ARP_HEADER *sptr_arp_header, USHORT port_number);
#endif
/* Jo 23/04/99 */

void send_arp_reply (USHORT port_number, ARP_PACKET *sptr_arp_packet, USHORT number_of_bytes_rxed,
	ULONG target_protocol_address, ARP_TABLE_ENTRY *sptr_arp_table_entry, enum BOOLEAN proxy_arp, enum BOOLEAN i_am_target)
{
	sptr_arp_packet->header.operation_code = ARP_REPLY;

	if (proxy_arp == FALSE)
		{
		sptr_arp_packet->header.target_hardware_address = sptr_arp_packet->header.sender_hardware_address;
		sptr_arp_packet->header.target_protocol_address = sptr_arp_packet->header.sender_protocol_address;

		sptr_arp_packet->header.sender_protocol_address = swap_long (target_protocol_address);
		}
	else
		{
		sptr_arp_packet->header.target_hardware_address = sptr_arp_table_entry->hardware_address;
		}

	if (i_am_target == TRUE)
		{
		sptr_arp_packet->header.sender_hardware_address = ip.port[port_number].mac_address;
		}
	else
		{
		if (sptr_arp_table_entry != NULL)
			{
			sptr_arp_packet->header.sender_hardware_address = sptr_arp_table_entry->hardware_address;
			}
		}

#ifdef _BIG_PROXY_
	if (ip.port[port_number].config.token_ring == TRUE && ip.port[port_number].config.rfc1042_enabled == TRUE)
		{
		if (sptr_arp_table_entry->use_rif == TRUE)
			{
			add_rif_to_token_ring_packet ((UNION_IP_PACKET *) sptr_arp_packet, sptr_arp_table_entry);
			}
		}
#endif

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
	printf("ARP: Replying for ARP request on port %d \n", port_number);
	print_txed_arp_header (&sptr_arp_packet->header, port_number);
#endif
/* Jo 23/04/99 */

	send_packet_to_lsl (port_number, (UNION_IP_PACKET *) sptr_arp_packet, number_of_bytes_rxed, TRUE, NULL, SNAP_IP_ARP_PACKET,
		&sptr_arp_packet->header.target_hardware_address);

	++ip.arp.statistics.total_number_of_replies_sent;
}
/*************************************************************************/
enum TEST send_proxy_arp_if_enabled_when_the_target_is_not_this_router (ULONG sender_protocol_address,
	ULONG target_protocol_address, USHORT port_number, enum BOOLEAN target_to_me,
	ARP_TABLE_ENTRY **ptr_to_sptr_arp_table_entry, ARP_PACKET *sptr_arp_packet)
{
	PARAMETER_NOT_USED (sender_protocol_address);

#ifdef __IP_DEBUG__
	ip_printf (ARP_PRINTF, "   IP/ARP: request received\n");
#endif /* __IP__DEBUG__ */

	if (target_to_me == FALSE)
		{
		*ptr_to_sptr_arp_table_entry = find_arp_table_entry (port_number, target_protocol_address, TRUE);

		if (*ptr_to_sptr_arp_table_entry == NULL)
			{
			if (ip.port[port_number].config.proxy_arp_enabled == TRUE)
				{
				send_proxy_arp_request (port_number, sptr_arp_packet, target_protocol_address);
				}

			return (PASS);
			}
		}

	return (FAIL);
}
/*************************************************************************/
static void send_proxy_arp_request (USHORT port_number, ARP_PACKET *sptr_arp_packet, ULONG target_protocol_address)
{
	USHORT proxy_arp_port_number;

	for (proxy_arp_port_number = 0x0000; proxy_arp_port_number < ip.number_of_ports; ++proxy_arp_port_number)
		{
		if ((proxy_arp_port_number != port_number) && (ip.port[proxy_arp_port_number].config.proxy_arp_enabled == TRUE))
			{
			send_arp_request_packet (proxy_arp_port_number, target_protocol_address, TRUE,
				&sptr_arp_packet->header.sender_hardware_address, sptr_arp_packet->header.sender_protocol_address);
			}
		}
}
/*************************************************************************/
enum TEST send_arp_request_packet (USHORT tx_port_number, ULONG tx_ip_address, enum BOOLEAN proxy_arp,
	MAC_ADDRESS *sptr_mac_address, ULONG sender_ip_address)
{
	ARP_PACKET *sptr_arp_packet;
	IP_PORT_CLASS *sptr_port;

	PARAMETER_NOT_USED (sptr_mac_address);

	sptr_port = &ip.port[tx_port_number];

	sptr_arp_packet = (ARP_PACKET *) get_an_ip_send_packet (tx_port_number, sizeof (ARP_PACKET));

	if (sptr_arp_packet == NULL)
		{
		return (FAIL);
		}

	build_arp_packet (sptr_port, sptr_arp_packet, proxy_arp, sender_ip_address, tx_ip_address);

#ifdef _BIG_PROXY_
	if ((ip.port[tx_port_number].config.token_ring == TRUE) && (ip.port[tx_port_number].config.rfc1042_enabled == TRUE))
		{
		convert_ip_tx_header_to_source_routed_header (tx_port_number, (UNION_IP_PACKET *) sptr_arp_packet, SNAP_IP_ARP_PACKET);
		}
#endif

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
	ip_printf (ARP_PRINTF, "IP/ARP: sent request for %s\n", convert_ip_address_to_dot_format (&ip.print_buffer[0],
		tx_ip_address));

	print_txed_arp_header (&sptr_arp_packet->header, tx_port_number);
#endif
/* Jo 23/04/99 */

	send_packet_to_lsl (tx_port_number, (UNION_IP_PACKET *) sptr_arp_packet, sizeof (ARP_PACKET), FALSE,
		send_completion_ip_packet, SNAP_IP_ARP_PACKET, &ethernet_broadcast_address);

	++ip.arp.statistics.total_number_of_requests_sent;

	return (PASS);
}
/*************************************************************************/

#ifdef _BIG_PROXY_
void *convert_ip_tx_header_to_source_routed_header (USHORT tx_port_number, UNION_IP_PACKET *uptr_ip_packet,
	enum SNAP_PROTOCOL_ID protocol_type)
{
	UNION_ROUTING_CONTROL_FIELD *sptr_routing_control_field;

	put_the_routing_control_field_into_packet (tx_port_number, uptr_ip_packet, protocol_type, &sptr_routing_control_field);

	put_the_length_of_the_rif_field_into_packet (sptr_routing_control_field);

	build_snap_header (uptr_ip_packet, protocol_type);

	uptr_ip_packet->ip.mac_header.ethernet.source_address._ulong =
		uptr_ip_packet->ip.mac_header.ethernet.source_address._ulong | SET_SOURCE_ROUTING_BIT;

	return (uptr_ip_packet);
}
/*************************************************************************/
static void	put_the_routing_control_field_into_packet (USHORT tx_port_number, UNION_IP_PACKET *uptr_ip_packet,
	enum SNAP_PROTOCOL_ID protocol_type, UNION_ROUTING_CONTROL_FIELD **ptr_to_sptr_routing_control_field)
{
	/* put the routing control field in */

	*ptr_to_sptr_routing_control_field = (UNION_ROUTING_CONTROL_FIELD *) ((ULONG) uptr_ip_packet - sizeof (SNAP_HEADER) -
		sizeof (BYTE) - sizeof (ROUTING_CONTROL_FIELD));

	(*ptr_to_sptr_routing_control_field)->_ushort = 0x0000;

	(*ptr_to_sptr_routing_control_field)->_bit.length_of_routing_field = sizeof (ROUTING_CONTROL_FIELD);

	if (protocol_type == SNAP_IP_PACKET)
		{
		(*ptr_to_sptr_routing_control_field)->_bit.broadcast_indicators = SINGLE_ROUTE_BROADCAST;
		}
	else
		{
		(*ptr_to_sptr_routing_control_field)->_bit.broadcast_indicators = ALL_ROUTES_BROADCAST;
		}

	(*ptr_to_sptr_routing_control_field)->_bit.largest_frame = (BYTE) ip.port[tx_port_number].config.token_ring_largest_frame;
}
/*************************************************************************/
static void	put_the_length_of_the_rif_field_into_packet (UNION_ROUTING_CONTROL_FIELD *sptr_routing_control_field)
{
	/* put the length of the rif field in */

	*(BYTE *) ((ULONG) sptr_routing_control_field + sizeof (ROUTING_CONTROL_FIELD)) = sizeof (ROUTING_CONTROL_FIELD);
}
/*************************************************************************/

static void	build_snap_header (UNION_IP_PACKET *uptr_ip_packet, enum SNAP_PROTOCOL_ID protocol_type)
{
	SNAP_HEADER *sptr_snap_header;

	sptr_snap_header = (SNAP_HEADER *) ((ULONG) uptr_ip_packet - sizeof (SNAP_HEADER));

	sptr_snap_header->destination_address_DSAP = LSAP_SNAP_LLC;
	sptr_snap_header->source_address_SSAP = LSAP_SNAP_LLC;
	sptr_snap_header->llc_frame_type = UNNUMBERED_INFORMATION;

	sptr_snap_header->protocol_id_filler[0] = 0x00;
	sptr_snap_header->protocol_id_filler[1] = 0x00;
	sptr_snap_header->protocol_id_filler[2] = 0x00;

	sptr_snap_header->protocol_id = (USHORT_ENUM (SNAP_PROTOCOL_ID)) protocol_type;
}
#endif
/* Jo 24/04/99 */

static void	build_arp_packet (IP_PORT_CLASS *sptr_port, ARP_PACKET *sptr_arp_packet, enum BOOLEAN proxy_arp,
	ULONG sender_ip_address, ULONG tx_ip_address)
{
	if (sptr_port->config.lsl_packet_type == ETHERNET_TYPE_II)
		{
		sptr_arp_packet->header.hardware_type = ARP_HARDWARE_ETHERNET;
		}
	else
		{
		sptr_arp_packet->header.hardware_type = ARP_HARDWARE_IEEE_802_NETWORKS;
		}

	sptr_arp_packet->header.protocol = SNAP_IP_PACKET;
	sptr_arp_packet->header.hardware_address_length = sptr_port->hardware_address_length;
	sptr_arp_packet->header.protocol_address_length = IP_ADDRESS_LENGTH;
	sptr_arp_packet->header.operation_code = ARP_REQUEST;

	if (proxy_arp == TRUE)
		{
		sptr_arp_packet->header.sender_protocol_address = sender_ip_address;
		}
	else
		{
		sptr_arp_packet->header.sender_protocol_address = swap_long (sptr_port->config.ip_address);
		}

	sptr_arp_packet->header.sender_hardware_address = sptr_port->mac_address;

	sptr_arp_packet->header.target_hardware_address._ushort = 0x0000;
	sptr_arp_packet->header.target_hardware_address._ulong = 0x00000000L;

	sptr_arp_packet->header.target_protocol_address = swap_long (tx_ip_address);
}
/*************************************************************************/
MAC_ADDRESS *resolve_destination_ip_address_using_arp (UNION_IP_PACKET *sptr_tx_packet, USHORT tx_port_number,
	ULONG tx_ip_address, USHORT number_of_bytes)
{
	ARP_TABLE_ENTRY *sptr_arp_table_entry;
	MAC_ADDRESS *sptr_mac_address;

	sptr_mac_address = NULL;

	sptr_arp_table_entry = ip.arp.port[tx_port_number].sptr_cached_arp_entry;

	if ((sptr_arp_table_entry != NULL) && (sptr_arp_table_entry->ip_address == tx_ip_address))
		{
		++ip.arp.port[tx_port_number].number_of_times_cached_entry_was_used;
		}
	else
		{
	#ifdef __IP_DEBUG__
/*		ip_printf (ARP_PRINTF, "IP/ARP: checking table for %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], tx_ip_address)); */
	#endif /* __IP__DEBUG__ */

		sptr_arp_table_entry = find_arp_table_entry (tx_port_number, tx_ip_address, FALSE);
		}

	if (check_if_matching_arp_table_entry_is_found (sptr_arp_table_entry, tx_port_number, sptr_tx_packet) == TRUE)
		{
/* #ifdef __IP_DEBUG__ */
		ip_printf (ARP_PRINTF, "IP/ARP: entry for %s is found in table\n", &ip.print_buffer[0]);
/* #endif __IP__DEBUG__ */

		return (&sptr_arp_table_entry->hardware_address);
		}

#ifdef __IP_DEBUG__
	ip_printf (ARP_PRINTF, "IP/ARP: entry for %s is not found in table\n", &ip.print_buffer[0]);
#endif /* __IP__DEBUG__ */

	if (processing_when_arp_table_entry_is_not_found (sptr_arp_table_entry, tx_port_number, tx_ip_address, sptr_tx_packet,
		number_of_bytes) == PASS)
		{
		return (sptr_mac_address);
		}
printf("ARP: Keeping the packet in the queue.......\n");	

#ifdef __IP_DEBUG__
/* Jo	printf("ARP: Keeping the packet in the queue.......\n");	*/
#endif /* __IP__DEBUG__ */
	put_current_packet_on_waiting_to_send_queue_of_arp_table_entry (tx_port_number, number_of_bytes, sptr_arp_table_entry,
		sptr_tx_packet);

	return (sptr_mac_address);
}
/*************************************************************************/
static enum BOOLEAN check_if_matching_arp_table_entry_is_found (ARP_TABLE_ENTRY *sptr_arp_table_entry, USHORT tx_port_number,
	UNION_IP_PACKET *sptr_tx_packet)
{
	if ((sptr_arp_table_entry != NULL) && ((sptr_arp_table_entry->type == DYNAMIC_ARP_ENTRY) ||
		(sptr_arp_table_entry->type == STATIC_ARP_ENTRY)))
		{
		sptr_arp_table_entry->timer = 0x0000; 													/* restart timer */

#ifdef _BIG_PROXY_
		if ((ip.port[tx_port_number].config.token_ring == TRUE) && (ip.port[tx_port_number].config.rfc1042_enabled == TRUE))
			{
			if (sptr_arp_table_entry->use_rif == TRUE)
				{
				add_rif_to_token_ring_packet (sptr_tx_packet, sptr_arp_table_entry);
				}
			}
#endif
		ip.arp.port[tx_port_number].sptr_cached_arp_entry = sptr_arp_table_entry;

		return (TRUE);
		}

	return (FALSE);
}
/*************************************************************************/
static enum TEST processing_when_arp_table_entry_is_not_found (ARP_TABLE_ENTRY *sptr_arp_table_entry, USHORT tx_port_number,
	ULONG tx_ip_address, UNION_IP_PACKET *sptr_tx_packet, USHORT number_of_bytes)
{
	if (sptr_arp_table_entry == NULL)
		{
		if (send_arp_request_packet (tx_port_number, tx_ip_address, FALSE, 0x00000000L, (ULONG) NULL) == FAIL)
			{
			++ip.arp.statistics.total_number_of_pending_packets_discarded;

			return (PASS);
			}

		sptr_arp_table_entry = (ARP_TABLE_ENTRY *) add_entry_to_arp_table (tx_port_number, tx_ip_address,
			&sptr_tx_packet->arp.header.target_hardware_address, INVALID_ARP_ENTRY, sptr_tx_packet);

		if (sptr_arp_table_entry == NULL)
			{
			++ip.arp.statistics.total_number_of_pending_packets_discarded;

			return (PASS);
			}

		++ip.arp.port[tx_port_number].number_of_arp_table_entries_awaiting_reply;

/* Jo 23/04/99 */
	#if PRINT_IP_TABLE_INFO
		arp_print_table ();
	#endif /* __IP__DEBUG__ */

		put_current_packet_on_waiting_to_send_queue_of_arp_table_entry (tx_port_number, number_of_bytes, sptr_arp_table_entry,
			sptr_tx_packet);

		return (PASS);
		}

	return (FAIL);
}
/*************************************************************************/
static void	put_current_packet_on_waiting_to_send_queue_of_arp_table_entry (USHORT tx_port_number, USHORT number_of_bytes,
	ARP_TABLE_ENTRY *sptr_arp_table_entry, UNION_IP_PACKET *sptr_tx_packet)
{
	UNION_IP_PACKET *uptr_ip_packet;
	UNION_IP_PACKET_LIST_ELEMENT *sptr_ip_packet_list_element;

	uptr_ip_packet = (UNION_IP_PACKET *) get_an_ip_send_packet (tx_port_number, number_of_bytes);

	if (uptr_ip_packet != NULL)
		{
		memcpy (uptr_ip_packet, sptr_tx_packet, number_of_bytes);

		sptr_ip_packet_list_element = (UNION_IP_PACKET_LIST_ELEMENT *) table_malloc (1, sizeof (UNION_IP_PACKET_LIST_ELEMENT));

		if (sptr_ip_packet_list_element == NULL)
			{
			ip_printf (IP_ALARM_PRINTF, "ARP: table_malloc failed\n");

			return;
			}

		sptr_ip_packet_list_element->sptr_packet_waiting_to_send = uptr_ip_packet;
		sptr_ip_packet_list_element->number_of_bytes_to_send = number_of_bytes;

		add_entry_to_list ((LINK *) &sptr_arp_table_entry->list_of_packets_waiting_to_be_sent,
			(LINK *) sptr_ip_packet_list_element);
		}
}

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
static void print_txed_arp_header (ARP_HEADER *sptr_arp_header, USHORT port_number)
{
	char *ptr_to_string;

	if (ip.print_class.arp_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], net_to_host_long (sptr_arp_header->sender_protocol_address));

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], net_to_host_long (sptr_arp_header->target_protocol_address));

		ptr_to_string += sprintf (ptr_to_string, "IP/ARP: txed packet %x%x:%s --> %x%x:%s on port %u\n",
			net_to_host_long (sptr_arp_header->sender_hardware_address._ulong),
			net_to_host_short (sptr_arp_header->sender_hardware_address._ushort), &ip.print_buffer[0],
			net_to_host_long (sptr_arp_header->target_hardware_address._ulong),
			net_to_host_short (sptr_arp_header->target_hardware_address._ushort), ip.print_buffer_2,
			port_number);

		ptr_to_string += sprintf (ptr_to_string, "   header: type:%u,proto:%u,halen:%u,palen:%u,opcode:%u\n",
			sptr_arp_header->hardware_type,
			net_to_host_short (sptr_arp_header->protocol), (USHORT) sptr_arp_header->hardware_address_length,
			(USHORT) sptr_arp_header->protocol_address_length, net_to_host_short (sptr_arp_header->operation_code));

		ip_printf (ARP_PRINTF, &ip.string_to_print[0]);
		}
}
#endif
/* Jo 23/04/99 */
