#include "detip.h"
#include "kdetip.h"
#include "detipstr.h"

#include "..\..\store\boot.h"
#include <cnffile.h>
#include <flashmgr.h>

#define RECEIVE_FAILED 14

extern PROXY_SERVER_DISCOVERY_CLASS proxy_server_discovery;
extern mac_address[MAX_MAC_ADDRESS_LENGTH+1];
extern USHORT update_crc(USHORT accumulated_crc, BYTE *packet, ULONG packet_length);

PROXY_SERVER_DISCOVERY_RESPONSE_PACKET proxy_server_discovery_response_packet;

/* These functions are in TFTP directory */
extern int send_data_packet (ULONG destination_ip_address, int destination_port,
                   int socket, BYTE *info, ULONG length);
extern int receive_data(ULONG *source_ip_address, int *source_port, int socket,
                BYTE *packet, int *packet_length);

extern ULONG get_ip_address(USHORT);
extern ULONG net_to_host_long (ULONG);

/* Local Prototypes */
void send_response_for_proxy_server_discovery(void);
enum TEST set_proxy_server_ip_address(USHORT port_number, BYTE *ip_address);

extern void reset(void);
#ifdef SMALL_MEM_MAP
extern	BootBinIOPBType	BootBinIOPB;
#else
extern	BYTE	*DownloadFlag;
#endif

void proxy_server_discovery_timer(void)
{
	if ((proxy_server_discovery.enabled == FALSE) || (proxy_server_discovery.socket_interface_enabled == FALSE) 
			|| (proxy_server_discovery.socket_interface_initialized == FALSE))
	{
		return ;
	}
	
	send_response_for_proxy_server_discovery ();
}

void send_response_for_proxy_server_discovery(void)
{
	
	int packet_length, reboot_needed = 0, port_number = 0;
	ULONG index ;
	PROXY_SERVER_DISCOVERY_RESPONSE_PACKET rcvd_pkt ;
	BYTE *packet, *ptr_to_next;

	packet = (BYTE *) malloc ( MAX_PACKET_SIZE );
   if ( packet == NULL )
   {
	   printf("\n\rDETTIMER : packet malloc failed.");
      return;
   }

	if (receive_data ( &proxy_server_discovery.remote_internet_address, 
			&proxy_server_discovery.remote_port_number, proxy_server_discovery.socket,
			packet, &packet_length) != RECEIVE_FAILED )
	{
		proxy_server_discovery.remote_internet_address = INTERNET_ADDRESS_BROADCAST ;

		ptr_to_next = packet ;

		rcvd_pkt.pkt_type = *ptr_to_next ;

		ptr_to_next++;

		rcvd_pkt.ip_address = net_to_host_long (*(ULONG *)ptr_to_next);

		ptr_to_next+= sizeof (ULONG);

		memcpy(rcvd_pkt.mac_address, ptr_to_next, MAX_MAC_ADDRESS_LENGTH);
		rcvd_pkt.mac_address[MAX_MAC_ADDRESS_LENGTH] = '\0';  /* Jo */


		if ( rcvd_pkt.pkt_type == PROXY_SERVER_DISCOVERY_REQUEST ) 
		{
			memset( &proxy_server_discovery_response_packet, 0, sizeof (PROXY_SERVER_DISCOVERY_RESPONSE_PACKET));
		
			proxy_server_discovery_response_packet.pkt_type = PROXY_SERVER_DISCOVERY_RESPONSE ;
			proxy_server_discovery_response_packet.ip_address = get_ip_address(0);
			strcpy((char *)proxy_server_discovery_response_packet.mac_address, (char *)mac_address);
		
			send_data_packet ( proxy_server_discovery.remote_internet_address, 
							proxy_server_discovery.remote_port_number, proxy_server_discovery.socket,
							(BYTE *)&proxy_server_discovery_response_packet, sizeof ( PROXY_SERVER_DISCOVERY_RESPONSE_PACKET ));	
		}
		else if ( rcvd_pkt.pkt_type == PROXY_SERVER_CONFIGURE_IP_REQUEST )
		{
			if ( strcmp((char *)rcvd_pkt.mac_address,(char *)mac_address) == 0 )
			{
				if (set_proxy_server_ip_address ( port_number, (BYTE *)&rcvd_pkt.ip_address ) == PASS)
				{
					proxy_server_discovery_response_packet.pkt_type = PROXY_SERVER_CONFIGURE_IP_RESPONSE ;
					reboot_needed = 1;
				}
				
				proxy_server_discovery_response_packet.ip_address = get_ip_address(0);
				strcpy((char *)proxy_server_discovery_response_packet.mac_address,(char *)mac_address);

				send_data_packet ( proxy_server_discovery.remote_internet_address, 
					proxy_server_discovery.remote_port_number, proxy_server_discovery.socket,
						(BYTE *)&proxy_server_discovery_response_packet, sizeof ( PROXY_SERVER_DISCOVERY_RESPONSE_PACKET ));	

				if ( reboot_needed == 1 )
				{
					for(index = 0; index < 0xFFFF; index++); /* wait for some time */

					/* reboot proxy server for the new configured ip address to be 
					   reflected everywhere after waiting for some time. */
					
#ifdef SMALL_MEM_MAP
					BootBinIOPB.BootMode = WARM_BOOT_MODE;
#else
					*DownloadFlag = WARM_BOOT_MODE;
#endif
					reset();
				
				}
			}
		}
	}
  	if ( packet != NULL )
   {
  		free (packet) ;
     	packet = NULL ;
	}
}

enum TEST set_proxy_server_ip_address(USHORT port_number, BYTE *ip_address)
{
	int count = sizeof(ULONG);
	USHORT accumulated_crc = 0xFFFF ;
	HeaderType *sptr_dram_setup_header, *ptr_flash_setup_hdr = (HeaderType *)FL_CFG_HDR;
	BYTE *dest_addr = (BYTE *)ptr_flash_setup_hdr->DnLdAddr;
	int code_length = (BYTE *)ptr_flash_setup_hdr->CodeLength;

	CNF_IP *ip_ptr;

	ip_ptr = (CNF_IP *)dest_addr;
	c_write_to_AMD_flash((char *)ip_address, (char *)&ip_ptr->ip_ports[port_number].ip_address,count);

	accumulated_crc = update_crc (accumulated_crc, dest_addr, code_length) ;
	accumulated_crc = update_crc(accumulated_crc, "\x0\x0", 2) ;

	sptr_dram_setup_header = (BYTE *)FL_CFG_HDR;
	c_write_to_AMD_flash((char *)&accumulated_crc, (char *)&sptr_dram_setup_header->CRC, sizeof(USHORT));

	return (PASS);
}
