#include "dns.h"
#include "ip.h"
#include <string.h>
#include "kdns.h"
#include "vdnsstr.h"
#include "vdns.h"

void set_rtx_timeout (USHORT port_number);
/* Jo BYTE host_unknown[]= "\n\r\n\r\t\tHostname Unknown!!!\n\r"; */
extern int ip_addr_rcvd[MAX_WAN_PORTS];

void deinitialize_dns_port (USHORT port_number)
{
   dns.port[port_number].in_use = FALSE;
   dns.port[port_number].number_of_retries = 0;
   dns.port[port_number].current_timer_value = dns.config.min_timeout;
   dns.port[port_number].time_counter = 0;
   dns.port[port_number].dns_state = IDLE;
   dns.port[port_number].socket_num = 0;
   dns.port[port_number].server_ip_address = 0;
   dns.port[port_number].resolved_address = 0;
/* Naveen / Sudha 23 June 1998 Free the allocated block to store all ip addresses */
/* Sudha 20 July 1998 ->  if condition */
	if ( dns.port[port_number].dns_resolved_multi_ip_addr.ip_address &&
	   (dns.port[port_number].dns_resolved_multi_ip_addr.count > 0 ))
		free ( dns.port[port_number].dns_resolved_multi_ip_addr.ip_address);
   dns.port[port_number].dns_resolved_multi_ip_addr.count = 0;
   dns.port[port_number].number_of_references = 0;
   dns.port[port_number].fptr_complete_routine = NULL;
   query_info[port_number].num_of_referals = 0;
   query_info[port_number].index_of_ref_info = 0;

   if (!ip_addr_rcvd[port_number])
   	dns.no_of_connections--;

   if (pkt_to_send[port_number])
   {
   	if (pkt_to_send[port_number]->send_quest) {
   		free (pkt_to_send[port_number]->send_quest);
		pkt_to_send[port_number]->send_quest = NULL;
	}
   	free (pkt_to_send[port_number]);
	pkt_to_send[port_number] = NULL;
   }
}   

void remove_entry_from_cache (USHORT index)
{
   dns_cache[index].in_use = FALSE;
   if (dns_cache[index].resource_rec->re_name) {
	free (dns_cache[index].resource_rec->re_name);
	dns_cache[index].resource_rec->re_name = NULL;
   }
   if (dns_cache[index].resource_rec->re_rdata) {
	free (dns_cache[index].resource_rec->re_rdata);
	dns_cache[index].resource_rec->re_rdata = NULL;
   }
}

void send_request_and_wait_for_reply (USHORT port_number)
{
   if (send_query_to_the_address (port_number) == FAIL)
   {
      if (dns.port[port_number].number_of_retries >= dns.config.max_retransmissions)
      {
         printf("DNS: No reply\n");
         dns.port[port_number].dns_state = RESOLVE_ERR;
         dns.port[port_number].number_of_retries = 0;
         return ;
      }
      dns.port[port_number].number_of_retries++;
      return ;
   }
   dns.port[port_number].time_counter = dns.port[port_number].current_timer_value;
   dns.port[port_number].dns_state = READY_TO_RECV;
   return ;
}

void set_rtx_timer_and_send_again (USHORT port_number)
{
   if (dns.port[port_number].current_timer_value == dns.config.max_timeout)
   {
	dns.port[port_number].dns_state = RESOLVE_ERR;
	printf("DNS: Timeout");
	return;
    }
    set_rtx_timeout (port_number);
    query_info[port_number].num_of_referals = 0;
    return;
}

void recv_response_and_process (USHORT port_number)
{
   USHORT ret=0;
   BYTE *rcv_buf;
   SOCKADDR_IN rem_addr;
   int addrlen = sizeof (SOCKADDR_IN);


   rcv_buf = malloc (MAX_SIZE_OF_DNS_PKT);
   if (rcv_buf == NULL)
      return;

   ret = recvfrom (dns.port[port_number].socket_num, rcv_buf, MAX_SIZE_OF_DNS_PKT, 0, (SOCKADDR *) &rem_addr, &addrlen);
            
   if (ret > 0 && ret <= MAX_SIZE_OF_DNS_PKT)
   {
/*	sudhir, 30th April 1997 */
      dns.port[port_number].rcvd_buff_len = ret;
      dns.port[port_number].current_timer_value = dns.config.min_timeout;
      dns.port[port_number].resolved_address = net_to_host_long(received_dns_packet (rcv_buf, ret, port_number));
   }
/* Jo 20/05/99 Added this Taken from Big Proxy */
	else
	{
		if (dns.port[port_number].number_of_retries >= dns.config.max_retransmissions)
	   {
   	   printf("DNS: No DNS packet received\n");
      	dns.port[port_number].dns_state = RESOLVE_ERR;
	      dns.port[port_number].number_of_retries = 0;
	   }
		else
   		dns.port[port_number].number_of_retries++;
	}
/* Jo 20/05/99 Added this Taken from Big Proxy */
   free (rcv_buf);
   return;
}

void pass_the_ip_address_to_application(USHORT port_number)
{
   if (dns.port[port_number].fptr_complete_routine != NULL)
   {
      dns.port[port_number].fptr_complete_routine 
			(dns.port[port_number].dns_resolved_multi_ip_addr.ip_address, 
			 dns.port[port_number].dns_resolved_multi_ip_addr.count,
			 port_number, RESOLVED);
/* Jo      dns.port[port_number].fptr_complete_routine (dns.port[port_number].resolved_address, port_number, RESOLVED);*/
   }
   dns.port[port_number].dns_state = IDLE;
   if (!ip_addr_rcvd[port_number])
   {
      closesocket (dns.port[port_number].socket_num);
   }
   deinitialize_dns_port (port_number);
   return;
}

void send_error_message_to_application (USHORT port_number)
{
/* Jo   dns.port[port_number].fptr_complete_routine (dns.port[port_number].resolved_address, port_number, RESOLVE_ERR); */
   dns.port[port_number].fptr_complete_routine 
	(dns.port[port_number].dns_resolved_multi_ip_addr.ip_address, 
	 dns.port[port_number].dns_resolved_multi_ip_addr.count,
	 port_number, RESOLVE_ERR);

   if (!ip_addr_rcvd[port_number])
   {
   	closesocket (dns.port[port_number].socket_num);
   }
   deinitialize_dns_port (port_number);
   dns.port[port_number].dns_state = IDLE;
}

/* dns_timer is dns timer routine */
void dns_timer ()
{
   USHORT i=0;
         

   if (dns.enabled == FALSE)
      return;
      
   for (i = 0; i < MAX_WAN_PORTS; i++)
   {
      switch (dns.port[i].dns_state)
      {
         case READY_TO_SEND:
/* sudhir, 30th April 1997 */
            dns.port[i].rcvd_buff_len = 0;
            dns.port[i].rcvd_buff_index = 0;
                  
            if (query_info[i].num_of_referals <=query_info[i].no_of_ns)
               send_request_and_wait_for_reply (i);
            else
               set_rtx_timer_and_send_again (i);

            break;         

         case READY_TO_RECV:
            dns.port[i].time_counter--;
            if (dns.port[i].time_counter == 0)
            {
               query_info[i].index_of_ref_info++;
               dns.port[i].time_counter = dns.port[i].current_timer_value ;
               dns.port[i].dns_state = READY_TO_SEND;
               dns.port[i].server_ip_address = 0;
               break;
            }
            recv_response_and_process (i);
            break;

         case WAITING_FOR_IP_ADDR:
            break;

         case RESOLVED:
/*	sudhir, 30th April 1997 */
            dns.port[i].rcvd_buff_len = 0;
            dns.port[i].rcvd_buff_index = 0;

            pass_the_ip_address_to_application(i);   
             break;

         case RESOLVE_ERR:
/* sudhir, 30th April 1997 */
            dns.port[i].rcvd_buff_len = 0;
            dns.port[i].rcvd_buff_index = 0;

            send_error_message_to_application (i);
            break;

         case IDLE:
            break;

      }
   }

   for (i = 0; i < MAX_NUMBER_OF_CACHE; i++)
   {
      if (dns_cache[i].in_use == FALSE)
         continue;

      if (dns_cache[i].resource_rec->re_ttl == 0)
         remove_entry_from_cache (i);
      dns_cache[i].resource_rec->re_ttl--;
   }
   return;  
}

void set_rtx_timeout (USHORT port_number)
{
   dns.port[port_number].current_timer_value =  dns.port[port_number].current_timer_value << 1;
   if (dns.port[port_number].current_timer_value > dns.config.max_timeout)
      dns.port[port_number].current_timer_value = dns.config.max_timeout;                                             

   dns.port[port_number].time_counter = dns.port[port_number].current_timer_value;
}
