#include	"defs.h"
/*
 * $Log: /IP/ICMPPRNT.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: icmpprnt.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	"ip.h"
/****************************************************************************/
static void	print_icmp_echo_message_header (ICMP_HEADER *sptr_icmp_header);
static void	print_icmp_unreachable_message_header (ICMP_HEADER *sptr_icmp_header);
static void	print_icmp_redirect_message_header (ICMP_HEADER *sptr_icmp_header);
static void	print_icmp_time_exceeded_message_header (ICMP_HEADER *sptr_icmp_header);
static void	print_icmp_source_quench_or_parameter_problem_message_header (ICMP_HEADER *sptr_icmp_header);
static void	print_icmp_timestamp_message_header (ICMP_HEADER *sptr_icmp_header);
static void print_icmp_information_message_header (ICMP_HEADER *sptr_icmp_header);
static void	print_icmp_address_mask_message_header (ICMP_HEADER *sptr_icmp_header);
/****************************************************************************/

#ifdef _BIG_PROXY_
void print_icmp_header (ICMP_HEADER *sptr_icmp_header)
{
	if (ip.print_class.icmp_printing_enabled == TRUE)
		{
		switch (sptr_icmp_header->type)
			{
			case ICMP_ECHO_REQUEST_TYPE:
			case ICMP_ECHO_REPLY_TYPE:

				print_icmp_echo_message_header (sptr_icmp_header);

				break;

			case ICMP_DESTINATION_UNREACHABLE_TYPE:

				print_icmp_unreachable_message_header (sptr_icmp_header);

				break;

			case ICMP_REDIRECT_TYPE:

				print_icmp_redirect_message_header (sptr_icmp_header);

				break;

			case ICMP_TIME_EXCEEDED_TYPE:

				print_icmp_time_exceeded_message_header (sptr_icmp_header);

				break;

			case ICMP_SOURCE_QUENCH_TYPE:
			case ICMP_PARAMETER_PROBLEM_TYPE:

				print_icmp_source_quench_or_parameter_problem_message_header (sptr_icmp_header);

				break;

			case ICMP_TIMESTAMP_TYPE:
			case ICMP_TIMESTAMP_REPLY_TYPE:

				print_icmp_timestamp_message_header (sptr_icmp_header);

				break;

			case ICMP_INFO_REQUEST_TYPE:
			case ICMP_INFO_REPLY_TYPE:

				print_icmp_information_message_header (sptr_icmp_header);

				break;

			case ICMP_ADDRESS_MASK_TYPE:
			case ICMP_ADDR_MASK_REPLY_TYPE:

				print_icmp_address_mask_message_header (sptr_icmp_header);

				break;

			default:

				break;
			}
		}
}
/****************************************************************************/
static void	print_icmp_echo_message_header (ICMP_HEADER *sptr_icmp_header)
{
	switch (sptr_icmp_header->type)
		{
		case ICMP_ECHO_REQUEST_TYPE:

			ip_printf (ICMP_PRINTF, "ICMP: header: ECHO REQUEST, %u, %x, %u, %u\n", sptr_icmp_header->code.generic,
				sptr_icmp_header->checksum, net_to_host_short (sptr_icmp_header->option.echo_message.identifier),
				net_to_host_short (sptr_icmp_header->option.echo_message.sequence_number)); 

			break;

		case ICMP_ECHO_REPLY_TYPE:

			ip_printf (ICMP_PRINTF, "ICMP: header: ECHO REPLY, %u, %x, %u, %u\n", sptr_icmp_header->code.generic,
				sptr_icmp_header->checksum, net_to_host_short (sptr_icmp_header->option.echo_message.identifier),
				net_to_host_short (sptr_icmp_header->option.echo_message.sequence_number)); 

			break;

		default:

			break;
		}
}
/****************************************************************************/
static void	print_icmp_unreachable_message_header (ICMP_HEADER *sptr_icmp_header)
{
	switch (sptr_icmp_header->code.generic)
		{
		case ICMP_NET_UNREACHABLE_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:DESTINATION UNREACHABLE, code:NET UNREACHABLE, %x\n",
				sptr_icmp_header->checksum);

			break;

		case ICMP_HOST_UNREACHABLE_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:DESTINATION UNREACHABLE, code:HOST UNREACHABLE, %x\n",
				sptr_icmp_header->checksum);

			break;

		case ICMP_PROTOCOL_UNREACHABLE_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:DESTINATION UNREACHABLE, code:PROTOCOL UNREACHABLE, %x\n",
				sptr_icmp_header->checksum);

			break;

		case ICMP_PORT_UNREACHABLE_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:DESTINATION UNREACHABLE, code:PORT UNREACHABLE, %x\n",
				sptr_icmp_header->checksum);

			break;

		case ICMP_FRAGMENT_NEEDED_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:DESTINATION UNREACHABLE, code:FRAGMENTATION NEEDED AND DF SET, %x\n",
				sptr_icmp_header->checksum);

			break;

		case ICMP_ROUTE_FAIL_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:DESTINATION UNREACHABLE, code:SOURCE ROUTE FAILED, %x\n",
				sptr_icmp_header->checksum);

			break;

		case ICMP_ADMIN_PROHIBIT_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:DESTINATION UNREACHABLE, code:ADMINISTRATIVELY PROHIBITED, %x\n",
				sptr_icmp_header->checksum);

			break;

		default:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:DESTINATION UNREACHABLE, code:UNRECOGNIZED CODE, %x\n",
				sptr_icmp_header->checksum);

			break;
		}
}
/****************************************************************************/
static void	print_icmp_redirect_message_header (ICMP_HEADER *sptr_icmp_header)
{
	ULONG gateway;

	gateway = net_to_host_long (sptr_icmp_header->option.redirect_message.gateway);

	convert_ip_address_to_dot_format (&ip.print_buffer[0], gateway);

	switch (sptr_icmp_header->code.generic)
		{
		case ICMP_REDIRECT_NET_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:REDIRECT, code:REDIRECT FOR NET, %x, %s\n",
				sptr_icmp_header->checksum, &ip.print_buffer[0]);

			break;

		case ICMP_REDIRECT_HOST_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:REDIRECT, code:REDIRECT FOR HOST, %x, %s\n",
				sptr_icmp_header->checksum, &ip.print_buffer[0]);

			break;

		case ICMP_REDIRECT_TOS_AND_NET_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:REDIRECT, code:REDIRECT TYPE OF SERVICE AND NET, %x, %s\n",
				sptr_icmp_header->checksum, &ip.print_buffer[0]);

			break;

		case ICMP_REDIRECT_TOS_AND_HOST_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:REDIRECT, code:REDIRECT TYPE OF SERVICE AND HOST, %x, %s\n",
				sptr_icmp_header->checksum, &ip.print_buffer[0]);

			break;

		default:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:REDIRECT, code:UNRECOGNIZED CODE, %x, %s\n",
				sptr_icmp_header->checksum, &ip.print_buffer[0]);

			break;
		}
}
/****************************************************************************/
static void	print_icmp_time_exceeded_message_header (ICMP_HEADER *sptr_icmp_header)
{
	switch (sptr_icmp_header->code.generic)
		{
		case ICMP_TTL_EXCEEDED_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:TIME EXCEEDED, code:TTL-TO-LIVE COUNT EXCEEDED, %x\n",
				sptr_icmp_header->checksum);

			break;

		case ICMP_FRAGMENT_EXCEEDED_CODE:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:TIME EXCEEDED, code:FRAGMENT REASSEMBLY TIME EXCEEDED, %x\n",
				sptr_icmp_header->checksum);

			break;

		default:

			ip_printf (ICMP_PRINTF, "ICMP: header: type:TIME EXCEEDED, code:UNRECOGNIZED CODE, %x\n",
				sptr_icmp_header->checksum);

			break;
		}
}
/****************************************************************************/
static void	print_icmp_source_quench_or_parameter_problem_message_header (ICMP_HEADER *sptr_icmp_header)
{
	switch (sptr_icmp_header->type)
		{
		case ICMP_SOURCE_QUENCH_TYPE:

			ip_printf (ICMP_PRINTF, "ICMP: header: SOURCE QUENCH, %u, %x\n", sptr_icmp_header->code.generic,
				sptr_icmp_header->checksum);

			break;

		case ICMP_PARAMETER_PROBLEM_TYPE:

			ip_printf (ICMP_PRINTF, "ICMP: header: PARAMETER PROBLEM, %u, %x, %u\n", sptr_icmp_header->code.generic,
				sptr_icmp_header->checksum, sptr_icmp_header->option.parameter_problem_message.pointer);

			break;

		default:

			break;
		}
}
/****************************************************************************/
static void	print_icmp_timestamp_message_header (ICMP_HEADER *sptr_icmp_header)
{
	switch (sptr_icmp_header->type)
		{
		case ICMP_TIMESTAMP_TYPE:

			ip_printf (ICMP_PRINTF, "ICMP: header: TIMESTAMP REQUEST, %u, %x, %u, %u, %u, %u, %u\n", sptr_icmp_header->code.generic,
				sptr_icmp_header->checksum, net_to_host_short (sptr_icmp_header->option.timestamp_message.identifier),
				net_to_host_short (sptr_icmp_header->option.timestamp_message.sequence_number),
				net_to_host_long (sptr_icmp_header->option.timestamp_message.orginate_timestamp),
				net_to_host_long (sptr_icmp_header->option.timestamp_message.receive_timestamp),
				net_to_host_long (sptr_icmp_header->option.timestamp_message.transmit_timestamp));

			break;

		case ICMP_TIMESTAMP_REPLY_TYPE:

			ip_printf (ICMP_PRINTF, "ICMP: header: TIMESTAMP REPLY, %u, %x, %u, %u, %u, %u, %u\n", sptr_icmp_header->code.generic,
				sptr_icmp_header->checksum, net_to_host_short (sptr_icmp_header->option.timestamp_message.identifier),
				net_to_host_short (sptr_icmp_header->option.timestamp_message.sequence_number),
				net_to_host_long (sptr_icmp_header->option.timestamp_message.orginate_timestamp),
				net_to_host_long (sptr_icmp_header->option.timestamp_message.receive_timestamp),
				net_to_host_long (sptr_icmp_header->option.timestamp_message.transmit_timestamp));

			break;

		default:

			break;
		}
}
/****************************************************************************/
static void print_icmp_information_message_header (ICMP_HEADER *sptr_icmp_header)
{
	switch (sptr_icmp_header->type)
		{
		case ICMP_INFO_REQUEST_TYPE:

			ip_printf (ICMP_PRINTF, "ICMP: header: INFORMATION REQUEST, %u, %x\n", sptr_icmp_header->code.generic,
				sptr_icmp_header->checksum);

			break;

		case ICMP_INFO_REPLY_TYPE:

			ip_printf (ICMP_PRINTF, "ICMP: header: INFORMATION REPLY, %u, %x\n", sptr_icmp_header->code.generic,
				sptr_icmp_header->checksum);

			break;

		default:

			break;
		}
}
/****************************************************************************/
static void	print_icmp_address_mask_message_header (ICMP_HEADER *sptr_icmp_header)
{
	ULONG address_mask;

	address_mask = net_to_host_long (sptr_icmp_header->option.address_mask_message.mask);

	convert_ip_address_to_dot_format (&ip.print_buffer[0], address_mask);

	switch (sptr_icmp_header->type)
		{
		case ICMP_ADDRESS_MASK_TYPE:

			ip_printf (ICMP_PRINTF, "ICMP: header: ADDRESS MASK, %u, %x, %u, %u, %s\n", sptr_icmp_header->code.generic,
				sptr_icmp_header->checksum, net_to_host_short (sptr_icmp_header->option.address_mask_message.identifier),
				net_to_host_short (sptr_icmp_header->option.address_mask_message.sequence_number), &ip.print_buffer[0]);

			break;

		case ICMP_ADDR_MASK_REPLY_TYPE:

			ip_printf (ICMP_PRINTF, "ICMP: header: ADDRESS MASK REPLY, %u, %x, %u, %u, %s\n", sptr_icmp_header->code.generic,
				sptr_icmp_header->checksum, net_to_host_short (sptr_icmp_header->option.address_mask_message.identifier),
				net_to_host_short (sptr_icmp_header->option.address_mask_message.sequence_number), &ip.print_buffer[0]);

			break;

		default:

			break;
		}
}
#endif
