/*	$Modname: ipadrtab.c$  $version: 1.4$		 $date: 06/29/95$	  */
/*
* 	$lgb$
1.0 12/27/94 ross
1.1 12/27/94 ross added copyright.
1.2 01/17/95 ross fixed arp problems from snmp
1.3 01/26/95 ross SNMP name change, printf change.
1.4 06/29/95 ross new snmp access routine
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<stddef.h>
#include	<stdlib.h>
#include "defs.h"
#include "ip.h"
#include	<visnpstr.h>
#include <v8022str.h>
/**********************************************************************************/
/* Jo 23/04/99 */
#if 0
static void	add_address_entry_to_sorted_list (IP_ADDRESS_ENTRY *sptr_address_entry);
static enum BOOLEAN get_ip_mib_table_indices (BYTE *bptr_table_indices, USHORT *usptr_number_of_bytes_in_table_indices,
	enum BOOLEAN *eptr_received_indices, ULONG *ulptr_ipadentaddr);
static IP_ADDRESS_ENTRY *ip_calculate_pointer_to_next_row_in_mib_table (IP_ADDRESS_ENTRY *sptr_address_entry);
#endif

#if 0
enum TEST ip_apply_mib_operation_on_current_instance_of_mib_variable (void *vptr_row_in_table,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	USHORT arg_not_used;

	arg_not_used = 0x0000;

	if ((sptr_snmp_table_entry->fptr_mib_access_function) (arg_not_used,
		sptr_mib_access_parameters->mib_operation, sptr_snmp_table_entry->offset_of_mib_variable,
		(ULONG) vptr_row_in_table, (ULONG) arg_not_used, sptr_mib_access_parameters->bptr_variable_value,
		sptr_mib_access_parameters->usptr_size_of_variable_value) == FAIL)
		{
		return (FAIL);
		}

	*(sptr_mib_access_parameters->usptr_size_of_variable_value) = sptr_snmp_table_entry->size_of_mib_variable;

	return (PASS);
}

/**********************************************************************************/
enum BOOLEAN check_if_ip_mib_table_exists (void)
{
	IP_ADDRESS_ENTRY *sptr_address_entry;

	sptr_address_entry = (IP_ADDRESS_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.address_list);

	if (sptr_address_entry != NULL)
		{
		return (TRUE);
		}

	return (FALSE);
}
#endif

/**********************************************************************************/
#ifdef _BIG_PROXY_
void create_ip_mib_table_sorted_on_indices (void)
{
	USHORT interface_index;
	IP_ADDRESS_ENTRY *sptr_address_entry;

	for (interface_index = 0x0000; interface_index < ip.number_of_ports; ++interface_index)
		{
		sptr_address_entry = (IP_ADDRESS_ENTRY *) table_malloc (1, sizeof (IP_ADDRESS_ENTRY));

		if (sptr_address_entry == NULL)
			{
			ip_printf (IP_ALARM_PRINTF, "IP: create_ip_mib_table_sorted_on_indices (): table_malloc failed\n");
			}

		sptr_address_entry->ulptr_to_ipAdEntAddr = ip.port[interface_index].config.ip_address;
		sptr_address_entry->usptr_to_ipAdEntIfIndex = (USHORT) (interface_index + 1);
		sptr_address_entry->ulptr_to_ipAdEntNetMask = ip.port[interface_index].netmask;
		sptr_address_entry->ulptr_to_ipAdEntBcastAddr = ip.port[interface_index].net_broadcast_address;
		sptr_address_entry->usptr_to_ipAdEntReasmMaxSize = ip.port[interface_index].config.mtu;

		add_address_entry_to_sorted_list (sptr_address_entry);
		}
}
/**********************************************************************************/
static void	add_address_entry_to_sorted_list (IP_ADDRESS_ENTRY *sptr_address_entry)
{
	LINKED_LIST_SORT_PARAMETERS linked_list_sort_parameters;

	linked_list_sort_parameters.sptr_list = (LINK *) &ip.address_list;
	linked_list_sort_parameters.sptr_entry_to_add = (LINK *) sptr_address_entry;

	linked_list_sort_parameters.index[0].offset = offsetof (IP_ADDRESS_ENTRY, ulptr_to_ipAdEntAddr);
	linked_list_sort_parameters.index[0].size = sizeof (ULONG);
	linked_list_sort_parameters.index[0]._swap = TRUE;

	linked_list_sort_parameters.index[1].size = 0x0000;

	add_entry_to_sorted_linked_list (&linked_list_sort_parameters);
}
/**********************************************************************************/
enum TEST find_pointer_to_row_in_ip_mib_table (SNMP_TABLE_ENTRY *sptr_snmp_table_entry,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,	void **ptr_to_vptr_row_in_table)
{
	enum BOOLEAN received_indices;
	ULONG ipadentaddr;
	enum BOOLEAN valid_table_indices;
	IP_ADDRESS_ENTRY *sptr_address_entry;

	PARAMETER_NOT_USED (sptr_snmp_table_entry);

	valid_table_indices = get_ip_mib_table_indices (sptr_mib_access_parameters->bptr_table_indices,
		sptr_mib_access_parameters->usptr_size_of_table_indices, &received_indices, &ipadentaddr);

	if (valid_table_indices == FALSE)
		{
		return (FAIL);
		}

	*ptr_to_vptr_row_in_table = NULL;

	if (received_indices == FALSE)
		{
		/* no indices have been received, so we will be accessing first instance of mib variable */

		*ptr_to_vptr_row_in_table = (void *)
			ip_calculate_pointer_to_next_row_in_mib_table ((IP_ADDRESS_ENTRY *) *ptr_to_vptr_row_in_table);

		if (*ptr_to_vptr_row_in_table == NULL)
			{
			return (FAIL);
			}

		return (PASS);
		}
	else
		{
		sptr_address_entry = ip_calculate_pointer_to_next_row_in_mib_table ((IP_ADDRESS_ENTRY *) *ptr_to_vptr_row_in_table);

		while (sptr_address_entry != NULL)
			{
			if (sptr_address_entry->ulptr_to_ipAdEntAddr == ipadentaddr)
				{
				*ptr_to_vptr_row_in_table = (void *) ip_calculate_pointer_to_next_row_in_mib_table (sptr_address_entry);

				if (*ptr_to_vptr_row_in_table == NULL)
					{
					ip_printf (IP_PRINTF, "IP: ADRTAB: SNMP: Pointer to next row is NULL\n");

					return (FAIL);
					}

				return (PASS);
				}

			sptr_address_entry = ip_calculate_pointer_to_next_row_in_mib_table (sptr_address_entry);
			}

		ip_printf (IP_PRINTF, "IP: ADRTAB: SNMP: No more rows in table\n");

		return (FAIL);
		}
}
/**********************************************************************************/
static enum BOOLEAN get_ip_mib_table_indices (BYTE *bptr_table_indices, USHORT *usptr_number_of_bytes_in_table_indices,
	enum BOOLEAN *eptr_received_indices, ULONG *ulptr_ipadentaddr)
{
	enum BOOLEAN valid_table_indices;

	valid_table_indices = TRUE;

	*eptr_received_indices = TRUE;

	if (*usptr_number_of_bytes_in_table_indices == 0x0000)
		{
		ip_printf (IP_PRINTF, "IP: ADRTAB: SNMP: No indices received\n");

		*eptr_received_indices = FALSE;
		}
	else if (*usptr_number_of_bytes_in_table_indices == sizeof (ULONG))
		{
		*ulptr_ipadentaddr = *((ULONG *) bptr_table_indices);

		ip_printf (IP_PRINTF, "IP: ADRTAB: SNMP: Value of ipadentaddr is %x\n", *ulptr_ipadentaddr);

		*ulptr_ipadentaddr = swap_long (*ulptr_ipadentaddr);

		ip_printf (IP_PRINTF, "IP: ADRTAB: SNMP: Value of ipadentaddr is %x\n", *ulptr_ipadentaddr);
		}
	else
		{
		return (FALSE);
		}

	return (valid_table_indices);
}
/**********************************************************************************/
static IP_ADDRESS_ENTRY *ip_calculate_pointer_to_next_row_in_mib_table (IP_ADDRESS_ENTRY *sptr_address_entry)
{
	IP_ADDRESS_ENTRY *sptr_address_entry_new;

	if (sptr_address_entry == NULL)
		{
		/* we must be accessing the first instance of the variable */

		sptr_address_entry_new = (IP_ADDRESS_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.address_list);
		}
	else
		{
		sptr_address_entry_new = (IP_ADDRESS_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_address_entry);
		}

	return (sptr_address_entry_new);
}
/**********************************************************************************/
enum TEST build_ip_table_indices_for_current_instance_of_mib_variable (void *vptr_row_in_table,
	BYTE *bptr_table_indices, USHORT *usptr_number_of_bytes_in_table_indices)
{
	*((ULONG *) bptr_table_indices) = swap_long (((IP_ADDRESS_ENTRY *) vptr_row_in_table)->ulptr_to_ipAdEntAddr);

	*usptr_number_of_bytes_in_table_indices = sizeof (ULONG);

	return (PASS);
}
#endif
