#include	"defs.h"
/*
 * $Log: /IP/IPBUF.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipbuf.c$  $version: 1.13$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/15/94 yarran Add trace buffer to debug transport buffer leaking problem.
1.4 02/22/94 yarran Fix i960 compiler error for header.vptr_data casting
1.5 02/22/94 yarran Add declaration for ptr_data.
1.6 03/01/94 yarran Style changes.
1.7 03/04/94 yarran Add udp_user_get_buffer().
1.8 03/07/94 yarran Fix bug in free_buffer().
1.9 03/10/94 yarran Add IP: heading for printf.
1.10 05/02/94 yarran added rfc1042 changes.
1.11 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.12 01/26/95 ross SNMP name change, printf change.
1.13 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include <stdlib.h>
#include "ip.h"
/****************************************************************************/
enum BOOLEAN memory_is_low (void)
{
	/* TBD */

	return (FALSE);
}
/****************************************************************************/
IP_LIST_PACKET *get_ip_list_packet (USHORT packet_size)
{
	IP_LIST_PACKET *sptr_ip_list_packet;
	USHORT size_of_buffer;
	 
	size_of_buffer = (USHORT) (packet_size + sizeof (LIST_HEADER) + sizeof (UNION_MAC_HEADER));

	sptr_ip_list_packet = (IP_LIST_PACKET *) buffer_malloc (size_of_buffer);

	if (sptr_ip_list_packet == NULL)
		{
#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
		++ip.statistics.number_of_times_out_of_memory_while_allocating_ip_packet;
#endif /* Jo 26/05/99 */

		ip_printf (IP_ALARM_PRINTF, "IP: buffer_malloc () failed\n");

		return (NULL);
		}

	sptr_ip_list_packet->header.vptr_data = &sptr_ip_list_packet->type;
	sptr_ip_list_packet->header.number_of_bytes = size_of_buffer;
	sptr_ip_list_packet->header.byte_count = (USHORT) (packet_size + sizeof (UNION_MAC_HEADER));
	sptr_ip_list_packet->header.links.sptr_forward_link = (LIST_HEADER *) NULL;
	sptr_ip_list_packet->header.links.sptr_backward_link = (LIST_HEADER *) NULL;

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
	++ip.statistics.total_transport_buffers_allocated;
	++ip.statistics.outstanding_transport_ip_list_packets;
#endif /* Jo 26/05/99 */

	ip_printf (IP_MEMORY_PRINTF, "IP: allocated ip list packet: %p, bytes:%u\n", sptr_ip_list_packet, size_of_buffer);

	return (sptr_ip_list_packet);
}
/****************************************************************************/
void free_ip_list_packet (IP_LIST_PACKET *sptr_ip_list_packet)
{
	IP_LIST_PACKET *sptr_next_ip_list_packet;

	ip_printf (IP_MEMORY_PRINTF, "IP: free_ip_list_packet called with: %p\n", sptr_ip_list_packet);

	while (sptr_ip_list_packet != NULL)
	{
		sptr_next_ip_list_packet = (IP_LIST_PACKET *) sptr_ip_list_packet->header.links.sptr_forward_link;
		ip_printf (IP_MEMORY_PRINTF, "IP: freeing buffer at %08lx\r\n", (ULONG) sptr_ip_list_packet);
		buffer_free ((void *) sptr_ip_list_packet);
		sptr_ip_list_packet = sptr_next_ip_list_packet;
	}
}
/****************************************************************************/
IP_LIST_PACKET *copy_ip_list_packet (USHORT ip_list_packet_size, USHORT header_length, USHORT data_size_to_copy,
	BYTE *bptr_packet_to_copy_from)
{
	IP_LIST_PACKET *sptr_ip_list_packet;
	USHORT bytes_to_be_copied;

	sptr_ip_list_packet = get_ip_list_packet (ip_list_packet_size);

	if (sptr_ip_list_packet != NULL)
	{
		bytes_to_be_copied = (USHORT) (data_size_to_copy + sizeof (UNION_MAC_HEADER));
 		memcpy ((void *) sptr_ip_list_packet->header.vptr_data, (void *) bptr_packet_to_copy_from, bytes_to_be_copied);

/*	Jo	ip_printf (IP_PRINTF, "IP: copied fragment to ip list packet: %p, bytes:%u\n", sptr_ip_list_packet->header.vptr_data,
			bytes_to_be_copied); */

		sptr_ip_list_packet->header.vptr_data = (void *) ((ULONG) sptr_ip_list_packet->header.vptr_data + header_length +
			sizeof (UNION_MAC_HEADER));
 		sptr_ip_list_packet->header.byte_count = (USHORT) (data_size_to_copy - header_length);
 	}
 	return (sptr_ip_list_packet);
}
