#include	"defs.h"

/*
 * $Log: /IP/IPCTRL.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipctrl.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/

/* 
History of Changes :
		{Jo, 11 Oct 1999, Added for Monitoring Program}
*/

/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include "ip.h"
/* Jo 29/06/99 Added from Jessi */
#include <wanmgr.h> /* sudha 18 May 1999 */
#include "\rtrware\rwutils\event.h"  /* Added by Subbi On 05 Oct 1999 */
#include "\rtrware\rwutils\evnt.h"  /* Added by Subbi On 05 Oct 1999 */
#include "\rtrware\rwutils\evntstr.h"  /* Added by Subbi On 05 Oct 1999 */

/*************************************************************************/

ULONG get_local_ip_address (USHORT) ;


static enum TEST shut_down_ip_router (void);
/* Third parameter for local IP address : Sachin and Sudhir */
static void bring_up_port (USHORT port_number, ULONG remote_point_to_point_link_ip_address, ULONG local_ip_address);
static void shut_down_port (USHORT port_number);
static void	turn_on_appropriate_print_flags (void);

#ifndef __LSL__
static void call_control_routines_of_other_transport_protocols (enum TRANSPORT_CONTROL_OPERATION command, ULONG parameter_0,
	ULONG parameter_1);
#endif /* __LSL__ */

static enum TEST reinitialize_ip (void);
extern BYTE is_dialing_initiated_by_this_end (USHORT port_number);
extern BYTE is_remote_access_client_active (USHORT port_number);

#ifdef __IP_BREAKPOINT__
static void check_for_ip_shutdown_breakpoint (void);
#endif /* __IP_BREAKPOINT__ */

extern event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet);/* Added by Subbi on 05 Oct 1999 */
extern ULONG get_ip_address(USHORT port_number);/* Added by Subbi on 05 Oct 1999 */

/*************************************************************************/
enum TEST ip_control (enum PROTOCOL_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1, ULONG parameter_2)
{
	ULONG parameter_3 ;

	switch (command)
		{
		case PROTOCOL_STACK_ROUTERWARE_CONTROL:

#if defined (_MSC_VER)
			*((ULONG *) parameter_1) = routerware_control (parameter_0, parameter_1);
#endif

			break;

		case OPEN_PROTOCOL_STACK:

			break;

#ifdef _BIG_PROXY_
		case CLOSE_PROTOCOL_STACK:

			if (shut_down_ip_router () == FAIL)
				{
				return (FAIL);
				}

			break;
		case REINITIALIZE_PROTOCOL_STACK:

			if (reinitialize_ip () == FAIL)
				{
				return (FAIL);
				}

			break;
#endif

		case OPEN_VIRTUAL_PORT:
			if (parameter_0)
         {
				parameter_3 = get_local_ip_address (parameter_0 - 1) ;

            /*
            This is to free up all the dsescriptors allocated
            for this port earlier. In case of DOD, IP is not notified
            of the port going down. But we DO notify about the port coming
            up because the IP address (local and remote) may change
            depending on how the RAS chooses to give the address.
            */
            ip_port_down (parameter_0) ;
         }

			if (is_remote_access_client_active(((USHORT)parameter_0)-1) == FALSE)
			{
				ip.port[(USHORT)parameter_0].routing_status = PROXY_PORT;
				ip.port[(USHORT)parameter_0].config.remote_access_enabled = FALSE;
				printf ("IPPROX : Setting Port for Proxy %d\n",(USHORT)parameter_0); 
			}
			else
			{
				ip.port[(USHORT)parameter_0].routing_status = ROUTING_PORT;
				ip.port[(USHORT)parameter_0].config.ip_address = get_ip_address (0);
				ip.port[(USHORT)parameter_0].config.remote_access_enabled = TRUE;
				printf ("IPPROX : Setting Port for Routing %d\n",(USHORT)parameter_0); 
			}

         ip_printf (IP_DIAGNOSTIC_PRINTF, "Bringing up port %d, MTU : %d, Remote IP Address : %s\n",
            (USHORT)parameter_0,
            parameter_2,
            convert_ip_address_to_dot_format (&ip.print_buffer[0], parameter_1)) ;

			ip.port[(USHORT) parameter_0].config.mtu = (USHORT) parameter_2;

/* Sudhir and Sachin added the third parameter which is the local IP address */

         bring_up_port ((USHORT) parameter_0, parameter_1,parameter_3);


			lsl_control ((ULONG) INFORM_TRANSPORT_PROTOCOL_ON_PORT_STATUS, (ULONG) IGRP_ROUTING,
				(ULONG) OPEN_TRANSPORT_VIRTUAL_PORT, parameter_0, parameter_1);

			break;

		case CLOSE_VIRTUAL_PORT:

			shut_down_port ((USHORT) parameter_0);
			
			ip.port[(USHORT)parameter_0].routing_status = PROXY_PORT;

			lsl_control ((ULONG) INFORM_TRANSPORT_PROTOCOL_ON_PORT_STATUS, (ULONG) IGRP_ROUTING,
				(ULONG) CLOSE_TRANSPORT_VIRTUAL_PORT, parameter_0, (ULONG) NULL);

			break;

		case CLEAR_CACHED_ROUTE:

			flush_route_cache ();

			break;

		case REGISTER_TO_IP_FROM_UPPER_LAYER:

			ip_register_upper_layer_protocol ((USHORT) parameter_0,
				(void (*) (IP_PARAMETERS *sptr_ip_parameters, void *vptr_rx_packet, USHORT packet_size)) parameter_1,
				(enum TEST (*) (ULONG type_of_service, ULONG destination_ip_address, void **ptr_to_vptr_route_entry))
				parameter_2);

			break;

/* sudhir */
		case UPDATE_DNS_SERVER_ADDRESS:
			printf ("Updating DNS Server address %08x  %08x\n",
					parameter_1, parameter_2);

			update_dns_server_address_in_resolver (parameter_1, parameter_2);
			update_dns_server_address_in_dhcp_address_list (parameter_1); 
			start_resolving_proxy_dns_filters ();
			break;
/* sudhir */

		default:

			if (ip_configuration (command, parameter_0, parameter_1) == FAIL)
				{
			#ifdef __IP_ALARM_DEBUG__
				ip_printf (IP_ALARM_PRINTF, "IP: bad command for ip_control: %d\n", command);
			#endif /* __IP__ALARM_DEBUG__ */
				}

		#ifndef __LSL__

			call_control_routines_of_other_transport_protocols (command, parameter_0, parameter_1);

		#endif /* __LSL__ */

			break;
		}

	return (PASS);
}
/****************************************************************************/
#ifdef _BIG_PROXY_
static enum TEST reinitialize_ip (void)
{
#ifdef __IP_BREAKPOINT__
	check_for_ip_initialization_breakpoint ();
#endif /* __IP_BREAKPOINT__ */

	if (ip.enabled == FALSE)
		{
		return (FAIL);
		}

	if (initialize_all_virtual_ports () == FAIL)
		{
		return (FAIL);
		}

	ip.rip.protocol_enabled = TRUE;

	if (rip_initialization () == FAIL)
		{
		return (FAIL);
		}

	rip_broadcast_request_packets_on_all_ports ();

	return (PASS);
}
#endif
/*************************************************************************/
#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
static void	turn_on_appropriate_print_flags (void)
{
	ip.print_class.ip_printing_enabled = TRUE;
	ip.print_class.ip_route_printing_enabled = TRUE;
}
#endif /* Jo 26/05/99 */
/*************************************************************************/
void flush_route_cache (void)
{
	IP_ROUTE_CACHE_HASH_BUCKET *sptr_bucket;
	USHORT bucket;

	sptr_bucket = ip.sptr_route_cache;

	for (bucket = 0x0000; bucket < ip.number_of_route_cache_hash_table_buckets; ++bucket)
		{
		sptr_bucket->number_of_entries = 0x0000;

		++sptr_bucket;
		}

	ip.sptr_most_recently_used_route = NULL;

#ifdef __IP_DEBUG__
	ip_printf (IP_CACHE_PRINTF, "IP: route cache has been flushed\n");
#endif /* __IP__DEBUG__ */
}
/*************************************************************************/
#ifdef _BIG_PROXY
static enum TEST shut_down_ip_router (void)
{
#ifdef __IP_BREAKPOINT__
	check_for_ip_shutdown_breakpoint ();
#endif /* __IP_BREAKPOINT__ */

	if (ip.shutdown_has_begun == FALSE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: router has begun SHUTDOWN\n");
	#endif /* __IP__ALARM_DEBUG__ */

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
		turn_on_appropriate_print_flags ();
#endif /* Jo 26/05/99 */

/* Jo 23/04/99 */
	#if PRINT_IP_TABLE_INFO
		ip_print_routing_table ();
	#endif
/* Jo 23/04/99 */

		inform_neighboring_routers_of_invalid_routes ();

		ip.shutdown_has_begun = TRUE;
		}

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
	if (ip.statistics.number_of_allocated_packets_waiting_for_transmit_completes != 0x00L)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: waiting for transmits to complete: %u\n",
			ip.statistics.number_of_allocated_packets_waiting_for_transmit_completes);
	#endif /* __IP__ALARM_DEBUG__ */
#endif /* Jo 26/05/99 */

		return (FAIL);
		}

#ifdef __IP_ALARM_DEBUG__
	ip_printf (IP_ALARM_PRINTF, "IP: router is doing SHUTDOWN\n");
#endif /* __IP__ALARM_DEBUG__ */

	free_ip_rip_list_entries ();

	free_udp_control_blocks ();

	free_ip_route_cache_entries ();

	free_ip_routing_table_entries ();

	free_ip_reassembly_control_blocks ();

	free_ip_arp_entries ();

	free_ip_rarp_entries ();

	ip.timer_enabled = FALSE;


/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
	ip_print_port_statistics ();
	ip_print_protocol_statistics ();
#endif /* Jo 23/04/99 */

	if (ip.stack_id != 0x00000000L)
		{
		lsl_control ((ULONG) DEREGISTER_PROTOCOL_STACK, (ULONG) NETWORK_LAYER_TYPE, (ULONG) ip.stack_id);
		}

	ip.enabled = FALSE;

	return (PASS);
}
#ifdef __IP_BREAKPOINT__
/*************************************************************************/
static void check_for_ip_shutdown_breakpoint (void)
{
	if (ip.shutdown_breakpoint == TRUE)
		{
		BREAKPOINT;
		}
}
#endif /* __IP_BREAKPOINT__ */
#endif  /* Jo 23/04/99 */
/*************************************************************************/
/* Sudhir and Sachin added the third parameter which is the local IP address */
static void bring_up_port (USHORT port_number, ULONG remote_point_to_point_link_ip_address, ULONG local_ip_address)
{
	IP_PORT_CLASS *sptr_port;
	ULONG remote_ip_address;
	IP_SOCKET remote_socket;
	EVENT_HEADER  evnt_header; /* Added  by Subbi on 05 Oct 1999 */

	sptr_port = &ip.port[port_number];

	if (sptr_port->config.point_to_point_link == FALSE)
	{
		return;
	}
	

	remote_ip_address = net_to_host_long (remote_point_to_point_link_ip_address);
	local_ip_address = net_to_host_long (local_ip_address) ;
	

	if (local_ip_address)
		ip.port[port_number].config.ip_address = local_ip_address ;


	if (remote_ip_address != 0x00000000L)
	{
		if (ip_match_full_address_to_port (remote_ip_address) == NO_SUCH_PORT)
		{
			sptr_port->config.point_to_point_remote_ip_address = remote_ip_address;
		}
	}
	else if (sptr_port->config.remote_access_enabled == TRUE)
	{
		return;
	}

	sptr_port->port_is_up = TRUE;

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
	reset_ip_port_statistics (sptr_port);
#endif /* Jo 26/05/99 */

	start_resolving_proxy_dns_filters ();

/* ...Jo 11 Oct 1999 Added for Monitoring Program */
	if (!is_port_is_remote_access (port_number))
	{
   	evnt_header.event_type = WAN_EVENTS;
		evnt_header.message_type = MONITOR_EVENT_WAN_LINK_UP;
		evnt_header.server_ip_address	= get_ip_address(0);
		evnt_header.client_ip_address = 0;
      evnt_header.dest_ip_address= local_ip_address;
		evnt_header.port = port_number;
	   strcpy(evnt_header.client_mac_address,"");
		event_broadcast_packets_on_all_ports (&evnt_header);
	}
/* Jo 11 Oct 1999 Added for Monitoring Program... */

	printf ("IP: Port %04X up with Local IP address %s and Remote IP address %s\n",
		port_number,
		convert_ip_address_to_dot_format ((char *) &ip.print_buffer[0], ip.port[port_number].config.ip_address),
		convert_ip_address_to_dot_format ((char *) &ip.print_buffer_2[0], ip.port[port_number].config.point_to_point_remote_ip_address));
	ip_port_up (port_number) ;
	
/* Jo 29/06/99 Added from Jessi */
/* sudha 18 May 1999 */
	if (is_dialing_initiated_by_this_end (port_number - 1) == TRUE)
		set_dialing_initiated_from_proxy_successful_to_true (port_number - 1); 

	ip_add_route_for_port (port_number);

/* Jo 18/06/99 Added for RAS */

	remote_access_client_up (port_number, remote_point_to_point_link_ip_address) ;
	
/* ...Jo 11 Oct 1999 Added for Monitoring Program */
	if (is_port_is_remote_access (port_number))
	{
		evnt_header.event_type = WAN_EVENTS;
		evnt_header.message_type = MONITOR_EVENT_RAS_CLIENT_UP;
		evnt_header.server_ip_address	= get_ip_address(0);
		evnt_header.client_ip_address = 0;
		evnt_header.dest_ip_address= remote_ip_address;
		evnt_header.port = port_number;
		strcpy(evnt_header.client_mac_address,"");
		event_broadcast_packets_on_all_ports (&evnt_header);
	}
/* Jo 11 Oct 1999 Added for Monitoring Program... */

/* Jo 18/06/99 Added for RAS */
#ifdef _BIG_PROXY_
	if (remote_access_client_up (port_number, remote_point_to_point_link_ip_address) == NULL)
	{
		
/* sudhir just for now */
		if (ip.rip.protocol_enabled == TRUE)
		{
			ip_add_route_for_port (port_number);
			
			rip_initiate_triggered_broadcast (port_number);

		/* the following are added by me to care of DOD  where RIP Response
		for that packet will be disabled*/
		/* if DOD is enabled only , send this RIP */
			if (ip.rip.config.route_aging_timeout_value == 0)
			{
				determine_destination_ip_address (&ip.port[port_number],&remote_socket);
				remote_socket.port = RIP_PORT;
				remote_socket.virtual_port_number = port_number;
				rip_send_full_response (port_number, &remote_socket,ip.rip.port[port_number].poison_reverse_enabled, FALSE, FALSE);
			}
		}
	}
#endif
}
/*************************************************************************/
static void shut_down_port (USHORT port_number)
{
	IP_PORT_CLASS *sptr_port;
	EVENT_HEADER  evnt_header; /* Added  by Subbi on 05 Oct 1999 */
	
#ifdef __IP_DEBUG__
	ip_printf (IP_PRINTF, "IP: WAN is down on virtual port %d\n", port_number);
#endif /* __IP__DEBUG__ */

	sptr_port = &ip.port[port_number];

/* sudhir */
	sptr_port->config.remote_access_enabled = sptr_port->config.configured_remote_access_enabled ;		
/* sudhir */

	if (sptr_port->port_is_up == TRUE)
	{
		sptr_port->port_is_up = FALSE;

		if (sptr_port->config.point_to_point_link == TRUE)
		{
/* PROXY_SERVER : Sudhir */

/* ...Jo 11 Oct 1999 Added for Monitoring Program */
			if (!is_port_is_remote_access (port_number))
			{
			  	evnt_header.event_type = WAN_EVENTS;
				evnt_header.message_type = MONITOR_EVENT_WAN_LINK_DOWN;
 				evnt_header.server_ip_address	= get_ip_address(0);
				evnt_header.client_ip_address = 0;
	  		   evnt_header.dest_ip_address= 0;
				evnt_header.port = port_number;
			   strcpy(evnt_header.client_mac_address,"");
				event_broadcast_packets_on_all_ports (&evnt_header);
			}
/* Jo 11 Oct 1999 Added for Monitoring Program... */

			printf ("IP: Port %04X down\n", port_number) ;
			ip_port_down (port_number) ;

/* Jo 18/06/99 Added for RAS */
			remote_access_client_down (port_number, sptr_port->config.point_to_point_remote_ip_address) ;
/* Jo 18/06/99 Added for RAS */

/* ...Jo 11 Oct 1999 Added for Monitoring Program */
			if (is_port_is_remote_access (port_number))
			{
   			evnt_header.event_type = WAN_EVENTS;
				evnt_header.message_type = MONITOR_EVENT_RAS_CLIENT_DOWN;
				evnt_header.server_ip_address	= get_ip_address(0);
				evnt_header.client_ip_address = 0;
				evnt_header.dest_ip_address= sptr_port->config.point_to_point_remote_ip_address ;
				evnt_header.port = port_number;
				strcpy(evnt_header.client_mac_address,"");
				event_broadcast_packets_on_all_ports (&evnt_header);
			}
/* Jo 11 Oct 1999 Added for Monitoring Program... */

#ifdef _BIG_PROXY_
			if (remote_access_client_down (port_number, sptr_port->config.point_to_point_remote_ip_address) == NULL)
			{
				rip_delete_route_for_port (port_number);
			}
#endif
		}
		else
		{
			rip_delete_route_for_port (port_number);
		}
	}
}
#ifndef __LSL__
/*************************************************************************/
static void call_control_routines_of_other_transport_protocols (enum TRANSPORT_CONTROL_OPERATION command, ULONG parameter_0,
	ULONG parameter_1)
{
	USHORT index_of_other_transport_protocols;

	for (index_of_other_transport_protocols = 0x0000; index_of_other_transport_protocols <
		ip.number_of_other_transport_protocols; ++index_of_other_transport_protocols)
		{
		if (ip.other_transport_protocols[index_of_other_transport_protocols].fptr_control != NULL)
			{
			(*(ip.other_transport_protocols[index_of_other_transport_protocols].fptr_control)) (command, parameter_0,
				parameter_1);
			}
		}
}
#endif /* __LSL__ */
