#ifndef _IP_FILTER_H_

#define _IP_FILTER_H_

enum ip_filter_type
{
	IP_INVALID_FILTER = 0,
	IP_FILTER_ON_SOURCE_ADDRESS,
	IP_FILTER_ON_DESTINATION_ADDRESS,
	IP_FILTER_ON_SOURCE_RANGE,
	IP_FILTER_ON_DESTINATION_RANGE,
	IP_FORWARD_ON_SOURCE_ADDRESS,
	IP_FORWARD_ON_DESTINATION_ADDRESS,
	IP_FORWARD_ON_SOURCE_RANGE,
	IP_FORWARD_ON_DESTINATION_RANGE,
   IP_FILTER_ON_SOURCE_PORT,
   IP_FILTER_ON_DESTINATION_PORT,
   IP_FORWARD_ON_SOURCE_PORT,
   IP_FORWARD_ON_DESTINATION_PORT
} ;
typedef enum ip_filter_type IP_FILTER_TYPE ;

typedef enum
{
	IP_FILTER_DEFAULT_ACTION_FORWARD,
	IP_FILTER_DEFAULT_ACTION_FILTER
} IP_FILTER_DEFAULT_ACTION ;

typedef struct
{
   BYTE protocol ;
   USHORT port_number ;
} PROTOCOL_PORT ;

struct struct_ip_filter
{
	struct struct_ip_filter *forward_link ;
	struct struct_ip_filter *backward_link ;
   union
   {
	   ULONG ip_address ;
      PROTOCOL_PORT protocol_port ;
   } lower_end ;
   union
   {
	   ULONG ip_address ;
      PROTOCOL_PORT protocol_port ;
   } higher_end ;
	USHORT port ;
	IP_FILTER_TYPE type ;
} ;
typedef struct struct_ip_filter IP_FILTERING_ENTRY ;

typedef struct ip_filter_class
{
   IP_FILTERING_ENTRY *ip_filtering_table ;
   enum BOOLEAN ip_filtering_inited ;
   USHORT ip_filter_table_size ;
   USHORT ip_number_of_src_filter_entries, ip_number_of_dest_filter_entries, ip_number_of_filter_entries ;
   IP_FILTERING_ENTRY *sptr_ip_src_filter_chain, *sptr_ip_dest_filter_chain ;
   IP_FILTER_DEFAULT_ACTION ip_filter_default_rx_action, ip_filter_default_tx_action, ip_filter_default_action ;
} IP_FILTER_CLASS ;

/* Extern declarations */
extern IP_FILTERING_ENTRY *ip_get_src_filtering_entry (ULONG ip_address, USHORT protocol_port, BYTE protocol) ;
extern IP_FILTERING_ENTRY *ip_get_dest_filtering_entry (ULONG ip_address, USHORT protocol_port, BYTE protocol) ;
extern void display_ip_filtering_table () ;

extern enum BOOLEAN ip_filtering_inited ;
extern IP_FILTER_DEFAULT_ACTION ip_filter_default_rx_action, ip_filter_default_tx_action ;


/* Standard C library functions */
extern void *malloc(ULONG) ;

#endif 
