#include	"defs.h"
/*
 * $Log: /IP/IPFRAGTX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipfragtx.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdio.h>
#include	<string.h>
#include "ip.h"
/****************************************************************************/
void	set_variables_for_fragmentation (enum BOOLEAN *eptr_option_cleaned, BYTE *bptr_ip_header_tx_packet,
	IP_HEADER_WITH_OPTIONS **ptr_to_sptr_ip_packet_header, IP_PARAMETERS *sptr_ip_parameters, USHORT *usptr_header_length,
	UNION_IP_PACKET *sptr_tx_packet, USHORT max_tx_unit_size, USHORT *usptr_fragment_data_size, USHORT *usptr_data_length,
	BYTE **ptr_to_bptr_copy_from);
void	determine_the_number_of_bytes_to_be_copied (USHORT header_length, USHORT data_length, USHORT fragment_data_size,
	USHORT *usptr_size_to_copy);
enum TEST get_ip_fragment (USHORT outgoing_port_number, USHORT fragment_data_size, USHORT header_length,
	UNION_IP_PACKET **ptr_to_sptr_new_ip_packet, BYTE **ptr_to_bptr_copy_to);
void	set_up_ip_header_for_fragment (USHORT *usptr_host_order_offset, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_new_ip_packet, USHORT header_length, USHORT data_length, USHORT remainder_number_of_bytes,
	IP_HEADER_WITH_OPTIONS *sptr_ip_packet_header);
/* Sachin, 14th May, 1997 */
/*
void copy_header_to_packet_and_send_fragment (UNION_IP_PACKET *sptr_new_ip_packet, USHORT header_length,
	USHORT data_length, IP_HEADER_WITH_OPTIONS *sptr_ip_packet_header, USHORT outgoing_port_number, enum BOOLEAN is_broadcast,
	ULONG next_router_ip_address);
*/
enum IP_SEND_CONFIRMATION copy_header_to_packet_and_send_fragment (UNION_IP_PACKET *sptr_new_ip_packet, USHORT header_length,
	USHORT data_length, IP_HEADER_WITH_OPTIONS *sptr_ip_packet_header, USHORT outgoing_port_number, enum BOOLEAN is_broadcast,
	ULONG next_router_ip_address);
/* Sachin, 14th May, 1997 */

void	clear_options_that_can_not_be_copied_to_any_fragment_other_than_the_first (enum BOOLEAN *eptr_option_cleaned,
	IP_PARAMETERS *sptr_ip_parameters, IP_HEADER_WITH_OPTIONS *sptr_ip_packet_header, USHORT *usptr_header_length);
void	keep_count_of_the_type_of_packet_that_was_txed (USHORT tx_port_number, UNION_IP_PACKET *uptr_ip_packet);
#ifdef __IP_DEBUG__
void print_txed_mac_header (LSL_IP_HEADER *sptr_lsl_header);
#endif /* __IP__DEBUG__ */
/*************************************************************************/
enum IP_SEND_CONFIRMATION check_for_fragmentation_and_send_packet (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_ip_packet, USHORT number_of_bytes, IP_PORT_CLASS *sptr_outgoing_port, enum BOOLEAN do_checksum,
	USHORT outgoing_port_number, enum BOOLEAN is_broadcast, enum BOOLEAN forwarded_packet, ULONG next_hop_ip_address,
	void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet))
{
	enum IP_SEND_CONFIRMATION normal_return_code;
	enum TEST fragment_return_code;
	union UNION_ICMP_PARAMETER icmp_parameter;

	/* If the packet size is greater than MTU, do fragmentation */

#ifdef __IP_DEBUG__
/*	ip_printf (IP_TX_PRINTF, "IP: size of packet: %u, link mtu: %u\n", sptr_ip_parameters->total_length,
		sptr_outgoing_port->config.mtu); */
#endif /* __IP__DEBUG__ */

	if (sptr_ip_parameters->total_length <= sptr_outgoing_port->config.mtu)			/* no fragmentation! */
	{
		if (do_checksum == TRUE)
		{
			sptr_ip_packet->ip.header.header_checksum = 0x0000;

			sptr_ip_packet->ip.header.header_checksum = calculate_ip_checksum (NULL, (BYTE *) &sptr_ip_packet->ip.header,
				sptr_ip_parameters->header_length);
		}

		normal_return_code = resolve_mac_address_and_send (outgoing_port_number, sptr_ip_packet, number_of_bytes,
			forwarded_packet, next_hop_ip_address, is_broadcast,
			(void (*) (USHORT port_number, void *vptr_ip_packet)) fptr_tx_completion);

		return (normal_return_code);
	}

	if (sptr_ip_parameters->do_not_fragment_flag == TRUE)				/* do fragmentation */
		{
#ifdef _BIG_PROXY_
		++ip.mib.ipFragFails;
#endif

		if (forwarded_packet == TRUE)
			{
			icmp_parameter.mtu = sptr_outgoing_port->config.mtu;

			send_icmp_error_packet (outgoing_port_number, sptr_ip_parameters, sptr_ip_packet, ICMP_DESTINATION_UNREACHABLE_TYPE,
				ICMP_FRAGMENT_NEEDED_CODE, &icmp_parameter);
			}

#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: packet size exceeds mtu, but fragmentation was disallowed by user\n");
#endif /* __IP__ALARM_DEBUG__ */

		return (IP_SEND_FRAGMENTATION_NEEDED);
		}

#ifdef __IP_DEBUG__
	ip_printf (IP_TX_PRINTF, "IP: fragmenting packet\n");
#endif /* __IP__DEBUG__ */

	fragment_return_code = fragment_packet_and_forward (sptr_ip_parameters, sptr_outgoing_port->config.mtu, number_of_bytes,
		is_broadcast, outgoing_port_number, next_hop_ip_address, sptr_ip_packet);

	if (fragment_return_code == PASS)
		return (IP_SEND_PACKET_FRAGMENTED_OK);
	else
		return (IP_SEND_CANNOT_FRAGMENT);
}
/*************************************************************************/
enum IP_SEND_CONFIRMATION resolve_mac_address_and_send (USHORT tx_port_number, UNION_IP_PACKET *sptr_ip_packet,
	USHORT number_of_bytes, enum BOOLEAN forwarded_packet, ULONG tx_ip_address, enum BOOLEAN is_broadcast,
	void (*fptr_tx_completion) (USHORT port_number, void *vptr_ip_packet))
{
	MAC_ADDRESS *sptr_destination_mac_address;
	enum TEST return_code;

	if (is_broadcast == TRUE)
	{
		/*	For point to point link, we expect LSL to change the ethernet broadcast address to the right mac layer address. */

#ifdef _BIG_PROXY_
		if ((ip.port[tx_port_number].config.token_ring == TRUE) && (ip.port[tx_port_number].config.rfc1042_enabled == TRUE))
			{
			convert_ip_tx_header_to_source_routed_header (tx_port_number, sptr_ip_packet, SNAP_IP_PACKET);
			}
#endif

#ifdef __IP_DEBUG__
		ip_printf (IP_DATA_PRINTF, "IP: packet is to be broadcast on link\n");
#endif /* __IP__DEBUG__ */

		sptr_destination_mac_address = &ethernet_broadcast_address;

#ifdef __IP_DEBUG__
		ip_printf (IP_DATA_PRINTF, "IP: destination mac address is %x:%x\n", sptr_destination_mac_address->_ulong,
			sptr_destination_mac_address->_ushort);
#endif /* __IP__DEBUG__ */
	}
	else
	{
		if (ip.port[tx_port_number].config.arp_enabled == TRUE)
		{
			sptr_destination_mac_address = resolve_destination_ip_address_using_arp (sptr_ip_packet,
				tx_port_number, tx_ip_address, number_of_bytes);

			if (sptr_destination_mac_address == NULL)
				return (IP_SEND_NO_ARP_TABLE_ENTRY);
		}
		else
		{
			if (ip.port[tx_port_number].config.point_to_point_link == FALSE)
			{
#ifdef __IP_ALARM_DEBUG__
				ip_printf (IP_ALARM_PRINTF, "IP: ARP is disallowed\n");
#endif /* __IP__ALARM_DEBUG__ */
			}

			sptr_destination_mac_address = &ethernet_broadcast_address;

#ifdef __IP_DEBUG__
			ip_printf (IP_DATA_PRINTF, "IP: destination mac address is %x:%x\n", sptr_destination_mac_address->_ulong,
				sptr_destination_mac_address->_ushort);
#endif /* __IP__DEBUG__ */
		}
	}

	if (sptr_destination_mac_address != (MAC_ADDRESS *) NULL)
		{
#ifdef __IP_DEBUG__
		if (forwarded_packet == FALSE)
			{
			print_txed_ip_header (&sptr_ip_packet->ip.header, tx_port_number);
			}
		else
			{
			print_forwarded_ip_header (&sptr_ip_packet->ip.header, tx_port_number);
			}
#endif /* __IP__DEBUG__ */

		return_code = send_packet_to_lsl (tx_port_number, sptr_ip_packet, number_of_bytes, forwarded_packet,
			fptr_tx_completion, SNAP_IP_PACKET, sptr_destination_mac_address);

		if (return_code == FAIL)
			return (IP_SEND_REAL_PORT_DISABLED);
		}
	else
		{
#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: send failed for INVALID destination mac address\n");
#endif /* __IP__ALARM_DEBUG__ */
		}

	return (IP_SEND_OK);
}
/****************************************************************************/
/* The packet to be sent out is fragmented here because the packet size is greater than MTU.
 * In the latter case, the packet is from the upper layer such as UDP, TCP or ICMP.
 * For instance, an ICMP echo request may be reassembled at this node by ICMP which maintains
 * multiple ip_list_packets and sends them back as echo response. */

enum TEST fragment_packet_and_forward (IP_PARAMETERS *sptr_ip_parameters, USHORT max_tx_unit_size, USHORT number_of_bytes,
	enum BOOLEAN is_broadcast, USHORT outgoing_port_number, ULONG next_router_ip_address, UNION_IP_PACKET *sptr_tx_packet)
{
	enum BOOLEAN option_cleaned;
	BYTE ip_header_tx_packet[MAXIMUM_IP_HEADER_LENGTH];
	BYTE *bptr_copy_from;
	BYTE *bptr_copy_to;
	USHORT data_length;
	USHORT header_length;
	USHORT fragment_data_size;
	USHORT host_order_offset;
	USHORT size_to_copy;
	IP_HEADER_WITH_OPTIONS *sptr_ip_packet_header;
	UNION_IP_PACKET *sptr_new_ip_packet;
	enum IP_SEND_CONFIRMATION normal_return_code;

	PARAMETER_NOT_USED (number_of_bytes);

	set_variables_for_fragmentation (&option_cleaned, &ip_header_tx_packet[0], &sptr_ip_packet_header, sptr_ip_parameters,
		&header_length, sptr_tx_packet, max_tx_unit_size, &fragment_data_size, &data_length, &bptr_copy_from);

	while (data_length != 0x0000)
		{
		determine_the_number_of_bytes_to_be_copied (header_length, data_length, fragment_data_size, &size_to_copy);

		if (get_ip_fragment (outgoing_port_number, size_to_copy, header_length, &sptr_new_ip_packet, &bptr_copy_to)
			== FAIL)
			{
			return (FAIL);
			}

		memcpy ((void *) bptr_copy_to, (void *) bptr_copy_from, size_to_copy);

		data_length = (USHORT) (data_length - size_to_copy);

		bptr_copy_from += size_to_copy;

/* Sachin, 14th May, 1997 */
      /* bptr_copy_to += size_to_copy; */
/* Sachin, 14th May, 1997 */

		set_up_ip_header_for_fragment (&host_order_offset, sptr_ip_parameters, sptr_new_ip_packet, header_length,
			size_to_copy, data_length, sptr_ip_packet_header);

/* Sachin 14th May 1997 */
/* Modified copy_header_to_packet_and_send_fragment to return a return code
This is needed because in some cases the buffer is not freed. we check the
return code and free buffer */

		normal_return_code = copy_header_to_packet_and_send_fragment (sptr_new_ip_packet, header_length, size_to_copy, sptr_ip_packet_header,
			outgoing_port_number, is_broadcast, next_router_ip_address);

/* Sachin 14th May 1997 */
		if (normal_return_code == IP_SEND_NO_ARP_TABLE_ENTRY)
		{				/* buffer was not freed so free it */
			sptr_new_ip_packet = 
				normalize_ip_send_packet_header(outgoing_port_number, sptr_new_ip_packet);
			send_completion_ip_packet(outgoing_port_number, sptr_new_ip_packet);
		}
		else if (normal_return_code == IP_SEND_REAL_PORT_DISABLED)
		{				/* Buffer is freed but since error, return */
			return(FAIL);
		}

		clear_options_that_can_not_be_copied_to_any_fragment_other_than_the_first (&option_cleaned, sptr_ip_parameters,
			sptr_ip_packet_header, &header_length);
		}
#ifdef _BIG_PROXY_
	++ip.mib.ipFragOKs;
#endif
	return (PASS);
}
/****************************************************************************/
void	set_variables_for_fragmentation (enum BOOLEAN *eptr_option_cleaned, BYTE *bptr_ip_header_tx_packet,
	IP_HEADER_WITH_OPTIONS **ptr_to_sptr_ip_packet_header, IP_PARAMETERS *sptr_ip_parameters, USHORT *usptr_header_length,
	UNION_IP_PACKET *sptr_tx_packet, USHORT max_tx_unit_size, USHORT *usptr_fragment_data_size, USHORT *usptr_data_length,
	BYTE **ptr_to_bptr_copy_from)
{
	*eptr_option_cleaned = FALSE;

	*ptr_to_sptr_ip_packet_header = (IP_HEADER_WITH_OPTIONS *) bptr_ip_header_tx_packet;

	*usptr_header_length = sptr_ip_parameters->header_length;

	/* save IP header to stack */

	memcpy ((void *) *ptr_to_sptr_ip_packet_header, (void *) &sptr_tx_packet->ip.header, *usptr_header_length);

	/* offset must be on 8-octet boundaries for fragmentation */

	*usptr_fragment_data_size = (USHORT) ((max_tx_unit_size - *usptr_header_length) & 0xfff8);

	*usptr_data_length = (USHORT) (sptr_ip_parameters->total_length - *usptr_header_length);

#ifdef __IP_DEBUG__
	ip_printf (IP_FRAGMENT_PRINTF, "IP: size of packet to be fragmented is %d\n", *usptr_data_length);
#endif /* __IP__DEBUG__ */

	/* the more_fragment_flag in every fragment except the last one should be set to 1 */

	(*ptr_to_sptr_ip_packet_header)->flags_fragment_offset.more_fragment_flag = TRUE;

	*ptr_to_bptr_copy_from = (BYTE *) &sptr_tx_packet->ip.header + *usptr_header_length;
}
/****************************************************************************/
void	determine_the_number_of_bytes_to_be_copied (USHORT header_length, USHORT data_length, USHORT fragment_data_size,
	USHORT *usptr_size_to_copy)
{
/* Sachin 15th May, 1997 */
#if 0
	if ((data_length + header_length + sizeof (UNION_MAC_HEADER)) < fragment_data_size)
		{
		*usptr_size_to_copy = data_length;
		}
	else
		{
		*usptr_size_to_copy = (USHORT) (fragment_data_size - header_length - sizeof (UNION_MAC_HEADER));
		}

	*usptr_size_to_copy = (USHORT) (*usptr_size_to_copy & 0xfff8);
#endif
   if (data_length < fragment_data_size)
      *usptr_size_to_copy = data_length ;
   else
      *usptr_size_to_copy = fragment_data_size ;
/* Sachin 15th May, 1997 */
}
/****************************************************************************/
enum TEST get_ip_fragment (USHORT outgoing_port_number, USHORT fragment_data_size, USHORT header_length,
	UNION_IP_PACKET **ptr_to_sptr_new_ip_packet, BYTE **ptr_to_bptr_copy_to)
{
	*ptr_to_sptr_new_ip_packet = (UNION_IP_PACKET *) get_an_ip_send_packet (outgoing_port_number,
		fragment_data_size + header_length + sizeof (UNION_MAC_HEADER));

	if (*ptr_to_sptr_new_ip_packet != NULL)
		{
		/* reserve IP header space */

		*ptr_to_bptr_copy_to = (BYTE *) ((ULONG) &(*ptr_to_sptr_new_ip_packet)->ip.header + header_length);
		}
	else
		{
#ifdef _BIG_PROXY_
		++ip.mib.ipFragFails;
#endif
		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
void	set_up_ip_header_for_fragment (USHORT *usptr_host_order_offset, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_new_ip_packet, USHORT header_length, USHORT data_length, USHORT remainder_number_of_bytes,
	IP_HEADER_WITH_OPTIONS *sptr_ip_packet_header)
{
	PARAMETER_NOT_USED (sptr_new_ip_packet);

	*usptr_host_order_offset = (USHORT) (sptr_ip_parameters->offset >> 3);			/* current fragment offset in 8 bytes */

	/* update for next fragment offset */

#ifdef __IP_DEBUG__
	ip_printf (IP_FRAGMENT_PRINTF, "IP: next fragment offset will be: %u\n", sptr_ip_parameters->offset);
#endif /* __IP__DEBUG__ */

	sptr_ip_parameters->offset = (USHORT) (sptr_ip_parameters->offset + data_length);

	if (remainder_number_of_bytes == 0x0000)
	{
/* Check for the more fragment flag in the original header. Only if it is FALSE i.e it is the last fragment */
/* set the more_fragment_flag to false else leave it at TRUE. All fragments of a fragmented packet should have */
/* the more_fragment_flag set to TRUE but for the last fragment of the last fragment */
/* Sachin 14th May 1997 */
		if (sptr_ip_parameters->more_fragment_flag == FALSE)
		   sptr_ip_packet_header->flags_fragment_offset.more_fragment_flag = FALSE;
	}

	sptr_ip_packet_header->total_length = host_to_net_short ((USHORT) (data_length + header_length));

	sptr_ip_packet_header->fragment_offset_least_significant_part = (BYTE) (*usptr_host_order_offset & 0xff);

	sptr_ip_packet_header->flags_fragment_offset.fragment_offset_most_significant_part =
		(BYTE) (*usptr_host_order_offset >> 8);

	sptr_ip_packet_header->header_checksum = 0x0000;

	sptr_ip_packet_header->header_checksum = calculate_ip_checksum (NULL, (BYTE *) sptr_ip_packet_header, header_length);
}
/****************************************************************************/
/* 14th May, 1997 Sachin modified to return the error code */
enum IP_SEND_CONFIRMATION copy_header_to_packet_and_send_fragment (UNION_IP_PACKET *sptr_new_ip_packet, USHORT header_length,
	USHORT data_length, IP_HEADER_WITH_OPTIONS *sptr_ip_packet_header, USHORT outgoing_port_number, enum BOOLEAN is_broadcast,
	ULONG next_router_ip_address)
{
	/* copy ip header into new fragment */

	memcpy ((void *) &sptr_new_ip_packet->ip.header, (void *) sptr_ip_packet_header, header_length);

	return (resolve_mac_address_and_send (outgoing_port_number, sptr_new_ip_packet,
		(USHORT) (data_length + header_length + sizeof (UNION_MAC_HEADER)), FALSE, next_router_ip_address,
		is_broadcast, send_completion_ip_packet)) ;
}
/****************************************************************************/
void	clear_options_that_can_not_be_copied_to_any_fragment_other_than_the_first (enum BOOLEAN *eptr_option_cleaned,
	IP_PARAMETERS *sptr_ip_parameters, IP_HEADER_WITH_OPTIONS *sptr_ip_packet_header, USHORT *usptr_header_length)
{
	/* clear options that can not be copied to other than the first fragment */

	if (*eptr_option_cleaned == FALSE) 								/* Do this only once for the rest of fragments */
		{
		*eptr_option_cleaned = TRUE;
#ifdef _BIG_PROXY_
		if (clear_options ((BYTE *) &sptr_ip_packet_header->ip_options, sptr_ip_parameters->options_length) == FAIL)
			{
			sptr_ip_parameters->header_length = (USHORT) (sptr_ip_parameters->header_length - sptr_ip_parameters->options_length);

			sptr_ip_parameters->options_length = 0x0000;

			sptr_ip_packet_header->version_header_length.header_length = (BYTE) (sptr_ip_parameters->header_length >> 2);
			}
#endif

		*usptr_header_length = sptr_ip_parameters->header_length;
		}
}
/*************************************************************************/
enum TEST send_packet_to_lsl (USHORT tx_port_number, UNION_IP_PACKET *uptr_tx_packet, USHORT number_of_bytes,
	enum BOOLEAN forwarded_packet, void (*fptr_tx_completion) (USHORT port_number, void *uptr_tx_packet),
	enum SNAP_PROTOCOL_ID protocol_type, MAC_ADDRESS *destination_mac_address)
{
	LSL_IP_HEADER *sptr_lsl_packet_header;
	IP_PORT_CLASS *sptr_port;

	sptr_port = &ip.port[tx_port_number];

	sptr_lsl_packet_header = (LSL_IP_HEADER *) ((ULONG) uptr_tx_packet - sizeof (USHORT_ENUM (SNAP_PROTOCOL_ID)));

	if (ip.port[tx_port_number].config.port_enabled == FALSE)
		{
#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
		++ip.port[tx_port_number].statistics.number_of_txed_packets_filtered;
#endif /* Jo 26/05/99 */

		uptr_tx_packet = normalize_ip_send_packet_header (tx_port_number, uptr_tx_packet);

		if (fptr_tx_completion != NULL)
		{
			(*fptr_tx_completion) (tx_port_number, uptr_tx_packet);
		}

		return (FAIL);
		}

	sptr_lsl_packet_header->destination_address._ulong = destination_mac_address->_ulong;
	sptr_lsl_packet_header->destination_address._ushort = destination_mac_address->_ushort;
	sptr_lsl_packet_header->source_address._ulong = sptr_port->mac_address._ulong;
	sptr_lsl_packet_header->source_address._ushort = sptr_port->mac_address._ushort;
	sptr_lsl_packet_header->lsl_packet_type = (USHORT_ENUM (LSL_PACKET_TYPE)) sptr_port->config.lsl_packet_type;
	sptr_lsl_packet_header->protocol_type = (USHORT_ENUM (SNAP_PROTOCOL_ID)) protocol_type;

	if (ip.port[tx_port_number].config.token_ring == TRUE && ip.port[tx_port_number].config.rfc1042_enabled == TRUE)
	{
		uptr_tx_packet->ip.mac_header.ethernet.source_address._ulong =
			uptr_tx_packet->ip.mac_header.ethernet.source_address._ulong | SET_SOURCE_ROUTING_BIT;
	}

#ifdef __IP_DEBUG__
	print_txed_mac_header (sptr_lsl_packet_header);
#endif /* __IP__DEBUG__ */

	keep_count_of_the_type_of_packet_that_was_txed (tx_port_number, uptr_tx_packet);

	send_packet (ip.stack_id, tx_port_number, (ETHERNET_BUFFER *) uptr_tx_packet,
		number_of_bytes, FALSE, forwarded_packet,
		(void (*) (USHORT port_number, void *sptr_ethernet_packet)) fptr_tx_completion);

	return (PASS);
}
/*************************************************************************/
void	keep_count_of_the_type_of_packet_that_was_txed (USHORT tx_port_number, UNION_IP_PACKET *uptr_ip_packet)
{
	enum IP_PROTOCOL_VALUE protocol;

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
	++ip.port[tx_port_number].statistics.number_of_ip_packets_txed;

	protocol = (enum IP_PROTOCOL_VALUE) uptr_ip_packet->ip.header.protocol;

	if (protocol == TCP_PROTOCOL)
		{
		++ip.port[tx_port_number].statistics.number_of_tcp_packets_txed;
		}
	else if (protocol == IGP_PROTOCOL)
		{
		++ip.port[tx_port_number].statistics.number_of_igrp_packets_txed;
		}
	else if (protocol == ICMP_PROTOCOL)
		{
		++ip.port[tx_port_number].statistics.number_of_icmp_packets_txed;
		}
	else if (protocol == UDP_PROTOCOL)
		{
		++ip.port[tx_port_number].statistics.number_of_udp_packets_txed;
		}
	else
		{
		++ip.port[tx_port_number].statistics.number_of_unrecognized_packets_txed;
		}
#endif /* Jo 26/05/99 */
}
/****************************************************************************/
#ifdef _BIG_PROXY_
void print_txed_ip_header (IP_HEADER *sptr_ip_header, USHORT port_number)
{
	char *ptr_to_string;

	if (ip.print_class.ip_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], net_to_host_long (sptr_ip_header->source_ip_address));

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], net_to_host_long (sptr_ip_header->destination_ip_address));

		ptr_to_string += sprintf (ptr_to_string, "IP: txed packet %s --> %s on port %u\n", &ip.print_buffer[0],
			ip.print_buffer_2, port_number);

		ptr_to_string += sprintf (ptr_to_string, "   header: hlen:%u,ver:%u,tos.rel:%u,tos.tgh:%u,tos.del:%u,tos.prec:%u\n",
			sptr_ip_header->version_header_length.header_length,
			sptr_ip_header->version_header_length.version, sptr_ip_header->service_type.high_reliability,
			sptr_ip_header->service_type.high_throughput, sptr_ip_header->service_type.low_delay,
			sptr_ip_header->service_type.precedence);

		ip_printf (IP_TX_PRINTF, &ip.string_to_print[0]);

		ptr_to_string = &ip.string_to_print[0];

		ptr_to_string += sprintf (ptr_to_string,
			"      header: tlen:%u,iden:%u,flg.mf:%u,flg.df:%u,off.hg:%u,off.lw:%u,ttl:%u,proto:%u,cksum:%x\n",
			net_to_host_short (sptr_ip_header->total_length),
			net_to_host_short (sptr_ip_header->identifier),
			sptr_ip_header->flags_fragment_offset.more_fragment_flag, sptr_ip_header->flags_fragment_offset.do_not_fragment_flag,
			sptr_ip_header->flags_fragment_offset.fragment_offset_most_significant_part,
			sptr_ip_header->fragment_offset_least_significant_part, sptr_ip_header->time_to_live, sptr_ip_header->protocol,
			sptr_ip_header->header_checksum);

		ip_printf (IP_TX_PRINTF, &ip.string_to_print[0]);
		}
}
/****************************************************************************/
void print_forwarded_ip_header (IP_HEADER *sptr_ip_header, USHORT port_number)
{
	char *ptr_to_string;

	if (ip.print_class.ip_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], net_to_host_long (sptr_ip_header->source_ip_address));

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], net_to_host_long (sptr_ip_header->destination_ip_address));

		ptr_to_string += sprintf (ptr_to_string, "IP: forwarded packet %s --> %s on port %u\n",
			&ip.print_buffer[0], ip.print_buffer_2, port_number);

		ptr_to_string += sprintf (ptr_to_string, "   header: hlen:%u,ver:%u,tos.rel:%u,tos.tgh:%u,tos.del:%u,tos.prec:%u\n",
			sptr_ip_header->version_header_length.header_length,
			sptr_ip_header->version_header_length.version, sptr_ip_header->service_type.high_reliability,
			sptr_ip_header->service_type.high_throughput, sptr_ip_header->service_type.low_delay,
			sptr_ip_header->service_type.precedence);

		ip_printf (IP_TX_PRINTF, &ip.string_to_print[0]);

		ptr_to_string = &ip.string_to_print[0];

		ptr_to_string += sprintf (ptr_to_string,
			"      header: tlen:%u,iden:%u,flg.mf:%u,flg.df:%u,off.hg:%u,off.lw:%u,ttl:%u,proto:%u,cksum:%x\n",
			net_to_host_short (sptr_ip_header->total_length),
			net_to_host_short (sptr_ip_header->identifier),
			sptr_ip_header->flags_fragment_offset.more_fragment_flag, sptr_ip_header->flags_fragment_offset.do_not_fragment_flag,
			sptr_ip_header->flags_fragment_offset.fragment_offset_most_significant_part,
			sptr_ip_header->fragment_offset_least_significant_part, sptr_ip_header->time_to_live, sptr_ip_header->protocol,
			sptr_ip_header->header_checksum);

		ip_printf (IP_TX_PRINTF, &ip.string_to_print[0]);
		}
}
#endif

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
/****************************************************************************/
void print_txed_mac_header (LSL_IP_HEADER *sptr_lsl_header)
{
	ip_printf (IP_TX_PRINTF, "IP: txed packet mac %8x:%4x --> mac %8x:%4x\n",
		net_to_host_long (sptr_lsl_header->source_address._ulong),
		net_to_host_short (sptr_lsl_header->source_address._ushort),
		net_to_host_long (sptr_lsl_header->destination_address._ulong),
		net_to_host_short (sptr_lsl_header->destination_address._ushort));
}
#endif
/* Jo 23/04/99 */
