#include	"defs.h"
/*
 * $Log: /IP/IPNWCNFG.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<stddef.h>
#include	<string.h>
#include	<stdio.h>
#include "ip.h"
#include	<vnvrmstr.h>
/****************************************************************************/
static enum TEST check_if_configuration_item_and_parameters_are_consistent (ULONG parameter[],enum TEST (*fptr_configuration_function) (char *), CONFIGURATION_FUNCTION *sptr_configuration_item);
static enum BOOLEAN check_if_configuration_operation_is_to_get_value (ULONG parameter[]);
static enum TEST check_if_get_operation_for_configuration_item_has_been_implemented (CONFIGURATION_FUNCTION *sptr_configuration_item);
static enum TEST compose_configuration_string_and_set_value (ULONG parameter[],enum TEST (*fptr_configuration_function) (char *), char parameter_string[]);
static ULONG get_value_string_for_configuration_item (CONFIGURATION_FUNCTION *sptr_configuration_item, ULONG parameter[]);
static enum TEST get_rip_reject_list_entries (ULONG parameter[]);
static enum TEST get_rip_advertise_list_entries (ULONG parameter[]);
static enum TEST get_rip_neighbor_list_entries (ULONG parameter[]);
static enum TEST get_ip_address_string (char **ptr_to_cptr_node_ip_address_string, ULONG ip_address_to_get);
static enum TEST get_ip_default_value_flag (ULONG parameter[]);
static enum TEST get_ip_port_frame_type (ULONG parameter[]);
static enum TEST get_largest_token_ring_frame_size (ULONG parameter[]);
static enum TEST get_static_route_table_entries (ULONG parameter[]);
static enum TEST get_route_information (char **ptr_to_cptr_node_ip_address_string, IP_ROUTE_ENTRY *sptr_route_entry);
static enum TEST get_default_route (ULONG parameter[]);
static enum TEST get_default_route_information (char **ptr_to_cptr_node_ip_address_string, IP_ROUTE_ENTRY *sptr_route_entry);
static enum TEST get_rarp_server_table_entries (ULONG parameter[]);

#ifdef _BIG_PROXY_
static enum TEST get_rarp_table_information (char **ptr_to_cptr_node_ip_address_string, RARP_TABLE_ENTRY *sptr_rarp_entry);
#endif

#ifdef __IP_BREAKPOINT__
static void check_for_ip_configuration_breakpoint (void);
#endif /* __IP_BREAKPOINT__ */
/****************************************************************************/
#ifdef _BIG_PROXY_
ULONG special_configuration_function_processing (ULONG parameter[])
{
	char parameter_string[256];
	enum TEST (*fptr_configuration_function) (char *);
	CONFIGURATION_FUNCTION *sptr_configuration_item;
	ULONG return_value;

#ifdef __IP_BREAKPOINT__
	check_for_ip_configuration_breakpoint ();
#endif /* __IP_BREAKPOINT__ */

	sptr_configuration_item = (CONFIGURATION_FUNCTION *) parameter[0x01];

	fptr_configuration_function = (enum TEST (*) (char *)) sptr_configuration_item->fptr_parameter_function;

	if (check_if_configuration_item_and_parameters_are_consistent (&parameter[0x00],
		fptr_configuration_function, sptr_configuration_item) == FAIL)
		{
		return_value = (ULONG) FAIL;

		return (return_value);
		}

	if (check_if_configuration_operation_is_to_get_value (&parameter[0x00]) == TRUE)
		{
		if (check_if_get_operation_for_configuration_item_has_been_implemented (sptr_configuration_item) == FAIL)
			{
			strcpy ((char *) parameter[0x02], "not supported yet");

			return_value = (ULONG) PASS;

			return (return_value);
			}

		return_value = get_value_string_for_configuration_item (sptr_configuration_item, &parameter[0x00]);
		}
	else 
		{
		return_value = (ULONG) compose_configuration_string_and_set_value (&parameter[0x00], fptr_configuration_function,
			&parameter_string[0x00]);
		}

	return (return_value);
}
#ifdef __IP_BREAKPOINT__
/****************************************************************************/
static void check_for_ip_configuration_breakpoint (void)
{
	if (ip.configuration_breakpoint == TRUE)
		{
		BREAKPOINT;
		}
}
#endif /* __IP_BREAKPOINT__ */
/****************************************************************************/
static enum TEST check_if_configuration_item_and_parameters_are_consistent (ULONG parameter[],
	enum TEST (*fptr_configuration_function) (char *), CONFIGURATION_FUNCTION *sptr_configuration_item)
{
	if (fptr_configuration_function == NULL)
		{
		return (FAIL);
		}

	if ((parameter[0x00] == 0xffffffff) && (strstr (sptr_configuration_item->cptr_parameter_string, "Port ") != NULL))
		{
		return (FAIL);
		}

	if ((parameter[0x00] != 0xffffffff) && (strstr (sptr_configuration_item->cptr_parameter_string, "Port ") == NULL))
		{
		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static enum BOOLEAN check_if_configuration_operation_is_to_get_value (ULONG parameter[])
{
	if ( *((char *) parameter[0x02]) == '\0')
		{
		return (TRUE);
		}

	return (FALSE);
}
/****************************************************************************/
static enum TEST check_if_get_operation_for_configuration_item_has_been_implemented (
	CONFIGURATION_FUNCTION *sptr_configuration_item)
{
	PARAMETER_NOT_USED (sptr_configuration_item);
/*
	if (strstr (sptr_configuration_item->cptr_parameter_string, "IP Port RARP Server Table Entries =") != NULL)
		{
		return (FAIL);
		}
*/

	return (PASS);
}

/****************************************************************************/
static ULONG get_value_string_for_configuration_item (CONFIGURATION_FUNCTION *sptr_configuration_item, ULONG parameter[])
{
	ULONG return_value;

	if (strcmp (sptr_configuration_item->cptr_parameter_string, "IP RIP Neighbor List Entries =") == STRINGS_MATCH)
		{
		return_value = (ULONG) get_rip_neighbor_list_entries (&parameter[0x00]);
		}
	else if (strcmp (sptr_configuration_item->cptr_parameter_string, "IP Port RIP Reject List Entries =") == STRINGS_MATCH)
		{
		return_value = (ULONG) get_rip_reject_list_entries (&parameter[0x00]);
		}
	else if (strcmp (sptr_configuration_item->cptr_parameter_string, "IP Port RIP Advertise List Entries =") == STRINGS_MATCH)
		{
		return_value = (ULONG) get_rip_advertise_list_entries (&parameter[0x00]);
		}
	else if (strcmp (sptr_configuration_item->cptr_parameter_string, "IP Port Frame Type =") == STRINGS_MATCH)
		{
		return_value = (ULONG) get_ip_port_frame_type (&parameter[0x00]);
		}
	else if (strcmp (sptr_configuration_item->cptr_parameter_string, "IP Port Token Ring Largest Frame Size =")
		== STRINGS_MATCH)
		{
		return_value = get_largest_token_ring_frame_size (&parameter[0x00]);
		}
	else if (strcmp (sptr_configuration_item->cptr_parameter_string, "IP Set Default Values =") == STRINGS_MATCH)
		{
		return_value = get_ip_default_value_flag (&parameter[0x00]);
		}
	else if (strcmp (sptr_configuration_item->cptr_parameter_string, "IP Static Route Table Entries =") == STRINGS_MATCH)
		{
		return_value = get_static_route_table_entries (&parameter[0x00]);
		}
	else if (strcmp (sptr_configuration_item->cptr_parameter_string, "IP Default Route =") == STRINGS_MATCH)
		{
		return_value = get_default_route (&parameter[0x00]);
		}
	else if (strcmp (sptr_configuration_item->cptr_parameter_string, "IP Port RARP Server Table Entries =") == STRINGS_MATCH)
		{
		return_value = get_rarp_server_table_entries (&parameter[0x00]);
		}
	else
		{
		strcpy ((char *) parameter[0x02], "not supported yet");

		return_value = (ULONG) PASS;
		}

	return (return_value);
}
/****************************************************************************/
static enum TEST compose_configuration_string_and_set_value (ULONG parameter[], enum TEST (*fptr_configuration_function) (char *),
	char parameter_string[])
{
	enum TEST return_value;

	if (parameter[0x00] != 0xffffffff)
		{
		sprintf (parameter_string, "%02u,%s", parameter[0x00], (char *) parameter[0x02]);
		}
	else
		{
		strcpy (parameter_string, (char *) parameter[0x02]);
		}

	return_value = (*fptr_configuration_function) (parameter_string);

	return (return_value);
}
/****************************************************************************/
static enum TEST get_rip_reject_list_entries (ULONG parameter[])
{
	ULONG port_number;
	char *cptr_ip_address_string;
	RIP_DESTINATION_ENTRY *sptr_destination_entry;

	port_number = parameter[0x00];

	if (port_number >= ip.number_of_ports)
		{
		return (FAIL);
		}

	cptr_ip_address_string = (char *) parameter[0x02];

	sptr_destination_entry = (RIP_DESTINATION_ENTRY *) get_pointer_to_first_entry_in_list (
		(LINK *) &ip.rip.port[port_number].reject_list);

	if (sptr_destination_entry == NULL)
		{
		strcpy (cptr_ip_address_string, "No entries");

		return (PASS);
		}

	while (sptr_destination_entry != NULL)
		{
		get_ip_address_string (&cptr_ip_address_string, sptr_destination_entry->ip_address);

		sptr_destination_entry = (RIP_DESTINATION_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_destination_entry);

		if (sptr_destination_entry != NULL)
			{
			*cptr_ip_address_string = ',';

			cptr_ip_address_string += 1;

			*cptr_ip_address_string = ' ';

			cptr_ip_address_string += 1;
			}
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST get_rip_advertise_list_entries (ULONG parameter[])
{
	ULONG port_number;
	char *cptr_ip_address_string;
	RIP_DESTINATION_ENTRY *sptr_destination_entry;

	port_number = parameter[0x00];

	if (port_number >= ip.number_of_ports)
		{
		return (FAIL);
		}

	cptr_ip_address_string = (char *) parameter[0x02];

	sptr_destination_entry = (RIP_DESTINATION_ENTRY *) get_pointer_to_first_entry_in_list (
		(LINK *) &ip.rip.port[port_number].advertise_list);

	if (sptr_destination_entry == NULL)
		{
		strcpy (cptr_ip_address_string, "No entries");

		return (PASS);
		}

	while (sptr_destination_entry != NULL)
		{
		get_ip_address_string (&cptr_ip_address_string, sptr_destination_entry->ip_address);

		sptr_destination_entry = (RIP_DESTINATION_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_destination_entry);

		if (sptr_destination_entry != NULL)
			{
			*cptr_ip_address_string = ',';

			cptr_ip_address_string += 1;

			*cptr_ip_address_string = ' ';

			cptr_ip_address_string += 1;
			}
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST get_rip_neighbor_list_entries (ULONG parameter[])
{
	char *cptr_ip_address_string;
	RIP_NEIGHBOR_ENTRY *sptr_neighbor_entry;

	cptr_ip_address_string = (char *) parameter[0x02];

	sptr_neighbor_entry = (RIP_NEIGHBOR_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.rip.neighbor_list);

	if (sptr_neighbor_entry == NULL)
		{
		strcpy (cptr_ip_address_string, "No entries");

		return (PASS);
		}

	while (sptr_neighbor_entry != NULL)
		{
		get_ip_address_string (&cptr_ip_address_string, sptr_neighbor_entry->ip_address);

		sptr_neighbor_entry = (RIP_NEIGHBOR_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_neighbor_entry);

		if (sptr_neighbor_entry != NULL)
			{
			*cptr_ip_address_string = ',';

			cptr_ip_address_string += 1;

			*cptr_ip_address_string = ' ';

			cptr_ip_address_string += 1;
			}
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST get_ip_address_string (char **ptr_to_cptr_node_ip_address_string, ULONG ip_address_to_get)
{
	BYTE ip_address_array[SIZE_OF_IP_ADDRESS];

	*((ULONG *) &ip_address_array[0]) = host_to_net_long (ip_address_to_get);

	*ptr_to_cptr_node_ip_address_string += sprintf (*ptr_to_cptr_node_ip_address_string, "%lu.%lu.%lu.%lu",
		(int) ip_address_array[0], (int) ip_address_array[1], (int) ip_address_array[2], (int) ip_address_array[3]);

	return (PASS);
}
/****************************************************************************/
static enum TEST get_ip_default_value_flag (ULONG parameter[])
{
	if (ip.default_values_have_been_set == TRUE)
		{
		strcpy ((char *) parameter[0x02], "enabled");
		}
	else
		{
		strcpy ((char *) parameter[0x02], "disabled");
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST get_ip_port_frame_type (ULONG parameter[])
{
	ULONG port_number;

	port_number = parameter[0x00];

	if (port_number >= ip.number_of_ports)
		{
		return (FAIL);
		}

	switch (ip.port[port_number].config.lsl_packet_type)
		{
		case SNAP_PACKET:

			strcpy ((char *) parameter[0x02], "SNAP");

			break;

		case ETHERNET_TYPE_II:

			strcpy ((char *) parameter[0x02], "TYPE_II");

			break;

		case WAN_PACKET:

			strcpy ((char *) parameter[0x02], "WAN");

			break;

		case SAME_TYPE_AS_RX_PACKET_:

			strcpy ((char *) parameter[0x02], "SAME_TYPE_AS_RX_FRAME");

			break;

		default:

		#ifdef __IP_ALARM_DEBUG__
			ip_printf (IP_ALARM_PRINTF, "IP: CONFIGURATION: failed to get port frame type (for port %d)\n", port_number);
		#endif /* __IP__ALARM_DEBUG__ */

			return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST get_largest_token_ring_frame_size (ULONG parameter[])
{
	ULONG port_number;
	USHORT frame_size;

	port_number = parameter[0x00];

	if (port_number >= ip.number_of_ports)
		{
		return (FAIL);
		}

	switch (ip.port[port_number].config.token_ring_largest_frame)
		{
		case _1470:

			frame_size = 1470;

			break;

		case _2052:

			frame_size = 2052;

			break;

		case _4472:

			frame_size = 4472;

			break;

		case _8144:

			frame_size = 8144;

			break;

		case _11407:

			frame_size = 11407;

			break;

		case _17800:

			frame_size = 17800;

			break;

		case INITIAL_VALUE_OF_BROADCAST_FRAMES:

			frame_size = 0xffff;

			break;

		case _516:
		default:

			frame_size = 516;

			break;
	  }

	sprintf ((char *) parameter[0x02], "%u", frame_size);

	return (PASS);
}
/****************************************************************************/
static enum TEST get_static_route_table_entries (ULONG parameter[])
{
	char *cptr_ip_address_string;
	IP_ROUTE_ENTRY *sptr_route_entry;
	enum BOOLEAN found_static_route;

	found_static_route = FALSE;

	cptr_ip_address_string = (char *) parameter[0x02];

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
	sptr_route_entry = get_first_ip_route_entry ();
#else
	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);
#endif

	if (sptr_route_entry == NULL)
		{
		strcpy (cptr_ip_address_string, "No entries");

		return (PASS);
		}

	while (sptr_route_entry != NULL)
		{
		if ((sptr_route_entry->flags.private_route == TRUE) && (sptr_route_entry->flags.do_no_aging == TRUE))
			{
			get_route_information (&cptr_ip_address_string, sptr_route_entry);

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
			sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
			sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif

			if (sptr_route_entry != NULL)
				{
				*cptr_ip_address_string = ';';

				cptr_ip_address_string += 1;

				*cptr_ip_address_string = ' ';

				cptr_ip_address_string += 1;

				*cptr_ip_address_string = '\0';

				found_static_route = TRUE;
				}
			}
		else
			{
#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
			sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
			sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif
			}
		}

	if (found_static_route == FALSE)
		{
		strcpy (cptr_ip_address_string, "No entries");

		return (PASS);
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST get_route_information (char **ptr_to_cptr_node_ip_address_string, IP_ROUTE_ENTRY *sptr_route_entry)
{
	BYTE target_array[SIZE_OF_IP_ADDRESS];
	BYTE gateway_array[SIZE_OF_IP_ADDRESS];
	BYTE mask_array[SIZE_OF_IP_ADDRESS];

	*((ULONG *) &target_array[0]) = host_to_net_long (sptr_route_entry->target);
	*((ULONG *) &gateway_array[0]) = host_to_net_long (sptr_route_entry->gateway);
	*((ULONG *) &mask_array[0]) = host_to_net_long (sptr_route_entry->mask);

	*ptr_to_cptr_node_ip_address_string += sprintf (*ptr_to_cptr_node_ip_address_string,
		"%lu.%lu.%lu.%lu, %lu.%lu.%lu.%lu, %lu.%lu.%lu.%lu, %lu",
		(int) target_array[0], (int) target_array[1], (int) target_array[2], (int) target_array[3],
		(int) gateway_array[0], (int) gateway_array[1], (int) gateway_array[2], (int) gateway_array[3],
		(int) mask_array[0], (int) mask_array[1], (int) mask_array[2], (int) mask_array[3], (int) sptr_route_entry->metric);

	return (PASS);
}
/****************************************************************************/
static enum TEST get_default_route (ULONG parameter[])
{
	char *cptr_ip_address_string;
	IP_ROUTE_ENTRY *sptr_route_entry;

	cptr_ip_address_string = (char *) parameter[0x02];

	sptr_route_entry = &ip.default_route;

	if (sptr_route_entry == NULL)
		{
		strcpy (cptr_ip_address_string, "No entries");

		return (PASS);
		}

	get_default_route_information (&cptr_ip_address_string, sptr_route_entry);

	return (PASS);
}
/****************************************************************************/
static enum TEST get_default_route_information (char **ptr_to_cptr_node_ip_address_string, IP_ROUTE_ENTRY *sptr_route_entry)
{
	BYTE gateway_array[SIZE_OF_IP_ADDRESS];

	*((ULONG *) &gateway_array[0]) = host_to_net_long (sptr_route_entry->gateway);

	*ptr_to_cptr_node_ip_address_string += sprintf (*ptr_to_cptr_node_ip_address_string, "%lu.%lu.%lu.%lu, %lu",
		(int) gateway_array[0], (int) gateway_array[1], (int) gateway_array[2], (int) gateway_array[3],
		(int) sptr_route_entry->metric);

	return (PASS);
}
/****************************************************************************/
static enum TEST get_rarp_server_table_entries (ULONG parameter[])
{
	ULONG port_number;
	char *cptr_ip_address_string;
	RARP_TABLE_ENTRY *sptr_rarp_entry;

	port_number = parameter[0x00];

	if (port_number >= ip.number_of_ports)
		{
		return (FAIL);
		}

	cptr_ip_address_string = (char *) parameter[0x02];

	sptr_rarp_entry = (RARP_TABLE_ENTRY *) get_pointer_to_first_entry_in_list (
		(LINK *) &ip.rarp.port[port_number].config.current_list);

	if (sptr_rarp_entry == NULL)
		{
		strcpy (cptr_ip_address_string, "No entries");

		return (PASS);
		}

	while (sptr_rarp_entry != NULL)
		{
		get_rarp_table_information (&cptr_ip_address_string, sptr_rarp_entry);

		sptr_rarp_entry = (RARP_TABLE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_rarp_entry);

		if (sptr_rarp_entry != NULL)
			{
			*cptr_ip_address_string = ';';

			cptr_ip_address_string += 1;

			*cptr_ip_address_string = ' ';

			cptr_ip_address_string += 1;

			*cptr_ip_address_string = '\0';
			}
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST get_rarp_table_information (char **ptr_to_cptr_node_ip_address_string, RARP_TABLE_ENTRY *sptr_rarp_entry)
{
	BYTE iaddr_array[SIZE_OF_IP_ADDRESS];
	BYTE haddr_array[SIZE_OF_MAC_ADDRESS];

	*((ULONG *) &iaddr_array[0]) = host_to_net_long (sptr_rarp_entry->ip_address);

	memcpy (&haddr_array[0], &sptr_rarp_entry->hardware_address, sizeof (MAC_ADDRESS));

	*ptr_to_cptr_node_ip_address_string += sprintf (*ptr_to_cptr_node_ip_address_string, "%lu.%lu.%lu.%lu, %x%x%x%x%x%x",
		(int) iaddr_array[0], (int) iaddr_array[1], (int) iaddr_array[2], (int) iaddr_array[3],
		(int) haddr_array[0], (int) haddr_array[1], (int) haddr_array[2],
		(int) haddr_array[3], (int) haddr_array[4], (int) haddr_array[5]);

	return (PASS);
}
#endif
