#include	"defs.h"
/*
 * $Log: /IP/IPOPTNS.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipoptns.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c) (1) (ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<string.h>
#include "ip.h"
/****************************************************************************/
static void	set_up_variables_for_ip_option_processing (BYTE *bptr_options_length, enum BOOLEAN *eptr_strict_source_route_flag,
	IP_PARAMETERS *sptr_ip_parameters);
static void get_pointer_to_ip_option_and_set_option_number (IP_OPTION **ptr_to_sptr_option, BYTE *bptr_option_number,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet);
static enum BOOLEAN check_if_current_option_length_is_valid (USHORT current_option_length, BYTE options_length,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters,
	UNION_ICMP_PARAMETER *uptr_icmp_parameter);
static enum TEST processing_based_on_option_number (BYTE option_number, enum BOOLEAN *eptr_strict_source_route_flag,
	enum BOOLEAN *eptr_source_route_flag, IP_OPTION *sptr_option, USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet,
	IP_PARAMETERS *sptr_ip_parameters, USHORT current_option_length, enum BOOLEAN *eptr_need_new_checksum,
	enum BOOLEAN *eptr_change_ip_destination_for_source_route, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry);
static enum BOOLEAN check_if_current_option_is_supported (BYTE option_number);
/****************************************************************************/

#ifdef _BIG_PROXY_
enum TEST process_ip_options (UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters,
	enum BOOLEAN *eptr_source_route_flag, enum BOOLEAN *eptr_need_new_checksum, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry,
	USHORT *usptr_total_processed_option_length, enum BOOLEAN *eptr_change_ip_destination_for_source_route)
{
	enum BOOLEAN strict_source_route_flag;
	BYTE options_length;
	USHORT current_option_length;
	BYTE option_number;
	USHORT processed_option_length;
	IP_OPTION *sptr_option;
	UNION_ICMP_PARAMETER icmp_parameter;

	set_up_variables_for_ip_option_processing (&options_length, &strict_source_route_flag, sptr_ip_parameters);

	for (processed_option_length = 0x0000; processed_option_length < options_length;
		processed_option_length = (USHORT) (processed_option_length + current_option_length))
		{
		get_pointer_to_ip_option_and_set_option_number (&sptr_option, &option_number, processed_option_length, sptr_ip_packet);

		if (option_number == IP_EOL_OPTION)
			{
			/* options all done */

			*usptr_total_processed_option_length = processed_option_length;

			return (PASS);
			}

		if (option_number == IP_NOOP_OPTION)
			{
			current_option_length = 0x0001;

			continue;
			}

		current_option_length = sptr_option->length;

		if (check_if_current_option_is_supported (option_number) == FALSE)
			{
			continue;
			}

		if (check_if_current_option_length_is_valid (current_option_length, options_length, processed_option_length,
			sptr_ip_packet, sptr_ip_parameters, &icmp_parameter) == FALSE)
			{
			return (FAIL);
			}

		if (processing_based_on_option_number (option_number, &strict_source_route_flag, eptr_source_route_flag, sptr_option,
			processed_option_length, sptr_ip_packet, sptr_ip_parameters, current_option_length, eptr_need_new_checksum,
			eptr_change_ip_destination_for_source_route, ptr_to_sptr_route_entry) == FAIL)
			{
			return (FAIL);
			}
	 	}

	*usptr_total_processed_option_length = processed_option_length;

	return (PASS);
}
/****************************************************************************/
static enum BOOLEAN check_if_current_option_is_supported (BYTE option_number)
{
	switch (option_number)
		{
		case IP_EOL_OPTION:
		case IP_NOOP_OPTION:
		case IP_LOOSE_SOURCE_ROUTE_OPTION:
		case IP_STRICT_SOURCE_ROUTE_OPTION:
		case IP_RECORD_ROUTE_OPTION:

			/* the above options are supported */

			return (TRUE);

		case IP_SECURITY_OPTION:
		case IP_STREAM_ID_OPTION:
		case IP_TIMESTAMP_OPTION:
		default:

			/* the above options are not yet supported */

			return (FALSE);
		}
}
/****************************************************************************/
static void	set_up_variables_for_ip_option_processing (BYTE *bptr_options_length, enum BOOLEAN *eptr_strict_source_route_flag,
	IP_PARAMETERS *sptr_ip_parameters)
{
	*bptr_options_length = sptr_ip_parameters->options_length;

	*eptr_strict_source_route_flag = FALSE;
}
/****************************************************************************/
static void get_pointer_to_ip_option_and_set_option_number (IP_OPTION **ptr_to_sptr_option, BYTE *bptr_option_number,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet)
{
	*ptr_to_sptr_option = (IP_OPTION *) (&sptr_ip_packet->ip.options_or_data + processed_option_length);

	*bptr_option_number = (BYTE) (*ptr_to_sptr_option)->code.option_number;
}
/****************************************************************************/
static enum BOOLEAN check_if_current_option_length_is_valid (USHORT current_option_length, BYTE options_length,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters,
	UNION_ICMP_PARAMETER *uptr_icmp_parameter)
{
	if ((current_option_length == MINIMUM_IP_OPTION_SIZE) || ((options_length - processed_option_length) < current_option_length))
		{
#ifdef _BIG_PROXY_
		++ip.mib.ipInHdrErrors;
#endif
		uptr_icmp_parameter->pointer = (BYTE) (MINIMUM_IP_HEADER_LENGTH + processed_option_length);

		send_icmp_error_packet (sptr_ip_parameters->rx_port_number, sptr_ip_parameters, sptr_ip_packet,
			ICMP_PARAMETER_PROBLEM_TYPE, 0, uptr_icmp_parameter);

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static enum TEST processing_based_on_option_number (BYTE option_number, enum BOOLEAN *eptr_strict_source_route_flag,
	enum BOOLEAN *eptr_source_route_flag, IP_OPTION *sptr_option, USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet,
	IP_PARAMETERS *sptr_ip_parameters, USHORT current_option_length, enum BOOLEAN *eptr_need_new_checksum,
	enum BOOLEAN *eptr_change_ip_destination_for_source_route, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry)
{
	switch (option_number)
		{
		case IP_STRICT_SOURCE_ROUTE_OPTION: 			/* Strict source route & record route */

			*eptr_strict_source_route_flag = TRUE;

			/* control flows through into next switch case */

		case IP_LOOSE_SOURCE_ROUTE_OPTION: 				/* Loose source route & record route */

			*eptr_source_route_flag = TRUE;

			if (process_source_route_option (sptr_option, processed_option_length, sptr_ip_packet, sptr_ip_parameters,
				*eptr_strict_source_route_flag, current_option_length, eptr_need_new_checksum,
				eptr_change_ip_destination_for_source_route, ptr_to_sptr_route_entry) == FAIL)
				{
				return (FAIL);
				}

			break;

		case IP_RECORD_ROUTE_OPTION: 						/* record route */

			if (process_record_route_option (sptr_option, processed_option_length, sptr_ip_packet, sptr_ip_parameters,
				current_option_length, eptr_need_new_checksum, ptr_to_sptr_route_entry) == FAIL)
				{
				return (FAIL);
				}

			break;

		case IP_TIMESTAMP_OPTION:
		case IP_SECURITY_OPTION:
			/* not supported */
		default:

			break;
		}

	return (PASS);
}
/****************************************************************************/
/* Clear options that should not be copied into all fragmented datagrams */

enum TEST clear_options (BYTE *bptr_option, USHORT option_length)
{
	BYTE *bptr_current_option;
	USHORT processed_option_length;
	USHORT current_option_length;
	BYTE option_number;
	USHORT length_index;
	IP_OPTION *sptr_option;
	enum TEST return_value;

	return_value = FAIL;

	for (processed_option_length = 0x0000; processed_option_length < option_length;
		processed_option_length = (USHORT) (processed_option_length + current_option_length))
		{
		bptr_current_option = bptr_option + processed_option_length;

		sptr_option = (IP_OPTION *) bptr_current_option;

		option_number = (BYTE) sptr_option->code.option_number;

		if (option_number == IP_EOL_OPTION)
			{
			/* options all done */

			return (return_value);
			}

		if (option_number == IP_NOOP_OPTION)
			{
			current_option_length = 0x0001;

			continue;
			}

		current_option_length = sptr_option->length;

		if (sptr_option->code.copy_option_on_fragmentation == FALSE)
			{
			/* Clear this option with NOOP */

			for (length_index = 0x0000; length_index < current_option_length; ++length_index)
				{
				*bptr_current_option = IP_NOOP_OPTION;

				++bptr_current_option;
				}
			}
		else
			{
			return_value = PASS;
			}
		}

	return (return_value);
}
#endif
