#include	"defs.h"
/*
 * $Log: /IP/IPREASSM.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipreassm.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ip.h"
/****************************************************************************/
void scan_fragment_list_for_the_appropriate_position_for_current_packet (REASSEMBLY *sptr_reassembly,
	USHORT first_byte_offset_of_current_packet, FRAGMENT **ptr_to_sptr_last_fragment, FRAGMENT **ptr_to_sptr_next_fragment);
enum TEST check_and_adjust_for_overlap_with_preceeding_fragment (FRAGMENT *sptr_last_fragment,
	USHORT *usptr_first_byte_offset_of_current_packet, IP_LIST_PACKET *uptr_ip_rx_packet);
enum TEST check_and_adjust_for_overlap_with_succeeding_fragment (FRAGMENT **ptr_to_sptr_next_fragment,
	USHORT last_byte_offset_of_current_packet, REASSEMBLY *sptr_reassembly);
FRAGMENT *trim_succeeding_fragments (FRAGMENT *sptr_next_fragment, REASSEMBLY *sptr_reassembly,
	USHORT last_byte_offset_of_current_packet);
void trim_data_from_fragment (FRAGMENT *sptr_fragment, USHORT number_of_bytes_to_trim);
void	determine_whether_the_packet_is_to_be_inserted_or_to_be_merged (enum REASSEMBLY_QUEUE_ACTION *eptr_action,
	FRAGMENT *sptr_last_fragment, FRAGMENT *sptr_next_fragment, USHORT first_byte_offset_of_current_packet,
	USHORT last_byte_offset_of_current_packet);
enum TEST create_and_insert_new_fragment_structure (FRAGMENT **ptr_to_sptr_fragment,
	USHORT first_byte_offset_of_current_packet, USHORT last_byte_offset_of_current_packet, IP_LIST_PACKET *uptr_ip_rx_packet,
	REASSEMBLY *sptr_reassembly, FRAGMENT *sptr_last_fragment, FRAGMENT *sptr_next_fragment);
FRAGMENT *get_new_fragment (USHORT offset, USHORT offset_of_last_byte, IP_LIST_PACKET *sptr_ip_list_packet);
void	merge_packet_with_preceeding_fragment (FRAGMENT *sptr_last_fragment, IP_LIST_PACKET *uptr_ip_rx_packet,
	USHORT last_byte_offset_of_current_packet);
void	merge_packet_with_succeeding_fragment (FRAGMENT *sptr_next_fragment, IP_LIST_PACKET *uptr_ip_rx_packet,
	USHORT first_byte_offset_of_current_packet);
void merge_packet_and_succeeding_fragment_into_the_preceeding_fragment (FRAGMENT *sptr_last_fragment,
	IP_LIST_PACKET *uptr_ip_rx_packet, FRAGMENT *sptr_next_fragment);
enum TEST copy_ip_list_packet_to_union_ip_packet (IP_LIST_PACKET *sptr_ip_list_packet, USHORT size_of_ip_data,
	UNION_IP_PACKET **ptr_to_uptr_ip_rx_packet);
void	update_ip_parameters_for_reassembled_union_ip_packet (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_packet);

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
void print_list_of_fragments (REASSEMBLY *sptr_reassembly);
#endif
/* Jo 23/04/99 */

/****************************************************************************/
enum TEST put_packet_into_reassembly_queue (REASSEMBLY *sptr_reassembly, USHORT first_byte_offset_of_current_packet,
	USHORT last_byte_offset_of_current_packet, IP_LIST_PACKET *sptr_ip_list_packet)
{
	FRAGMENT *sptr_last_fragment;
	FRAGMENT *sptr_next_fragment;
	FRAGMENT *sptr_fragment;
	enum REASSEMBLY_QUEUE_ACTION action;							/* bit map */

	scan_fragment_list_for_the_appropriate_position_for_current_packet (sptr_reassembly, first_byte_offset_of_current_packet,
		&sptr_last_fragment, &sptr_next_fragment);

	if (check_and_adjust_for_overlap_with_preceeding_fragment (sptr_last_fragment, &first_byte_offset_of_current_packet,
		sptr_ip_list_packet) == FAIL)
		{
		return (FAIL);
		}

	check_and_adjust_for_overlap_with_succeeding_fragment (&sptr_next_fragment, last_byte_offset_of_current_packet,
		sptr_reassembly);

	determine_whether_the_packet_is_to_be_inserted_or_to_be_merged (&action, sptr_last_fragment, sptr_next_fragment,
		first_byte_offset_of_current_packet, last_byte_offset_of_current_packet);

	switch (action)
		{
		case INSERT_NO_MERGE:

			if (create_and_insert_new_fragment_structure (&sptr_fragment, first_byte_offset_of_current_packet,
				last_byte_offset_of_current_packet, sptr_ip_list_packet, sptr_reassembly, sptr_last_fragment, sptr_next_fragment)
				== FAIL)
				{
				return (FAIL);
				}

		#ifdef __IP_DEBUG__
			ip_printf (IP_REASSEMBLY_PRINTF, "IP: fragment inserted in reassembly queue\n");
		#endif /* __IP__DEBUG__ */

			break;

		case MERGE_WITH_PRECEEDING_FRAGMENT:

			merge_packet_with_preceeding_fragment (sptr_last_fragment, sptr_ip_list_packet, last_byte_offset_of_current_packet);

		#ifdef __IP_DEBUG__
			ip_printf (IP_REASSEMBLY_PRINTF, "IP: fragment merged with preceeding fragment\n");
		#endif /* __IP__DEBUG__ */

			break;

		case MERGE_WITH_SUCCEEDING_FRAGMENT:

			merge_packet_with_succeeding_fragment (sptr_next_fragment, sptr_ip_list_packet, first_byte_offset_of_current_packet);

		#ifdef __IP_DEBUG__
			ip_printf (IP_REASSEMBLY_PRINTF, "IP: fragment merged with succeeding fragment\n");
		#endif /* __IP__DEBUG__ */

			break;

		case (MERGE_PACKET_AND_SUCCEEDING_FRAGMENT_WITH_PRECEEDING_FRAGMENT):

			merge_packet_and_succeeding_fragment_into_the_preceeding_fragment (sptr_last_fragment, sptr_ip_list_packet,
				sptr_next_fragment);

		#ifdef __IP_DEBUG__
			ip_printf (IP_REASSEMBLY_PRINTF, "IP: packet and succeeding fragment merged with preceeding fragment\n");
		#endif /* __IP__DEBUG__ */

			break;
		}


/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
	print_reassembly_control_block (sptr_reassembly);
	print_list_of_fragments (sptr_reassembly);
#endif
/* Jo 23/04/99 */

	return (PASS);
}
/****************************************************************************/
void scan_fragment_list_for_the_appropriate_position_for_current_packet (REASSEMBLY *sptr_reassembly,
	USHORT first_byte_offset_of_current_packet, FRAGMENT **ptr_to_sptr_last_fragment, FRAGMENT **ptr_to_sptr_next_fragment)
{
	/* Set sptr_next_fragment to the first fragment which begins after us, and sptr_last_fragment to the last fragment which
	 *	begins before us. */

	*ptr_to_sptr_last_fragment = NULL;

	for (*ptr_to_sptr_next_fragment = sptr_reassembly->sptr_fragment_link; *ptr_to_sptr_next_fragment != NULL;
		*ptr_to_sptr_next_fragment = (*ptr_to_sptr_next_fragment)->sptr_forward)
	{
		if ((*ptr_to_sptr_next_fragment)->offset >= first_byte_offset_of_current_packet)
			break;
		*ptr_to_sptr_last_fragment = *ptr_to_sptr_next_fragment;
	}
}
/****************************************************************************/
enum TEST check_and_adjust_for_overlap_with_preceeding_fragment (FRAGMENT *sptr_last_fragment,
	USHORT *usptr_first_byte_offset_of_current_packet, IP_LIST_PACKET *sptr_ip_list_packet)
{
	USHORT number_of_bytes_overlapped;

	/* Check and adjust for overlap with preceeding fragment */

	if ((sptr_last_fragment != NULL) && (*usptr_first_byte_offset_of_current_packet < sptr_last_fragment->offset_of_last_byte))
	{
		number_of_bytes_overlapped = (USHORT) (sptr_last_fragment->offset_of_last_byte -
			*usptr_first_byte_offset_of_current_packet);

	#ifdef __IP_DEBUG__
		ip_printf (IP_REASSEMBLY_PRINTF, "IP: fragment overlaps with preceding fragment for %d bytes\n",
			number_of_bytes_overlapped);
	#endif /* __IP__DEBUG__ */

		if (sptr_ip_list_packet->header.byte_count <= number_of_bytes_overlapped)
		{
#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
			++ip.statistics.ipReasmOverlap;
#endif /* Jo 26/05/99 */

			return (FAIL);
		}
		else
		{
			/* Trim overlap on the current packet */

			sptr_ip_list_packet->header.vptr_data = (BYTE *) sptr_ip_list_packet->header.vptr_data + number_of_bytes_overlapped;

			sptr_ip_list_packet->header.byte_count = (USHORT) (sptr_ip_list_packet->header.byte_count -
				number_of_bytes_overlapped);

			*usptr_first_byte_offset_of_current_packet = (USHORT) (*usptr_first_byte_offset_of_current_packet +
				number_of_bytes_overlapped);

		#ifdef __IP_DEBUG__
			ip_printf (IP_REASSEMBLY_PRINTF, "IP: trimmed overlap on the current fragment\n");
		#endif /* __IP__DEBUG__ */
		}
	}
	return (PASS);
}
/****************************************************************************/
enum TEST check_and_adjust_for_overlap_with_succeeding_fragment (FRAGMENT **ptr_to_sptr_next_fragment,
	USHORT last_byte_offset_of_current_packet, REASSEMBLY *sptr_reassembly)
{
	/* Look for overlap with succeeding fragments */

	if ((*ptr_to_sptr_next_fragment != NULL) && ((*ptr_to_sptr_next_fragment)->offset <= last_byte_offset_of_current_packet))
	{
	#ifdef __IP_DEBUG__
		ip_printf (IP_REASSEMBLY_PRINTF, "IP: fragment overlaps with succeeding fragment\n");
	#endif /* __IP__DEBUG__ */

		*ptr_to_sptr_next_fragment = trim_succeeding_fragments (*ptr_to_sptr_next_fragment, sptr_reassembly,
			last_byte_offset_of_current_packet);
	}

	return (PASS);
}
/****************************************************************************/
FRAGMENT *trim_succeeding_fragments (FRAGMENT *sptr_next_fragment, REASSEMBLY *sptr_reassembly,
	USHORT last_byte_offset_of_current_packet)
{
	USHORT number_of_bytes_overlapped;
	FRAGMENT *sptr_fragment;

	while (sptr_next_fragment != NULL)
	{
		sptr_fragment = sptr_next_fragment->sptr_forward;

		if (sptr_next_fragment->offset > last_byte_offset_of_current_packet)
			/* No overlap, OK */
			break;

		/* Overlap: trim overlapped data out of succeeding fragments */

		number_of_bytes_overlapped = (USHORT) (last_byte_offset_of_current_packet - sptr_next_fragment->offset + 1);

		if (sptr_next_fragment->list_packet_links.sptr_forward_link->byte_count <= number_of_bytes_overlapped)
		{
			/* Next fragment is all overlapped by the current fragment, delete the next fragment from list */

			if (sptr_next_fragment->sptr_backward != NULL)
			{
				/* Next fragment was not the first fragment in the list */
				sptr_next_fragment->sptr_backward->sptr_forward = sptr_next_fragment->sptr_forward;
			}
			else
				/* Next fragment was the first fragment in the list */
					sptr_reassembly->sptr_fragment_link = sptr_next_fragment->sptr_forward;

			if (sptr_fragment->sptr_forward != NULL)
				sptr_next_fragment->sptr_forward->sptr_backward = sptr_next_fragment->sptr_backward;

			free_fragment (sptr_next_fragment);
		}
		else
		{
			/* Next fragment is partially overlapped by the current fragment, trim next fragment */

			sptr_next_fragment->offset = last_byte_offset_of_current_packet;
			trim_data_from_fragment (sptr_next_fragment, number_of_bytes_overlapped);
		}
		sptr_next_fragment = sptr_fragment;
	}
	return (sptr_next_fragment);
}
/****************************************************************************/
void trim_data_from_fragment (FRAGMENT *sptr_fragment, USHORT number_of_bytes_to_trim)
{
	IP_LIST_PACKET *sptr_ip_list_packet;

	sptr_ip_list_packet = (IP_LIST_PACKET *) sptr_fragment->list_packet_links.sptr_forward_link;

	while (number_of_bytes_to_trim)
	{
		if (sptr_ip_list_packet->header.byte_count > number_of_bytes_to_trim)
		{
			sptr_ip_list_packet->header.vptr_data = (void *) ((BYTE *) sptr_ip_list_packet->header.vptr_data +
				number_of_bytes_to_trim);

			sptr_ip_list_packet->header.byte_count = (USHORT) (sptr_ip_list_packet->header.byte_count - number_of_bytes_to_trim);

			return;
		}
		else if (sptr_ip_list_packet->header.byte_count == number_of_bytes_to_trim)
		{
			sptr_fragment->list_packet_links.sptr_forward_link =
				(LIST_HEADER *) sptr_ip_list_packet->header.links.sptr_forward_link;

			free_ip_list_packet (sptr_ip_list_packet);
			return;
		}
		else
		{
			number_of_bytes_to_trim = (USHORT) (number_of_bytes_to_trim - sptr_ip_list_packet->header.byte_count);
			sptr_fragment->list_packet_links.sptr_forward_link =
				(LIST_HEADER *) sptr_ip_list_packet->header.links.sptr_forward_link;
			free_ip_list_packet (sptr_ip_list_packet);
			sptr_ip_list_packet = (IP_LIST_PACKET *) sptr_fragment->list_packet_links.sptr_forward_link;
		}
	}
}
/****************************************************************************/
void	determine_whether_the_packet_is_to_be_inserted_or_to_be_merged (enum REASSEMBLY_QUEUE_ACTION *eptr_action,
	FRAGMENT *sptr_last_fragment, FRAGMENT *sptr_next_fragment, USHORT first_byte_offset_of_current_packet,
	USHORT last_byte_offset_of_current_packet)
{
	*eptr_action = INSERT_NO_MERGE;

	if ((sptr_last_fragment != NULL) && (sptr_last_fragment->offset_of_last_byte == (first_byte_offset_of_current_packet - 1)))
		{
		*eptr_action = (enum REASSEMBLY_QUEUE_ACTION) ((BYTE) *eptr_action | (BYTE) MERGE_WITH_PRECEEDING_FRAGMENT);
		}

	if ((sptr_next_fragment != NULL) && (sptr_next_fragment->offset == (last_byte_offset_of_current_packet + 1)))
		{
		*eptr_action = (enum REASSEMBLY_QUEUE_ACTION) ((BYTE) *eptr_action | (BYTE) MERGE_WITH_SUCCEEDING_FRAGMENT);
		}
}
/****************************************************************************/
enum TEST create_and_insert_new_fragment_structure (FRAGMENT **ptr_to_sptr_fragment,
	USHORT first_byte_offset_of_current_packet, USHORT last_byte_offset_of_current_packet, IP_LIST_PACKET *sptr_ip_list_packet,
	REASSEMBLY *sptr_reassembly, FRAGMENT *sptr_last_fragment, FRAGMENT *sptr_next_fragment)
{
	/* create a new fragment structure with this ip_list_packet */

	*ptr_to_sptr_fragment = get_new_fragment (first_byte_offset_of_current_packet, last_byte_offset_of_current_packet,
		sptr_ip_list_packet);

	if (*ptr_to_sptr_fragment == NULL)
	{
#ifdef _BIG_PROXY_
		++ip.mib.ipReasmFails;
#endif
		return (FAIL);
	}

	(*ptr_to_sptr_fragment)->sptr_backward = sptr_last_fragment;
	(*ptr_to_sptr_fragment)->sptr_forward = sptr_next_fragment;

	if (sptr_last_fragment != NULL)
		sptr_last_fragment->sptr_forward = *ptr_to_sptr_fragment; 									/* Middle of list */
	else
		sptr_reassembly->sptr_fragment_link = *ptr_to_sptr_fragment;

	if (sptr_next_fragment != NULL)
		sptr_next_fragment->sptr_backward = *ptr_to_sptr_fragment;

	return (PASS);
}
/****************************************************************************/
FRAGMENT *get_new_fragment (USHORT offset, USHORT offset_of_last_byte, IP_LIST_PACKET *sptr_ip_list_packet)
{
	FRAGMENT *sptr_fragment;

	sptr_fragment = (FRAGMENT *) table_malloc (1, sizeof (FRAGMENT));

	if (sptr_fragment == NULL)
	{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: table_malloc () failed\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (NULL);
	}

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "IP: allocated fragment %p\n", sptr_fragment);
#endif /* __IP__DEBUG__ */

	sptr_fragment->offset = offset;
	sptr_fragment->offset_of_last_byte = offset_of_last_byte;

	add_entry_to_list ((LINK *) &sptr_fragment->list_packet_links, (LINK *) &sptr_ip_list_packet->header.links);
	return (sptr_fragment);
}
/****************************************************************************/
void	merge_packet_with_preceeding_fragment (FRAGMENT *sptr_last_fragment, IP_LIST_PACKET *sptr_ip_list_packet,
	USHORT last_byte_offset_of_current_packet)
{
	/* put ip_list_packet to the end of ip_list_packet chain in the preceeding fragment block */

	add_entry_to_list ((LINK *) &sptr_last_fragment->list_packet_links, (LINK *) &sptr_ip_list_packet->header.links);
	sptr_last_fragment->offset_of_last_byte = last_byte_offset_of_current_packet;							/* Extend forward */
}
/****************************************************************************/
void	merge_packet_with_succeeding_fragment (FRAGMENT *sptr_next_fragment, IP_LIST_PACKET *sptr_ip_list_packet,
	USHORT first_byte_offset_of_current_packet)
{
	/* put ip_list_packet to the top of ip_list_packet chain in the succeeding fragment block */

	add_entry_to_front_of_list ((LINK *) &sptr_next_fragment->list_packet_links, (LINK *) &sptr_ip_list_packet->header.links);
	sptr_next_fragment->offset = first_byte_offset_of_current_packet;
}
/****************************************************************************/
void merge_packet_and_succeeding_fragment_into_the_preceeding_fragment (FRAGMENT *sptr_last_fragment,
	IP_LIST_PACKET *sptr_ip_list_packet, FRAGMENT *sptr_next_fragment)
{
	/* Merge this packet and the succeeding fragment into the preceeding fragment and delete the succeeding fragment
	 * control block. */

	add_entry_to_list ((LINK *) &sptr_last_fragment->list_packet_links, (LINK *) &sptr_ip_list_packet->header.links);

	add_entry_to_list ((LINK *) &sptr_last_fragment->list_packet_links,
		(LINK *) sptr_next_fragment->list_packet_links.sptr_forward_link);

	sptr_last_fragment->offset_of_last_byte = sptr_next_fragment->offset_of_last_byte;

	sptr_last_fragment->sptr_forward = sptr_next_fragment->sptr_forward;

	if (sptr_next_fragment->sptr_forward != NULL)
		sptr_next_fragment->sptr_forward->sptr_backward = sptr_last_fragment;
	free_fragment (sptr_next_fragment);
}
/****************************************************************************/
void free_fragment (FRAGMENT *sptr_fragment)
{
	if (sptr_fragment->list_packet_links.sptr_forward_link != NULL)
		free_ip_list_packet ((IP_LIST_PACKET *) sptr_fragment->list_packet_links.sptr_forward_link);

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "IP: freeing fragment %p\n", sptr_fragment);
#endif /* __IP__DEBUG__ */

	table_free (sptr_fragment);
}
/****************************************************************************/
enum TEST check_if_the_whole_datagram_has_been_reassembled (UNION_IP_PACKET **ptr_to_uptr_ip_rx_packet,
	IP_PARAMETERS *sptr_ip_parameters, REASSEMBLY *sptr_reassembly)
{
	/* check if the whole datagram has been reassembled */

	if ((sptr_reassembly->sptr_fragment_link->offset == 0) && (sptr_reassembly->sptr_fragment_link->sptr_forward == NULL) &&
		(sptr_reassembly->length != 0))
	{
		sptr_reassembly->length = (USHORT) (sptr_reassembly->sptr_fragment_link->offset_of_last_byte + 1);

	#ifdef __IP_DEBUG__
		ip_printf (IP_REASSEMBLY_PRINTF, "IP: length of reassembled packet %u\n", sptr_reassembly->length);
	#endif /* __IP__DEBUG__ */

		/* yes, all done! */

		copy_ip_list_packet_to_union_ip_packet (
			(IP_LIST_PACKET *) sptr_reassembly->sptr_fragment_link->list_packet_links.sptr_forward_link,
			sptr_reassembly->length, ptr_to_uptr_ip_rx_packet);

		update_ip_parameters_for_reassembled_union_ip_packet (sptr_ip_parameters, *ptr_to_uptr_ip_rx_packet);

		free_reassembly (sptr_reassembly);
#ifdef _BIG_PROXY_
		++ip.mib.ipReasmOKs;
#endif
		return (PASS);
	}

	return (FAIL);
}
/****************************************************************************/
enum TEST copy_ip_list_packet_to_union_ip_packet (IP_LIST_PACKET *sptr_ip_list_packet, USHORT size_of_ip_data,
	UNION_IP_PACKET **ptr_to_uptr_ip_rx_packet)
{
	UNION_IP_PACKET *uptr_ip_packet;
	USHORT size_of_ip_packet;
	USHORT ip_header_length;
	BYTE *bptr_to_copy_from;
	BYTE *bptr_to_copy_to;
	USHORT size_to_copy;
	USHORT checksum;

	ip_header_length = (USHORT) (sptr_ip_list_packet->type.ip.header.version_header_length.header_length << 2);

	size_of_ip_packet = (USHORT) (size_of_ip_data + ip_header_length + sizeof (UNION_MAC_HEADER));

	uptr_ip_packet = get_an_ip_send_packet (0x0000, size_of_ip_packet);

	bptr_to_copy_to = (BYTE *) &uptr_ip_packet->ip.mac_header;

	size_to_copy = (USHORT) (sptr_ip_list_packet->header.number_of_bytes - sizeof (LIST_HEADER));

	bptr_to_copy_from = (BYTE *) &sptr_ip_list_packet->type;

	while (sptr_ip_list_packet != NULL)
	{
	#ifdef __IP_DEBUG__
/*	Jo	ip_printf (IP_REASSEMBLY_PRINTF, "IP: copying %u bytes into union ip packet\n", size_to_copy); */
	#endif /* __IP__DEBUG__ */

		memcpy ((void *) bptr_to_copy_to, (void *) bptr_to_copy_from, size_to_copy);

		sptr_ip_list_packet = (IP_LIST_PACKET *) sptr_ip_list_packet->header.links.sptr_forward_link;

		if (sptr_ip_list_packet != NULL)
		{
			bptr_to_copy_to = bptr_to_copy_to + size_to_copy;
			size_to_copy = sptr_ip_list_packet->header.byte_count;
			bptr_to_copy_from = (BYTE *) sptr_ip_list_packet->header.vptr_data;
		}
	}

	uptr_ip_packet->ip.header.total_length = host_to_net_short ((USHORT) (size_of_ip_data + ip_header_length));
	uptr_ip_packet->ip.header.flags_fragment_offset.more_fragment_flag = FALSE;
	uptr_ip_packet->ip.header.header_checksum = 0x0000;

	checksum = calculate_ip_checksum (NULL, (BYTE *) &uptr_ip_packet->ip.header, ip_header_length);

	if (checksum == 0x0000)
		checksum = 0xffff;

	uptr_ip_packet->ip.header.header_checksum = checksum;
	*ptr_to_uptr_ip_rx_packet = uptr_ip_packet;
	return (PASS);
}
/****************************************************************************/
void	update_ip_parameters_for_reassembled_union_ip_packet (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_packet)
{
	IP_HEADER *sptr_ip_pdu;
	USHORT header_length;

	sptr_ip_pdu = &uptr_ip_packet->ip.header;

	header_length = (USHORT) (sptr_ip_pdu->version_header_length.header_length << 2);

	extract_ip_header (sptr_ip_parameters, sptr_ip_pdu, header_length);


/* Sachin 14th May, 1997 */
/* When we Free the buffer we should know the port number on which the buffer
is allocated. We use port number 0 when we get a buffer in function
copy_ip_list_packet_to_union_ip_packet. So set the port number 0 here. */

   sptr_ip_parameters->rx_port_number = 0x0000;

/* Sachin 14th May, 1997 */

	sptr_ip_parameters->union_ip_packet_is_to_be_freed = TRUE;
}

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
void print_list_of_fragments (REASSEMBLY *sptr_reassembly)
{
	FRAGMENT *sptr_fragment;

	if (ip.print_class.ip_printing_enabled == TRUE)
		{
		sptr_fragment = sptr_reassembly->sptr_fragment_link;

		ip_printf (IP_REASSEMBLY_PRINTF, "IP: list of fragments:\n");

		while (sptr_fragment != NULL)
			{
			ip_printf (IP_REASSEMBLY_PRINTF, "fragment: fwdptr:%p,bkdptr:%p,fwdlnk:%p,offset:%u,off.lastbyte%u\n",
				sptr_fragment->sptr_forward, sptr_fragment->sptr_backward, sptr_fragment->list_packet_links.sptr_forward_link,
				sptr_fragment->offset, sptr_fragment->offset_of_last_byte);

			sptr_fragment = sptr_fragment->sptr_forward;
			}
		}
}
#endif
/* Jo 23/04/99 */
