#include	"defs.h"
/*
 * $Log: /IP/IPREMACC.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipremacc.c$  $version: 1.8$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/10/94 ross
1.1 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.2 11/04/94 ross remote access testing and fixes.
1.3 12/20/94 ross
1.4 12/27/94 ross added better table instrumentation via new snmp.
1.5 12/27/94 ross added copyright.
1.6 01/17/95 ross fixed arp problems from snmp
1.7 01/26/95 ross SNMP name change, printf change.
1.8 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<stdlib.h>
#include	"ip.h"

/* Jo Added for RAS 03/06/99 */
void print_RAC_list (void) ;

/*************************************************************************/
/*
	This function simply traverses thru' the remote access client-list and
	returns a pointer to the node that has information about the client that
	matches the ip-address, passed as the parameter
*/
REMOTE_ACCESS_TABLE_ENTRY *find_remote_access_target (ULONG target_protocol_address)
{
	REMOTE_ACCESS_TABLE_ENTRY *sptr_remote_access_entry;

	for (sptr_remote_access_entry = (REMOTE_ACCESS_TABLE_ENTRY *) ip.remote_access.client_list.sptr_forward_link;
		sptr_remote_access_entry != NULL; sptr_remote_access_entry = sptr_remote_access_entry->links.sptr_forward_link)
	{
		if (sptr_remote_access_entry->ip_address == target_protocol_address)
			break;
	}
	return (sptr_remote_access_entry);
}


/*************************************************************************/
/*
	This function is called (from ip_control()) as soon as the port comes up.
	Here, a node is added to the client-list for the new port, with remote
	port number and the remote ip-address. The IP address is also added to
	the arp table.
*/
REMOTE_ACCESS_TABLE_ENTRY *remote_access_client_up (USHORT rx_port_number,ULONG ip_address)
{
	REMOTE_ACCESS_TABLE_ENTRY *sptr_remote_access_entry;

	sptr_remote_access_entry = NULL;

	if (ip.port[rx_port_number].config.remote_access_enabled == TRUE)
	{
		/* printf ("Remote access client up on port %d\n", rx_port_number) ; */

		sptr_remote_access_entry = find_remote_access_target (ip_address);

		if (sptr_remote_access_entry == NULL)
		{
			sptr_remote_access_entry = (REMOTE_ACCESS_TABLE_ENTRY *) table_malloc (1,sizeof (REMOTE_ACCESS_TABLE_ENTRY));

			if (sptr_remote_access_entry != NULL)
			{
				sptr_remote_access_entry->remote_port_number = rx_port_number;
				sptr_remote_access_entry->lan_port_number = ip.port[rx_port_number].config.lan_port_number; 
				sptr_remote_access_entry->ip_address = ip_address;

				/* printf ("Adding entry for port %d to RAC list\n", rx_port_number) ; */
				add_entry_to_list ((LINK *) &ip.remote_access.client_list,(LINK *) &sptr_remote_access_entry->links);
				/* print_RAC_list () ; */

				/* printf ("Adding entry for port %d to ARP table\n", rx_port_number) ; */
				add_entry_to_arp_table (rx_port_number,ip_address,
					&ip.port[sptr_remote_access_entry->lan_port_number].mac_address,STATIC_ARP_ENTRY,NULL);

				/* arp_print_table (); */
			}
			else
			{
			#ifdef __IP_ALARM_DEBUG__
				ip_printf (IP_ALARM_PRINTF, "IP/REMACC: table_malloc failed\n");
			#endif /* __IP__ALARM_DEBUG__ */

				return (NULL);
			}
		}
	}

	return (sptr_remote_access_entry);
}
/*************************************************************************/
REMOTE_ACCESS_TABLE_ENTRY *remote_access_client_down (USHORT rx_port_number,ULONG ip_address)
{
	REMOTE_ACCESS_TABLE_ENTRY *sptr_remote_access_entry;

	PARAMETER_NOT_USED (rx_port_number);

	/* printf ("Remote access client down on port %d\n", rx_port_number) ; */

	sptr_remote_access_entry = find_remote_access_target (ip_address);

	if (sptr_remote_access_entry != NULL)
	{
		/* printf ("Deleting RAC entry for port %d\n", rx_port_number) ; */
		delete_entry_from_list ((LINK *) &ip.remote_access.client_list,(LINK *) &sptr_remote_access_entry->links);
		/* print_RAC_list () ; */

		/* printf ("Deleting ARP entry for port %d\n", rx_port_number) ; */
		delete_arp_table_entry_using_ip_address (rx_port_number,ip_address);
	}

	return (sptr_remote_access_entry);
}
/****************************************************************************/
enum BOOLEAN remote_access_enabled_for_lan (USHORT port_number)
{
	USHORT virtual_port_number;

	for (virtual_port_number = 0x0000; virtual_port_number < ip.number_of_ports; ++virtual_port_number)
	{
		if (ip.port[virtual_port_number].config.remote_access_enabled == TRUE)
		{
			if (ip.port[virtual_port_number].config.lan_port_number == port_number)
				return (TRUE);
		}
	}
	return (FALSE);
}


/* Sachin 27/07/1996 */

enum TEST arp_processing_for_remote_clients (ARP_PACKET *sptr_arp_packet, USHORT port_number, ULONG target_protocol_address,
                                                USHORT number_of_bytes_rxed)
{
	REMOTE_ACCESS_TABLE_ENTRY *sptr_remote_access_entry ;

	sptr_remote_access_entry = find_remote_access_target (target_protocol_address) ;
	if (sptr_remote_access_entry == NULL)
		return (FAIL) ;

	sptr_arp_packet->header.operation_code = ARP_REPLY ;
	sptr_arp_packet->header.target_hardware_address = sptr_arp_packet->header.sender_hardware_address;
	sptr_arp_packet->header.target_protocol_address = sptr_arp_packet->header.sender_protocol_address;

	sptr_arp_packet->header.sender_protocol_address = swap_long (target_protocol_address);
	sptr_arp_packet->header.sender_hardware_address = ip.port[0].mac_address;
	
	/* It is assumed here that port 0 is the LAN port */

	send_packet_to_lsl (port_number, (UNION_IP_PACKET *)sptr_arp_packet, number_of_bytes_rxed, TRUE, NULL, SNAP_IP_ARP_PACKET,
	                    &sptr_arp_packet->header.target_hardware_address) ;

	++ip.arp.statistics.total_number_of_replies_sent ;

	return (PASS) ;
}

void print_RAC_list (void)
{
	REMOTE_ACCESS_TABLE_ENTRY *sptr_ras_list_entry ;

	sptr_ras_list_entry = (REMOTE_ACCESS_TABLE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *)
								  &ip.remote_access.client_list) ;

	printf ("Printing Remote Access Client List......\n") ;

	while (sptr_ras_list_entry != NULL)
	{
		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ras_list_entry->ip_address) ;
		printf ("IP address : %s, port : %d\n", &ip.print_buffer[0], sptr_ras_list_entry->remote_port_number) ;

		sptr_ras_list_entry = (REMOTE_ACCESS_TABLE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_ras_list_entry);
	}
}
/* Sachin 27/07/1996 */
/* Jo Added for RAS 03/06/99 */
