#include        "defs.h"
/*
 * $Log: /IP/IPROUTE.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*      $Modname: iproute.c$  $version: 1.1$             $date: 10/25/95$         */
/*
*       $lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
*       $lge$
*/
/************************************************************************/
/*      Copyright (C) 1989 - 1993 Router Engines, Inc.                                                          */
/*      Unpublished - rights reserved under the Copyright Laws of the                   */
/*      United States.  Use, duplication, or disclosure by the                                  */
/*      Government is subject to restrictions as set forth in                                   */
/*      subparagraph (c)(1)(ii) of the Rights in Technical Data and                     */
/*      Computer Software clause at 252.227-7013.                                                                               */
/*      Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659                             */
/************************************************************************/
#include        <string.h>
#include        "ip.h"


/* Sachin 11/06/1996 */
USHORT port_index_list[NUMBER_OF_IP_PORTS] ;
/* Sachin 11/06/1996 */

/* Jo 09/08/99 Added for Static routes */ 
enum BOOLEAN static_port_list[NUMBER_OF_IP_PORTS] ;
/* Jo 09/08/99 Added for Static routes */ 



/****************************************************************************/
enum TEST find_rip_route_and_update_cache (ULONG destination_ip_address, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry);
static BYTE get_number_of_sequential_zero_bits (ULONG ip_address, BYTE number_of_bits_to_check);
static void     create_route_entry_for_port (USHORT port_number, IP_PORT_CLASS *sptr_port, ULONG target_ip_address,
	BYTE mask_bits);
/* Jo static void     set_the_metric_of_all_learned_routes_to_infinity (void);*/
static enum BOOLEAN check_if_the_target_is_a_host_on_one_of_the_directly_connected_networks (ULONG target_host);
static enum BOOLEAN check_if_the_target_is_a_subnet_of_one_of_the_directly_connected_networks (ULONG target_network,
	BYTE *bptr_number_of_bits_in_subnet_mask);
static enum BOOLEAN check_if_target_is_the_address_of_a_network_and_not_a_subnet (ULONG target,
	BYTE *bptr_number_of_bits_in_subnet_mask);
extern enum BOOLEAN check_if_packet_is_meant_for_our_remote_address (ULONG destination_address, USHORT *outgoing_port_number);
/****************************************************************************/
IP_ROUTE_ENTRY *ip_find_route_and_update_cache (ULONG destination_ip_address, ULONG type_of_service)
{
	IP_ROUTE_ENTRY *sptr_route_entry;
	USHORT index;

	sptr_route_entry = NULL;

	if (type_of_service != 0x00000001L)
		type_of_service = (ULONG) 0x01;

	for (index = 0x0000; index < ip.number_of_other_transport_protocols; ++index)
	{
		if (ip.other_transport_protocols[index].fptr_find_route_and_update_cache != NULL)
		{
			ip.other_transport_protocols[index].fptr_find_route_and_update_cache (type_of_service, destination_ip_address,
				&sptr_route_entry);

			if (sptr_route_entry != NULL)
			{
				if (ip.other_transport_protocols[index].protocol == IGP_PROTOCOL)
				{
				#ifdef __IP_DEBUG__
					ip_printf (IP_PRINTF, "IP: found route using IGRP\n");
				#endif /* __IP__DEBUG__ */

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
					++ip.statistics.number_of_packets_routed_by_igrp;
#endif /* Jo 26/05/99 */
				}
				else
				{
				#ifdef __IP_DEBUG__
					ip_printf (IP_PRINTF, "IP: found route using transport protocol %u\n",
						ip.other_transport_protocols[index].protocol);
				#endif /* __IP__DEBUG__ */

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
					++ip.statistics.number_of_packets_routed_by_some_other_transport_protocol;
#endif /* Jo 26/05/99 */
				}

				return (sptr_route_entry);
			}
		}
	}

		/* if (ip.rip.protocol_enabled == TRUE) Vidy 10/06/96 */
		{
		find_rip_route_and_update_cache (destination_ip_address, &sptr_route_entry);

		if (sptr_route_entry != NULL)
		{
		#ifdef __IP_DEBUG__
			ip_printf (IP_PRINTF, "IP: found route using RIP\n");
		#endif /* __IP__DEBUG__ */

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
			++ip.statistics.number_of_packets_routed_by_rip;
#endif /* Jo 26/05/99 */

			return (sptr_route_entry);
		}
			/* printf ("find_rip_route_and_update_cache() failed for target %08X\n", destination_ip_address) ; */
	}

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
	++ip.statistics.number_of_packets_for_which_no_routes_were_found;
#endif /* Jo 26/05/99 */

	return (NULL);
}
/****************************************************************************/
enum TEST find_rip_route_and_update_cache (ULONG destination_ip_address, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry)
{
	ULONG target;
/* Sachin 12/06/1996 */
	USHORT i, port_index, destination_port ;
	ULONG subnet_mask ;
/* Sachin 12/06/1996 */

	*ptr_to_sptr_route_entry = NULL ;

	convert_ip_address_to_dot_format (&ip.print_buffer[0], destination_ip_address);

#if 0
	if (find_remote_access_target (destination_ip_address) != NULL)
	{
		printf ("Cannot route to %s using RIP\n", &ip.print_buffer[0]) ;
		return (FAIL) ;
	}
#endif

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
	*ptr_to_sptr_route_entry = get_first_ip_route_entry ();
#else
	*ptr_to_sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);
#endif

/* Sachin 12/06/1996 */
	/*
		In case of a subnetted environment, this will not work. So, we first
		find out the port where this packet is expected to go. Then, we see if
		we have a route to the destination over that port.
	*/

	destination_port = NO_SUCH_PORT ;

	for (i = 0 ; i < ip.number_of_ports ; i++)
	{
		port_index = port_index_list[i] ;

		if (ip.port[port_index].config.port_enabled == FALSE)
			continue ;

		subnet_mask = ip.port[port_index].config.subnetmask ;
		if ((subnet_mask & ip.port[port_index].config.ip_address) !=
		    (subnet_mask & destination_ip_address))
			continue ;
		
		destination_port = port_index ;
		break ;
	}

#if 0
	if (destination_port != NO_SUCH_PORT)
		printf ("Destination expected to be on port %d\n", destination_port) ;
	else
		printf ("Cannot decide on the destination to send the packet\n") ;
#endif
/* Sachin 12/06/1996 */

	while (*ptr_to_sptr_route_entry != NULL)
	{
		target = destination_ip_address & (*ptr_to_sptr_route_entry)->mask;
		if (((*ptr_to_sptr_route_entry)->metric < INFINITY_METRIC_VALUE) && ((*ptr_to_sptr_route_entry)->target == target))
/* Sachin 12/06/1996 */
		{
			if (destination_port != NO_SUCH_PORT)
			{
				if (destination_port == (*ptr_to_sptr_route_entry)->port_number)
				{
/* Jo 28/07/99 Added for Static Routes */
/*printf ("Found an entry to put packet to %s on port %d\n", &ip.print_buffer[0], (*ptr_to_sptr_route_entry)->port_number) ;*/
					return (PASS);
				}
			}
			else
			{
/*printf ("Found an entry to put packet to %s on port %d\n", &ip.print_buffer[0], (*ptr_to_sptr_route_entry)->port_number) ;*/
				return (PASS) ;
			}
		}
/* Sachin 12/06/1996 */

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
		*ptr_to_sptr_route_entry = get_next_ip_route_entry (*ptr_to_sptr_route_entry);
#else
		*ptr_to_sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *)       *ptr_to_sptr_route_entry);
#endif
	}

	if (ip.default_route.port_number != NO_SUCH_PORT)
	{
		*ptr_to_sptr_route_entry = &ip.default_route;
		return (PASS);
	}

	*ptr_to_sptr_route_entry = NULL;
	return (FAIL);
}
/****************************************************************************/
USHORT ip_match_full_address_to_port (ULONG ip_address)
{
	USHORT port_index;

	for (port_index = 0x0000; port_index < ip.number_of_ports; ++port_index)
	{
		if (ip.port[port_index].config.port_enabled == TRUE)
		{
			if (ip.port[port_index].config.ip_address == ip_address)
				return (port_index);
		}
	}
	return (NO_SUCH_PORT);
}
/****************************************************************************/
USHORT ip_match_subnet_address_to_port (ULONG ip_address)
{
	USHORT port_index;
	USHORT last_found_port;
	enum BOOLEAN found;
	ULONG last_found_mask;

	found = FALSE;

	last_found_mask = 0x00000000L;
	last_found_port = 0x0000;

	for (port_index = 0x0000; port_index < ip.number_of_ports; port_index++)
	{
		if (ip.port[port_index].config.port_enabled == TRUE)
		{
			if ((ip_address & ip.port[port_index].config.subnetmask) == ip.port[port_index].subnet_address)
			{
				if (ip.port[port_index].config.subnetmask >= last_found_mask)
				{
					last_found_mask = ip.port[port_index].config.subnetmask;
					last_found_port = port_index;
					found = TRUE;
				}
			}
		}
	}

	if (found == TRUE)
		return (last_found_port);
	else
		return (NO_SUCH_PORT);
}
/****************************************************************************/
ULONG ip_get_address_of_outgoing_interface (ULONG destination_ip_address)
{
	USHORT port_number;
	IP_ROUTE_ENTRY *sptr_route_entry;
	ULONG type_of_service;

	/* is it a loopback ? */

	if (ip_match_full_address_to_port (destination_ip_address) != NO_SUCH_PORT)
		return (destination_ip_address);

	port_number = ip_match_subnet_address_to_port (destination_ip_address);

	if (port_number != NO_SUCH_PORT)
		return (ip.port[port_number].config.ip_address);

	if (destination_ip_address != 0xffffffffL)
	{
		type_of_service = (ULONG) 0x01;
		sptr_route_entry = ip_find_route_and_update_cache (destination_ip_address, type_of_service);

		if (sptr_route_entry != NULL)
			return (ip.port[sptr_route_entry->port_number].config.ip_address);
	}
	return (INTERNET_ADDRESS_ANY);
}
/****************************************************************************/
BYTE ip_determine_number_of_bits_in_net_portion (ULONG ip_address)
{
	if (ip_address == 0x00000000L)
		/* 0.0.0.0 default route has 0 number of bit for netmask */
		return (0x00);

	switch (high_byte_of_ulong (ip_address) >> 6)
	{
		case 3:
			/* Class C address: host can have 8 bits at most */

			return (24);

		case 2:
			/* Class B address: host can have 16 bits at most */

			return (16);

		case 0:
		case 1:
			/* Class A address: host can have 24 bits at most */

			return (8);

		default:
			return (0x00);
	}
}
/****************************************************************************/
ULONG ip_get_network_mask (ULONG ip_address)
{
	USHORT number_of_bits_in_net_portion;
	ULONG netmask;

	number_of_bits_in_net_portion = ip_determine_number_of_bits_in_net_portion (ip_address);

	netmask = 0xffffffffL << (32 - number_of_bits_in_net_portion);

	return (netmask);
}
/****************************************************************************/
BYTE ip_convert_mask_to_bits (ULONG mask)
{
	BYTE bits;

	bits = 0x0000;

	while (mask > 0x00000000L)
	{
		mask <<= 1;
		++bits;
	}
	return (bits);
}
/****************************************************************************/
/* Add route for interface if not currently installed. Create a route to other end if a point-to-point link,
 * otherwise a route to its (sub)network. */

void ip_add_route_for_port (USHORT port_number)
{
	BYTE mask_bits;
	ULONG target_ip_address;
	IP_ROUTE_ENTRY *sptr_route_entry;
	IP_PORT_CLASS  *sptr_port;

#if 0
	if ((ip.mib.ipForwarding == FALSE) && (ip.rip.protocol_enabled == FALSE))
		{
		/* node is a host and not a router */

		return;
		}
#endif

	sptr_port = &ip.port[port_number];
	target_ip_address = sptr_port->subnet_address;
	mask_bits = (BYTE) ip_convert_mask_to_bits (sptr_port->config.subnetmask);

	if ((target_ip_address == 0) || (mask_bits == 0))	/* vidy 30/4/99 */
		return;

	sptr_route_entry = rip_search_route_table_with_bits (target_ip_address, mask_bits);

#if 0           /* Vidy 12/06/96 */
	you have to update the local interface also in case of WAN links
	if ((sptr_route_entry != NULL) && (sptr_route_entry->flags.local_interface_route == TRUE))
		{
		return;
		}
#endif

	if (sptr_route_entry != NULL)
		delete_ip_route_entry (sptr_route_entry);

	create_route_entry_for_port (port_number, sptr_port, target_ip_address, mask_bits);

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
	ip_print_routing_table ();
#endif
/* Jo 23/04/99 */
}
/****************************************************************************/
static void     create_route_entry_for_port (USHORT port_number, IP_PORT_CLASS *sptr_port, ULONG target_ip_address,
	BYTE mask_bits)
{
	ROUTE_FLAGS flags;
	IP_ROUTE_ENTRY *sptr_route_entry;

	memset (&flags, 0, sizeof (ROUTE_FLAGS));
	flags.local_interface_route = TRUE;
	flags.do_no_aging = TRUE;

	if (sptr_port->config.port_is_loopback == TRUE)
	{
		flags.private_route = TRUE;
		flags.host_route = TRUE;
	}

	sptr_route_entry =
		add_ip_route_entry (target_ip_address, mask_bits, (ULONG) NULL, port_number, sptr_port->config.metric, &flags);

	sptr_route_entry->ipRouteProto = LOCALLY_CONFIGURED_TYPE;

	if ((sptr_port->is_point_to_point == TRUE) && (sptr_port->config.point_to_point_remote_ip_address != 0x00000000L))
	{
		target_ip_address = sptr_port->config.point_to_point_remote_ip_address;
		mask_bits = 32;
		flags.host_route = TRUE;
		sptr_route_entry =
			add_ip_route_entry (target_ip_address, mask_bits, (ULONG) NULL, port_number, sptr_port->config.metric, &flags);

		sptr_route_entry->ipRouteProto = LOCALLY_CONFIGURED_TYPE;
	}
}
/****************************************************************************/
/* This routine "guesses" the mask bits for ip address received from the RIP packet.
 * The resolution is based on byte boundary. For more acuracy, it should mask with each local
 * port's subnetmask and compare with the port's subnet. If equal, then we know the subnetmask.
 * However, if the subnet is not on our local network, then this is a better way.
 * Perhaps, a combination of both is better, i.e. check on local ports first, and if not find, guess it. (TBD) */

BYTE ip_guess_the_number_of_bits_in_subnet_mask (ULONG ip_address)
{
	BYTE number_of_bits;

	number_of_bits = 0x00;

	if (ip_address == 0x00000000L)
		/* 0.0.0.0 default route has 0 number of bits for netmask */
		return (0x00);

	switch ((high_byte_of_ulong (ip_address)) >> 6)
	{
		case 3:

			/* Class C address: host can have 8 bits at most */

			number_of_bits = get_number_of_sequential_zero_bits (ip_address, 8);
			number_of_bits += (USHORT) 24;
			return (number_of_bits);

		case 2:

			/* Class B address: host can have 16 bits at most */

			number_of_bits = get_number_of_sequential_zero_bits (ip_address, 16);
			number_of_bits += (USHORT) 16;
			return (number_of_bits);

		case 0:
		case 1:

			/* Class A address: host can have 24 bits at most */

			number_of_bits = get_number_of_sequential_zero_bits (ip_address, 24);
			number_of_bits += (USHORT) 8;
			return (number_of_bits);

		default:
			return (number_of_bits);
	}
}
/****************************************************************************/
static BYTE get_number_of_sequential_zero_bits (ULONG ip_address, BYTE number_of_bits_to_check)
{
	BYTE bit_index;
	BYTE return_value;

	for (bit_index = 0x00; bit_index < number_of_bits_to_check; )
	{
		if ((ip_address & 0x00000001L) == 0x00000001L)
		{
			return_value = (BYTE) (number_of_bits_to_check - bit_index);
			return (return_value);
		}
		ip_address >>= 1;
		bit_index = (BYTE) (bit_index + 1);
	}
	return (0x00);
}
/****************************************************************************/

#ifdef _BIG_PROXY_
void inform_neighboring_routers_of_invalid_routes (void)
{
	set_the_metric_of_all_learned_routes_to_infinity ();

	rip_broadcast_updates (TRUE, NO_SUCH_PORT);
}

static void  set_the_metric_of_all_learned_routes_to_infinity (void)
{
	IP_ROUTE_ENTRY *sptr_route_entry;

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
	sptr_route_entry = get_first_ip_route_entry ();
#else
	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);
#endif

	while (sptr_route_entry != NULL)
		{
		/* set all routes to destinations as learned */

		sptr_route_entry->flags.local_interface_route = FALSE;
		sptr_route_entry->flags.do_no_aging = FALSE;

		sptr_route_entry->metric = INFINITY_METRIC_VALUE;

		sptr_route_entry->ipRouteType = INVALID_ROUTE_TYPE;

		sptr_route_entry->flags.route_changed = TRUE;

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
		sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
		sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif
		}
}
#endif /* Jo 23/04/99 */

BYTE ip_determine_number_of_bits_in_subnet_mask (ULONG *ulptr_target, USHORT port_number, BYTE metric)
{
	BYTE number_of_bits_in_mask;
	ULONG network_mask;
	ULONG target_network;
	IP_ROUTE_ENTRY *sptr_route_entry;

	if (check_if_the_target_is_a_host_on_one_of_the_directly_connected_networks (*ulptr_target) == TRUE)
		return (32);
	else if (check_if_the_target_is_a_subnet_of_one_of_the_directly_connected_networks (*ulptr_target,
		&number_of_bits_in_mask) == TRUE)
		{
			return (number_of_bits_in_mask);
		}
#ifdef _BIG_PROXY_ /* Jo 26/05/99 */
	else if (ip.rip.port[port_number].route_summarization_enabled == TRUE)
		{
		network_mask = ip_get_network_mask (*ulptr_target);

		target_network = *ulptr_target & network_mask;

		number_of_bits_in_mask = ip_determine_number_of_bits_in_net_portion (target_network);

		sptr_route_entry = rip_search_route_table_with_bits (target_network, number_of_bits_in_mask);

		if (sptr_route_entry != NULL)
			{
			if ((sptr_route_entry->metric > metric) && (sptr_route_entry->ipRouteType != INVALID_ROUTE_TYPE))
				{
				if (sptr_route_entry->target != *ulptr_target)
					{
					return (32);
					}
				else
					{
					return (sptr_route_entry->number_of_subnet_mask_bits);
					}
				}
			}

		return (number_of_bits_in_mask);
		}
#endif /* Jo 26/05/99 */
	else if (check_if_target_is_the_address_of_a_network_and_not_a_subnet (*ulptr_target, &number_of_bits_in_mask)
		== TRUE)
		{
		/* target is a remote (ie. not directly connected) network */

		return (number_of_bits_in_mask);
		}
	else
		{
		if (ip.port[port_number].config.icmp_mask_request_enabled == FALSE)
			{
			/* when icmp address mask requests are disallowed on that port */

			number_of_bits_in_mask = ip_determine_number_of_bits_in_net_portion (*ulptr_target);
			return (number_of_bits_in_mask);
			}
		else
			{
			/* target is either a subnet of or a host on a remote (ie. not directly connected) network */

			return (SUBNET_MASK_NOT_KNOWN);
			}
		}
}
/****************************************************************************/
#if 0
static enum BOOLEAN check_if_the_target_is_a_host_on_one_of_the_directly_connected_networks (ULONG target_host)
{
	USHORT port_index;
	ULONG subnet_mask;
	ULONG number_of_bits_in_subnet_mask;
	ULONG bits;

	for (port_index = 0x0000; port_index < ip.number_of_ports; ++port_index)
		{
		if (ip.port[port_index].config.port_enabled == TRUE)
			{
			subnet_mask = ip.port[port_index].config.subnetmask;

			if ((target_host & subnet_mask) == ip.port[port_index].subnet_address)
				{
				number_of_bits_in_subnet_mask = ip_guess_the_number_of_bits_in_subnet_mask (subnet_mask);

				bits = ip_guess_the_number_of_bits_in_subnet_mask (target_host);

				if (bits > number_of_bits_in_subnet_mask)
					{
					return (TRUE);
					}
				}
			}
		}

	return (FALSE);
}
#endif


/* Sachin 11/06/1996 */
static enum BOOLEAN check_if_the_target_is_a_host_on_one_of_the_directly_connected_networks (ULONG target_host)
{
	USHORT i, port_index;
	ULONG subnet_mask;

	for (i = 0x0000; i < ip.number_of_ports; ++i)
	{
		port_index = port_index_list[i] ;

		if (ip.port[port_index].config.port_enabled == TRUE)
		{
			subnet_mask = ip.port[port_index].config.subnetmask ;
			if ((subnet_mask & target_host) == (subnet_mask & ip.port[port_index].config.ip_address))
			{
				/*
					The host, if it exists should fall in the subnet
					under port port_index and cannot be present anywhere else
					if the configuration of the internetwork is correct.
				*/

				if (ip.port[port_index].config.point_to_point_link)
				{
					/*
						The only host that can be present on a network of the PPP link
						is the remote host
					*/

					if (ip.port[port_index].config.point_to_point_remote_ip_address == target_host)
						return (TRUE) ;
					else
						return (FALSE) ;
				}
				return (TRUE) ;
			}
		}
	}
}
/* Sachin 11/06/1996 */


/****************************************************************************/
#if 0
static enum BOOLEAN check_if_the_target_is_a_subnet_of_one_of_the_directly_connected_networks (ULONG target_network,
	BYTE *bptr_number_of_bits_in_subnet_mask)
{
	USHORT port_index;
	ULONG netmask;

	netmask = ip_get_network_mask (target_network);

	target_network = target_network & netmask;

	for (port_index = 0x0000; port_index < ip.number_of_ports; ++port_index)
		{
		if (ip.port[port_index].config.port_enabled == TRUE)
			{
			if (target_network == ip.port[port_index].net_address)
				/* && (netmask == ip.port[port_index].netmask)) */
				{
				*bptr_number_of_bits_in_subnet_mask = ip_convert_mask_to_bits (ip.port[port_index].config.subnetmask);

				return (TRUE);
				}
			}
		}

	return (FALSE);
}
#endif


static enum BOOLEAN check_if_the_target_is_a_subnet_of_one_of_the_directly_connected_networks (ULONG target_network,
	BYTE *bptr_number_of_bits_in_subnet_mask)
{
	USHORT i, port_index;
	ULONG netmask;

	for (i = 0x0000; i < ip.number_of_ports; ++i)
	{
		port_index = port_index_list[i] ;

		if (ip.port[port_index].config.port_enabled == TRUE)
		{
			netmask = ip.port[port_index].config.subnetmask ;
			if ((netmask & target_network) == (netmask & ip.port[port_index].config.ip_address))
			{
				*bptr_number_of_bits_in_subnet_mask = ip_convert_mask_to_bits (netmask) ;
				return (TRUE) ;
			}
		}
	}
	return (FALSE);
}
/* Sachin 11/06/1996 */

/****************************************************************************/
static enum BOOLEAN check_if_target_is_the_address_of_a_network_and_not_a_subnet (ULONG target,
	BYTE *bptr_number_of_bits_in_subnet_mask)
{
	BYTE number_of_bits_in_network_mask;
	BYTE bits;

	number_of_bits_in_network_mask = ip_determine_number_of_bits_in_net_portion (target);

	bits = ip_guess_the_number_of_bits_in_subnet_mask (target);

	if (bits > number_of_bits_in_network_mask)
		return (FALSE);
	*bptr_number_of_bits_in_subnet_mask = number_of_bits_in_network_mask;
	return (TRUE);
}


/* Sachin 11/06/1996 */

void arrange_port_index_list (void)
{
	ULONG subnet_masks[NUMBER_OF_IP_PORTS], largest_mask ;
	int i, j ;
	enum BOOLEAN ports_entered[NUMBER_OF_IP_PORTS] ;

	for (i = 0 ; i < ip.number_of_ports ; i++)
	{
/*  Sachin added the second condition for Remote Access (17/07/1996) */

		if ((ip.port[i].config.port_enabled == TRUE) && (ip.port[i].config.remote_access_enabled == FALSE))
			subnet_masks[i] = ip.port[i].config.subnetmask ;
		else
			subnet_masks[i] = 0L ;
		ports_entered[i] = FALSE ;
	}

	for (i = 0 ; i < ip.number_of_ports ; i++)
	{
		largest_mask = 0L ;

		for (j = 0 ; j < ip.number_of_ports ; j++)
		{
			if ((ports_entered[j] == FALSE) && (subnet_masks[j] >= largest_mask))
			{
				largest_mask = subnet_masks[j] ;
				port_index_list[i] = j ;
			}
		}
		subnet_masks[port_index_list[i]] = 0L ;
		ports_entered[port_index_list[i]] = TRUE ;
	}

#if 0
	printf ("Port Index List : ") ;
	for (i = 0 ; i < ip.number_of_ports ; i++)
		printf ("%d ", port_index_list[i]) ;
	printf ("\n") ;
#endif

}

USHORT ip_get_outgoing_port_number_from_ip_address (ULONG destination_ip_address)
{
	USHORT port_number, outgoing_port_number = 0;
	IP_ROUTE_ENTRY *sptr_route_entry;
	ULONG type_of_service;

/* Jo 03/06/99 Took from sudha 23 March 1999.Fix for RAS clients not able 
		to do telnet or web to our proxy server. */

	if (check_if_packet_is_meant_for_our_remote_address (destination_ip_address, &outgoing_port_number) == TRUE)
	{
		port_number = outgoing_port_number;
		if (port_number != NO_SUCH_PORT)
 		{
/*		printf ("IPPROX: Returning Subnet matched port number %d\n",port_number);  */
			return (port_number);
		}
	}
/* ...sudha 23 March 1999. */
/* Jo 03/06/99 Added for RAS Taken from BIG Proxy */
	
	port_number = ip_match_subnet_address_to_port (destination_ip_address);

	if (port_number != NO_SUCH_PORT)
 	{
/*		printf ("IPPROX: Returning Subnet matched port number %d\n",port_number);  */
		return (port_number);
	}
	return (NO_SUCH_PORT);

#if 0
	if (destination_ip_address != 0xffffffffL)
	{
		type_of_service = (ULONG) 0x01;

		sptr_route_entry = ip_find_route_and_update_cache (destination_ip_address, type_of_service);

		if (sptr_route_entry != NULL)
		{
/*			printf ("IPPROX: Selected port %d from RIP table\n",sptr_route_entry->port_number); */
			return (sptr_route_entry->port_number);
		}
	}
/*	printf ("IPPROX: Get ip port from address failed\n"); */
	return (NO_SUCH_PORT);
#endif
}

/* Jo 03/06/99 Added for RAS Taken from BIG Proxy */
enum BOOLEAN check_if_packet_is_meant_for_our_remote_address (ULONG destination_address, USHORT *outgoing_port_number)
{
	USHORT port_number;
	
	for (port_number = 0; port_number < ip.number_of_ports; port_number++)
	{
		if (ip.port[port_number].config.point_to_point_remote_ip_address == destination_address)
		{
			*outgoing_port_number = port_number;
			return TRUE;
		}
	}
	return FALSE;
}
/* Jo 03/06/99 Added for RAS Taken from BIG Proxy */
