#include	"defs.h"

/*
 * $Log: /IP/IPRXPR.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdio.h>
#include "ip.h"
#ifdef IP_FILTERING
#include "ipfilt.h"
/*#define PRINTF 1*/
#endif

/****************************************************************************/
static enum BOOLEAN ip_check_if_destination_is_an_invalid_address (ULONG target);
static enum BOOLEAN ip_check_if_source_is_an_invalid_address (ULONG target);
static enum BOOLEAN ip_check_if_source_is_a_network_directed_broadcast_address (ULONG target);
static enum BOOLEAN ip_check_if_target_is_a_network_address_with_host_portion_all_zeroes (ULONG target);
#ifdef __IP_BREAKPOINT__
/****************************************************************************/
void check_for_ip_runtime_breakpoint (void)
{
	if (ip.runtime_breakpoint == TRUE)
		{
		BREAKPOINT;
		}
}
#endif /* __IP_BREAKPOINT__ */
/****************************************************************************/
enum BOOLEAN ip_check_if_destination_address_is_valid (ULONG target)
{
	if (target == INTERNET_ADDRESS_LOOPBACK)
		return (FALSE);
	else if (target == INTERNET_ADDRESS_BROADCAST)
		return (TRUE);
	else if (IN_CLASS_D (target))
		return (FALSE);
	else if (IN_EXPERIMENTAL (target))
		return (FALSE);
	else if (IN_BADCLASS (target))
		return (FALSE);

	if ((IN_CLASS_A (target)) || (IN_CLASS_B (target)) || (IN_CLASS_C (target)))
	{
		if (ip_check_if_destination_is_an_invalid_address (target) == TRUE)
			return (FALSE);

		if (ip_check_if_target_is_a_network_address_with_host_portion_all_zeroes (target) == TRUE)
			return (FALSE);

		return (TRUE);
	}
	return (FALSE);
}
/****************************************************************************/
static enum BOOLEAN ip_check_if_destination_is_an_invalid_address (ULONG target)
{
	if (IN_CLASS_A (target))
	{
		if ((target & 0xff000000) == 0x7f000000)
			return (TRUE);
		else if ((target & 0xff000000) == 0x00)
			return (TRUE);
	}
	else if (IN_CLASS_B (target))
	{
		if ((target & 0xffff0000) == 0xbfff0000)
			return (TRUE);
		else if ((target & 0xffff0000) == 0x80000000)
			return (TRUE);
	}
	else if (IN_CLASS_C (target))
	{
		if ((target & 0xffffff00) == 0xdfffff00)
			return (TRUE);
		else if ((target & 0xffffff00) == 0xc0000000)
			return (TRUE);
	}

	return (FALSE);
}
/****************************************************************************/
enum BOOLEAN ip_check_if_source_address_is_valid (ULONG target, USHORT port_number)
{
	if (target == INTERNET_ADDRESS_LOOPBACK)
		return (FALSE);
	else if (target == INTERNET_ADDRESS_BROADCAST)
		return (FALSE);
	else if (IN_CLASS_D (target))
		return (FALSE);
	else if (IN_EXPERIMENTAL (target))
		return (FALSE);
	else if (IN_BADCLASS (target))
		return (FALSE);

	if ((port_number != NO_SUCH_PORT) && (ip.port[port_number].config.bootp_enabled == TRUE) && (target == 0x00000000L))
		return (TRUE);

	if ((IN_CLASS_A (target)) || (IN_CLASS_B (target)) || (IN_CLASS_C (target)))
	{
		if (ip_check_if_source_is_an_invalid_address (target) == TRUE)
			return (FALSE);

		if (ip_check_if_source_is_a_network_directed_broadcast_address (target) == TRUE)
			return (FALSE);

		if (ip_check_if_target_is_a_network_address_with_host_portion_all_zeroes (target) == TRUE)
			return (FALSE);

		return (TRUE);
	}

	return (FALSE);
}
/****************************************************************************/
static enum BOOLEAN ip_check_if_source_is_an_invalid_address (ULONG target)
{
	if (target == 0x00000000L)
		return (FALSE);
	else if (IN_CLASS_A (target))
	{
		if ((target & 0xff000000L) == 0x7f000000L)
			return (TRUE);
		else if ((target & 0xff000000L) == 0x00000000L)
			return (FALSE);
	}
	else if (IN_CLASS_B (target))
  {
		if ((target & 0xffff0000L) == 0xbfff0000L)
			return (TRUE);
		else if ((target & 0xffff0000L) == 0x80000000L)
			return (TRUE);
		else if ((target & 0xffff0000L) == 0x00000000L)
			return (FALSE);
	}
	else if (IN_CLASS_C (target))
	{
		if ((target & 0xffffff00L) == 0xdfffff00L)
			return (TRUE);
		else if ((target & 0xffffff00L) == 0xc0000000L)
			return (TRUE);
		else if ((target & 0xffffff00L) == 0x00000000L)
			return (FALSE);
	}

	return (FALSE);
}
/****************************************************************************/
static enum BOOLEAN ip_check_if_source_is_a_network_directed_broadcast_address (ULONG target)
{
	USHORT port_index;

	if (IN_CLASS_A (target))
		{
		if ((target & IN_CLASS_A_HOST) == 0x00ffffffL)
			{
			return (TRUE);
			}
		}
	else if (IN_CLASS_B (target))
	  {
		if ((target & IN_CLASS_B_HOST) == 0x0000ffffL)
			{
			return (TRUE);
			}
	  }
	else if (IN_CLASS_C (target))
	  {
		if ((target & IN_CLASS_C_HOST) == 0x000000ffL)
			{
			return (TRUE);
			}
	  }

	/* does check for subnet directed broadcast addresses */

	for (port_index = 0x0000; port_index < ip.number_of_ports; ++port_index)
		{
		if (ip.port[port_index].config.port_enabled == TRUE)
			{
			if ((target & ip.port[port_index].config.subnetmask) == ip.port[port_index].subnet_address)
				{
				if ((target & ~ip.port[port_index].config.subnetmask) == ~ip.port[port_index].config.subnetmask)
					{
					return (TRUE);
					}
				}
			}
		}

	return (FALSE);
}
/****************************************************************************/
static enum BOOLEAN ip_check_if_target_is_a_network_address_with_host_portion_all_zeroes (ULONG target)
{
	USHORT port_index;

	if (IN_CLASS_A (target))
		{
		if ((target & IN_CLASS_A_HOST) == 0x00000000L)
			{
			return (TRUE);
			}
		}
	else if (IN_CLASS_B (target))
	  {
		if ((target & IN_CLASS_B_HOST) == 0x00000000L)
			{
			return (TRUE);
			}
	  }
	else if (IN_CLASS_C (target))
	  {
		if ((target & IN_CLASS_C_HOST) == 0x00000000L)
			{
			return (TRUE);
			}
	  }

	for (port_index = 0x0000; port_index < ip.number_of_ports; ++port_index)
		{
		if (ip.port[port_index].config.port_enabled == TRUE)
			{
			if ((target & ip.port[port_index].config.subnetmask) == ip.port[port_index].subnet_address)
				{
				if ((target & ~ip.port[port_index].config.subnetmask) == 0x00000000L)
					{
					return (TRUE);
					}
				}
			}
		}

	return (FALSE);
}
/****************************************************************************/
enum BOOLEAN ip_rx_filter (IP_PORT_CLASS *sptr_incoming_port, UNION_IP_PACKET *sptr_ip_packet)
{
#ifndef IP_FILTERING

	PARAMETER_NOT_USED (sptr_incoming_port);

	PARAMETER_NOT_USED (sptr_ip_packet);

	return (FALSE);

#else
	IP_FILTERING_ENTRY *ip_filtering_entry ;
   
#ifdef PRINTF
	char c1, c2, c3, c4, *temp_ptr = (char *)&sptr_ip_packet->ip.header.source_ip_address ;
	c1 = *(temp_ptr+0) ;
	c2 = *(temp_ptr+1) ;
	c3 = *(temp_ptr+2) ;
	c4 = *(temp_ptr+3) ;
#endif
/* Sachin 31st December 1996 */
	if (sptr_ip_packet->ip.header.protocol == ICMP_PROTOCOL)
	switch (sptr_ip_packet->icmp.header.type)
	{
		case (ICMP_ECHO_REPLY_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[0] == TRUE)
				return (TRUE) ;
			else
				break ;

		case (ICMP_DESTINATION_UNREACHABLE_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[1] == TRUE)
				return (TRUE) ;
			else
				break ;

		case (ICMP_SOURCE_QUENCH_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[2] == TRUE)
				return (TRUE) ;
			else
				break ;

		case (ICMP_REDIRECT_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[3] == TRUE)
				return (TRUE) ;
			else
				break ;

		case (ICMP_ECHO_REQUEST_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[4] == TRUE)
				return (TRUE) ;
			else
				break ;

		case (ICMP_TIME_EXCEEDED_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[5] == TRUE)
				return (TRUE) ;
			else
				break ;

		case (ICMP_PARAMETER_PROBLEM_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[6] == TRUE)
				return (TRUE) ;
			else
				break ;

		case (ICMP_TIMESTAMP_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[7] == TRUE)
				return (TRUE) ;
			else
				break ;

		case (ICMP_TIMESTAMP_REPLY_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[8] == TRUE)
				return (TRUE) ;
			else
				break ;

		case (ICMP_ADDRESS_MASK_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[9] == TRUE)
				return (TRUE) ;
			else
				break ;

		case (ICMP_ADDR_MASK_REPLY_TYPE) :
			if (sptr_incoming_port->icmp_packet_type_filters[10] == TRUE)
				return (TRUE) ;
			else
				break ;

		default :
			break ;
	}

	if (ip_filtering_inited == FALSE)
	{
		return (FALSE) ;
	}

	ip_filtering_entry = ip_get_src_filtering_entry (sptr_ip_packet->ip.header.source_ip_address,
                        sptr_ip_packet->udp.header.source_port,
                        sptr_ip_packet->ip.header.protocol) ;
	if (ip_filtering_entry == NULL)
	{
		if (ip_filter_default_rx_action == IP_FILTER_DEFAULT_ACTION_FILTER)
			return (TRUE) ;
		else
			return (FALSE) ;
	}

	if (ip_filtering_entry->port != sptr_incoming_port->config.virtual_port_number)
	{
		if (ip_filter_default_rx_action == IP_FILTER_DEFAULT_ACTION_FILTER)
			return (TRUE) ;
		else
			return (FALSE) ;
	}

	if ((ip_filtering_entry->type == IP_FILTER_ON_SOURCE_ADDRESS) ||
	    (ip_filtering_entry->type == IP_FILTER_ON_SOURCE_PORT) ||
	    (ip_filtering_entry->type == IP_FILTER_ON_SOURCE_RANGE))
	{
#ifdef PRINTF
			ip_printf (IP_FILTER_PRINTF, "\nIP Filter : Packet from %d.%d.%d.%d filtered off",
			       c1, c2, c3, c4) ;
#endif
		 	return (TRUE) ;
	}
	else
	if ((ip_filtering_entry->type == IP_FORWARD_ON_SOURCE_ADDRESS) ||
	    (ip_filtering_entry->type == IP_FORWARD_ON_SOURCE_PORT) ||
	    (ip_filtering_entry->type == IP_FORWARD_ON_SOURCE_RANGE))
	{
#ifdef PRINTF
			ip_printf (IP_FILTER_PRINTF, "\nIP Filter : Packet from %d.%d.%d.%d forwarded",
			       c1, c2, c3, c4) ;
#endif
		 	return (FALSE) ;
	}

	
	if (ip_filter_default_rx_action == IP_FILTER_DEFAULT_ACTION_FILTER)
		return (TRUE) ;

	return (FALSE) ;

#endif
}
/****************************************************************************/
enum BOOLEAN check_if_packet_is_to_be_forwarded_onto_a_directly_attached_network (USHORT rx_port_number,
	UNION_IP_PACKET *uptr_ip_rx_packet)
{
	USHORT port_index;
	IP_PORT_CLASS *sptr_port;
	ULONG destination_address;

	destination_address = net_to_host_long (uptr_ip_rx_packet->ip.header.destination_ip_address);

	for (port_index = 0x0000; port_index < ip.number_of_ports; ++port_index)
	{
		if (ip.port[port_index].config.port_enabled == TRUE)
		{
			sptr_port = &ip.port[port_index];

			if ((sptr_port->subnet_broadcast_address == destination_address) ||
				/* for old broadcast host portion 0 */
				(destination_address == sptr_port->subnet_address))
			{
				if (port_index != rx_port_number)
					return (TRUE);
			}

			if ((sptr_port->net_broadcast_address == destination_address) ||
				/* for old broadcast host portion 0 */
				(destination_address == sptr_port->net_address))
			{
				if (port_index != rx_port_number)
					return (TRUE);
			}
		}
	}

	return (FALSE);
}

/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
void print_rxed_ip_header (IP_HEADER *sptr_ip_header, USHORT port_number)
{
	char *ptr_to_string;

	if (ip.print_class.ip_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], net_to_host_long (sptr_ip_header->source_ip_address));

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], net_to_host_long (sptr_ip_header->destination_ip_address));

		ptr_to_string += sprintf (ptr_to_string, "IP: rxed packet %s --> %s on port %u\n", &ip.print_buffer[0],
			ip.print_buffer_2, port_number);

		ptr_to_string += sprintf (ptr_to_string, "   header: hlen:%u,ver:%u,tos.rel:%u,tos.tgh:%u,tos.del:%u,tos.prec:%u\n",
			sptr_ip_header->version_header_length.header_length,
			sptr_ip_header->version_header_length.version, sptr_ip_header->service_type.high_reliability,
			sptr_ip_header->service_type.high_throughput, sptr_ip_header->service_type.low_delay,
			sptr_ip_header->service_type.precedence);

		ip_printf (IP_RX_PRINTF, &ip.string_to_print[0]);

		ptr_to_string = &ip.string_to_print[0];

		ptr_to_string += sprintf (ptr_to_string,
			"      header: tlen:%u,iden:%u,flg.mf:%u,flg.df:%u,off.hg:%u,off.lw:%u,ttl:%u,proto:%u,cksum:%x\n",
			net_to_host_short (sptr_ip_header->total_length),
			net_to_host_short (sptr_ip_header->identifier),
			sptr_ip_header->flags_fragment_offset.more_fragment_flag, sptr_ip_header->flags_fragment_offset.do_not_fragment_flag,
			sptr_ip_header->flags_fragment_offset.fragment_offset_most_significant_part,
			sptr_ip_header->fragment_offset_least_significant_part, sptr_ip_header->time_to_live, sptr_ip_header->protocol,
			sptr_ip_header->header_checksum);

		ip_printf (IP_RX_PRINTF, &ip.string_to_print[0]);
		}
}
#endif
/* Jo 23/04/99 */
