#include	"defs.h"
/*
 * $Log: /IP/IPSRCRT.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipsrcrt.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include "ip.h"
/****************************************************************************/
static void	set_up_destination_address (IP_UPPER_LAYER_PARAMETERS *sptr_ip_request, ULONG **ptr_to_ulptr_next_route);
static void	record_return_path_as_an_ip_source_route (IP_UPPER_LAYER_PARAMETERS *sptr_ip_request, ULONG **ptr_to_ulptr_option,
	ULONG **ptr_to_ulptr_next_route);
static void save_source_route_option (void *vptr_source_route, USHORT current_option_length);
static void	when_there_is_not_enough_room_in_source_route_record (IP_PARAMETERS *sptr_ip_parameters,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet);
static void	send_parameter_problem_type_icmp_error_packet (IP_PARAMETERS *sptr_ip_parameters, USHORT processed_option_length,
	UNION_IP_PACKET *sptr_ip_packet);
static void	when_destination_is_not_this_router_and_source_routing_is_strict (IP_PARAMETERS *sptr_ip_parameters,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet);
static enum BOOLEAN check_if_the_packet_is_for_this_router (USHORT *usptr_source_route_pointer, USHORT current_option_length);
static enum TEST get_next_gateway_address_from_option_and_replace_with_the_ip_address_of_outgoing_interface (
	IP_OPTION *sptr_option, USHORT source_route_pointer, IP_PARAMETERS *sptr_ip_parameters,
	enum BOOLEAN *eptr_change_ip_destination_for_source_route, enum BOOLEAN strict_source_route_flag,
	IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet);
static enum BOOLEAN find_route_and_check_if_next_hop_is_valid_for_strict_source_route (IP_PARAMETERS *sptr_ip_parameters,
	enum BOOLEAN strict_source_route_flag, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, USHORT processed_option_length,
	UNION_IP_PACKET *sptr_ip_packet);
static void	send_destination_unreachable_icmp_error_packet (IP_PARAMETERS *sptr_ip_parameters, USHORT processed_option_length,
	UNION_IP_PACKET *sptr_ip_packet, BYTE code);
static void	when_there_is_not_enough_room_in_record_route_option (IP_PARAMETERS *sptr_ip_parameters,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet);
static enum TEST when_route_list_is_used_up_send_icmp_message (IP_PARAMETERS *sptr_ip_parameters,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet, USHORT source_route_pointer, USHORT current_option_length);
static enum TEST find_route_and_if_route_exists_put_ip_address_of_outgoing_interface_in_route_record (IP_OPTION *sptr_option,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters,
	IP_ROUTE_ENTRY **sptr_route_entry, USHORT source_route_pointer);
/****************************************************************************/
/*	Use the saved source route option to set up a reversed order of source route option
 *	for such use as in sending icmp error message. Notice this routine may change the ip_request.destination_address . */

#ifdef _BIG_PROXY_
void ip_setup_source_route (IP_UPPER_LAYER_PARAMETERS *sptr_ip_request, ULONG ip_source_address){
	ULONG *ulptr_next_route;
	ULONG *ulptr_option;

	if (ip.source_route_working_area.number_of_hops_in_source_route == 0x0000)
		{
		sptr_ip_request->option_length = 0x00;

		return;
		}

	ulptr_next_route =
		&ip.source_route_working_area.source_routes[ip.source_route_working_area.number_of_hops_in_source_route - 1];

	set_up_destination_address (sptr_ip_request, &ulptr_next_route);

	/* Copy saved option field and padding (nop) to new option space. */

	ip.source_route_working_area.nop = IP_NOOP_OPTION;
	ip.source_route_working_area.source_route_option.pointer = MINIMUM_SOURCE_ROUTE_POINTER;

	/* copy the option nop/code/length/pointer */

	memcpy (sptr_ip_request->user_options.char_options, &ip.source_route_working_area.nop,
		MINIMUM_SOURCE_ROUTE_OPTION_LENGTH + 1);

	record_return_path_as_an_ip_source_route (sptr_ip_request, &ulptr_option, &ulptr_next_route);

	/* the original ip source address should be the last hop in source route list */

	*ulptr_option = host_to_net_long (ip_source_address);

	sptr_ip_request->option_length = (BYTE) (ip.source_route_working_area.number_of_hops_in_source_route * sizeof (ULONG) +
		MINIMUM_SOURCE_ROUTE_OPTION_LENGTH + 1);
}
/****************************************************************************/
static void	set_up_destination_address (IP_UPPER_LAYER_PARAMETERS *sptr_ip_request, ULONG **ptr_to_ulptr_next_route)
{
	/* if the source route list is: X.Y.W, then W is the first gateway we want to send to */

	sptr_ip_request->destination_address = net_to_host_long (**ptr_to_ulptr_next_route);

	--*ptr_to_ulptr_next_route;
}
/****************************************************************************/
static void	record_return_path_as_an_ip_source_route (IP_UPPER_LAYER_PARAMETERS *sptr_ip_request, ULONG **ptr_to_ulptr_option,
	ULONG **ptr_to_ulptr_next_route)
{
	/* Record return path as an IP source route, reversing the path (pointers are now aligned) . */

	*ptr_to_ulptr_option = &sptr_ip_request->user_options.ulong_options[1];

	while (*ptr_to_ulptr_next_route >= ip.source_route_working_area.source_routes)
		{
		/* copy X.Y as Y.X */

		**ptr_to_ulptr_option = **ptr_to_ulptr_next_route;

		++*ptr_to_ulptr_option;

		--*ptr_to_ulptr_next_route;
		}
}
/****************************************************************************/
enum TEST process_source_route_option (IP_OPTION *sptr_option, USHORT processed_option_length,
	UNION_IP_PACKET *uptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, enum BOOLEAN strict_source_route_flag,
	USHORT current_option_length, enum BOOLEAN *eptr_need_new_checksum,
	enum BOOLEAN *eptr_change_ip_destination_for_source_route, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry)
{
	USHORT source_route_pointer;

	source_route_pointer = sptr_option->pointer;

	save_source_route_option (sptr_option, current_option_length);			/* in case there arises a need to send an ICMP message */

	if ((current_option_length < MINIMUM_SOURCE_ROUTE_OPTION_LENGTH) || (source_route_pointer < MINIMUM_SOURCE_ROUTE_POINTER))
		{
		when_there_is_not_enough_room_in_source_route_record (sptr_ip_parameters, processed_option_length, uptr_ip_packet);

		return (FAIL);
		}

	if (ip_match_full_address_to_port (sptr_ip_parameters->destination_address) == NO_SUCH_PORT)
		{
		if (strict_source_route_flag == TRUE)
			{
			when_destination_is_not_this_router_and_source_routing_is_strict (sptr_ip_parameters, processed_option_length,
				uptr_ip_packet);

			return (FAIL);
			}

		/*	for loose source route, this must be an intermediate gateway not on the source route list.
		 * just ignore this option. */

	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, "IP: rxed loosely source routed datagram whose destination is not me, %s --> %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__DEBUG__ */

		return (PASS);
		}

	if (check_if_the_packet_is_for_this_router (&source_route_pointer, current_option_length) == TRUE)
		{
		return (PASS);
		}

	if (get_next_gateway_address_from_option_and_replace_with_the_ip_address_of_outgoing_interface (sptr_option,
		source_route_pointer, sptr_ip_parameters, eptr_change_ip_destination_for_source_route, strict_source_route_flag,
		ptr_to_sptr_route_entry, processed_option_length, uptr_ip_packet) == FAIL)
		{
		return (FAIL);
		}

	*eptr_need_new_checksum = TRUE;

	return (PASS);
}
/****************************************************************************/
static void save_source_route_option (void *vptr_source_route, USHORT current_option_length)
{
	if (current_option_length > (MINIMUM_SOURCE_ROUTE_OPTION_LENGTH + MAXIMUM_IP_OPTION_LENGTH))
		{
		return;
		}

	memcpy (&ip.source_route_working_area.source_route_option, vptr_source_route, current_option_length);

	ip.source_route_working_area.number_of_hops_in_source_route = (USHORT)
		((ULONG) (current_option_length - MINIMUM_SOURCE_ROUTE_OPTION_LENGTH) / sizeof (ULONG));
}
/****************************************************************************/
static void	when_there_is_not_enough_room_in_source_route_record (IP_PARAMETERS *sptr_ip_parameters,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet)
{
	/* not enough room in source route record */

#ifdef _BIG_PROXY_
	++ip.mib.ipInHdrErrors;
#endif

#ifdef __IP_DEBUG__
	ip_printf (IP_PRINTF, "IP: source route option too short %s --> %s\n",
		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address));
#endif /* __IP__DEBUG__ */

	send_parameter_problem_type_icmp_error_packet (sptr_ip_parameters, processed_option_length, sptr_ip_packet);
}
/****************************************************************************/
static void	send_parameter_problem_type_icmp_error_packet (IP_PARAMETERS *sptr_ip_parameters, USHORT processed_option_length,
	UNION_IP_PACKET *sptr_ip_packet)
{
	UNION_ICMP_PARAMETER icmp_parameter;

	icmp_parameter.pointer = (BYTE) (MINIMUM_IP_HEADER_LENGTH + processed_option_length);

	send_icmp_error_packet (sptr_ip_parameters->rx_port_number, sptr_ip_parameters, sptr_ip_packet,
		ICMP_PARAMETER_PROBLEM_TYPE, 0, &icmp_parameter);
}
/****************************************************************************/
static void	when_destination_is_not_this_router_and_source_routing_is_strict (IP_PARAMETERS *sptr_ip_parameters,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet)
{
#ifdef _BIG_PROXY_
	++ip.mib.ipInHdrErrors;
#endif

#ifdef __IP_DEBUG__
	ip_printf (IP_PRINTF, "IP: rxed strictly source routed datagram whose destination is not me, %s --> %s\n",
		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address));
#endif /* __IP__DEBUG__ */

	send_destination_unreachable_icmp_error_packet (sptr_ip_parameters, processed_option_length, sptr_ip_packet,
		ICMP_ROUTE_FAIL_CODE);
}
/****************************************************************************/
static void	send_destination_unreachable_icmp_error_packet (IP_PARAMETERS *sptr_ip_parameters, USHORT processed_option_length,
	UNION_IP_PACKET *sptr_ip_packet, BYTE code)
{
	UNION_ICMP_PARAMETER icmp_parameter;

#ifdef _BIG_PROXY_
	++ip.mib.ipOutNoRoutes;
#endif

	icmp_parameter.pointer = (BYTE) (MINIMUM_IP_HEADER_LENGTH + processed_option_length);

	send_icmp_error_packet (sptr_ip_parameters->rx_port_number, sptr_ip_parameters, sptr_ip_packet,
		ICMP_DESTINATION_UNREACHABLE_TYPE, code, &icmp_parameter);
}
/****************************************************************************/
static enum BOOLEAN check_if_the_packet_is_for_this_router (USHORT *usptr_source_route_pointer, USHORT current_option_length)
{
	--*usptr_source_route_pointer;

	if ((*usptr_source_route_pointer + IP_ADDRESS_LENGTH) > current_option_length)
		{
		/* route list used up, it must be for me. */

		return (TRUE);
		}

	return (FALSE);
}
/****************************************************************************/
static enum TEST get_next_gateway_address_from_option_and_replace_with_the_ip_address_of_outgoing_interface (
	IP_OPTION *sptr_option, USHORT source_route_pointer, IP_PARAMETERS *sptr_ip_parameters,
	enum BOOLEAN *eptr_change_ip_destination_for_source_route, enum BOOLEAN strict_source_route_flag,
	IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, USHORT processed_option_length, UNION_IP_PACKET *uptr_ip_packet)
{
	ULONG ip_address_of_outgoing_interface;

	/* Get next gateway address from option and replace it with the IP address of the outgoing interface.
	 * Increase pointer by 4. */

	sptr_ip_parameters->destination_address = net_to_host_long (*(ULONG *) ((BYTE *) sptr_option + source_route_pointer));

	if (find_route_and_check_if_next_hop_is_valid_for_strict_source_route (sptr_ip_parameters, strict_source_route_flag,
		ptr_to_sptr_route_entry, processed_option_length, uptr_ip_packet) == FALSE)
		{
		return (FAIL);
		}

	*eptr_change_ip_destination_for_source_route = TRUE;

	ip_address_of_outgoing_interface = ip_get_address_of_outgoing_interface (sptr_ip_parameters->destination_address);

	*(ULONG *) ((BYTE *) sptr_option + source_route_pointer) = host_to_net_long (ip_address_of_outgoing_interface);

	sptr_option->pointer += (BYTE) IP_ADDRESS_LENGTH;

	return (PASS);
}
/****************************************************************************/
static enum BOOLEAN find_route_and_check_if_next_hop_is_valid_for_strict_source_route (IP_PARAMETERS *sptr_ip_parameters,
	enum BOOLEAN strict_source_route_flag, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, USHORT processed_option_length,
	UNION_IP_PACKET *uptr_ip_packet)
{
	ULONG type_of_service;

	/* find route by IP header destination address */

	type_of_service = (ULONG) 0x01;

	*ptr_to_sptr_route_entry = ip_find_route_and_update_cache (sptr_ip_parameters->destination_address, type_of_service);

	/* for strict source route, next stop must be a local subnet or point-to-point link */

	if ((*ptr_to_sptr_route_entry == NULL) ||
		((strict_source_route_flag == TRUE) && ((*ptr_to_sptr_route_entry)->gateway != 0x00000000L)))
		{
#ifdef _BIG_PROXY_
		++ip.mib.ipInHdrErrors;
#endif

	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, "IP: rxed strict source route option, next route is not on local network, %s --> %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__DEBUG__ */

		sptr_ip_parameters->destination_address = net_to_host_long (uptr_ip_packet->ip.header.destination_ip_address);

		send_destination_unreachable_icmp_error_packet (sptr_ip_parameters, processed_option_length, uptr_ip_packet,
			ICMP_ROUTE_FAIL_CODE);

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
enum TEST process_record_route_option (IP_OPTION *sptr_option, USHORT processed_option_length,
	UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters,
	USHORT current_option_length, enum BOOLEAN *eptr_need_new_checksum, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry)
{
	USHORT source_route_pointer;

	source_route_pointer = sptr_option->pointer;

	if ((current_option_length < MINIMUM_SOURCE_ROUTE_OPTION_LENGTH) || (source_route_pointer < MINIMUM_SOURCE_ROUTE_POINTER))
		{
		when_there_is_not_enough_room_in_record_route_option (sptr_ip_parameters, processed_option_length, sptr_ip_packet);

		return (FAIL);
		}

	--source_route_pointer;

	if ((source_route_pointer + sizeof (ULONG)) > current_option_length)
		{
		if (when_route_list_is_used_up_send_icmp_message (sptr_ip_parameters, processed_option_length, sptr_ip_packet,
			source_route_pointer, current_option_length) == FAIL)
			{
			return (FAIL);
			}

		return (PASS);
		}
	else
		{
		if (ip_match_full_address_to_port (sptr_ip_parameters->destination_address) != NO_SUCH_PORT)
			{
			/* if destination is us */

			*(ULONG *) ((BYTE *) sptr_option + source_route_pointer) = host_to_net_long (sptr_ip_parameters->destination_address);
			}
		else
			{
			if (find_route_and_if_route_exists_put_ip_address_of_outgoing_interface_in_route_record (sptr_option,
				processed_option_length, sptr_ip_packet, sptr_ip_parameters, ptr_to_sptr_route_entry, source_route_pointer) == FAIL)
				{
				return (FAIL);
				}
			}

		sptr_option->pointer += (BYTE) (IP_ADDRESS_LENGTH);

		*eptr_need_new_checksum = TRUE;
		}

	return (PASS);
}
/****************************************************************************/
static void	when_there_is_not_enough_room_in_record_route_option (IP_PARAMETERS *sptr_ip_parameters,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet)
{
#ifdef _BIG_PROXY_
	++ip.mib.ipInHdrErrors;
#endif
#ifdef __IP_DEBUG__
	ip_printf (IP_PRINTF, "IP: record route option too short from %s to %s\n",
		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address));
#endif /* __IP__DEBUG__ */

	send_parameter_problem_type_icmp_error_packet (sptr_ip_parameters, processed_option_length, sptr_ip_packet);
}
/****************************************************************************/
static enum TEST when_route_list_is_used_up_send_icmp_message (IP_PARAMETERS *sptr_ip_parameters,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet, USHORT source_route_pointer, USHORT current_option_length)
{
	/* route list used up, send icmp message */

#ifdef __IP_DEBUG__
	ip_printf (IP_PRINTF, "IP: record route list used up from %s to %s\n",
		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address));
#endif /* __IP__DEBUG__ */

	send_parameter_problem_type_icmp_error_packet (sptr_ip_parameters, processed_option_length, sptr_ip_packet);

	if (source_route_pointer != current_option_length)
		{
		/* bad pointer */
#ifdef _BIG_PROXY_
		++ip.mib.ipInHdrErrors;
#endif
	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, "IP: record route option pointer is bad, from %s to %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__DEBUG__ */

		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST find_route_and_if_route_exists_put_ip_address_of_outgoing_interface_in_route_record (IP_OPTION *sptr_option,
	USHORT processed_option_length, UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters,
	IP_ROUTE_ENTRY **sptr_route_entry, USHORT source_route_pointer)
{
	ULONG type_of_service;

	type_of_service = (ULONG) 0x01;

	*sptr_route_entry = ip_find_route_and_update_cache (sptr_ip_parameters->destination_address, type_of_service);

	if (*sptr_route_entry == NULL)
		{
	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, "IP: no route, from %s to %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__DEBUG__ */

		send_destination_unreachable_icmp_error_packet (sptr_ip_parameters, processed_option_length, sptr_ip_packet,
			ICMP_HOST_UNREACHABLE_CODE);

		return (FAIL);
		}

	*(ULONG *) ((BYTE *) sptr_option + source_route_pointer) =
		host_to_net_long (ip.port[(*sptr_route_entry)->port_number].config.ip_address);

	return (PASS);
}
#endif
