#include	"defs.h"

/*
 * $Log: /IP/IPTX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: iptx.c$  $version: 1.24$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/09/94 yarran fix reassembly bug
1.4 02/09/94 yarran Fix fragmentation bug
1.5 02/15/94 yarran Fix fragmentation bug -- losing one transport buffer for each fragmentation.
1.6 02/22/94 yarran Fix i960 compiler error - cast on header.vptr_data, bad name over 32 characters.
1.7 02/28/94 yarran Delete SNAP initialization in send_packet_to_lsl.
1.8 02/28/94 yarran Change route, port flags from bit map to enum BOOLEAN.
1.9 03/01/94 yarran Split iptx.c to multiple files.
1.10 05/02/94 yarran added rfc1042 changes.
1.11 05/03/94 yarran fixed rfc1042 bug.
1.12 06/15/94 yarran added check for function pointer being null in send_packet to lsl.
1.13 09/01/94 ross added BYTE and USHORT_ENUM support.
1.14 10/10/94 ross added rarp, proxy arp, remote access functions
1.15 10/10/94 ross added copyrights, udp fixes.
1.16 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.17 11/01/94 ross testing remote access.
1.18 11/04/94 ross remote access testing and fixes.
1.19 12/20/94 ross
1.20 12/27/94 ross added better table instrumentation via new snmp.
1.21 01/17/95 ross fixed arp problems from snmp
1.22 03/03/95 ross added lsl control.
1.23 06/29/95 ross new snmp access routine
1.24 10/25/95 ross
* 	$lge$
*/

/*
History of Changes :
		{Jo, 27 Oct 1999, Removed static function prototype for 
			post_processing_an_ip_packet to fix memory leakages}
*/

/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stddef.h>
#include	<string.h>
#include	"ip.h"
#ifdef IP_FILTERING
#include "ipfilt.h"
#endif


/*************************************************************************/
/* Kamalnath 08\02\1997 Removed static decl to call from iprxbc.c */
enum IP_SEND_CONFIRMATION send_ip_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	USHORT number_of_bytes, IP_ROUTE_CACHE_ENTRY *sptr_route_cache, USHORT tx_port_number, enum BOOLEAN do_checksum,
	enum BOOLEAN change_ip_destination_for_source_route, enum BOOLEAN forwarded_packet,
	void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet),
	ULONG type_of_service, IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters);
/*
static enum IP_SEND_CONFIRMATION send_ip_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	USHORT number_of_bytes, IP_ROUTE_CACHE_ENTRY *sptr_route_cache, USHORT tx_port_number, enum BOOLEAN do_checksum,
	enum BOOLEAN change_ip_destination_for_source_route, enum BOOLEAN forwarded_packet,
	void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet),
	ULONG type_of_service, IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters);
*/
static enum TEST determine_next_hop_ip_address_and_outgoing_port (ULONG *ulptr_next_hop_ip_address,
	USHORT *usptr_outgoing_port_number, IP_PORT_CLASS **ptr_to_sptr_outgoing_port, IP_ROUTE_CACHE_ENTRY *sptr_route_cache,
	ULONG destination_address, USHORT tx_port_number, ULONG type_of_service,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters);
static enum BOOLEAN check_if_packet_is_filtered (USHORT outgoing_port_number, IP_PORT_CLASS *sptr_outgoing_port,
	UNION_IP_PACKET *sptr_ip_packet);
static void fill_in_source_address_in_ip_header_if_applicable (ULONG source_address, USHORT outgoing_port_number,
	IP_PORT_CLASS *sptr_outgoing_port, UNION_IP_PACKET *sptr_ip_packet, enum BOOLEAN *eptr_do_checksum);
static enum BOOLEAN check_if_it_is_ok_to_send_packet_if_next_hop_ip_address_is_a_broadcast_address (
	IP_PARAMETERS *sptr_ip_parameters, ULONG next_hop_ip_address, IP_PORT_CLASS *sptr_outgoing_port,
	enum IP_SEND_CONFIRMATION *eptr_return_code, enum BOOLEAN *eptr_is_broadcast);
static enum TEST build_ip_header_and_ip_options (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	UNION_IP_PACKET *sptr_ip_packet, USHORT *usptr_number_of_bytes, IP_PARAMETERS *sptr_ip_parameters,
	void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet));
static enum BOOLEAN check_if_ip_option_length_is_valid (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	UNION_IP_PACKET *sptr_ip_packet, void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet));
static void	build_ip_header (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, UNION_IP_PACKET *sptr_ip_packet,
	USHORT number_of_bytes, IP_PARAMETERS *sptr_ip_parameters);
static void	build_ip_options (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, UNION_IP_PACKET *sptr_ip_packet,
	USHORT *usptr_number_of_bytes);
static void	build_new_set_of_ip_parameters (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	IP_PARAMETERS *sptr_ip_parameters);
void	post_processing_an_ip_packet (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT result_code,
	void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet));

extern USHORT ip_get_outgoing_port_number_from_ip_address (ULONG destination_ip_address);
extern void modify_outgoing_port_number_to_support_ip_extensions (USHORT *usptr_outgoing_port_number,
	ULONG ip_destination_address);
extern enum BOOLEAN check_and_process_the_packets_to_or_from_internet_servers (UNION_IP_PACKET *,
	IP_PARAMETERS *, USHORT *, enum BOOLEAN *, enum BOOLEAN *);

/*************************************************************************/
void send_ip_packet_from_upper_layer (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	enum BOOLEAN forwarded_packet, IP_PACKET *sptr_ip_packet, USHORT number_of_bytes,
	void (*fptr_tx_completion) (USHORT port_number, IP_PACKET *sptr_ip_packet))
{
	USHORT result_code;
	IP_PARAMETERS ip_layer_parameters;
	USHORT outgoing_port_number=0;
	enum BOOLEAN is_my_packet=FALSE, pkt_size_modified = FALSE;

#ifdef _BIG_PROXY_
	++ip.mib.ipOutRequests;
#endif

	memset (&ip_layer_parameters, 0x00, sizeof (IP_PARAMETERS));

	if (build_ip_header_and_ip_options (sptr_ip_upper_layer_parameters, (UNION_IP_PACKET *) sptr_ip_packet, &number_of_bytes,
		&ip_layer_parameters,
		(void (*) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet)) fptr_tx_completion) == FAIL)
		{
/* Sachin 07.06.1996 */
			/*
			If build_ip_header_and_ip_options() fails, it is its responsibility
			to free up the allocated buffer. So by the time control comes here,
			the buffer should be freed. Make modifications if need be in the code
			for build_ip_...() to ensure that.
			*/
/* Sachin 07.06.1996 */
		return;
		}

		if (sptr_ip_upper_layer_parameters->virtual_port_number == NO_SUCH_PORT)
			sptr_ip_upper_layer_parameters->virtual_port_number = ip_get_outgoing_port_number_from_ip_address(sptr_ip_upper_layer_parameters->destination_address); 

/* sudhir new fix */
/* Jo 11/08/98 */
#if 0
		if ((ip.port[0].config.default_gateway != 0x0L) &&
			((ip.port[sptr_ip_upper_layer_parameters->virtual_port_number].config.ip_address &
			ip.port[sptr_ip_upper_layer_parameters->virtual_port_number].config.subnetmask) ==  			
			(sptr_ip_upper_layer_parameters->destination_address & ip.port[sptr_ip_upper_layer_parameters->virtual_port_number].config.subnetmask)))
		{
			sptr_ip_upper_layer_parameters->gateway = ip.port[0].config.default_gateway;
		}
#endif
/* Jo 11/08/98 */
		
		

/* sudhir */
	if (check_and_process_the_packets_to_or_from_internet_servers (sptr_ip_packet,
			&ip_layer_parameters, &outgoing_port_number, &is_my_packet, &pkt_size_modified) == TRUE)
	{
/*		printf ("IP: Sending packets to internet client\n"); */
		result_code = (USHORT) send_ip_packet (&ip_layer_parameters, (UNION_IP_PACKET *) sptr_ip_packet, number_of_bytes,
			(IP_ROUTE_CACHE_ENTRY *) sptr_ip_upper_layer_parameters->vptr_cached_route,
			outgoing_port_number, TRUE, FALSE, forwarded_packet,
			(void (*) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet)) fptr_tx_completion,
			(ULONG) *((BYTE *) &sptr_ip_upper_layer_parameters->type_of_service), sptr_ip_upper_layer_parameters);

		return;
	}
/* sudhir */


	result_code = (USHORT) send_ip_packet (&ip_layer_parameters, (UNION_IP_PACKET *) sptr_ip_packet, number_of_bytes,
		(IP_ROUTE_CACHE_ENTRY *) sptr_ip_upper_layer_parameters->vptr_cached_route,
		sptr_ip_upper_layer_parameters->virtual_port_number, TRUE, FALSE, forwarded_packet,
		(void (*) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet)) fptr_tx_completion,
		(ULONG) *((BYTE *) &sptr_ip_upper_layer_parameters->type_of_service), sptr_ip_upper_layer_parameters);

/* Sachin 07/06/1996 */
	/*
		result_codes for which the buffer is not freed :
		IP_SEND_NO_ROUTE
		IP_SEND_PACKET_FILTERED
		IP_SEND_BROADCAST_NOT_AVAILABLE
		IP_SEND_MESSAGE_TOO_BIG
		.....

		If result code is not IP_SEND_OK, the buffer has not been freed
	*/

/* Sachin 07/06/1996 */

	post_processing_an_ip_packet (sptr_ip_upper_layer_parameters, (UNION_IP_PACKET *) sptr_ip_packet, &ip_layer_parameters,
		result_code, (void (*) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet)) fptr_tx_completion);

	return;
}
/****************************************************************************/
static enum TEST build_ip_header_and_ip_options (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	UNION_IP_PACKET *sptr_ip_packet, USHORT *usptr_number_of_bytes, IP_PARAMETERS *sptr_ip_parameters,
	void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet))
{
/* Sachin 13/06/1996 */
	/*
	This routine is called only from send_ip_packet_from_upper_layer(). It MUST
	free up the buffer IF AND ONLY IF it fails. 
	*/
/* Sachin 13/06/1996 */

	if (ip_check_if_source_address_is_valid (sptr_ip_upper_layer_parameters->source_address,
		sptr_ip_upper_layer_parameters->virtual_port_number) == FALSE)
	{
/* Sachin 02/05/1997 */
      if (fptr_tx_completion != NULL)
      {
         sptr_ip_packet = normalize_ip_send_packet_header (sptr_ip_upper_layer_parameters->virtual_port_number, sptr_ip_packet) ;
         (*fptr_tx_completion) (sptr_ip_upper_layer_parameters->virtual_port_number, (UNION_IP_PACKET *)sptr_ip_packet) ;
      }
/* Sachin 02/05/1997 */
		return (FAIL);
	}

	if (ip_check_if_destination_address_is_valid (sptr_ip_upper_layer_parameters->destination_address) == FALSE)
	{
/* Sachin 02/05/1997 */
      if (fptr_tx_completion != NULL)
      {
         sptr_ip_packet = normalize_ip_send_packet_header (sptr_ip_upper_layer_parameters->virtual_port_number, sptr_ip_packet) ;
         (*fptr_tx_completion) (sptr_ip_upper_layer_parameters->virtual_port_number, (UNION_IP_PACKET *)sptr_ip_packet) ;
      }
/* Sachin 02/05/1997 */
      return (FAIL) ;
	}

	if (check_if_ip_option_length_is_valid (sptr_ip_upper_layer_parameters, sptr_ip_packet, fptr_tx_completion) == FALSE)
	{
/* Sachin 07.06.1996 */
		/*
			Safe here. If it fails, check_if_ip_option_length_is_valid() fails, it
			frees up the buffer too.
		*/
/* Sachin 07.06.1996 */
		return (FAIL);
	}

	build_ip_options (sptr_ip_upper_layer_parameters, sptr_ip_packet, usptr_number_of_bytes);

	build_ip_header (sptr_ip_upper_layer_parameters, sptr_ip_packet, *usptr_number_of_bytes, sptr_ip_parameters);

	build_new_set_of_ip_parameters (sptr_ip_upper_layer_parameters, sptr_ip_parameters);

	return (PASS);
}
/****************************************************************************/
static enum BOOLEAN check_if_ip_option_length_is_valid (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	UNION_IP_PACKET *sptr_ip_packet, void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet))
{
	if (sptr_ip_upper_layer_parameters->option_length > MAXIMUM_IP_OPTION_LENGTH)
	{
/* Sachin 02/05/1997 */
      if (fptr_tx_completion != NULL)
      {
         sptr_ip_packet = normalize_ip_send_packet_header (sptr_ip_upper_layer_parameters->virtual_port_number, sptr_ip_packet) ;
         (*fptr_tx_completion) (sptr_ip_upper_layer_parameters->virtual_port_number, (UNION_IP_PACKET *)sptr_ip_packet) ;
      }
/* Sachin 02/05/1997 */
      return (FALSE) ;
	}

	return (TRUE);
}
/****************************************************************************/
static void	build_ip_header (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, UNION_IP_PACKET *sptr_ip_packet,
	USHORT number_of_bytes, IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT sequence_id;

	/* WARNING! Assuming the space has been reserved by the upper layer to put ip header before the current data pointer. */

	sptr_ip_parameters->header_length = (USHORT) (MINIMUM_IP_HEADER_LENGTH + sptr_ip_upper_layer_parameters->option_length);
	sptr_ip_parameters->total_length = (USHORT) (number_of_bytes - sizeof (UNION_MAC_HEADER));

	if (sptr_ip_upper_layer_parameters->sequence_id > 0x0000)
		sequence_id = sptr_ip_upper_layer_parameters->sequence_id;
	else
		sequence_id = ++ip.sequence_id;

	sptr_ip_packet->ip.header.version_header_length.header_length = (BYTE) (sptr_ip_parameters->header_length >> 2);
	sptr_ip_packet->ip.header.version_header_length.version = IP_VERSION;
	sptr_ip_packet->ip.header.service_type = sptr_ip_upper_layer_parameters->type_of_service; 
	sptr_ip_packet->ip.header.total_length = host_to_net_short (sptr_ip_parameters->total_length);
	sptr_ip_packet->ip.header.identifier = host_to_net_short (sequence_id);
	sptr_ip_packet->ip.header.flags_fragment_offset.do_not_fragment_flag =
		sptr_ip_upper_layer_parameters->do_not_fragment_flag;
	sptr_ip_packet->ip.header.flags_fragment_offset.more_fragment_flag = FALSE;
	sptr_ip_packet->ip.header.flags_fragment_offset.fragment_offset_most_significant_part = 0x0;
	sptr_ip_packet->ip.header.fragment_offset_least_significant_part = 0x00;
	sptr_ip_packet->ip.header.flags_fragment_offset.unused_bit = FALSE;

	if (sptr_ip_upper_layer_parameters->time_to_live > 0x00)
		sptr_ip_packet->ip.header.time_to_live = sptr_ip_upper_layer_parameters->time_to_live;
	else
		sptr_ip_packet->ip.header.time_to_live = (BYTE) ip.ipDefaultTTL;

	sptr_ip_packet->ip.header.protocol = sptr_ip_upper_layer_parameters->protocol; 
	sptr_ip_packet->ip.header.source_ip_address = host_to_net_long (sptr_ip_upper_layer_parameters->source_address);
	sptr_ip_packet->ip.header.destination_ip_address = host_to_net_long (sptr_ip_upper_layer_parameters->destination_address);
}
/****************************************************************************/
static void	build_ip_options (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, UNION_IP_PACKET *sptr_ip_packet,
	USHORT *usptr_number_of_bytes)
{
	BYTE *bptr_option;
	BYTE option_length;
	USHORT ip_user_data_length;
	BYTE *bptr_ip_user_data;

	if (sptr_ip_upper_layer_parameters->option_length != 0x00)
	{
		ip_user_data_length = (USHORT) (*usptr_number_of_bytes - sizeof (UNION_MAC_HEADER) - sizeof (IP_HEADER));

	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, "IP: OPTIONS: shifted %u bytes of user data\n", ip_user_data_length);
	#endif /* __IP__DEBUG__ */

		bptr_ip_user_data = (BYTE *) &ip.print_buffer[0];

		memcpy ((void *) bptr_ip_user_data, (void *) &sptr_ip_packet->ip.options_or_data, ip_user_data_length);

		memcpy ((void *) ((ULONG) &sptr_ip_packet->ip.options_or_data + sptr_ip_upper_layer_parameters->option_length),
			(void *) bptr_ip_user_data, ip_user_data_length);

		memcpy ((void *) &sptr_ip_packet->ip.options_or_data, sptr_ip_upper_layer_parameters->user_options.char_options,
			sptr_ip_upper_layer_parameters->option_length);

	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, "IP: OPTIONS: copied %u bytes of options\n", sptr_ip_upper_layer_parameters->option_length);
	#endif /* __IP__DEBUG__ */

		*usptr_number_of_bytes = (USHORT) (*usptr_number_of_bytes + sptr_ip_upper_layer_parameters->option_length);
	}

	/* make ip options on 4-byte boundary */

	if (sptr_ip_upper_layer_parameters->option_length & 0x03)
	{
		option_length = sptr_ip_upper_layer_parameters->option_length;

		bptr_option = (BYTE *) &sptr_ip_packet->ip.options_or_data + sptr_ip_upper_layer_parameters->option_length;

		for (; option_length & 0x03; option_length += (BYTE) 1)
		{
			*bptr_option = IP_EOL_OPTION;

			++bptr_option;
		}
	}
}
/****************************************************************************/
static void	build_new_set_of_ip_parameters (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	IP_PARAMETERS *sptr_ip_parameters)
{
	/* build ip parameters for send_ip_packet to do checksum */

	sptr_ip_parameters->source_address = sptr_ip_upper_layer_parameters->source_address;
	sptr_ip_parameters->destination_address = sptr_ip_upper_layer_parameters->destination_address;
	sptr_ip_parameters->gateway = sptr_ip_upper_layer_parameters->gateway;
	sptr_ip_parameters->offset = 0x0000;
	sptr_ip_parameters->do_not_fragment_flag = sptr_ip_upper_layer_parameters->do_not_fragment_flag;
	sptr_ip_parameters->more_fragment_flag = FALSE;
	sptr_ip_parameters->type_of_service = sptr_ip_upper_layer_parameters->type_of_service;

	/* TITUS:
	 * at this point shouldn't any changes to the time_to_live field from the above header processing be accounted for ? */

	sptr_ip_parameters->time_to_live = sptr_ip_upper_layer_parameters->time_to_live;

/* sudhir  2/2/98 */
	sptr_ip_parameters->protocol = sptr_ip_upper_layer_parameters->protocol;
/* sudhir  2/2/98 */

}
/****************************************************************************/
enum IP_SEND_CONFIRMATION send_ip_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	USHORT number_of_bytes, IP_ROUTE_CACHE_ENTRY *sptr_route_cache, USHORT tx_port_number, enum BOOLEAN do_checksum,
	enum BOOLEAN change_ip_destination_for_source_route, enum BOOLEAN forwarded_packet,
	void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet), ULONG type_of_service,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters)
{
	enum BOOLEAN is_broadcast;
	USHORT outgoing_port_number;
	ULONG next_hop_ip_address;
	IP_PORT_CLASS *sptr_outgoing_port;
	enum IP_SEND_CONFIRMATION normal_return_code;

#ifdef __IP_BREAKPOINT__
	check_for_ip_runtime_breakpoint ();
#endif /* __IP_BREAKPOINT__ */

	next_hop_ip_address = 0x00000000L;

	outgoing_port_number = NO_SUCH_PORT;

	if (determine_next_hop_ip_address_and_outgoing_port (&next_hop_ip_address, &outgoing_port_number, &sptr_outgoing_port,
		sptr_route_cache, sptr_ip_parameters->destination_address, tx_port_number, type_of_service,
		sptr_ip_upper_layer_parameters) == FAIL)
	{
			return (IP_SEND_NO_ROUTE);
	}

	sptr_ip_parameters->gateway = next_hop_ip_address;

	if (check_if_packet_is_filtered (outgoing_port_number, sptr_outgoing_port, sptr_ip_packet) == TRUE)
	{
		return (IP_SEND_PACKET_FILTERED);
	}

	fill_in_source_address_in_ip_header_if_applicable (sptr_ip_parameters->source_address, outgoing_port_number,
		sptr_outgoing_port, sptr_ip_packet, &do_checksum);

	if (check_if_it_is_ok_to_send_packet_if_next_hop_ip_address_is_a_broadcast_address (sptr_ip_parameters,
		next_hop_ip_address, sptr_outgoing_port, &normal_return_code, &is_broadcast) == FALSE)
{
			return (normal_return_code);
}
	if (change_ip_destination_for_source_route == TRUE)
		sptr_ip_packet->ip.header.destination_ip_address = host_to_net_long (next_hop_ip_address);

		/* TITUS: now that we have modified the ip header, shouldn't we ensure that checksum is recomputed ? */

	normal_return_code = check_for_fragmentation_and_send_packet (sptr_ip_parameters, sptr_ip_packet, number_of_bytes,
		sptr_outgoing_port, do_checksum, outgoing_port_number, is_broadcast, forwarded_packet, next_hop_ip_address,
		fptr_tx_completion);
	return (normal_return_code);
}
/*************************************************************************/
static enum TEST determine_next_hop_ip_address_and_outgoing_port (ULONG *ulptr_next_hop_ip_address,
	USHORT *usptr_outgoing_port_number, IP_PORT_CLASS **ptr_to_sptr_outgoing_port, IP_ROUTE_CACHE_ENTRY *sptr_route_cache,
	ULONG destination_address, USHORT tx_port_number, ULONG type_of_service,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters)
{
	if (tx_port_number != NO_SUCH_PORT)
	{
		/* Do not look for routing table or cache. */

		*usptr_outgoing_port_number = tx_port_number;
		if (sptr_ip_upper_layer_parameters->gateway != 0x0L)
			*ulptr_next_hop_ip_address = sptr_ip_upper_layer_parameters->gateway;
		else
			*ulptr_next_hop_ip_address = destination_address;
	}
	else
	{
		if ((sptr_route_cache != NULL) && (sptr_route_cache->target == destination_address))
		{
			*ulptr_next_hop_ip_address = sptr_route_cache->gateway;
			*usptr_outgoing_port_number = sptr_route_cache->port_number;
			modify_outgoing_port_number_to_support_ip_extensions (usptr_outgoing_port_number, destination_address) ;
		}
		else if ((ip.sptr_most_recently_used_route != NULL) &&
			(ip.sptr_most_recently_used_route->target == destination_address))
		{
			*ulptr_next_hop_ip_address = ip.sptr_most_recently_used_route->gateway;
			*usptr_outgoing_port_number = ip.sptr_most_recently_used_route->port_number;

			modify_outgoing_port_number_to_support_ip_extensions (usptr_outgoing_port_number, destination_address) ;
#ifdef _BIG_PROXY_ /* Jo 26/05/99 */
			++ip.number_of_times_mru_route_was_used;
#endif /* Jo 26/05/99 */

/* Jo 23/04/99 */
		#if PRINT_IP_TABLE_INFO
			print_most_recently_used_cache_entry (ip.sptr_most_recently_used_route);
		#endif
/* Jo 23/04/99 */
		}
		else if ((*ulptr_next_hop_ip_address == 0x00000000L) &&
			(lookup_route_cache (destination_address, ulptr_next_hop_ip_address, usptr_outgoing_port_number,
			sptr_ip_upper_layer_parameters) == PASS))
		{
			modify_outgoing_port_number_to_support_ip_extensions (usptr_outgoing_port_number, destination_address) ;
		}
		else if (set_up_routing_data (usptr_outgoing_port_number, ulptr_next_hop_ip_address, sptr_route_cache,
			destination_address, type_of_service, sptr_ip_upper_layer_parameters) == FAIL)
		{
			return (FAIL);
		}
	}

	*ptr_to_sptr_outgoing_port = &ip.port[*usptr_outgoing_port_number];

	sptr_ip_upper_layer_parameters->virtual_port_number = *usptr_outgoing_port_number;

	return (PASS);
}
/*************************************************************************/
static enum BOOLEAN check_if_packet_is_filtered (USHORT outgoing_port_number, IP_PORT_CLASS *sptr_outgoing_port,
	UNION_IP_PACKET *sptr_ip_packet)
{
#ifdef IP_FILTERING
	if (ip_tx_filter (outgoing_port_number, sptr_ip_packet) == TRUE)
		{
#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
		++sptr_outgoing_port->statistics.number_of_txed_packets_filtered;
#endif /* Jo 26/05/99 */

		return (TRUE);
		}
#else
	PARAMETER_NOT_USED (outgoing_port_number);
	PARAMETER_NOT_USED (sptr_outgoing_port);
	PARAMETER_NOT_USED (sptr_ip_packet);
#endif

	return (FALSE);
}
/*************************************************************************/
static void fill_in_source_address_in_ip_header_if_applicable (ULONG source_address, USHORT outgoing_port_number,
	IP_PORT_CLASS *sptr_outgoing_port, UNION_IP_PACKET *sptr_ip_packet, enum BOOLEAN *eptr_do_checksum)
{
	if ((source_address == INTERNET_ADDRESS_ANY) && (ip.port[outgoing_port_number].config.bootp_enabled == FALSE))
		{
		sptr_ip_packet->ip.header.source_ip_address = host_to_net_long (sptr_outgoing_port->config.ip_address);

		*eptr_do_checksum = TRUE;
		}
}
/*************************************************************************/
static enum BOOLEAN check_if_it_is_ok_to_send_packet_if_next_hop_ip_address_is_a_broadcast_address (
	IP_PARAMETERS *sptr_ip_parameters, ULONG next_hop_ip_address, IP_PORT_CLASS *sptr_outgoing_port,
	enum IP_SEND_CONFIRMATION *eptr_return_code, enum BOOLEAN *eptr_is_broadcast)
{
	*eptr_is_broadcast = is_broadcast_address (next_hop_ip_address);

	if (*eptr_is_broadcast == TRUE)
	{
		if (sptr_outgoing_port->allow_broadcast == FALSE)
		{
			*eptr_return_code = IP_SEND_BROADCAST_NOT_AVAILABLE;
			return (FALSE);
		}

		/* TITUS: shouldn't the next IF statement be outside the scope of "if (is_broadcast == TRUE)" ? */
		/* TITUS: or is fragmentation disallowed for broadcast packets ? */

		if (sptr_ip_parameters->total_length > sptr_outgoing_port->config.mtu)
		{
			*eptr_return_code = IP_SEND_MESSAGE_TOO_BIG;
			return (FALSE);
		}
	}

	return (TRUE);
}
/****************************************************************************/
/* Modified by Jo on 27 Oct 1999 to fix memory leakages... */
void post_processing_an_ip_packet (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT result_code,
	void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet))
{
#ifndef __IP_ALARM_DEBUG__
	PARAMETER_NOT_USED (sptr_ip_parameters);
#endif /* __IP_ALARM_DEBUG__ */

	if (result_code != IP_SEND_OK)
	{
#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
	#ifdef __IP_ALARM_DEBUG__
		if (result_code != IP_SEND_NO_ARP_TABLE_ENTRY)
		{
			ip_printf (IP_ALARM_PRINTF, select_print_ip_message (ip_send_messages, TOTAL_IP_SEND_CONFIRMATIONS, result_code,
				sptr_ip_parameters->gateway));
		}
	#endif /* __IP_ALARM_DEBUG__ */
#endif /* Jo 26/05/99 */

/* Sachin 02/05/1997 */
      /* For all return codes we need to free the buffer except
         in the case of IP_SEND_REAL_PORT_DISABLED, in which
         case send_packet_to_lsl() does the freeing.
         WHAT ABOUT IP_SEND_NO_ARP_TABLE_ENTRY ???????????
         Dont we have to keep away from freeing the buffer ?
         The same buffer is queued up in the particular
         ARP entry right ????????????????????
      */

		if (fptr_tx_completion != NULL)
		{
         if (result_code != IP_SEND_REAL_PORT_DISABLED)
			{
				sptr_ip_packet = normalize_ip_send_packet_header (sptr_ip_upper_layer_parameters->virtual_port_number,
					sptr_ip_packet);
            (*fptr_tx_completion) (sptr_ip_upper_layer_parameters->virtual_port_number, (UNION_IP_PACKET *) sptr_ip_packet) ;
/* Jo 27/10/99 testing */
/* Jo 27/10/99 testing */
			}
      }
/* Sachin 02/05/1997 */
		else
      {
         #ifdef __IP_ALARM_DEBUG__
         ip_printf (IP_ALARM_PRINTF, "IP: no transmit completion routine available to free packet\n");
         #endif /* __IP_ALARM_DEBUG__ */
      }
	}
}
/* ...Modified by Jo on 27 Oct 1999 to fix memory leakages */
/*************************************************************************/
UNION_IP_PACKET *normalize_ip_send_packet_header (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet)
{
/* Sachin 02/05/1997 */
   /* This function is called from inside the IP module just before freeing.
   When we allocate an IP packet (using get_a_free...() we return a buffer
   with some space for MAC headers. So, we need to reposition the header
   back so that we pass the right parameter to free.

   USHORT size_of_extra_header ;

   if (port_number != NO_SUCH_PORT)
   {
      size_of_extra_header = get_size_of_ip_link_layer_type_header (port_number) ;
      size_of_extra_header -= sizeof ((USHORT_ENUM) SNAP_PROTOCOL_ID) ;

      sptr_ip_packet = (UNION_IP_PACKET *) ((ULONG) sptr_ip_packet - size_of_ip_extra_header) ;
   }
   else
		printf ("Trying to normalize header with port number : NO_SUCH_PORT\n") ;
   

/* Sachin 02/05/1997 */

	return (sptr_ip_packet);
}
/*************************************************************************/
void send_completion_ip_packet (USHORT port_number, void *vptr_txed_packet)
{
#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "IP: send_completion_ip_packet called with: %p on port: %u\n", vptr_txed_packet, port_number);
#endif /* __IP__DEBUG__ */

	free_an_ip_send_packet (port_number, (UNION_IP_PACKET *) vptr_txed_packet);
}
/****************************************************************************/

/* Jo 11/08/99 Added the last parameter - gateway address */

enum FORWARD_STATUS forward_ip_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	enum BOOLEAN need_new_checksum, enum BOOLEAN change_ip_destination_for_source_route, USHORT number_of_bytes, USHORT dest_port_number, ULONG gateway_address)
{
	enum IP_SEND_CONFIRMATION result_code;
	IP_UPPER_LAYER_PARAMETERS dummy_parameters;

/* sudhir 9/11/97 for proxy server */
	enum BOOLEAN do_not_free_buffer;


	/* adjust the header checksum for modified TTL */

	if (need_new_checksum == FALSE)
	{
		sptr_ip_parameters->checksum = (USHORT) (sptr_ip_parameters->checksum + 0x100);

		if ((sptr_ip_parameters->checksum & 0xff00) == 0x0000)
			++sptr_ip_parameters->checksum;

		sptr_ip_packet->ip.header.header_checksum = host_to_net_short (sptr_ip_parameters->checksum);
	}

	keep_count_of_the_type_of_packet_that_was_forwarded (sptr_ip_parameters);

/* sudhir for proxy server */
#ifdef __PROXY_SERVER_
/* Jo 11/08/99 Added for Static routes */
	
	if (dest_port_number != NO_SUCH_PORT)
	{
		if (dest_port_number == 0)		
			dummy_parameters.gateway = gateway_address ;
		else
			dummy_parameters.gateway = ip.port[dest_port_number].config.point_to_point_remote_ip_address ; 
	}
/* Jo 11/08/99 Added for Static routes */		
#endif
/* sudhir for proxy server */
   
 	if (sptr_ip_parameters->union_ip_packet_is_to_be_freed == TRUE)
		do_not_free_buffer = FALSE;	
	else
		do_not_free_buffer = TRUE;	
   
	result_code = send_ip_packet (sptr_ip_parameters, sptr_ip_packet, number_of_bytes, (IP_ROUTE_CACHE_ENTRY *) NULL,
		dest_port_number, need_new_checksum, change_ip_destination_for_source_route, do_not_free_buffer, NULL,
		(ULONG) *((BYTE *) &sptr_ip_parameters->type_of_service), &dummy_parameters);
	if (result_code == IP_SEND_OK)
	{

#ifdef _BIG_PROXY_
		++ip.mib.ipForwDatagrams;
#endif

		return (FORWARD_OK);
	}
	else
	{
#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
		++ip.statistics.number_of_packets_that_couldnot_be_forwarded;
#endif /* Jo 26/05/99 */

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, select_print_ip_message (ip_send_messages, (USHORT) TOTAL_IP_SEND_CONFIRMATIONS,
			(USHORT) result_code, sptr_ip_parameters->destination_address));
	#endif /* __IP__DEBUG__ */
#endif /* Jo 26/05/99 */

		return (FORWARD_FAIL);
  	}
}
/*************************************************************************/
void send_completion_ip_list_packet (USHORT port_number, IP_LIST_PACKET *sptr_txed_packet)
{
#ifndef __IP_DEBUG__
	PARAMETER_NOT_USED (port_number);
#endif /* __IP__DEBUG__ */

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "IP: send_completion_ip_list_packet called with: %p on port: %u\n", sptr_txed_packet,
		port_number);
#endif /* __IP__DEBUG__ */

	sptr_txed_packet = (IP_LIST_PACKET *) ((ULONG) sptr_txed_packet - sizeof (LIST_HEADER));

	free_ip_list_packet (sptr_txed_packet);
}
