#include	"defs.h"
/*
 * $Log: /IP/IPUTIL.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: iputil.c$  $version: 1.17$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/09/94 yarran Fix free_fragment bug
1.4 02/22/94 yarran Fix i960 compiler error - cast on header.vptr_data, bad name over 32 characters.
1.5 02/28/94 yarran Add get_ip_mtu() to support TCP.
1.6 03/01/94 yarran Split iputil.c to multiple files.
1.7 05/02/94 yarran added rfc1042 changes.
1.8 06/15/94 yarran cosmetic changes.
1.9 09/01/94 ross added BYTE and USHORT_ENUM support.
1.10 10/10/94 ross added copyrights, udp fixes.
1.11 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.12 12/20/94 ross
1.13 12/27/94 ross added better table instrumentation via new snmp.
1.14 01/17/95 ross fixed arp problems from snmp
1.15 01/26/95 ross SNMP name change, printf change.
1.16 06/29/95 ross new snmp access routine
1.17 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	"ip.h"
/****************************************************************************/

static void ip_print_route_entry_flags_and_mask (IP_ROUTE_ENTRY *sptr_route_entry, ULONG mask, char **ptr_to_ptr_to_string);
#if PRINT_IP_TABLE_INFO /* Jo 23/04/99 */
#endif /* Jo 23/04/99 */
#ifdef __IP_ALARM_DEBUG__
static void packet_allocation_error (USHORT port_number,ULONG size_of_packet);
#endif /* __IP__ALARM_DEBUG__ */


/* 07/07/99 Jo added for Static routes */
enum BOOLEAN check_if_packet_is_destined_to_configured_static_routes (ULONG destination_address, IP_ROUTE_ENTRY **route_entry_ptr) ;
enum BOOLEAN get_port_number_if_statically_configured (ULONG destination_address, USHORT *port_number) ;

/****************************************************************************/
/* Return TRUE if the address might be a local broadcast address. */

enum BOOLEAN is_broadcast_address (ULONG ip_address)
{
	USHORT port_index;
	IP_PORT_CLASS *sptr_port;

  if ((ip_address == INTERNET_ADDRESS_BROADCAST) || (ip_address == INTERNET_ADDRESS_ANY))
		return (TRUE);

	for (port_index = 0x0000; port_index < ip.number_of_ports; ++port_index)
	{
		if (ip.port[port_index].config.port_enabled == TRUE)
		{
			sptr_port = &ip.port[port_index];

			if ((sptr_port->allow_broadcast == TRUE) &&
				((sptr_port->subnet_broadcast_address == ip_address) || (sptr_port->net_broadcast_address == ip_address) ||
				 /* for old broadcast host portion 0 */
				 (ip_address == sptr_port->subnet_address) || (ip_address == sptr_port->net_address)))
				{
				return (TRUE);
				}
		}
	}

  return (FALSE);
}
/****************************************************************************/
enum BOOLEAN received_broadcast_from_interface (USHORT port_number, UNION_IP_PACKET *uptr_ip_packet)
{
	enum BOOLEAN mac_broadcast;

	if (ip.port[port_number].config.point_to_point_link == TRUE)
	{
		/* Kamalnath 12\02\1997 */
		/*if ((ip.port[port_number].config.bootp_enabled == TRUE) */
		if ((ip.port[port_number].config.remote_access_enabled == TRUE) 
		/* Kamalnath 12\02\1997 */
		  && (net_to_host_long (uptr_ip_packet->ip.header.destination_ip_address) == INTERNET_ADDRESS_BROADCAST))
		{
			mac_broadcast = TRUE;
		}
		else
			mac_broadcast = FALSE;
	}
	else
	{
		if (ip.port[port_number].config.token_ring == FALSE)
		{
/* Jo 23/03/99 To take care of return value */
/*			mac_broadcast = (enum BOOLEAN) (((ETHERNET_BUFFER *) uptr_ip_packet)->mac_header.destination_address._ulong
				& ETHERNET_BROADCAST_BIT); */
			mac_broadcast = (((ETHERNET_BUFFER *) uptr_ip_packet)->mac_header.destination_address._ulong
				& ETHERNET_BROADCAST_BIT) ? TRUE : FALSE; 
		}
		else
		{
/* Jo 23/03/99 To take care of return value */
/*			mac_broadcast = (enum BOOLEAN) (((ETHERNET_BUFFER *) uptr_ip_packet)->mac_header.destination_address._ulong
				& TOKEN_RING_BROADCAST_BIT); */
			mac_broadcast = (((ETHERNET_BUFFER *) uptr_ip_packet)->mac_header.destination_address._ulong
				& TOKEN_RING_BROADCAST_BIT) ? TRUE : FALSE; 
		}
	}

	return (mac_broadcast);
}
/****************************************************************************/
/* Perform end-around-carry adjustment */

static USHORT end_around_carry (ULONG sum)				/* Carries in high order 16 bits */
{
	USHORT csum;
	USHORT return_value;

	csum = (USHORT) (sum >> 16);

	while (csum != 0x0000)
		{
		sum = csum + (sum & 0xffffL);

		csum = (USHORT) (sum >> 16);
		}

	/* Chops to 16 bits */

	return_value = (USHORT) (sum & 0x0000ffffL);

	return (return_value);
}
/****************************************************************************/
static USHORT calculate_word_checksum (USHORT *usptr_short, USHORT length)
{
	ULONG sum;
	USHORT result;

	sum = 0x00000000L;

	while (length != 0x0000)
	{
		--length;
		sum += *usptr_short;
		++usptr_short;
	}

	result = end_around_carry (sum);

	return (result);
}
/****************************************************************************/
/* the data order is assumed to be network order. */

USHORT calculate_ip_checksum (PSEUDO_IP_PARAMETERS *sptr_pseudo_header, BYTE *bptr_start_from, USHORT length)
{
	USHORT word_checksum;
	ULONG sum;
	ULONG checksum;
	USHORT return_value;
/*
	int swap_bytes;

	swap_bytes = 0x0000;
*/
	sum = 0x00000000L;

	if (sptr_pseudo_header != NULL)
	{
		word_checksum = calculate_word_checksum ((USHORT *) sptr_pseudo_header, (USHORT) (sizeof (PSEUDO_IP_PARAMETERS)) >> 1);

		sum = word_checksum;
	}

	checksum = 0x00000000L;

	if (length > 1)
	{
		/* ptr_start_from must be on short word boundary */

		word_checksum = calculate_word_checksum ((USHORT *) bptr_start_from, (USHORT) (length >> 1));

/*
		if (swap_bytes != 0x0000)
			word_checksum = (USHORT) ((word_checksum << 8) | (word_checksum >> 8));
*/
		checksum += word_checksum;
	}

	/* Handle odd trailing byte */

	if (length & 1)
	{
#ifndef BIG_ENDIAN
		checksum += (unsigned char) (bptr_start_from[--length]);
#else
		checksum += (USHORT) (((unsigned char) (bptr_start_from[--length])) << 8);
#endif
	}

	sum += checksum;

	/* Do final end-around carry, complement and return */

	return_value = (USHORT) (~end_around_carry (sum) & 0xffff);

	return (return_value);
}
/****************************************************************************/
void extract_ip_header (IP_PARAMETERS *sptr_ip_parameters, IP_HEADER *sptr_ip_pdu, USHORT header_length)
{
	USHORT fragment_offset;

	sptr_ip_parameters->version = (BYTE) sptr_ip_pdu->version_header_length.version;
	sptr_ip_parameters->header_length = (USHORT) (sptr_ip_pdu->version_header_length.header_length << 2);
	sptr_ip_parameters->options_length = (BYTE) (header_length - MINIMUM_IP_HEADER_LENGTH);
	sptr_ip_parameters->type_of_service = sptr_ip_pdu->service_type;
	sptr_ip_parameters->total_length = net_to_host_short (sptr_ip_pdu->total_length);
	sptr_ip_parameters->id = net_to_host_short (sptr_ip_pdu->identifier);

	fragment_offset = (USHORT) ((sptr_ip_pdu->flags_fragment_offset.fragment_offset_most_significant_part << 8) +
		sptr_ip_pdu->fragment_offset_least_significant_part);

	sptr_ip_parameters->offset = (USHORT) (fragment_offset << 3);
	sptr_ip_parameters->more_fragment_flag = (BYTE_ENUM (BOOLEAN)) sptr_ip_pdu->flags_fragment_offset.more_fragment_flag;
	sptr_ip_parameters->do_not_fragment_flag = (BYTE_ENUM (BOOLEAN)) sptr_ip_pdu->flags_fragment_offset.do_not_fragment_flag;
	sptr_ip_parameters->time_to_live = sptr_ip_pdu->time_to_live;
	sptr_ip_parameters->protocol = (BYTE_ENUM (IP_PROTOCOL_VALUE)) sptr_ip_pdu->protocol;
	sptr_ip_parameters->checksum = net_to_host_short (sptr_ip_pdu->header_checksum);
	sptr_ip_parameters->source_address = net_to_host_long (sptr_ip_pdu->source_ip_address);
	sptr_ip_parameters->destination_address = net_to_host_long (sptr_ip_pdu->destination_ip_address);
}

/* Jo 23/03/99 */
#if 0
void ip_clear_all_counters (void)
{
	USHORT port_number_index;

	for (port_number_index = 0x0000; port_number_index < ip.number_of_ports; ++port_number_index)
		{
		memset (&ip.port[port_number_index].statistics,(int) NULL,sizeof (IP_PORT_STATISTICS));
		}
}
#endif
/* Jo 23/03/99 */

USHORT ip_get_mtu_for_outgoing_port (ULONG destination_address)
{
	IP_ROUTE_ENTRY *sptr_route;

	sptr_route = rip_search_route_table (destination_address);

	if (sptr_route == NULL)
		return (0x0000);
	else
		return (ip.port[sptr_route->port_number].config.mtu);
}
/****************************************************************************/
void ip_send_snmp_trap (USHORT port_number,void *vptr_packet,USHORT length)
{
	PARAMETER_NOT_USED (port_number);
	PARAMETER_NOT_USED (length);
	PARAMETER_NOT_USED (vptr_packet);

	return;
}
/****************************************************************************/
ULONG get_ip_address (USHORT virtual_port_number)
{
	return (ip.port[virtual_port_number].config.ip_address);
}

ULONG get_ip_remote_address (USHORT virtual_port_number)
{
	return (ip.port[virtual_port_number].config.point_to_point_remote_ip_address);
}
/*************************************************************************/
UNION_IP_PACKET *get_an_ip_send_packet (USHORT port_number, ULONG size_of_packet)
{
	UNION_IP_PACKET *sptr_return;
	USHORT size_of_extra_header;

	size_of_extra_header = get_size_of_ip_link_layer_type_header (port_number);

	sptr_return = (UNION_IP_PACKET *) buffer_malloc (size_of_packet + size_of_extra_header);

	if (sptr_return == NULL)
	{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: buffer_malloc () failed\n");

		packet_allocation_error (port_number, size_of_packet);
	#endif /* __IP__ALARM_DEBUG__ */

		return (NULL);
	}
	else
	{
	#ifdef __IP_DEBUG__
		ip_printf (IP_MEMORY_PRINTF, "IP: pointer to allocated buffer for port %04x, %p, bytes: %u\r\n", port_number,
			sptr_return, size_of_packet);
	#endif /* __IP__DEBUG__ */

		sptr_return = (UNION_IP_PACKET *) ((ULONG) sptr_return + (ULONG) size_of_extra_header);

	#ifdef __IP_DEBUG__
		ip_printf (IP_MEMORY_PRINTF, "IP: pointer to send packet for port %04x, %p\r\n", port_number, sptr_return);
	#endif /* __IP__DEBUG__ */

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
		++ip.statistics.number_of_allocated_packets_waiting_for_transmit_completes;
#endif /* Jo 26/05/99 */
	}

	return (sptr_return);
}
/****************************************************************************/
USHORT get_size_of_ip_link_layer_type_header (USHORT port_number)
{
	USHORT size_of_extra_header;

	size_of_extra_header = sizeof (USHORT_ENUM (SNAP_PROTOCOL_ID));

	if ((ip.port[port_number].config.token_ring == TRUE) && (ip.port[port_number].config.rfc1042_enabled == TRUE))
		size_of_extra_header += (USHORT) (sizeof (ROUTING_CONTROL_FIELD) + sizeof (BYTE));

	if (ip.port[port_number].config.token_ring == TRUE)
	{
		switch (ip.port[port_number].config.lsl_packet_type)
		{
			case LLC_PACKET:
				size_of_extra_header += (USHORT) sizeof (LLC_HEADER);
				break;
			case SNAP_PACKET:
				size_of_extra_header += (USHORT) sizeof (SNAP_HEADER);
				break;
		}
	}
	else
	{
		switch (ip.port[port_number].config.lsl_packet_type)
		{
			case ETHERNET_TYPE_II:
			case RAW_8023:
				break;
			case LLC_PACKET:
				size_of_extra_header += (USHORT) sizeof (LLC_HEADER);
				break;
			case SNAP_PACKET:
				size_of_extra_header += (USHORT) sizeof (SNAP_HEADER);
				break;
			default:
				break;
		}
	}

	return (size_of_extra_header);
}
/*************************************************************************/
void free_an_ip_send_packet (USHORT port_number, void *vptr_txed_packet)
{
	USHORT size_of_extra_header;

	/*	implementation dependent, you need to normalize your packet to your existing buffer structure
	 *	feel free to modify for your own buffering scheme. */

/* Sachin 02/05/1997 */
#if 0
	if (port_number != NO_SUCH_PORT)
	{
		size_of_extra_header = get_size_of_ip_link_layer_type_header (port_number);

		vptr_txed_packet = (void *) ((ULONG) vptr_txed_packet - size_of_extra_header);
	}
	else
	{
			printf ("IP: Free with invalid port number\r\n");
				return;
	}
#endif
/* Sachin 02/05/1997 */

/* Sachin 02/05/1997 */
   /* When free is called from device_driver_send_complete(), the
   buffer pointer passed is already modified to accomodate the extra
   header for that port. When free is called from the IP modules
   itself, we normalize_ip_send_packet_header() to adjust the
   header and send it. */

	size_of_extra_header = sizeof (USHORT_ENUM (SNAP_PROTOCOL_ID));
   vptr_txed_packet = (void *) ((ULONG) vptr_txed_packet - size_of_extra_header) ;
/* Sachin 02/05/1997 */

	buffer_free (vptr_txed_packet);

#if PRINT_IP_TABLE_INFO /* Jo 26/05/99 */
	--ip.statistics.number_of_allocated_packets_waiting_for_transmit_completes;
#endif /* Jo 26/05/99 */
}
/****************************************************************************/
void set_ip_class_to_zero (void)
{
	memset (&ip, (int) NULL, sizeof (IP_CLASS));
}


/* Jo 23/04/99 */
#if PRINT_IP_TABLE_INFO
void ip_print_routing_table (void)
{
	IP_ROUTE_ENTRY *sptr_route_entry;
	char *ptr_to_string;

/*	if (ip.print_class.ip_route_printing_enabled == TRUE)*/
		{
		ip_printf (IP_ROUTE_PRINTF, "IP: routing table:\n");

		sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);

		while (sptr_route_entry != NULL)
			{
			ptr_to_string = &ip.string_to_print[0];

			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_route_entry->target);

			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_route_entry->gateway);

			ptr_to_string += sprintf (ptr_to_string, "   ROUTE: target:%s,gateway:%s,metric:%u,port:%u,used:%u,age:%u\n",
				&ip.print_buffer[0], &ip.print_buffer_2[0], sptr_route_entry->metric, sptr_route_entry->port_number,
				sptr_route_entry->use_count, sptr_route_entry->aging_timer);

			ip_print_route_entry_flags_and_mask (sptr_route_entry, sptr_route_entry->mask, &ptr_to_string);

			ip_printf (IP_ROUTE_PRINTF, &ip.string_to_print[0]);

			sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
			}

		if (ip.default_route.port_number != NO_SUCH_PORT)
			{
			ptr_to_string = &ip.string_to_print[0];

			sptr_route_entry = &ip.default_route;

			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_route_entry->target);

			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_route_entry->gateway);

			ptr_to_string += sprintf (ptr_to_string, "   ROUTE: target:%s,gateway:%s,metric:%u,port:%u,used:%u,age:%u\n",
				&ip.print_buffer[0], &ip.print_buffer_2[0], sptr_route_entry->metric, sptr_route_entry->port_number,
				sptr_route_entry->use_count, sptr_route_entry->aging_timer);

			ip_print_route_entry_flags_and_mask (sptr_route_entry, 0x00000000L, &ptr_to_string);

			ip_printf (IP_ROUTE_PRINTF, &ip.string_to_print[0]);
			}
		}
}

static void ip_print_route_entry_flags_and_mask (IP_ROUTE_ENTRY *sptr_route_entry, ULONG mask, char **ptr_to_ptr_to_string)
{
	enum BOOLEAN flags_header_has_been_printed;

	flags_header_has_been_printed = FALSE;

	*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, "      ");

	if (sptr_route_entry->flags.local_interface_route == TRUE)
		{
		if (flags_header_has_been_printed == FALSE)
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, "FLAGS: local");
	 
			flags_header_has_been_printed = TRUE;
			}
		}

	if (sptr_route_entry->flags.private_route == TRUE)
		{
		if (flags_header_has_been_printed == FALSE)
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, "FLAGS: private");

			flags_header_has_been_printed = TRUE;
			}
		else
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ",private");
			}
		}

	if (sptr_route_entry->flags.overriding_allowed == TRUE)
		{
		if (flags_header_has_been_printed == FALSE)
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, "FLAGS: override");

			flags_header_has_been_printed = TRUE;
			}
		else
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ",override");
			}
		}

	if (sptr_route_entry->flags.host_route == TRUE)
		{
		if (flags_header_has_been_printed == FALSE)
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, "FLAGS: host");

			flags_header_has_been_printed = TRUE;
			}
		else
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ",host");
			}
		}

	if (sptr_route_entry->flags.do_no_aging == FALSE)
		{
		if (flags_header_has_been_printed == FALSE)
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, "FLAGS: aging");

			flags_header_has_been_printed = TRUE;
			}
		else
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ",aging");
			}
		}

	if (sptr_route_entry->flags.route_changed == TRUE)
		{
		if (flags_header_has_been_printed == FALSE)
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, "FLAGS: changed");

			flags_header_has_been_printed = TRUE;
			}
		else
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ",changed");
			}
		}

	if (sptr_route_entry->flags.route_down == TRUE)
		{
		if (flags_header_has_been_printed == FALSE)
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, "FLAGS: down");

			flags_header_has_been_printed = TRUE;
			}
		else
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ",down");
			}
		}

	if (sptr_route_entry->flags.no_subnet_mask == TRUE)
		{
		if (flags_header_has_been_printed == FALSE)
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, "FLAGS: no mask");

			flags_header_has_been_printed = TRUE;
			}
		else
			{
			*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ",no mask");
			}
		}
	else
		{
		convert_ip_address_to_dot_format (&ip.print_buffer[0], mask);

		*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ", MASK: %s", &ip.print_buffer[0]);
		}

	if (sptr_route_entry->ipRouteType == INVALID_ROUTE_TYPE)
		{
		*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ", TYPE: invalid");
		}
	else if (sptr_route_entry->ipRouteType == DIRECT_ROUTE_TYPE)
		{
		*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ", TYPE: direct");
		}
	else if (sptr_route_entry->ipRouteType == INDIRECT_ROUTE_TYPE)
		{
		*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ", TYPE: indirect");
		}
	else
		{
		*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ", TYPE: other");
		}

	if (sptr_route_entry->ipRouteProto == RIP_PROTOCOL_TYPE)
		{
		*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ", rip");
		}
	else if (sptr_route_entry->ipRouteProto == LOCALLY_CONFIGURED_TYPE)
		{
		*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ", configured");
		}
	else
		{
		*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, ", unknown");
		}

	*ptr_to_ptr_to_string += sprintf (*ptr_to_ptr_to_string, "\n");
}
#endif
/* Jo 23/04/99 */

#ifdef __IP_ALARM_DEBUG__
/*************************************************************************/
static void packet_allocation_error (USHORT port_number,ULONG size_of_packet)
{
	ip_printf (IP_ALARM_PRINTF, "IP: error allocating packet of size:%u for port:%04x \r\n", size_of_packet, port_number);
}
#endif /* __IP__ALARM_DEBUG__ */

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST

/* vidy added this to fix the SNMP-manager-not-showing-default-route problem */
/* this routine skips the default route(target= 0 for default_route) */
IP_ROUTE_ENTRY *get_first_ip_route_entry(void)
{
	IP_ROUTE_ENTRY *sptr_route_entry;

	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);

	if (sptr_route_entry && sptr_route_entry->target == 0)
		sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);

	return sptr_route_entry;

}
/* this routine skips the default route(target= 0 for default_route) */
IP_ROUTE_ENTRY *get_next_ip_route_entry( IP_ROUTE_ENTRY *sptr_route_entry)
{
 	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);

	if (sptr_route_entry && sptr_route_entry->target == 0)
		sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);

	return sptr_route_entry;
}

#endif

enum BOOLEAN check_if_ip_enabled ()
{
   return (ip.enabled) ;
}


/* Sachin 02/05/1997 */
/* functions to allocate and free buffer. You don't needto know the 
extra frame header size. Assumption is extra frame header wont
be more than 15 bytes */

ICMP_PACKET *get_an_icmp_send_packet (USHORT size_of_packet)
{
	UNION_IP_PACKET *sptr_icmp_tx_packet;
	BYTE *bptr_buffer;
	BYTE *bptr_offset;
	BYTE *bptr_new_offset;
	ULONG length;
	ULONG new_offset;

	length = size_of_packet + EXTRA_FRAME_HEADER_BYTES;

	bptr_buffer = (BYTE *) buffer_malloc (length);

	if (bptr_buffer == NULL)
		return (NULL);

	bptr_offset = bptr_buffer + EXTRA_FRAME_HEADER_BYTES/2;

	new_offset = (ULONG) bptr_offset & EXTRA_FRAME_HEADER_MASK;

	bptr_new_offset = (BYTE *) new_offset;

	memcpy ((void *) bptr_new_offset, (const void *) &bptr_buffer, sizeof (ULONG));

	sptr_icmp_tx_packet = (UNION_IP_PACKET *) (bptr_new_offset + EXTRA_FRAME_HEADER_BYTES/2);

	return (sptr_icmp_tx_packet);
}

void send_completion_icmp_packet (USHORT port_number, ICMP_PACKET *sptr_icmp_tx_packet)
{
	BYTE *bptr_buffer;
	BYTE *bptr_offset;
	BYTE *bptr_new_offset;
	ULONG new_offset;

	PARAMETER_NOT_USED (port_number);

	if (sptr_icmp_tx_packet == NULL)
		return;

	bptr_offset = (BYTE *) sptr_icmp_tx_packet;

	bptr_offset = (bptr_offset - (EXTRA_FRAME_HEADER_BYTES/4));

	new_offset = (ULONG) bptr_offset & EXTRA_FRAME_HEADER_MASK;

	bptr_new_offset = (BYTE *) new_offset;

	memcpy ((void *) &bptr_buffer, (const void *) bptr_new_offset, sizeof (ULONG));

	buffer_free ((void *) bptr_buffer);
}

/* Sachin 02/05/1997 */

/* sudhir calling from proxy server */
enum BOOLEAN is_ipport_up (USHORT port_number)
{
	IP_PORT_CLASS *sptr_port;

	sptr_port = &ip.port[port_number];

	return (sptr_port->port_is_up);
}

BYTE *get_ptr_to_ip_data_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
    BYTE *ptr_to_ip_data;

    ptr_to_ip_data = (BYTE *)((ULONG)uptr_ip_rx_packet+sizeof (UNION_MAC_HEADER)
	 							+sptr_ip_parameters->header_length);

    return ptr_to_ip_data;
}

enum BOOLEAN is_port_is_remote_access (USHORT port_number)
{
	if (ip.port[port_number].routing_status == ROUTING_PORT)
		return TRUE;
	else
		return FALSE;
}

int strncmp (const char *src, const char *dest, size_t count)
{
	int i ;
	for (i = 0 ; i < count ; i++, dest++, src++)
	{
		if (*src != *dest)
			return (*dest - *src) ;
	}
	return (0) ;
}

/* 07/07/99 Jo added for Static routes */

enum BOOLEAN check_if_packet_is_destined_to_configured_static_routes (ULONG destination_address, IP_ROUTE_ENTRY **route_entry_ptr)
{
	IP_ROUTE_ENTRY *ptr_to_sptr_route_entry ;
	ULONG value ;

	ptr_to_sptr_route_entry = get_first_ip_route_entry () ;

	ptr_to_sptr_route_entry = get_next_ip_route_entry (ptr_to_sptr_route_entry) ;
	while (ptr_to_sptr_route_entry != NULL)
	{
		value = destination_address & ptr_to_sptr_route_entry->mask ;
		if (value == ptr_to_sptr_route_entry->target)
		{
			*route_entry_ptr = ptr_to_sptr_route_entry ;
			return TRUE ;
		}
		ptr_to_sptr_route_entry = get_next_ip_route_entry (ptr_to_sptr_route_entry) ;
	}	
	return FALSE ;
}

enum BOOLEAN get_port_number_if_statically_configured (ULONG destination_address, USHORT *port_number)
{
	IP_ROUTE_ENTRY *ptr_to_sptr_route_entry ;

	if (check_if_packet_is_destined_to_configured_static_routes (destination_address, &ptr_to_sptr_route_entry) == TRUE)	
	{
		*port_number = ptr_to_sptr_route_entry->port_number ;
		return TRUE ;
	}
	return FALSE ;
}
/* Jo 12/08/99 Added for Static routes */
