/*	$Modname: kicmp.h$  $version: 1.4$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.4 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _KICMP_H_
#define _KICMP_H_


#define	MINIMUM_ICMP_SIZE										8			/* Length of ICMP header */

#define DEFAULT_ICMP_MASK_REQUEST_TIMEOUT 				10



/* Message types */

enum ICMP_MESSAGE_TYPE
{
	ICMP_ECHO_REPLY_TYPE							= 0,
	ICMP_DESTINATION_UNREACHABLE_TYPE		= 3, 
	ICMP_SOURCE_QUENCH_TYPE						= 4,
	ICMP_REDIRECT_TYPE							= 5,
	ICMP_ECHO_REQUEST_TYPE 						= 8,
	ICMP_TIME_EXCEEDED_TYPE						= 11,
	ICMP_PARAMETER_PROBLEM_TYPE 				= 12,
	ICMP_TIMESTAMP_TYPE							= 13,
	ICMP_TIMESTAMP_REPLY_TYPE					= 14,
	ICMP_INFO_REQUEST_TYPE						= 15,
	ICMP_INFO_REPLY_TYPE							= 16,
	ICMP_ADDRESS_MASK_TYPE						= 17,
	ICMP_ADDR_MASK_REPLY_TYPE					= 18,
	TOTAL_ICMP_TYPES								= 19
};


/* Destination Unreachable codes */

enum ICMP_UNREACHABLE_CODE
{
	ICMP_NET_UNREACHABLE_CODE			= 0,
	ICMP_HOST_UNREACHABLE_CODE			= 1,
	ICMP_PROTOCOL_UNREACHABLE_CODE	= 2,
	ICMP_PORT_UNREACHABLE_CODE			= 3,
	ICMP_FRAGMENT_NEEDED_CODE			= 4,
	ICMP_ROUTE_FAIL_CODE					= 5,
	ICMP_ADMIN_PROHIBIT_CODE   		= 13,
	TOTAL_UNREACHABLE_CODES				= 14
};


/* Time Exceeded codes */

enum ICMP_TIME_EXCEEDED_CODE
{
	ICMP_TTL_EXCEEDED_CODE			= 0,
	ICMP_FRAGMENT_EXCEEDED_CODE	= 1,
	TOTAL_TIME_EXCEED_CODES			= 2
};


/* Redirect message codes */

enum ICMP_REDIRECT_CODE
{
	ICMP_REDIRECT_NET_CODE					= 0,
	ICMP_REDIRECT_HOST_CODE					= 1,
	ICMP_REDIRECT_TOS_AND_NET_CODE		= 2,
	ICMP_REDIRECT_TOS_AND_HOST_CODE		= 3,
	TOTAL_REDIRECT_CODES						= 4
};


#endif /* _KICMP_H_ */
