/*
 * $Log: /IP/KIP.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: kip.h$  $version: 1.14$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/15/94 yarran Add TRACE_BUFFER_SIZE. Do cosmetic changes.
1.4 03/01/94 yarran Change ptop to point_to_point.
1.5 03/10/94 yarran Add IP_MEMORY/DATA_PRINTF in IP_PRINTF_GROUPS.
1.6 03/17/94 yarran Add register_to_ip_from_upper_layer routine.
1.7 05/02/94 yarran added rfc1042 changes.
1.8 09/01/94 ross added BYTE and USHORT_ENUM support.
1.9 10/10/94 ross added rarp, proxy arp, remote access functions
1.10 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.11 12/20/94 ross
1.12 12/27/94 ross added better table instrumentation via new snmp.
1.13 01/17/95 ross fixed arp problems from snmp
1.14 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/

/*
History of Changes :
		{Jo, 02 Dec 1999. Added new #defines IP_UDP_PROTOCOL 17
														 DNS_PORT_NUMBER 53}
*/

#ifndef _KIP_H_
#define _KIP_H_


#ifdef BIG_ENDIAN
	#define NET_ORDER_SHORT_CONSTANT(ushort) 				ushort

	#define NET_ORDER_LONG_CONSTANT(ulong) 				ulong
#else
	#define NET_ORDER_SHORT_CONSTANT(ushort) 				(((0x00ff & ushort) << 8) | (ushort >> 8))

	#define NET_ORDER_LONG_CONSTANT(ulong) 				(((0x000000ffL & ulong) << 24 ) | \
																			((0x0000ff00L & ulong) << 8 ) | ((0x00ff0000L & ulong) >> 8) |	\
																			(ulong >> 24))
#endif

/* ip defaults */

#define IP_VERSION												4

#define DEFAULT_TTL 												64		/* according to RFC 1700 */

#define DEFAULT_IP_MAXIMUM_REASSEMBLY_SIZE 				65535

#define DEFAULT_IP_REASSEMBLY_TIMEOUT 						30


/* Timestamp option flags */

#define IP_OPTION_TIMESTAMP_ONLY								0				/* Time stamps only */

#define IP_OPTION_TIMESTAMP_ADDRESS							1				/* Addresses + Time stamps */

#define IP_OPTION_TIMESTAMP_PRESPECIFIED					3				/* Prespecified addresses only */


#define MINIMUM_IP_OPTION_SIZE								1

#define MINIMUM_SOURCE_ROUTE_OPTION_LENGTH				3

#define MINIMUM_SOURCE_ROUTE_POINTER						4



#define MAXIMUM_NUMBER_OF_OTHER_TRANSPORT_PROTOCOLS	3			/* other than udp and icmp protocols on top of ip */


#define IP_PACKET_STATE_MASK									0xff00

#define MAXIMUM_IP_HEADER_LENGTH								(MINIMUM_IP_HEADER_LENGTH + MAXIMUM_IP_OPTION_LENGTH)


/* Internet address class. Note the IP address is in host order. */

#define IN_CLASS_A(ip_address)								(((ULONG) (ip_address) & 0x80000000L) == 0)

#define IN_CLASS_A_NET											0xff000000L

#define IN_CLASS_A_HOST											0x00ffffffL

#define IN_CLASS_B(ip_address)								(((ULONG) (ip_address) & 0xc0000000L) == 0x80000000L)

#define IN_CLASS_B_NET											0xffff0000L

#define IN_CLASS_B_HOST											0x0000ffffL

#define IN_CLASS_C(ip_address)								(((ULONG) (ip_address) & 0xe0000000L) == 0xc0000000L)

#define IN_CLASS_C_NET											0xffffff00L

#define IN_CLASS_C_HOST											0x000000ffL

#define IN_CLASS_D(ip_address)								(((ULONG) (ip_address) & 0xf0000000L) == 0xe0000000L)

#define IN_MULTICAST(ip_address)								IN_CLASS_D (ip_address)

#define IN_EXPERIMENTAL(ip_address)							(((ULONG) (ip_address) & 0xe0000000L) == 0xe0000000L)

#define IN_BADCLASS(ip_address)								(((ULONG) (ip_address) & 0xf0000000L) == 0xf0000000L)

#ifndef INTERNET_ADDRESS_ANY
	#define INTERNET_ADDRESS_ANY									(ULONG) 0x00000000L
#endif

#ifndef INTERNET_ADDRESS_LOOPBACK
	#define INTERNET_ADDRESS_LOOPBACK							(ULONG) 0x7F000001L
#endif

#ifndef INTERNET_ADDRESS_BROADCAST
	#define INTERNET_ADDRESS_BROADCAST							(ULONG) 0xffffffffL
#endif

#define IN_LOOPBACK_NET											127


#define SET_SOURCE_ROUTING_BIT 								NET_ORDER_LONG_CONSTANT (0x80000000L)

#define CLEAR_SOURCE_ROUTING_BIT 							NET_ORDER_LONG_CONSTANT (0xefffffffL)

#define ETHERNET_BROADCAST_BIT 								NET_ORDER_LONG_CONSTANT (0x01000000L)

#define TOKEN_RING_BROADCAST_BIT 							NET_ORDER_LONG_CONSTANT (0x80000000L)

#define HOST_NAME_SIZE											150

#define PRINT_BUFFER_SIZE										150

#define MAXIMUM_SIZE_OF_PRINTF 								255

#define SIZE_OF_IP_ADDRESS 									10 			/* previously 10 */

#define SIZE_OF_PORT_NUMBER 									2

#define SIZE_OF_MAC_ADDRESS 									20

#define MAC_ADDRESS_LENGTH 									6


enum IP_PRINTF_GROUPS
{
	IP_PRINTF,
	IP_ROUTE_PRINTF,
	IP_CACHE_PRINTF,
	IP_TX_PRINTF,
	IP_RX_PRINTF,
	IP_FRAGMENT_PRINTF,
	IP_REASSEMBLY_PRINTF,
	IP_RIP_PRINTF,
	IP_ALWAYS_PRINTF,
	ICMP_PRINTF,
	ARP_PRINTF,
	RARP_PRINTF,
	UDP_PRINTF,
	IP_ALARM_PRINTF,
	IP_MEMORY_PRINTF,
	IP_DATA_PRINTF,
	IP_DIAGNOSTIC_PRINTF,
#ifdef IP_FILTERING
	IP_FILTER_PRINTF,
#endif
   IP_DNS_PRINTF
};


enum IP_PACKET_STATE
{ 
	IP_DATA_PACKET_RXED_AND_WAS_FORWARDED,
	IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED
};


enum IP_SEND_CONFIRMATION
{ 
	IP_SEND_ILLEGAL_OPTION_LENGTH 		= 0,
	IP_SEND_NO_ROUTE 							= 1,
	IP_SEND_BROADCAST_NOT_AVAILABLE 		= 2,
	IP_SEND_BROADCAST_NOT_ALLOWED 		= 3,
	IP_SEND_MESSAGE_TOO_BIG 				= 4,
	IP_SEND_FRAGMENTATION_NEEDED 			= 5,
	IP_SEND_PACKET_FILTERED 				= 6,
	IP_SEND_CANNOT_FRAGMENT 				= 7,
	IP_SEND_PORT_DISABLED 					= 8,
	IP_SEND_PACKET_FRAGMENTED_OK 			= 9,
	IP_SEND_OK 									= 0x0a,
	IP_SEND_NO_ARP_TABLE_ENTRY 			= 0x0b,
	IP_SEND_REAL_PORT_DISABLED 			= 0x0c,
	TOTAL_IP_SEND_CONFIRMATIONS 			= 0x0d
};


/* IP option numbers */

enum IP_OPTION_NUMBER
{
	IP_EOL_OPTION								= 0,
	IP_NOOP_OPTION								= 1,
	IP_SECURITY_OPTION						= 2,
	IP_LOOSE_SOURCE_ROUTE_OPTION			= 3,
	IP_TIMESTAMP_OPTION						= 4,
	IP_RECORD_ROUTE_OPTION					= 7,
	IP_STREAM_ID_OPTION						= 8,
	IP_STRICT_SOURCE_ROUTE_OPTION			= 9
};


enum ASSEMBLY_RESULT
{
	ASSEMBLY_FAIL,
	ALL_FRAGMENTS_ASSEMBLED,
	FRAGMENT_ASSEMBLED_BUT_INCOMPLETE
};


enum FORWARD_STATUS
{
	FORWARD_OK,
	FORWARD_FAIL
};


enum REASSEMBLY_QUEUE_ACTION
{
	INSERT_NO_MERGE 																	= 0x0,
	MERGE_WITH_PRECEEDING_FRAGMENT 												= 0x1,
	MERGE_WITH_SUCCEEDING_FRAGMENT 												= 0x2,
	MERGE_PACKET_AND_SUCCEEDING_FRAGMENT_WITH_PRECEEDING_FRAGMENT 		= 0x3
		/* 0x03 = (MERGE_WITH_PRECEEDING_FRAGMENT | MERGE_WITH_SUCCEEDING_FRAGMENT) */
};


enum BROADCAST_INDICATOR_TYPE
{
	NON_BROADCAST,
	ALL_ROUTES_BROADCAST 											= 0x4,
	SINGLE_ROUTE_BROADCAST 											= 0x6,
	SINGLE_ROUTE_BROADCAST_ALL_ROUTES_BROADCAST_RETURN 	= 0x7
};


enum LARGEST_FRAME
{
	_516,
	_1470,
	_2052,
	_4472,
	_8144,
	_11407,
	_17800,
	INITIAL_VALUE_OF_BROADCAST_FRAMES
};

enum IP_PORT_ROUTING_STATUS
{
	ROUTING_PORT,
	PROXY_PORT
};

#define NUMBER_OF_RECOGNIZED_ICMP_PACKET_TYPES 11

/* sachin 1/1/98 */
#define TCP_CSUM_DEBUG 0

/* Jo 02 Dec 1999... */
#define IP_UDP_PROTOCOL 17
#define DNS_PORT_NUMBER 53
/* ...Jo 02 Dec 1999 */

#endif /* _KIP_H_ */
