/*
 * $Log: /IP/KRIP.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: krip.h$  $version: 1.7$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 03/01/94 yarran
1.4 05/02/94 yarran added rfc1042 changes.
1.5 10/10/94 ross added rarp, proxy arp, remote access functions
1.6 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.7 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _KRIP_H_
#define _KRIP_H_


/* split horizon type */

#define SIMPLE_SPLIT_HORIZON 							0x1			/* Do split horizon processing */

#define SPLIT_POISON_REVERSE							0x2			/* Include ourselves in the list */


/* UDP Port for RIP */

#define RIP_PORT											520


/* RIP packet misc */

#define RIP_VERSION_ZERO 								0

#define RIP_VERSION_ONE 								1

#define RIP_VERSION_TWO									2

#define AWAITING_ADDRESS_MASK_REPLY					0xfd

#define SEND_ADDRESS_MASK_REQUEST					0xfe

#define SUBNET_MASK_NOT_KNOWN							0xff

#define MAXIMUM_NUMBER_OF_RIP_ENTRIES				25

#define RIP_ROUTE_ENTRY_SIZE 							sizeof (RIP_ROUTE_ENTRY)

#define MAXIMUM_RIP_HEADER_SIZE						(sizeof (RIP_HEADER) + \
																	(MAXIMUM_NUMBER_OF_RIP_ENTRIES * RIP_ROUTE_ENTRY_SIZE)) 			/* 504 */

/* distance value */

#define INFINITY_METRIC_VALUE							16


/* Timer values in seconds */

#define RIP_MAXIMUM_UPDATE_HOLDING_TIME			5

#define RIP_MINIMUM_UPDATE_HOLDING_TIME			1

#define RIP_UPDATE_HOLDING_TIME_RANGE				4 		/* RIP_MAXIMUM_UPDATE_HOLDING_TIME - RIP_MINIMUM_UPDATE_HOLDING_TIME */

#define DEFAULT_RIP_RESPONSE_INTERVAL							30

#define MAXIMUM_UPDATE_TIME_OFFSET								10

#define DEFAULT_RIP_ROUTE_AGING_TIME							180

#define DEFAULT_RIP_GARBAGE_COLLECTION_TIMEOUT				120

#define MAXIMUM_SIZE_OF_ROUTE_CACHE_HASH_TABLE 				4

#define MAXIMUM_LENGTH_OF_ROUTE_CACHE_HASH_BUCKET 			2


/* this is the address family type */

enum RIP_ADDRESS_FAMILIY
{
	RIP_UNSPECIFIED_FAMILY_TYPE	= 0x0000,
	RIP_IP_FAMILY_TYPE 				= 0x0002,
 
	_RIP_FAMILY_USHORT_FILLER 		= 0x0100
};


/* RIP Packet Types */

enum RIP_PACKET_TYPE
{
	RIP_REQUEST_PACKET_TYPE			= 1,
	RIP_RESPONSE_PACKET_TYPE 		= 2
};


#endif /* _KRIP_H_ */
