#include	"defs.h"
/*
 * $Log: /IP/RIPTX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: riptx.c$  $version: 1.13$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 03/01/94 yarran
1.1 03/01/94 yarran Add copyright.
1.2 03/02/94 yarran Use subnet broadcast address for non-point-to-point link.
1.3 03/02/94 yarran Use subnet broadcast address if point-to-point remote address is unknown.
1.4 03/04/94 yarran Change rip_get_buffer() to udp_user_get_buffer().
1.5 03/17/94 yarran Change type_of_service type.
1.6 05/02/94 yarran added rfc1042 changes.
1.7 06/15/94 yarran cosmetic changes.
1.8 09/01/94 ross added BYTE and USHORT_ENUM support.
1.9 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.10 11/04/94 ross remote access testing and fixes.
1.11 12/20/94 ross
1.12 12/27/94 ross added better table instrumentation via new snmp.
1.13 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stdlib.h>
#include "ip.h"
/****************************************************************************/

#ifdef _BIG_PROXY_
void	determine_destination_ip_address (IP_PORT_CLASS *sptr_port, IP_SOCKET *sptr_remote_socket);
static void	reset_route_changed_flag_for_route_table_entries (void);
static void send_rip_request_packet (IP_SOCKET *sptr_remote_socket);
/****************************************************************************/

void rip_initiate_triggered_broadcast (USHORT skip_port_number)
{
	if (ip.rip.periodic_time_counter >= ip.rip.next_trigger_broadcast_time)
		{
		/* if the randomly delayed trigger time has passed, then we can send now. */

		rip_broadcast_updates (TRUE, skip_port_number);

		rip_set_next_trigger_broadcast_time ();
		}
	else
		{
		/* the update is delayed, until the already set trigger fires */

		ip.rip.need_update = TRUE;
		}
}
/****************************************************************************/
enum TEST rip_set_next_trigger_broadcast_time (void)
{
	ULONG random_value;

	random_value = (ULONG) ((ULONG) rand () % RIP_UPDATE_HOLDING_TIME_RANGE + 1);

	ip.rip.next_trigger_broadcast_time = ip.rip.periodic_time_counter + random_value;

	if (ip.rip.next_regular_update_time <= (ip.rip.next_trigger_broadcast_time + RIP_MINIMUM_UPDATE_HOLDING_TIME))
		{
		/* if the regular update is set for less than 1 second after the next possible triggered update,
		 *	set next triggered update for a random value after the next regular update */

		ip.rip.next_trigger_broadcast_time = ip.rip.next_regular_update_time + random_value;

		return (FAIL);
		}
	else
		{
		/* the triggered update timer is set */

		return (PASS);
		}
}
/****************************************************************************/
void rip_broadcast_request_packets_on_all_ports (void)
{
	USHORT port_number;
	IP_SOCKET remote_socket;
	IP_PORT_CLASS *sptr_port;
	RIP_PORT_CLASS *sptr_rip_port;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if (ip.port[port_number].config.port_enabled == FALSE)
			{
			continue;
			}

		sptr_port = &ip.port[port_number];

		sptr_rip_port = &ip.rip.port[port_number];

		if ((sptr_port->port_is_up == FALSE) || (sptr_rip_port->send_requests == FALSE))
			{
			continue;
			}

	#ifdef __IP_DEBUG__
		ip_printf (IP_RIP_PRINTF, "IP/RIP: request packet sent on port %u\n", port_number);
	#endif /* __IP__DEBUG__ */

		/* Determine destination ip address */

		determine_destination_ip_address (sptr_port, &remote_socket);

		remote_socket.port = RIP_PORT;

		remote_socket.virtual_port_number = port_number;

		send_rip_request_packet (&remote_socket);
		}
}
/****************************************************************************/
void rip_broadcast_updates (enum BOOLEAN triggered, USHORT port_to_skip)
{
	USHORT port_number;
	IP_SOCKET remote_socket;
	IP_PORT_CLASS *sptr_port;
	RIP_PORT_CLASS *sptr_rip_port;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if ((port_number == port_to_skip) || (ip.port[port_number].config.port_enabled == FALSE))
			{
/*			printf("\r\n port %d is disabled\r\n",port_number);*/
			continue;
			}

		sptr_port = &ip.port[port_number];

		sptr_rip_port = &ip.rip.port[port_number];

		if ((sptr_port->port_is_up == FALSE) || (sptr_rip_port->send_response_updates == FALSE))
			{
/*			printf("\r\n%d port is up  %d  send_response_update is %d \r\n",port_number,sptr_port->port_is_up,sptr_rip_port->send_response_updates);*/
			continue;
			}


	#ifdef __IP_DEBUG__
		if (triggered == TRUE)
			{
			ip_printf (IP_RIP_PRINTF, "IP/RIP: triggered update sent on port %u\n", port_number);
			}
		else
			{
			ip_printf (IP_RIP_PRINTF, "IP/RIP: periodic update sent on port %u\n", port_number);
			}
	#endif /* __IP__DEBUG__ */

		determine_destination_ip_address (sptr_port, &remote_socket);

		remote_socket.port = RIP_PORT;

		remote_socket.virtual_port_number = port_number;

		rip_send_full_response (port_number, &remote_socket, sptr_rip_port->poison_reverse_enabled, triggered, FALSE);
		}

	reset_route_changed_flag_for_route_table_entries ();

	ip.rip.last_broadcast_time = ip.rip.periodic_time_counter;
}
/****************************************************************************/
void	determine_destination_ip_address (IP_PORT_CLASS *sptr_port, IP_SOCKET *sptr_remote_socket)
{
	/* Determine destination ip address */

	if (sptr_port->allow_broadcast == TRUE)
		{
		sptr_remote_socket->ip_address = sptr_port->subnet_broadcast_address;
		}
	else
		{
		if ((sptr_port->is_point_to_point == TRUE) && (sptr_port->config.point_to_point_remote_ip_address != 0x00000000L))
			{
			sptr_remote_socket->ip_address = sptr_port->config.point_to_point_remote_ip_address;
			}
		else
			{
			sptr_remote_socket->ip_address = INTERNET_ADDRESS_BROADCAST;
			}
		}
}
/****************************************************************************/
static void	reset_route_changed_flag_for_route_table_entries (void)
{
	IP_ROUTE_ENTRY *sptr_route_entry;

	/* reset route changed flag */

	ip.default_route.flags.route_changed = FALSE;

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
	sptr_route_entry = get_first_ip_route_entry ();
#else
	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);
#endif

	while (sptr_route_entry != NULL)
		{
		sptr_route_entry->flags.route_changed = FALSE;

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
		sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
		sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif
		}
}
/****************************************************************************/
static void send_rip_request_packet (IP_SOCKET *sptr_remote_socket)
{
	RIP_REQUEST_PACKET *sptr_rip_request_packet;
	IP_SOCKET local_socket;
	UNION_SERVICE_TYPE_BIT_STRUCTURE type_of_service;

	sptr_rip_request_packet = (RIP_REQUEST_PACKET *) get_an_ip_send_packet (sptr_remote_socket->virtual_port_number,
		sizeof (RIP_REQUEST_PACKET));

	if (sptr_rip_request_packet == NULL)
		{
		return;
		}

	local_socket.ip_address = ip.port[sptr_remote_socket->virtual_port_number].config.ip_address;
	local_socket.port = RIP_PORT;

	build_rip_header (&sptr_rip_request_packet->header, RIP_REQUEST_PACKET_TYPE);

	sptr_rip_request_packet->route_entry.address_family = NET_ORDER_SHORT_CONSTANT (RIP_UNSPECIFIED_FAMILY_TYPE);
	sptr_rip_request_packet->route_entry.target = 0x00000000L;
	sptr_rip_request_packet->route_entry.metric = NET_ORDER_LONG_CONSTANT (INFINITY_METRIC_VALUE);
	sptr_rip_request_packet->route_entry.reserved_field_1 = 0x0000;
	sptr_rip_request_packet->route_entry.reserved_field_2 = 0x00000000L;
	sptr_rip_request_packet->route_entry.reserved_field_3 = 0x00000000L;

	type_of_service._byte = 0x00;

	/* IP time to live is 1 */

#ifdef __IP_DEBUG__
	rip_print_routing_entry (&sptr_rip_request_packet->route_entry);
#endif /* __IP__DEBUG__ */

	send_udp (sptr_remote_socket->virtual_port_number, &local_socket, sptr_remote_socket, type_of_service._bit,
		ip.rip.config.minimum_ttl, (void *) sptr_rip_request_packet, 0, FALSE, sizeof (RIP_REQUEST_PACKET),
		send_completion_ip_packet, NULL);

	++ip.rip.statistics.number_of_request_packets_sent;
}
/****************************************************************************/
void build_rip_header (RIP_HEADER *sptr_rip_header, enum RIP_PACKET_TYPE type)
{
	sptr_rip_header->type = (BYTE_ENUM (RIP_PACKET_TYPE)) type;
	sptr_rip_header->version = RIP_VERSION_ONE;
	sptr_rip_header->reserved = 0x0000;

#ifdef __IP_DEBUG__
	rip_print_header (sptr_rip_header);
#endif /* __IP__DEBUG__ */
}
/****************************************************************************/
/* Note: destination ip address could be remote gateway, local net broadcast, or remote peer address of a point-to-point link.
 * parameter include_routes_to_me is set to 1 when this router received an all route request packet. */

void rip_send_full_response (USHORT outgoing_port_number, IP_SOCKET *sptr_remote_socket, enum BOOLEAN poison_reverse_enabled,
	enum BOOLEAN trigger_update, enum BOOLEAN include_routes_to_me)
{
	USHORT rip_packet_size;
	USHORT max_entries;
	IP_SOCKET local_socket;

	rip_packet_size = 0x0000;

	compute_rip_packet_size_and_number_of_routes (outgoing_port_number, &rip_packet_size, &max_entries);

	local_socket.ip_address = ip.port[outgoing_port_number].config.ip_address;
	local_socket.port = RIP_PORT;

	send_rip_response_packet (sptr_remote_socket, poison_reverse_enabled, trigger_update, include_routes_to_me,
		outgoing_port_number, rip_packet_size, max_entries, local_socket);
}
/****************************************************************************/
void compute_rip_packet_size_and_number_of_routes (USHORT outgoing_port_number, USHORT *usptr_rip_packet_size,
	USHORT *usptr_number_of_entries)
{
	USHORT size_of_extra_header;
	USHORT overhead;

	/* Compute maximum rip packet size and maximum number of routes we can send */

	size_of_extra_header = get_size_of_ip_link_layer_type_header (outgoing_port_number);

	if ((*usptr_rip_packet_size == 0x0000)	|| (*usptr_rip_packet_size > sizeof (RIP_PACKET)))
		{
		*usptr_rip_packet_size = sizeof (RIP_PACKET);

		*usptr_number_of_entries = MAXIMUM_NUMBER_OF_RIP_ENTRIES;
		}

	if ((*usptr_rip_packet_size + size_of_extra_header) > ip.port[outgoing_port_number].config.mtu)
		{
		*usptr_rip_packet_size = (USHORT) (ip.port[outgoing_port_number].config.mtu - size_of_extra_header);
		}

	overhead = (USHORT) (sizeof (UNION_MAC_HEADER) + sizeof (IP_HEADER) + sizeof (UDP_HEADER) + sizeof (RIP_HEADER));

	*usptr_number_of_entries = (USHORT) ((USHORT) (*usptr_rip_packet_size -	overhead) / sizeof (RIP_ROUTE_ENTRY));

	*usptr_rip_packet_size = (USHORT) (overhead + (*usptr_number_of_entries * sizeof (RIP_ROUTE_ENTRY)));
}
#endif
