/*
 * $Log: /IP/VARPSNMP.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/

#ifdef _BIG_PROXY_
#ifndef _VARPSNMP_H_
#define _VARPSNMP_H_


#ifdef __MSDOS__
	SNMP_TABLE_ENTRY_PARAMETERS far	arp_snmp_table_parameters[] =
#else
	SNMP_TABLE_ENTRY_PARAMETERS	arp_snmp_table_parameters[] =
#endif
{
	{(ULONG) NULL,
		TRUE,
		0x02,
		{{
			SNMP_SCALAR_TYPE,
			/* Srikar, Mar 18, 1997. Changed the size of table entry index from that of ulong to byte. */
			/* Srikar, Mar 31, 1997. Changed the size of table entry to size of ushort */
			sizeof (USHORT),
			offsetof (ARP_TABLE_ENTRY,port_number),
			/* Srikar, Mar 31, 1997. Changed the initialization of the need_to_increment from FALSE to TRUE */
			TRUE,
			NULL,
			FALSE,
			&ip.number_of_ports,
			TRUE
		},{
			/* Srikar, Mar 31, 1997. Changed the index_type field of the this table index from SNMP_SCALAR_TYPE
			to SNMP_IP_NETWORK_ADDRESS_TYPE */
			SNMP_IP_NETWORK_ADDRESS_TYPE,
			sizeof (ULONG),
			offsetof (ARP_TABLE_ENTRY,ip_address),
			FALSE,
			NULL,
			FALSE,
			&ip.number_of_ports,
			FALSE
		}},
/* Srikar, July 01, 1997. Changed the table type */
#if 0
		MIB_TABLE_AS_AN_ARRAY_OF_LINKED_LISTS,
		&ip.arp.port[0],
		sizeof (ARP_TABLE_ENTRY),
		NUMBER_OF_IP_PORTS,
		offsetof (ARP_PORT_CLASS,current_list)
#else
      MIB_TABLE_AS_A_LINKED_LIST,
      &ip.arp.port[0].current_list,
#endif
		}
};


#ifdef __MSDOS__
	SNMP_TABLE_ENTRY far	arp_snmp_table[] =
#else
	SNMP_TABLE_ENTRY	arp_snmp_table[] =
#endif
{
	{"atIfIndex",sizeof (ULONG),
	/* Srikar, Mar 31, 1997. Changed the mib access function from snmp_get_or_set_ushort to snmp_get_or_set_boolean_plus_one */
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
		(ULONG) offsetof (ARP_TABLE_ENTRY,port_number),
		&arp_snmp_table_parameters[0]
		},

	{"atPhysAddress",sizeof (MAC_ADDRESS),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_mac_address,
		FALSE,
		FALSE,
		(ULONG) offsetof (ARP_TABLE_ENTRY,hardware_address),
		&arp_snmp_table_parameters[0]
		},

	{"atNetAddress",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (ARP_TABLE_ENTRY,ip_address),
		&arp_snmp_table_parameters[0]
		},

	{"",0x0000,
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		(ULONG) NULL,
		FALSE,
		FALSE,
		(ULONG) NULL,
		NULL
		}
};


#endif /* _VARPSNMP_H_ */
#endif
