/*
 * $Log: /IP/VIPSNMP.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: vipsnmp.h$  $version: 1.6$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 06/15/94 yarran
1.1 06/15/94 yarran added copyright.
1.2 10/10/94 ross added rarp, proxy arp, remote access functions
1.3 12/27/94 ross added better table instrumentation via new snmp.
1.4 01/17/95 ross fixed arp problems from snmp
1.5 06/29/95 ross new snmp access routine
1.6 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/

#ifdef _BIG_PROXY_
#ifndef _VIPSNMP_H_
#define _VIPSNMP_H_

/* Srikar, Mar 24, 1997. Following function prototype added to validate the default TTL value. */
extern	enum TEST snmp_get_or_set_ipDefaultTTL (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

extern	enum TEST snmp_get_or_set_ipForwarding (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

extern	enum TEST snmp_get_or_set_ipRouteIfIndex (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

#ifdef __MSDOS__
	SNMP_TABLE_ENTRY_PARAMETERS far	ip_snmp_table_parameters[] =
#else
	SNMP_TABLE_ENTRY_PARAMETERS	ip_snmp_table_parameters[] =
#endif
{
	{(ULONG) &ip.mib,
		FALSE
		},

	{(ULONG) NULL,
		TRUE,
		0x01,
		{{
			/* Srikar, Mar 31, 1997. Changed the index_type field of the this table index from SNMP_SCALAR_TYPE
			to SNMP_IP_ADDRESS_TYPE */
			SNMP_IP_ADDRESS_TYPE,
			sizeof (ULONG),
			offsetof (IP_ADDRESS_ENTRY,ulptr_to_ipAdEntAddr),
			FALSE
		}},
		MIB_TABLE_AS_A_LINKED_LIST,
		&ip.address_list
		},

	{(ULONG) NULL,
		TRUE,
		0x01,
		{{
			/* Srikar, Mar 31, 1997. Changed the index_type field of the this table index from SNMP_SCALAR_TYPE
			to SNMP_IP_ADDRESS_TYPE */
			SNMP_IP_ADDRESS_TYPE,
			sizeof (ULONG),
			offsetof (IP_ROUTE_ENTRY,target),
			FALSE
		}},
		MIB_TABLE_AS_A_LINKED_LIST,
		&ip.route_list
		},

	{(ULONG) NULL,
		TRUE,
		0x02,
		{{
			SNMP_SCALAR_TYPE,
			/* Srikar, Mar 31, 1997. Changed the size of table entry index from that of ulong to ushort. */
			sizeof (USHORT),
			offsetof (ARP_TABLE_ENTRY,port_number),
			/* Srikar, Mar 31, 1997. Changed the initialization of the need_to_increment from FALSE to TRUE */
			TRUE,
			NULL,
			FALSE,
			&ip.number_of_ports,
			TRUE
		},{
			/* Srikar, Mar 31, 1997. Changed the index_type field of the this table index from SNMP_SCALAR_TYPE
			to SNMP_IP_ADDRESS_TYPE */
			SNMP_IP_ADDRESS_TYPE,
			sizeof (ULONG),
			offsetof (ARP_TABLE_ENTRY,ip_address),
			FALSE,
			NULL,
			FALSE,
			&ip.number_of_ports,
			FALSE
		}},
/* Srikar, July 01, 1997. Changed the table type */
#if 0
		MIB_TABLE_AS_AN_ARRAY_OF_LINKED_LISTS,
		&ip.arp.port[0],
		sizeof (ARP_TABLE_ENTRY),
		NUMBER_OF_IP_PORTS,
		offsetof (ARP_PORT_CLASS,current_list)
#else
      MIB_TABLE_AS_A_LINKED_LIST,
      &ip.arp.port[0].current_list,
#endif
		}
};


#ifdef __MSDOS__
	SNMP_TABLE_ENTRY far	ip_snmp_table[] =
#else
	SNMP_TABLE_ENTRY	ip_snmp_table[] =
#endif
{
	/* Srikar, Mar 24, 1997. Changed the access function from snmp_get_or_set_byte to snmp_get_or_set_ipForwarding. */
	{"ipForwarding",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ipForwarding,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipForwarding),
		&ip_snmp_table_parameters[0]
		},

	/* Srikar, Mar 24, 1997. Changed the access function from snmp_get_or_set_ulong to snmp_get_or_set_ipDefaultTTL */
	/* to validate the set operation. */
	{"ipDefaultTTL",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ipDefaultTTL,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipDefaultTTL),
		&ip_snmp_table_parameters[0]
		},

	{"ipInReceives",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipInReceives),
		&ip_snmp_table_parameters[0]
		},

	{"ipInHdrErrors",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipInHdrErrors),
		&ip_snmp_table_parameters[0]
		},

	{"ipInAddrErrors",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipInAddrErrors),
		&ip_snmp_table_parameters[0]
		},

	{"ipForwDatagrams",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipForwDatagrams),
		&ip_snmp_table_parameters[0]
		},

	{"ipInUnknownProtos",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipInUnknownProtos),
		&ip_snmp_table_parameters[0]
		},

	{"ipInDiscards",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipInDiscards),
		&ip_snmp_table_parameters[0]
		},

	{"ipInDelivers",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipInDelivers),
		&ip_snmp_table_parameters[0]
		},

	{"ipOutRequests",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipOutRequests),
		&ip_snmp_table_parameters[0]
		},

	{"ipOutDiscards",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipOutDiscards),
		&ip_snmp_table_parameters[0]
		},

	{"ipOutNoRoutes",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipOutNoRoutes),
		&ip_snmp_table_parameters[0]
		},

	{"ipReasmTimeout",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipReasmTimeout),
		&ip_snmp_table_parameters[0]
		},

	{"ipReasmReqds",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipReasmReqds),
		&ip_snmp_table_parameters[0]
		},

	{"ipReasmOKs",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipReasmOKs),
		&ip_snmp_table_parameters[0]
		},

	{"ipReasmFails",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipReasmFails),
		&ip_snmp_table_parameters[0]
		},

	{"ipFragOKs",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipFragOKs),
		&ip_snmp_table_parameters[0]
		},

	{"ipFragFails",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipFragFails),
		&ip_snmp_table_parameters[0]
		},

	{"ipFragCreates",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipFragCreates),
		&ip_snmp_table_parameters[0]
		},

	{"ipAdEntAddr",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ADDRESS_ENTRY,ulptr_to_ipAdEntAddr),
		&ip_snmp_table_parameters[1]
		},

	{"ipAdEntIfIndex",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ushort,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ADDRESS_ENTRY,usptr_to_ipAdEntIfIndex),
		&ip_snmp_table_parameters[1]
		},

	{"ipAdEntNetMask",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ADDRESS_ENTRY,ulptr_to_ipAdEntNetMask),
		&ip_snmp_table_parameters[1]
		},

	{"ipAdEntBcastAddr",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ADDRESS_ENTRY,ulptr_to_ipAdEntBcastAddr),
		&ip_snmp_table_parameters[1]
		},

	{"ipAdEntReasmMaxSize",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ushort,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ADDRESS_ENTRY,usptr_to_ipAdEntReasmMaxSize),
		&ip_snmp_table_parameters[1]
		},

	{"ipRouteDest",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,target),
		&ip_snmp_table_parameters[2]
		},

	/* Srikar, Mar 24, 1997. Changed the access function from snmp_get_or_set_ushort to snmp_get_or_set_ipRouteIfIndex */
	/* to increment the port number for get operation and to decrement the index on set. Also validation of the index */
	/* is done on set operation. */
	{"ipRouteIfIndex",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ipRouteIfIndex,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,port_number),
		&ip_snmp_table_parameters[2]
		},

	{"ipRouteMetric1",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,metric),
		&ip_snmp_table_parameters[2]
		},

	/* Srikar, Mar 18, 1997, Changed the unused metric from 'metric' to 'metric2' */
	{"ipRouteMetric2",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,metric2),
		&ip_snmp_table_parameters[2]
		},

	/* Srikar, Mar 18, 1997, Changed the unused metric from 'metric' to 'metric2' */
	{"ipRouteMetric3",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,metric2),
		&ip_snmp_table_parameters[2]
		},

	/* Srikar, Mar 18, 1997, Changed the unused metric from 'metric' to 'metric2' */
	{"ipRouteMetric4",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,metric2),
		&ip_snmp_table_parameters[2]
		},

	/* Srikar, Mar 18, 1997. Changed the access function from snmp_get_or_set_ulong to snmp_get_or_set_ip_address. */
	{"ipRouteNextHop",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ip_address,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,gateway),
		&ip_snmp_table_parameters[2]
		},

	{"ipRouteType",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_byte,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,ipRouteType),
		&ip_snmp_table_parameters[2]
		},

	{"ipRouteProto",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
/*		snmp_get_or_set_ulong,*/
		snmp_get_or_set_byte,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,ipRouteProto),
		&ip_snmp_table_parameters[2]
		},

	{"ipRouteAge",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ushort,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,aging_timer),
		&ip_snmp_table_parameters[2]
		},

	/* Srikar, Mar 18, 1997. Changed the access function from snmp_get_or_set_ulong to snmp_get_or_set_ip_address. */
	{"ipRouteMask",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ip_address,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,mask),
		&ip_snmp_table_parameters[2]
		},

	/* Srikar, Mar 18, 1997, Changed the unused metric from 'metric' to 'metric2' */
	{"ipRouteMetric5",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,metric2),
		&ip_snmp_table_parameters[2]
		},

	/* Srikar, Mar 18, 1997. Changed the field from 'metric' which was incorrect to the newly added 'ipRouteInfo'. */
	{"ipRouteInfo",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_ROUTE_ENTRY,ipRouteInfo),
		&ip_snmp_table_parameters[2]
		},

	{"ipNetToMediaIfIndex",sizeof (ULONG),
	/* Srikar, Mar 31, 1997. Changed the mib access function from snmp_get_or_set_ushort to snmp_get_or_set_boolean_plus_one */
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
		(ULONG) offsetof (ARP_TABLE_ENTRY,port_number),
		&ip_snmp_table_parameters[3]
		},

	{"ipNetToMediaPhysAddress",sizeof (MAC_ADDRESS),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_mac_address,
		FALSE,
		FALSE,
		(ULONG) offsetof (ARP_TABLE_ENTRY,hardware_address),
		&ip_snmp_table_parameters[3]
		},

	{"ipNetToMediaNetAddress",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (ARP_TABLE_ENTRY,ip_address),
		&ip_snmp_table_parameters[3]
		},

	{"ipNetToMediaType",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_byte,
		FALSE,
		FALSE,
		(ULONG) offsetof (ARP_TABLE_ENTRY,type),
		&ip_snmp_table_parameters[3]
		},

	{"ipRoutingDiscards",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IP_MIB,ipRoutingDiscards),
		&ip_snmp_table_parameters[0]
		},

	{"",0x0000,
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		(ULONG) NULL,
		FALSE,
		FALSE,
		(ULONG) NULL,
		NULL,
		}
};


#endif /* _VIPSNMP_H_ */
#endif
