/*
 * $Log: /IP/VIPUSSTR.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: vipusstr.h$  $version: 1.9$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 03/03/94 yarran Handle NVRAM parameters directly by IP
1.4 03/17/94 yarran Move PSEUDO_IP_HEADER from vipstr.h to this file.
1.5 03/17/94 yarran Change type_of_service type.
1.6 05/02/94 yarran added rfc1042 changes.
1.7 12/27/94 ross added better table instrumentation via new snmp.
1.8 06/29/95 ross new snmp access routine
1.9 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _VIPUSSTR_H_
#define _VIPUSSTR_H_


typedef struct SERVICE_TYPE_BIT_STRUCTURE
{
#ifndef BIG_ENDIAN
	unsigned char 		unused:2;
	unsigned char 		high_reliability:1;
	unsigned char 		high_throughput:1;
	unsigned char 		low_delay:1;
	unsigned char 		precedence:3;
#else
	unsigned char 		precedence:3;
	unsigned char 		low_delay:1;
	unsigned char 		high_throughput:1;
	unsigned char		high_reliability:1;
	unsigned char		unused:2;
#endif
} SERVICE_TYPE_BIT_STRUCTURE;


typedef union UNION_USER_OPTIONS
{
	BYTE 			char_options[MAXIMUM_IP_OPTION_LENGTH];							/* according to rfc791 format in network order */
	ULONG			ulong_options[MAXIMUM_IP_OPTION_LENGTH / sizeof (ULONG)];
} UNION_USER_OPTIONS;


/* all fields are in host order, except the options field */

typedef struct IP_UPPER_LAYER_PARAMETERS
{
	ULONG 								source_address;
	ULONG 								destination_address;
	BYTE_ENUM (BOOLEAN) 				do_not_fragment_flag;
	SERVICE_TYPE_BIT_STRUCTURE		type_of_service;
	USHORT 								sequence_id;
	BYTE 									time_to_live;
	BYTE 									protocol;
	BYTE 									option_length;
	UNION_USER_OPTIONS 				user_options;
	void 									*vptr_cached_route; 			/* address of cached route stored in user's space */
	USHORT								virtual_port_number;			/* do not route, send out through this port if not NO_SUCH_PORT */
	ULONG 								gateway;
#if 0
/* Sachin 13/06/1996 */
	USHORT								port_for_which_buffer_is_allocated ;
/* Sachin 13/06/1996 */
#endif
} IP_UPPER_LAYER_PARAMETERS;


typedef struct IP_PARAMETERS
{
	ULONG 												source_address;
	ULONG 												destination_address;
	USHORT												offset;
	USHORT 												header_length;
	SERVICE_TYPE_BIT_STRUCTURE						type_of_service;
	USHORT												total_length;
	USHORT 												id;
	BYTE 													time_to_live;
	BYTE_ENUM (IP_PROTOCOL_VALUE)					protocol;
	BYTE 													options_length;
	BYTE_ENUM (BOOLEAN) 								do_not_fragment_flag;
	BYTE_ENUM (BOOLEAN) 								more_fragment_flag;
	BYTE													version;
	USHORT												checksum;
	USHORT												rx_port_number;
	ULONG 												gateway;
	BYTE_ENUM (BOOLEAN) 								union_ip_packet_is_to_be_freed;
} IP_PARAMETERS;


/* Pseudo-header for calculating TCP and UDP checksum */

typedef struct PSEUDO_IP_PARAMETERS
{
	ULONG 		source_address;
	ULONG 		destination_address;
	BYTE			zero_field;
	BYTE 			protocol;
	USHORT 		length;
} PSEUDO_IP_PARAMETERS;


typedef	union	UNION_SERVICE_TYPE_BIT_STRUCTURE
{
	SERVICE_TYPE_BIT_STRUCTURE			_bit;
	BYTE										_byte;
} UNION_SERVICE_TYPE_BIT_STRUCTURE;


typedef struct IP_SOCKET
{
	USHORT 	port;
	ULONG 	ip_address;
	USHORT	virtual_port_number;
	BYTE		hardware_address[16];
} IP_SOCKET;


#endif /*  _VIPUSSTR_H_ */
