/*
 * $Log: /IP/VRARPSTR.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: vrarpstr.h$  $version: 1.3$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 09/26/94 ross
1.1 10/10/94 ross added copyrights, udp fixes.
1.2 12/27/94 ross added better table instrumentation via new snmp.
1.3 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/

#ifdef _BIG_PROXY_
#ifndef _VRARPSTR_H_
#define _VRARPSTR_H_


typedef struct RARP_HEADER
{
	USHORT_ENUM (ARP_HARDWARE_TYPES) 		hardware_type;
	USHORT 											protocol;
	BYTE 												hardware_address_length;
	BYTE 												protocol_address_length;
	USHORT_ENUM (ARP_OPERATION_CODES) 		operation_code;
	MAC_ADDRESS										sender_hardware_address;
	ULONG												sender_protocol_address;
	MAC_ADDRESS 									target_hardware_address;
	ULONG	 											target_protocol_address;
} RARP_HEADER;


typedef struct RARP_PACKET
{
	UNION_MAC_HEADER								mac_header;
	RARP_HEADER										header;
} RARP_PACKET;


typedef struct RARP_STATISTICS 
{
	ULONG 		bad_length_field;
	ULONG 		unsupported_hardware;
	ULONG 		unsupported_protocol;
	ULONG 		bad_address;
	ULONG 		total_number_of_packets_received;
	ULONG 		total_number_of_short_packets_received;
	ULONG 		total_number_of_packets_from_me_received;
	ULONG 		total_number_of_source_broadcasts_received;
	ULONG 		total_number_of_replies_sent;
	ULONG 		total_number_of_incoming_requests;
	ULONG			total_number_of_requests_sent;
} RARP_STATISTICS;


typedef struct RARP_CONFIGURATION_CLASS
{
	BYTE_ENUM (BOOLEAN) 				client_enabled;
	ULONG 								reply_timeout;
	RARP_TABLE_ENTRY_LINK 			current_list;
} RARP_CONFIGURATION_CLASS;


typedef	struct	RARP_PORT_CLASS
{
	RARP_CONFIGURATION_CLASS		config;
	BYTE_ENUM (BOOLEAN) 				pending_reply;
	USHORT								second_counter;
	USHORT								current_number_of_rarp_entries;
} RARP_PORT_CLASS;


typedef struct RARP_CLASS
{
	RARP_PORT_CLASS					port[NUMBER_OF_IP_PORTS];
	BYTE_ENUM (BOOLEAN) 				server_enabled;
	RARP_STATISTICS  					statistics;
} RARP_CLASS;



#endif /* _VRARPSTR_H_ */
#endif
