/*
 * $Log: /IP/VUDPSTR.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: vudpstr.h$  $version: 1.12$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/28/94 yarran Change
1.4 05/02/94 yarran added rfc1042 changes.
1.5 09/01/94 ross added BYTE and USHORT_ENUM support.
1.6 10/10/94 ross added rarp, proxy arp, remote access functions
1.7 10/10/94 ross added copyrights, udp fixes.
1.8 12/20/94 ross
1.9 12/27/94 ross added better table instrumentation via new snmp.
1.10 01/17/95 ross fixed arp problems from snmp
1.11 03/03/95 ross added lsl control.
1.12 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _VUDPSTR_H_
#define _VUDPSTR_H_


typedef struct UDP_MIB
{
	ULONG 		udpInDatagrams;
	ULONG 		udpNoPorts;
	ULONG 		udpInErrors;
	ULONG 		udpOutDatagrams;
} UDP_MIB;


typedef	struct	UDP_PACKET
{
	UNION_MAC_HEADER			mac_header;
	IP_HEADER					ip_header;
	UDP_HEADER					header;
	BYTE							data[VARIABLE_NUMBER_OF_BYTES];
} UDP_PACKET;


typedef	struct	UDP_CONTROL_BLOCK_LINK
{
	struct UDP_CONTROL_BLOCK 		*sptr_forward_link;
	struct UDP_CONTROL_BLOCK 		*sptr_backward_link;
} UDP_CONTROL_BLOCK_LINK;


typedef struct UDP_CONTROL_BLOCK
{
	UDP_CONTROL_BLOCK_LINK		links;
	IP_SOCKET		 				local_socket;
	IP_SOCKET						remote_socket;		/* updated when receiving UDP datagram from remote */

	void 								(*fptr_call_raw_udp_user) (USHORT rx_port_number, IP_SOCKET *sptr_remote_socket,
											void *vptr_packet_received, USHORT rx_user_data_size, IP_PARAMETERS *sptr_ip_parameters);

	void 								(*fptr_call_socket_user) (struct UDP_CONTROL_BLOCK *sptr_udp_control_block, USHORT count,
											void *vptr_user_data, IP_SOCKET *sptr_ip_socket);

	ULONG								user_link;
	UDP_BUFFER_LINK				receive_queue;
	USHORT 							receive_count;		/* Count of pending datagrams */
	void 								*vptr_cached_route;
} UDP_CONTROL_BLOCK;


typedef	struct UDP_CLASS
{
	SOCKET_FUNCTION_POINTERS 	socket_fptrs;
	UDP_MIB							mib;
 	UDP_CONTROL_BLOCK_LINK		current_control_block_list;
} UDP_CLASS;


#endif /* _VUDPSTR_H_ */
